/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.wire.store;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.UnaryOperator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.KuraStoreException;
import org.eclipse.kura.configuration.ConfigurableComponent;
import org.eclipse.kura.connection.listener.ConnectionListener;
import org.eclipse.kura.internal.wire.store.WireRecordStoreComponentOptions;
import org.eclipse.kura.wire.WireComponent;
import org.eclipse.kura.wire.WireEmitter;
import org.eclipse.kura.wire.WireEnvelope;
import org.eclipse.kura.wire.WireHelperService;
import org.eclipse.kura.wire.WireReceiver;
import org.eclipse.kura.wire.WireRecord;
import org.eclipse.kura.wire.WireSupport;
import org.eclipse.kura.wire.store.provider.WireRecordStore;
import org.eclipse.kura.wire.store.provider.WireRecordStoreProvider;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.wireadmin.Wire;

public class WireRecordStoreComponent
implements WireEmitter,
WireReceiver,
ConfigurableComponent,
ConnectionListener {
    private static final Logger logger = LogManager.getLogger(WireRecordStoreComponent.class);
    private State state = new Unsatisfied();
    private WireHelperService wireHelperService;
    private WireSupport wireSupport;

    public void bindWireHelperService(WireHelperService wireHelperService) {
        this.wireHelperService = wireHelperService;
    }

    public synchronized void bindWireRecordStoreProvider(WireRecordStoreProvider wireRecordStoreProvider) {
        wireRecordStoreProvider.addListener((ConnectionListener)this);
        this.updateState(s -> s.setWireRecordStoreProvider(wireRecordStoreProvider));
    }

    public synchronized void unbindWireRecordStoreProvider(WireRecordStoreProvider wireRecordStoreProvider) {
        if (this.state.getWireRecordStoreProvider().equals(Optional.of(wireRecordStoreProvider))) {
            wireRecordStoreProvider.removeListener((ConnectionListener)this);
            this.updateState(s -> s.unsetWireRecordStoreProvider(wireRecordStoreProvider));
        }
    }

    protected void activate(ComponentContext componentContext, Map<String, Object> properties) {
        logger.debug("Activating Wire Record Store Component...");
        this.wireSupport = this.wireHelperService.newWireSupport((WireComponent)this, componentContext.getServiceReference());
        this.updateState(s -> s.setOptions(new WireRecordStoreComponentOptions(properties)));
        logger.debug("Activating Wire Record Store Component... Done");
    }

    public synchronized void updated(Map<String, Object> properties) {
        logger.debug("Updating Wire Record Store Component...");
        this.updateState(s -> s.setOptions(new WireRecordStoreComponentOptions(properties)));
        logger.debug("Updating Wire Record Store Component... Done");
    }

    protected void deactivate() {
        logger.debug("Deactivating Wire Record Store Component...");
        this.state.shutdown();
        logger.debug("Deactivating Wire Record Store Component... Done");
    }

    public synchronized void onWireReceive(WireEnvelope wireEvelope) {
        List records = wireEvelope.getRecords();
        try {
            this.state.store(records);
        }
        catch (KuraException e) {
            logger.warn("Failed to store Wire Records", (Throwable)e);
        }
        this.wireSupport.emit(records);
    }

    public void consumersConnected(Wire[] wires) {
        this.wireSupport.consumersConnected(wires);
    }

    public Object polled(Wire wire) {
        return this.wireSupport.polled(wire);
    }

    public void producersConnected(Wire[] wires) {
        this.wireSupport.producersConnected(wires);
    }

    public void updated(Wire wire, Object value) {
        this.wireSupport.updated(wire, value);
    }

    private synchronized void updateState(UnaryOperator<State> transitionFunction) {
        this.state = (State)transitionFunction.apply(this.state);
    }

    public void disconnected() {
        this.updateState(State::onWireRecordStoreDisconnected);
    }

    public void connected() {
    }

    private static class Satisfied
    implements State {
        private final WireRecordStoreComponentOptions options;
        private final WireRecordStoreProvider provider;
        private Optional<WireRecordStore> store = Optional.empty();

        public Satisfied(WireRecordStoreComponentOptions options, WireRecordStoreProvider provider) {
            this.options = options;
            this.provider = provider;
        }

        @Override
        public State setOptions(WireRecordStoreComponentOptions options) {
            if (options.equals(this.options)) {
                return this;
            }
            this.shutdown();
            return new Satisfied(options, this.provider);
        }

        @Override
        public State setWireRecordStoreProvider(WireRecordStoreProvider wireRecordStoreProvider) {
            this.shutdown();
            return new Satisfied(this.options, wireRecordStoreProvider);
        }

        @Override
        public State unsetWireRecordStoreProvider(WireRecordStoreProvider wireRecordStoreProvider) {
            return new Unsatisfied().setOptions(this.options);
        }

        @Override
        public void store(List<WireRecord> records) throws KuraStoreException {
            try {
                this.storeInternal(records);
            }
            catch (Exception exception) {
                logger.warn("failed to store records, attempting to reopen store...");
                this.shutdown();
                this.storeInternal(records);
            }
        }

        private void storeInternal(List<WireRecord> records) throws KuraStoreException {
            WireRecordStore currentStore = this.getWireRecordStore();
            if (currentStore.getSize() >= this.options.getMaximumStoreSize()) {
                int recordsToKeep = Math.min(this.options.getCleanupRecordsKeep(), this.options.getMaximumStoreSize());
                currentStore.truncate(Math.max(0, recordsToKeep - 1));
            }
            currentStore.insertRecords(records);
        }

        @Override
        public void shutdown() {
            if (this.store.isPresent()) {
                this.store.get().close();
                this.store = Optional.empty();
            }
        }

        private WireRecordStore getWireRecordStore() throws KuraStoreException {
            if (this.store.isPresent()) {
                return this.store.get();
            }
            this.store = Optional.of(this.provider.openWireRecordStore(this.options.getStoreName()));
            return this.getWireRecordStore();
        }

        @Override
        public State onWireRecordStoreDisconnected() {
            this.shutdown();
            return this;
        }

        @Override
        public Optional<WireRecordStoreProvider> getWireRecordStoreProvider() {
            return Optional.of(this.provider);
        }
    }

    private static interface State {
        public State setOptions(WireRecordStoreComponentOptions var1);

        public State setWireRecordStoreProvider(WireRecordStoreProvider var1);

        public State unsetWireRecordStoreProvider(WireRecordStoreProvider var1);

        public Optional<WireRecordStoreProvider> getWireRecordStoreProvider();

        public void store(List<WireRecord> var1) throws KuraStoreException;

        public void shutdown();

        public State onWireRecordStoreDisconnected();
    }

    private static class Unsatisfied
    implements State {
        private Optional<WireRecordStoreComponentOptions> options = Optional.empty();
        private Optional<WireRecordStoreProvider> provider = Optional.empty();

        private Unsatisfied() {
        }

        @Override
        public State setOptions(WireRecordStoreComponentOptions options) {
            this.options = Optional.of(options);
            return this.checkSatisfied();
        }

        @Override
        public State setWireRecordStoreProvider(WireRecordStoreProvider wireRecordStoreProvider) {
            this.provider = Optional.of(wireRecordStoreProvider);
            return this.checkSatisfied();
        }

        @Override
        public State unsetWireRecordStoreProvider(WireRecordStoreProvider wireRecordStoreProvider) {
            this.provider = Optional.empty();
            return this.checkSatisfied();
        }

        private State checkSatisfied() {
            if (this.options.isPresent() && this.provider.isPresent()) {
                return new Satisfied(this.options.get(), this.provider.get());
            }
            return this;
        }

        @Override
        public void store(List<WireRecord> records) throws KuraStoreException {
            throw new KuraStoreException((Object)"Component dependencies are not satisfied");
        }

        @Override
        public void shutdown() {
        }

        @Override
        public State onWireRecordStoreDisconnected() {
            return this;
        }

        @Override
        public Optional<WireRecordStoreProvider> getWireRecordStoreProvider() {
            return this.provider;
        }
    }
}

