/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.wire;

import java.util.Objects;
import org.eclipse.kura.annotation.NotThreadSafe;
import org.eclipse.kura.annotation.Nullable;
import org.osgi.annotation.versioning.ProviderType;
import org.osgi.service.wireadmin.Wire;

@NotThreadSafe
@ProviderType
public class WireConfiguration {
    private final String emitterPid;
    @Nullable
    private String filter;
    private final String receiverPid;
    @Nullable
    private Wire wire;

    public WireConfiguration(String emitterPid, String receiverPid) {
        Objects.requireNonNull(emitterPid, "Emitter PID cannot be null");
        Objects.requireNonNull(receiverPid, "Receiver PID cannot be null");
        this.emitterPid = emitterPid;
        this.receiverPid = receiverPid;
    }

    public String getEmitterPid() {
        return this.emitterPid;
    }

    public String getFilter() {
        return this.filter;
    }

    public String getReceiverPid() {
        return this.receiverPid;
    }

    public Wire getWire() {
        return this.wire;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public void setWire(Wire wire) {
        this.wire = wire;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WireConfiguration other = (WireConfiguration)obj;
        if (this.emitterPid == null ? other.emitterPid != null : !this.emitterPid.equals(other.emitterPid)) {
            return false;
        }
        return !(this.receiverPid == null ? other.receiverPid != null : !this.receiverPid.equals(other.receiverPid));
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.emitterPid == null ? 0 : this.emitterPid.hashCode());
        result = 31 * result + (this.receiverPid == null ? 0 : this.receiverPid.hashCode());
        return result;
    }

    public String toString() {
        return "WireConfiguration [emitterPid=" + this.emitterPid + ", filter=" + this.filter + ", receiverPid=" + this.receiverPid + ", wire=" + this.wire + "]";
    }
}

