/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.utils;

import java.util.List;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.dom.DOMAttr;
import org.eclipse.lemminx.dom.DOMCharacterData;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMElement;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.dom.DOMProcessingInstruction;
import org.eclipse.lemminx.dom.DOMRange;
import org.eclipse.lemminx.dom.DOMText;
import org.eclipse.lemminx.dom.DTDAttlistDecl;
import org.eclipse.lemminx.dom.DTDDeclNode;
import org.eclipse.lemminx.dom.DTDDeclParameter;
import org.eclipse.lemminx.dom.DTDElementDecl;
import org.eclipse.lemminx.dom.TargetRange;
import org.eclipse.lemminx.dom.parser.Scanner;
import org.eclipse.lemminx.dom.parser.TokenType;
import org.eclipse.lemminx.dom.parser.XMLScanner;
import org.eclipse.lemminx.utils.DOMUtils;
import org.eclipse.lemminx.utils.StringUtils;
import org.eclipse.lsp4j.DocumentLink;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.LocationLink;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;

public class XMLPositionUtility {
    private static final Logger LOGGER = Logger.getLogger(XMLPositionUtility.class.getName());
    private static final Predicate<Character> ENTITY_NAME_PREDICATE = ch -> ch.charValue() == '_' || ch.charValue() == ':' || ch.charValue() == '.' || ch.charValue() == '-' || Character.isLetterOrDigit(ch.charValue());

    private XMLPositionUtility() {
    }

    public static Range selectAttributeName(DOMAttr attr) {
        if (attr != null) {
            return XMLPositionUtility.createAttrNameRange(attr, attr.getOwnerDocument());
        }
        return null;
    }

    public static Range selectAttributeNameAt(int offset, DOMDocument document) {
        offset = XMLPositionUtility.adjustOffsetForAttribute(offset, document);
        DOMAttr attr = document.findAttrAt(offset);
        return XMLPositionUtility.createAttrNameRange(attr, document);
    }

    public static Range selectAttributeValue(DOMAttr attr) {
        if (attr != null) {
            return XMLPositionUtility.createAttrValueRange(attr, attr.getOwnerDocument());
        }
        return null;
    }

    public static Range selectAttributeValueAt(String attrName, int offset, DOMDocument document) {
        DOMAttr attr;
        DOMNode element = document.findNodeAt(offset);
        if (element != null && (attr = element.getAttributeNode(attrName)) != null) {
            return XMLPositionUtility.createAttrValueRange(attr, document);
        }
        return null;
    }

    public static Range selectAttributeValueFromGivenValue(String attrValue, int offset, DOMDocument document) {
        DOMNode element = document.findNodeAt(offset);
        if (element != null && element.hasAttributes()) {
            List<DOMAttr> attribues = element.getAttributeNodes();
            for (DOMAttr attr : attribues) {
                if (!attrValue.equals(attr.getValue())) continue;
                return XMLPositionUtility.createAttrValueRange(attr, document);
            }
        }
        return null;
    }

    private static Range createAttrValueRange(DOMAttr attr, DOMDocument document) {
        DOMNode attrValue = attr.getNodeAttrValue();
        if (attrValue == null) {
            return null;
        }
        int startOffset = attrValue.getStart();
        int endOffset = attrValue.getEnd();
        return XMLPositionUtility.createRange(startOffset, endOffset, document);
    }

    public static Range selectAttributeValueByGivenValueAt(String attrValue, int offset, DOMDocument document) {
        DOMNode element = document.findNodeAt(offset);
        if (element != null && element.hasAttributes()) {
            List<DOMAttr> attributes = element.getAttributeNodes();
            for (DOMAttr attr : attributes) {
                if (!attrValue.equals(attr.getValue())) continue;
                return XMLPositionUtility.createAttrValueRange(attr, document);
            }
        }
        return null;
    }

    public static Range selectAttributeNameFromGivenNameAt(String attrName, int offset, DOMDocument document) {
        DOMAttr attr;
        DOMNode element = document.findNodeAt(offset);
        if (element != null && element.hasAttributes() && (attr = element.getAttributeNode(attrName)) != null) {
            return XMLPositionUtility.createAttrNameRange(attr, document);
        }
        return null;
    }

    public static Range selectAttributePrefixFromGivenNameAt(String attrName, int offset, DOMDocument document) {
        DOMAttr attr;
        if (attrName == null) {
            return null;
        }
        DOMNode element = document.findNodeAt(offset);
        int prefixLength = attrName.indexOf(58);
        if (element != null && element.hasAttributes() && (attr = element.getAttributeNode(attrName)) != null) {
            int startOffset = attr.getNodeAttrName().getStart();
            int endOffset = startOffset + prefixLength;
            return XMLPositionUtility.createRange(startOffset, endOffset, document);
        }
        return null;
    }

    private static Range createAttrNameRange(DOMAttr attr, DOMDocument document) {
        int startOffset = attr.getNodeAttrName().getStart();
        int endOffset = attr.getNodeAttrName().getEnd();
        return XMLPositionUtility.createRange(startOffset, endOffset, document);
    }

    public static Range selectAttributeFromGivenNameAt(String attrName, int offset, DOMDocument document) {
        DOMAttr attr;
        DOMNode element = document.findNodeAt(offset);
        if (element != null && element.hasAttributes() && (attr = element.getAttributeNode(attrName)) != null) {
            return XMLPositionUtility.createAttrRange(attr, document);
        }
        return null;
    }

    public static Range selectAllAttributes(int offset, DOMDocument document) {
        DOMNode element = document.findNodeAt(offset);
        if (element != null && element.hasAttributes()) {
            int startOffset = -1;
            int endOffset = 0;
            List<DOMAttr> attributes = element.getAttributeNodes();
            for (DOMAttr attr : attributes) {
                if (startOffset == -1) {
                    startOffset = attr.getStart();
                    endOffset = attr.getEnd();
                    continue;
                }
                startOffset = Math.min(attr.getStart(), startOffset);
                endOffset = Math.min(attr.getEnd(), startOffset);
            }
            if (startOffset != -1) {
                return XMLPositionUtility.createRange(startOffset, endOffset, document);
            }
        }
        return null;
    }

    private static Range createAttrRange(DOMAttr attr, DOMDocument document) {
        int startOffset = attr.getStart();
        int endOffset = attr.getEnd();
        return XMLPositionUtility.createRange(startOffset, endOffset, document);
    }

    private static int adjustOffsetForAttribute(int offset, DOMDocument document) {
        String text = document.getText();
        char c = text.charAt(offset);
        if (c == '>' && (c = text.charAt(--offset)) == '/') {
            --offset;
        }
        while (offset >= 0 && Character.isWhitespace(c)) {
            c = text.charAt(--offset);
        }
        return offset;
    }

    public static Range selectChildEndTag(String childTag, int offset, DOMDocument document) {
        DOMNode parent = document.findNodeAt(offset);
        if (parent == null || !parent.isElement() || ((DOMElement)parent).getTagName() == null) {
            return null;
        }
        DOMNode curr = parent;
        while (curr != null) {
            DOMNode child = XMLPositionUtility.findUnclosedChildNode(childTag, curr.getChildren());
            if (child == null) {
                curr = XMLPositionUtility.findUnclosedChildNode(curr.getChildren());
                continue;
            }
            return XMLPositionUtility.createRange(child.getStart() + 1, child.getStart() + 1 + childTag.length(), document);
        }
        String parentName = ((DOMElement)parent).getTagName();
        return XMLPositionUtility.createRange(parent.getStart() + 2, parent.getStart() + 2 + parentName.length(), document);
    }

    private static DOMNode findUnclosedChildNode(List<DOMNode> children) {
        for (DOMNode child : children) {
            if (child.isClosed()) continue;
            return child;
        }
        return null;
    }

    private static DOMNode findUnclosedChildNode(String childTag, List<DOMNode> children) {
        for (DOMNode child : children) {
            if (!child.isElement() || childTag == null || !childTag.equals(((DOMElement)child).getTagName()) || child.isClosed()) continue;
            return child;
        }
        return null;
    }

    public static Range selectRootStartTag(DOMDocument document) {
        DOMNode root = document.getDocumentElement();
        if (root == null) {
            root = document.getChild(0);
        }
        if (root == null) {
            return null;
        }
        return XMLPositionUtility.selectStartTagName(root);
    }

    public static Range selectRootAttributeValue(String attrName, DOMDocument document) {
        DOMNode root = document.getDocumentElement();
        if (root == null) {
            root = document.getChild(0);
        }
        if (root == null) {
            return null;
        }
        DOMAttr attr = ((DOMNode)root).getAttributeNode(attrName);
        if (attr == null) {
            return null;
        }
        return XMLPositionUtility.selectAttributeValue(attr);
    }

    public static Range selectStartTagName(int offset, DOMDocument document) {
        DOMNode element = document.findNodeAt(offset);
        if (element != null) {
            return XMLPositionUtility.selectStartTagName(element);
        }
        return null;
    }

    public static Range selectStartTagName(DOMNode element) {
        return XMLPositionUtility.selectStartTagName(element, false);
    }

    public static Range selectStartTagLocalName(DOMNode element) {
        return XMLPositionUtility.selectStartTagName(element, true);
    }

    private static Range selectStartTagName(DOMNode element, boolean localNameOnly) {
        int initialStartOffset;
        int finalStartOffset = initialStartOffset = element.getStart() + 1;
        if (localNameOnly) {
            String prefix = element.getPrefix();
            if (prefix != null) {
                finalStartOffset += prefix.length() + 1;
            } else {
                return null;
            }
        }
        int endOffset = initialStartOffset + XMLPositionUtility.getStartTagLength(element);
        if (element.isProcessingInstruction() || element.isProlog()) {
            ++endOffset;
        }
        DOMDocument document = element.getOwnerDocument();
        return XMLPositionUtility.createRange(finalStartOffset, endOffset, document);
    }

    private static int getStartTagLength(DOMNode node) {
        if (node.isElement()) {
            DOMElement element = (DOMElement)node;
            return element.getTagName() != null ? element.getTagName().length() : 0;
        }
        if (node.isProcessingInstruction() || node.isProlog()) {
            DOMProcessingInstruction element = (DOMProcessingInstruction)node;
            return element.getTarget() != null ? element.getTarget().length() : 0;
        }
        return 0;
    }

    public static int selectCurrentTagOffset(int offset, DOMDocument document) {
        DOMNode element = document.findNodeAt(offset);
        if (element != null) {
            return element.getStart();
        }
        return -1;
    }

    public static Range selectEndTagName(int offset, DOMDocument document) {
        DOMNode node = document.findNodeAt(offset);
        if (node != null && node.isElement()) {
            DOMElement element = (DOMElement)node;
            return XMLPositionUtility.selectEndTagName(element);
        }
        return null;
    }

    public static Range selectEndTagName(DOMElement element) {
        return XMLPositionUtility.selectEndTagName(element, false);
    }

    public static Range selectEndTagLocalName(DOMElement element) {
        return XMLPositionUtility.selectEndTagName(element, true);
    }

    public static Range selectEndTagName(DOMElement element, boolean localNameOnly) {
        if (element.hasEndTag()) {
            int initialStartOffset;
            int finalStartOffset = initialStartOffset = element.getEndTagOpenOffset() + 2;
            if (localNameOnly) {
                String prefix = element.getPrefix();
                if (prefix != null) {
                    finalStartOffset += prefix.length() + 1;
                } else {
                    return null;
                }
            }
            int endOffset = initialStartOffset + XMLPositionUtility.getStartTagLength(element);
            return XMLPositionUtility.createRange(finalStartOffset, endOffset, element.getOwnerDocument());
        }
        return null;
    }

    public static Range selectPreviousNodesEndTag(int offset, DOMDocument document) {
        DOMElement element;
        DOMNode node = null;
        DOMNode nodeAt = document.findNodeAt(offset);
        if (nodeAt != null && nodeAt.isElement()) {
            node = nodeAt;
        } else {
            DOMNode nodeBefore = document.findNodeBefore(offset);
            if (nodeBefore != null && nodeBefore.isElement()) {
                node = nodeBefore;
            }
        }
        if (node != null && (element = (DOMElement)node).isClosed() && !element.isEndTagClosed()) {
            return XMLPositionUtility.selectEndTagName(element.getEnd(), document);
        }
        int i = offset;
        char c = document.getText().charAt(i);
        while (i >= 0) {
            if (c == '>') {
                return XMLPositionUtility.selectEndTagName(i, document);
            }
            c = document.getText().charAt(--i);
        }
        return null;
    }

    public static EntityReferenceRange selectEntityReference(int offset, DOMDocument document) {
        return XMLPositionUtility.selectEntityReference(offset, document, true);
    }

    public static EntityReferenceRange selectEntityReference(int offset, DOMDocument document, boolean endsWithSemicolon) {
        String text = document.getText();
        int entityReferenceStart = XMLPositionUtility.getEntityReferenceStartOffset(text, offset);
        if (entityReferenceStart == -1) {
            return null;
        }
        int entityReferenceEnd = XMLPositionUtility.getEntityReferenceEndOffset(text, offset);
        if (entityReferenceEnd == -1) {
            if (endsWithSemicolon) {
                return null;
            }
            entityReferenceEnd = offset;
        }
        String name = endsWithSemicolon ? document.getText().substring(entityReferenceStart + 1, entityReferenceEnd - 1) : null;
        return new EntityReferenceRange(name, XMLPositionUtility.createRange(entityReferenceStart, entityReferenceEnd, document));
    }

    public static int getEntityReferenceStartOffset(String text, int offset) {
        if (--offset < 0) {
            return -1;
        }
        if (text.charAt(offset) == '&') {
            return offset;
        }
        if (offset == 0) {
            return -1;
        }
        int startEntityOffset = StringUtils.findStartWord(text, offset, ENTITY_NAME_PREDICATE);
        if (startEntityOffset <= 0) {
            return -1;
        }
        if (text.charAt(startEntityOffset - 1) != '&') {
            return -1;
        }
        return startEntityOffset - 1;
    }

    public static int getEntityReferenceEndOffset(String text, int offset) {
        int endEntityOffset = StringUtils.findEndWord(text, offset, ENTITY_NAME_PREDICATE);
        if (endEntityOffset == -1) {
            return -1;
        }
        if (endEntityOffset >= text.length() || text.charAt(endEntityOffset) != ';') {
            return -1;
        }
        return endEntityOffset + 1;
    }

    public static Range selectFirstNonWhitespaceText(int offset, DOMDocument document) {
        DOMNode element = document.findNodeAt(offset);
        if (element != null) {
            for (DOMNode node : element.getChildren()) {
                if (!node.isCharacterData() || !((DOMCharacterData)node).hasMultiLine()) continue;
                String content = ((DOMCharacterData)node).getData();
                int start = node.getStart();
                Integer end = null;
                for (int i = 0; i < content.length(); ++i) {
                    char c = content.charAt(i);
                    if (end == null) {
                        if (Character.isWhitespace(c)) {
                            ++start;
                            continue;
                        }
                        end = start;
                        continue;
                    }
                    if (Character.isWhitespace(c)) break;
                    Integer n = end;
                    Integer n2 = end = Integer.valueOf(end + 1);
                }
                if (end == null) continue;
                Integer n = end;
                Integer n3 = end = Integer.valueOf(end + 1);
                return XMLPositionUtility.createRange(start, end, document);
            }
        }
        return null;
    }

    public static Range selectText(DOMText text) {
        return XMLPositionUtility.selectText(text, text.getOwnerDocument());
    }

    private static Range selectText(DOMText text, DOMDocument document) {
        return XMLPositionUtility.createRange(text.getStartContent(), text.getEndContent(), document);
    }

    public static Range selectContent(int offset, DOMDocument document) {
        DOMNode node = document.findNodeAt(offset);
        if (node != null) {
            if (node.isElement()) {
                DOMElement element = (DOMElement)node;
                if (node.hasChildNodes()) {
                    return XMLPositionUtility.createRange(element.getStartTagCloseOffset() + 1, element.getEndTagOpenOffset(), document);
                }
                return XMLPositionUtility.selectStartTagName(node);
            }
            if (node.isText()) {
                DOMText text = (DOMText)node;
                return XMLPositionUtility.selectText(text, document);
            }
        }
        return null;
    }

    public static Range selectTrimmedText(int offset, DOMDocument document) {
        DOMNode node = document.findNodeAt(offset);
        if (node == null || !node.isElement()) {
            return null;
        }
        DOMElement element = (DOMElement)node;
        if (DOMUtils.containsTextOnly(element)) {
            DOMNode textNode = element.getFirstChild();
            String text = element.getFirstChild().getTextContent();
            int startOffset = textNode.getStart();
            int endOffset = textNode.getEnd();
            if (!StringUtils.isWhitespace(text)) {
                startOffset += StringUtils.getFrontWhitespaceLength(text);
                endOffset -= StringUtils.getTrailingWhitespaceLength(text);
            }
            try {
                Position startPosition = document.positionAt(startOffset);
                Position endPosition = document.positionAt(endOffset);
                return new Range(startPosition, endPosition);
            }
            catch (BadLocationException e) {
                return null;
            }
        }
        return null;
    }

    public static Range selectDTDElementDeclAt(int offset, DOMDocument document) {
        DOMNode node = document.findNodeAt(offset);
        if (node != null && node.isDTDElementDecl()) {
            return XMLPositionUtility.createRange(node.getStart(), node.getEnd(), document);
        }
        return null;
    }

    public static Range getLastValidDTDDeclParameter(int offset, DOMDocument document, boolean selectWholeParameter) {
        DOMNode node = document.findNodeAt(offset);
        if (node instanceof DTDDeclNode) {
            DTDDeclNode decl = (DTDDeclNode)node;
            List<DTDDeclParameter> params = decl.getParameters();
            if (params == null || params.isEmpty()) {
                return XMLPositionUtility.createRange(decl.declType.getStart(), decl.declType.getEnd(), document);
            }
            DTDDeclParameter finalParam = decl.unrecognized != null && decl.unrecognized.equals(params.get(params.size() - 1)) ? (params.size() > 1 ? params.get(params.size() - 2) : decl.declType) : params.get(params.size() - 1);
            if (selectWholeParameter) {
                return XMLPositionUtility.createRange(finalParam.getStart(), finalParam.getEnd(), document);
            }
            return XMLPositionUtility.createRange(finalParam.getEnd(), finalParam.getEnd() + 1, document);
        }
        return null;
    }

    public static Range getLastValidDTDDeclParameter(int offset, DOMDocument document) {
        return XMLPositionUtility.getLastValidDTDDeclParameter(offset, document, false);
    }

    public static Range getLastValidDTDDeclParameterOrUnrecognized(int offset, DOMDocument document) {
        DOMNode node = document.findNodeAt(offset);
        if (node instanceof DTDDeclNode) {
            List<DTDDeclParameter> params;
            DTDAttlistDecl attlist;
            List<DTDAttlistDecl> internal;
            DTDDeclNode decl = (DTDDeclNode)node;
            if (decl instanceof DTDAttlistDecl && (internal = (attlist = (DTDAttlistDecl)decl).getInternalChildren()) != null && !internal.isEmpty()) {
                decl = internal.get(internal.size() - 1);
            }
            if ((params = decl.getParameters()) == null || params.isEmpty()) {
                return XMLPositionUtility.createRange(decl.declType.getStart(), decl.declType.getEnd(), document);
            }
            DTDDeclParameter finalParam = params.get(params.size() - 1);
            if (decl.unrecognized != null && decl.unrecognized.equals(finalParam)) {
                return XMLPositionUtility.createRange(finalParam.getStart(), finalParam.getEnd(), document);
            }
            return XMLPositionUtility.createRange(finalParam.getEnd(), finalParam.getEnd() + 1, document);
        }
        return null;
    }

    public static Range getLastDTDDeclParameter(int offset, DOMDocument document) {
        DTDDeclNode decl;
        List<DTDDeclParameter> params;
        DOMNode node = document.findNodeAt(offset);
        if (node instanceof DTDDeclNode && (params = (decl = (DTDDeclNode)node).getParameters()) != null && !params.isEmpty()) {
            DTDDeclParameter lastParam = params.get(params.size() - 1);
            return XMLPositionUtility.createRange(lastParam.getStart(), lastParam.getEnd(), document);
        }
        return null;
    }

    public static Range selectDTDDeclTagNameAt(int offset, DOMDocument document) {
        DOMNode node = document.findNodeAt(offset);
        if (node instanceof DTDDeclNode) {
            DTDDeclNode declNode = (DTDDeclNode)node;
            return XMLPositionUtility.createRange(declNode.declType.getStart(), declNode.declType.getEnd(), document);
        }
        return null;
    }

    public static Range getElementDeclMissingContentOrCategory(int offset, DOMDocument document) {
        DOMNode node = document.findNodeAt(offset);
        if (node instanceof DTDElementDecl) {
            DTDElementDecl declNode = (DTDElementDecl)node;
            List<DTDDeclParameter> params = declNode.getParameters();
            if (params.isEmpty()) {
                return null;
            }
            if (params.size() == 1) {
                DTDDeclParameter param = params.get(0);
                return XMLPositionUtility.createRange(param.getEnd(), param.getEnd() + 1, document);
            }
            return XMLPositionUtility.createRange(params.get(1).getStart(), params.get(1).getEnd(), document);
        }
        return null;
    }

    public static Range createRange(DOMRange range) {
        return XMLPositionUtility.createRange(range.getStart(), range.getEnd(), range.getOwnerDocument());
    }

    public static Range createRange(int startOffset, int endOffset, DOMDocument document) {
        try {
            return new Range(document.positionAt(startOffset), document.positionAt(endOffset));
        }
        catch (BadLocationException e) {
            LOGGER.log(Level.SEVERE, "While creating Range the Offset was a BadLocation", e);
            return null;
        }
    }

    public static LocationLink createLocationLink(DOMRange origin, DOMRange target) {
        Range originSelectionRange = null;
        originSelectionRange = origin instanceof DOMElement ? XMLPositionUtility.selectStartTagName((DOMElement)origin) : XMLPositionUtility.createRange(origin);
        return XMLPositionUtility.createLocationLink(originSelectionRange, target);
    }

    public static LocationLink createLocationLink(Range origin, DOMRange target) {
        Range targetRange;
        Range targetSelectionRange = targetRange = XMLPositionUtility.createRange(target);
        DOMDocument targetDocument = target.getOwnerDocument();
        return new LocationLink(targetDocument.getDocumentURI(), targetRange, targetSelectionRange, origin);
    }

    public static LocationLink createLocationLink(Range origin, TargetRange target) {
        Range targetRange;
        Range targetSelectionRange = targetRange = target.getTargetRange();
        return new LocationLink(target.getTargetURI(), targetRange, targetSelectionRange, origin);
    }

    public static Location createLocation(DOMRange target) {
        DOMDocument targetDocument = target.getOwnerDocument();
        Range targetRange = XMLPositionUtility.createRange(target.getStart(), target.getEnd(), targetDocument);
        return new Location(targetDocument.getDocumentURI(), targetRange);
    }

    public static DocumentLink createDocumentLink(DOMRange target, String location) throws BadLocationException {
        DOMDocument document = target.getOwnerDocument();
        Position start = document.positionAt(target.getStart() + 1);
        Position end = document.positionAt(target.getEnd() - 1);
        return new DocumentLink(new Range(start, end), location);
    }

    public static Range selectFirstChild(int offset, DOMDocument document) {
        DOMNode node = document.findNodeAt(offset);
        if (node == null || !node.isElement()) {
            return null;
        }
        DOMElement element = (DOMElement)node;
        DOMNode child = element.getFirstChild();
        if (child == null) {
            return null;
        }
        int startOffset = child.getStart();
        int endOffset = child.getEnd();
        try {
            Position startPosition = document.positionAt(startOffset);
            Position endPosition = document.positionAt(endOffset);
            return new Range(startPosition, endPosition);
        }
        catch (BadLocationException e) {
            return null;
        }
    }

    public static Range selectWholeTag(int offset, DOMDocument document) {
        DOMNode node = document.findNodeAt(offset);
        if (node != null) {
            return XMLPositionUtility.createRange(node.getStart(), node.getEnd(), document);
        }
        return null;
    }

    public static boolean doesTagCoverPosition(Range startTagRange, Range endTagRange, Position position) {
        return startTagRange != null && XMLPositionUtility.covers(startTagRange, position) || endTagRange != null && XMLPositionUtility.covers(endTagRange, position);
    }

    public static boolean covers(Range range, Position position) {
        return XMLPositionUtility.isBeforeOrEqual(range.getStart(), position) && XMLPositionUtility.isBeforeOrEqual(position, range.getEnd());
    }

    public static boolean isBeforeOrEqual(Position pos1, Position pos2) {
        return pos1.getLine() < pos2.getLine() || pos1.getLine() == pos2.getLine() && pos1.getCharacter() <= pos2.getCharacter();
    }

    public static Range getTagNameRange(TokenType tokenType, int startOffset, DOMDocument xmlDocument) {
        Scanner scanner = XMLScanner.createScanner(xmlDocument.getText(), startOffset);
        TokenType token = scanner.scan();
        while (token != TokenType.EOS && token != tokenType) {
            token = scanner.scan();
        }
        if (token != TokenType.EOS) {
            try {
                return new Range(xmlDocument.positionAt(scanner.getTokenOffset()), xmlDocument.positionAt(scanner.getTokenEnd()));
            }
            catch (BadLocationException e) {
                LOGGER.log(Level.SEVERE, "While creating Range in XMLHighlighting the Scanner's Offset was a BadLocation", e);
                return null;
            }
        }
        return null;
    }

    public static Location toLocation(LocationLink locationLink) {
        return new Location(locationLink.getTargetUri(), locationLink.getTargetRange());
    }

    public static Position getMatchingTagPosition(DOMDocument xmlDocument, Position position) {
        try {
            int offset = xmlDocument.offsetAt(position);
            DOMNode node = xmlDocument.findNodeAt(offset);
            if (node.isElement()) {
                DOMElement element = (DOMElement)node;
                if (!element.hasEndTag() || element.isSelfClosed() || !element.hasStartTag()) {
                    return null;
                }
                int tagNameLength = element.getTagName().length();
                int startTagNameStart = element.getStartTagOpenOffset() + 1;
                int startTagNameEnd = startTagNameStart + tagNameLength;
                int endTagNameStart = element.getEndTagOpenOffset() + 2;
                int endTagNameEnd = endTagNameStart + tagNameLength;
                if (offset <= startTagNameEnd && offset >= startTagNameStart) {
                    int mirroredCursorOffset = endTagNameStart + (offset - startTagNameStart);
                    return xmlDocument.positionAt(mirroredCursorOffset);
                }
                if (offset >= endTagNameStart && offset <= endTagNameEnd) {
                    int mirroredCursorOffset = startTagNameStart + (offset - endTagNameStart);
                    return xmlDocument.positionAt(mirroredCursorOffset);
                }
            }
        }
        catch (BadLocationException e) {
            return null;
        }
        return null;
    }

    public static class EntityReferenceRange {
        private final String name;
        private final Range range;

        public EntityReferenceRange(String name, Range range) {
            this.name = name;
            this.range = range;
        }

        public String getName() {
            return this.name;
        }

        public Range getRange() {
            return this.range;
        }
    }
}

