/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services.extensions;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class HTMLTag {
    public static final Collection<HTMLTag> HTML_TAGS = Arrays.asList(HTMLTag.t("div", "The div element has no special meaning at all. It represents its children. It can be used with the class, lang, and title attributes to mark up semantics common to a group of consecutive elements.", new String[0]), HTMLTag.t("header", "The header element represents introductory content for its nearest ancestor sectioning content or sectioning root element. A header typically contains a group of introductory or navigational aids. When the nearest ancestor sectioning content or sectioning root element is the body element, then it applies to the whole page.", new String[0]), HTMLTag.t("html", "The html element represents the root of an HTML document.", new String[0]), HTMLTag.t("h1", "The h1 element represents a section heading.", new String[0]), HTMLTag.t("iframe", "The iframe element represents a nested browsing context.", new String[0]), HTMLTag.t("input", "The input element represents a typed data field, usually with a form control to allow the user to edit the data.", "dir", "disabled", "onmousemove", "size", "src", "style", "tabindex", "type:t"));
    private static final Map<String, String[]> valueSets = new HashMap<String, String[]>();
    private final String tag;
    private final String label;
    private final String[] attributes;

    public HTMLTag(String tag, String label, String ... attributes) {
        this.tag = tag;
        this.label = label;
        this.attributes = attributes;
    }

    public String getTag() {
        return this.tag;
    }

    public String getLabel() {
        return this.label;
    }

    public String[] getAttributes() {
        return this.attributes;
    }

    private static HTMLTag t(String tag, String label, String ... attributes) {
        return new HTMLTag(tag, label, attributes);
    }

    public static HTMLTag getHTMLTag(String tag) {
        Optional<HTMLTag> htmlTag = HTML_TAGS.stream().filter(t -> t.getTag().equals(tag)).findFirst();
        return htmlTag.isPresent() ? htmlTag.get() : null;
    }

    public static String[] getAttributeValues(String type) {
        return valueSets.get(type);
    }

    static {
        valueSets.put("t", new String[]{"text", "checkbox"});
    }
}

