/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.utils;

import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.lemminx.utils.ServerInfo;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ServerInfoTest {
    private static final String JAVA_HOME = "/foo/bar/java/";
    private ServerInfo serverInfo;

    @BeforeEach
    public void setup() {
        Properties sysProps = new Properties();
        sysProps.setProperty("java.home", JAVA_HOME);
        this.serverInfo = new ServerInfo(sysProps);
    }

    @Test
    public void testVersion() {
        String version = this.serverInfo.getVersion();
        Pattern pattern = Pattern.compile("^(\\d+\\.\\d+\\.\\d+)(-.*)$");
        Matcher matcher = pattern.matcher(version);
        Assertions.assertTrue((boolean)matcher.matches(), (String)("Unexpected format for :" + version));
    }

    @Test
    public void testJavaHome() {
        Assertions.assertEquals((Object)JAVA_HOME, (Object)this.serverInfo.getJava(), (String)"Unexpected Java home");
    }

    @Test
    public void testGitInfos() {
        Assertions.assertNotNull((Object)this.serverInfo.getBranch(), (String)"Branch was not set");
        Assertions.assertNotNull((Object)this.serverInfo.getCommitMessage(), (String)"Commit message was not set");
        Assertions.assertNotNull((Object)this.serverInfo.getShortCommitId(), (String)"Commit id was not set");
    }

    @Test
    public void testDetails() {
        String details = this.serverInfo.details();
        Assertions.assertTrue((boolean)details.contains(this.serverInfo.getVersion()), (String)"version is missing from the details");
        Assertions.assertTrue((boolean)details.contains(this.serverInfo.getJava()), (String)"Java is missing from the details");
        Assertions.assertTrue((boolean)details.contains(this.serverInfo.getCommitMessage()), (String)"commit message is missing from the details");
        Assertions.assertTrue((boolean)details.contains(this.serverInfo.getShortCommitId()), (String)"commit id is missing from the details");
        String branch = this.serverInfo.getBranch();
        if ("master".equals(branch)) {
            Assertions.assertFalse((boolean)details.contains(branch), (String)"master branch should not be in the details");
        } else {
            Assertions.assertTrue((boolean)details.contains(branch), (String)(branch + " branch is missing from the details"));
        }
    }
}

