/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.dtd.contentmodel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.xerces.impl.dtd.XMLElementDecl;
import org.eclipse.lemminx.dom.DOMElement;
import org.eclipse.lemminx.extensions.contentmodel.model.CMAttributeDeclaration;
import org.eclipse.lemminx.extensions.contentmodel.model.CMElementDeclaration;
import org.eclipse.lemminx.extensions.dtd.contentmodel.CMDTDDocument;
import org.eclipse.lemminx.services.extensions.ISharedSettingsRequest;

public class CMDTDElementDeclaration
extends XMLElementDecl
implements CMElementDeclaration {
    private final int index;
    private final CMDTDDocument document;
    private List<CMElementDeclaration> elements;
    private List<CMAttributeDeclaration> attributes;
    private String documentation;

    public CMDTDElementDeclaration(CMDTDDocument document, int index) {
        this.document = document;
        this.index = index;
    }

    @Override
    public String getName() {
        return this.name.localpart;
    }

    @Override
    public String getNamespace() {
        return null;
    }

    @Override
    public Collection<CMAttributeDeclaration> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new ArrayList<CMAttributeDeclaration>();
            this.document.collectAttributesDeclaration(this, this.attributes);
        }
        return this.attributes;
    }

    @Override
    public Collection<CMElementDeclaration> getElements() {
        if (this.elements == null) {
            this.elements = new ArrayList<CMElementDeclaration>();
            this.document.collectElementsDeclaration(this.getName(), this.elements);
        }
        return this.elements;
    }

    @Override
    public Collection<CMElementDeclaration> getPossibleElements(DOMElement parentElement, int offset) {
        return this.getElements();
    }

    @Override
    public CMElementDeclaration findCMElement(String tag, String namespace) {
        for (CMElementDeclaration cmElement : this.getElements()) {
            if (!cmElement.getName().equals(tag)) continue;
            return cmElement;
        }
        return null;
    }

    @Override
    public CMAttributeDeclaration findCMAttribute(String attributeName) {
        for (CMAttributeDeclaration cmAttribute : this.getAttributes()) {
            if (!cmAttribute.getName().equals(attributeName)) continue;
            return cmAttribute;
        }
        return null;
    }

    @Override
    public String getDocumentation(ISharedSettingsRequest settings) {
        if (this.documentation != null) {
            return this.documentation;
        }
        Map<String, CMDTDDocument.DTDElementInfo> hierarchiesMap = this.document.getHierarchiesMap();
        if (hierarchiesMap != null) {
            CMDTDDocument.DTDElementInfo dtdElementInfo = hierarchiesMap.get(this.getName());
            this.documentation = dtdElementInfo.getComment();
        }
        return this.documentation;
    }

    public String getDocumentation(String attrName) {
        CMDTDDocument.DTDElementInfo dtdElementInfo;
        Map<String, CMDTDDocument.DTDNodeInfo> attributesMap;
        CMDTDDocument.DTDNodeInfo nodeInfo;
        Map<String, CMDTDDocument.DTDElementInfo> hierarchiesMap = this.document.getHierarchiesMap();
        if (hierarchiesMap != null && (nodeInfo = (attributesMap = (dtdElementInfo = hierarchiesMap.get(this.getName())).getAttributes()).get(attrName)) != null) {
            this.documentation = nodeInfo.getComment();
        }
        return this.documentation;
    }

    @Override
    public boolean isEmpty() {
        return this.type == 1;
    }

    @Override
    public Collection<String> getEnumerationValues() {
        return Collections.emptyList();
    }

    @Override
    public String getTextDocumentation(String value, ISharedSettingsRequest request) {
        return null;
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public String getDocumentURI() {
        return this.document.getURI();
    }

    @Override
    public boolean isStringType() {
        return false;
    }

    @Override
    public boolean isMixedContent() {
        return this.type == 2;
    }
}

