/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel.participants.codeactions;

import java.util.List;
import java.util.TreeSet;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.commons.CodeActionFactory;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMElement;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.extensions.contentmodel.model.CMDocument;
import org.eclipse.lemminx.extensions.contentmodel.model.CMElementDeclaration;
import org.eclipse.lemminx.extensions.contentmodel.model.ContentModelManager;
import org.eclipse.lemminx.extensions.contentmodel.utils.XMLGenerator;
import org.eclipse.lemminx.services.extensions.codeaction.ICodeActionParticipant;
import org.eclipse.lemminx.services.extensions.codeaction.ICodeActionRequest;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;

public class cvc_complex_type_2_4_bCodeAction
implements ICodeActionParticipant {
    @Override
    public void doCodeAction(ICodeActionRequest request, List<CodeAction> codeActions, CancelChecker cancelChecker) {
        DOMDocument document = request.getDocument();
        Diagnostic diagnostic = request.getDiagnostic();
        try {
            Range diagnosticRange = diagnostic.getRange();
            int startOffset = document.offsetAt(diagnosticRange.getStart()) + 1;
            DOMNode node = document.findNodeAt(startOffset);
            if (node == null || !node.isElement()) {
                return;
            }
            DOMElement element = (DOMElement)node;
            int elementOffset = element.getStartTagCloseOffset() + 1;
            Position childElementPosition = document.positionAt(elementOffset);
            XMLGenerator generator = request.getXMLGenerator();
            ContentModelManager contentModelManager = (ContentModelManager)request.getComponent(ContentModelManager.class);
            TreeSet<String> existingElements = new TreeSet<String>();
            List<DOMNode> children = element.getChildren();
            for (DOMNode child : children) {
                if (!child.isElement()) continue;
                existingElements.add(child.getNodeName());
            }
            StringBuilder insertTextAll = new StringBuilder();
            StringBuilder insertTextRequired = new StringBuilder();
            for (CMDocument cmDocument : contentModelManager.findCMDocument(element)) {
                CMElementDeclaration matchesCMElement = cmDocument.findCMElement(element);
                if (matchesCMElement == null) continue;
                insertTextAll.append(generator.generate(matchesCMElement, null, true, true, existingElements, false));
                insertTextRequired.append(generator.generate(matchesCMElement, null, true, true, existingElements, true));
            }
            if (document.positionAt(element.getStartTagCloseOffset()).getLine() == document.positionAt(element.getEndTagOpenOffset()).getLine()) {
                insertTextAll.append(generator.getLineDelimiter());
                insertTextAll.append(generator.getWhitespacesIndent());
                insertTextRequired.append(generator.getLineDelimiter());
                insertTextRequired.append(generator.getWhitespacesIndent());
            }
            String insertStrAll = insertTextAll.toString();
            String insertStrRequired = insertTextRequired.toString();
            CodeAction insertAllExpectedElement = CodeActionFactory.insert("Insert all expected elements", childElementPosition, insertStrAll, document.getTextDocument(), diagnostic);
            codeActions.add(insertAllExpectedElement);
            CodeAction insertRequriedExpectedElement = CodeActionFactory.insert("Insert only required elements", childElementPosition, insertStrRequired, document.getTextDocument(), diagnostic);
            codeActions.add(insertRequriedExpectedElement);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }
}

