/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services.format;

import java.util.List;
import org.eclipse.lemminx.dom.DOMAttr;
import org.eclipse.lemminx.services.format.XMLFormatterDocument;
import org.eclipse.lemminx.services.format.XMLFormattingConstraints;
import org.eclipse.lemminx.settings.EnforceQuoteStyle;
import org.eclipse.lemminx.utils.StringUtils;
import org.eclipse.lsp4j.TextEdit;

public class DOMAttributeFormatter {
    private final XMLFormatterDocument formatterDocument;

    public DOMAttributeFormatter(XMLFormatterDocument formatterDocument) {
        this.formatterDocument = formatterDocument;
    }

    public void formatAttribute(DOMAttr attr, int prevOffset, boolean singleAttribute, boolean useSettings, XMLFormattingConstraints parentConstraints, List<TextEdit> edits) {
        int indentLevel = parentConstraints.getIndentLevel();
        boolean alreadyIndented = false;
        if (useSettings) {
            if (this.isPreserveAttributeLineBreaks() && this.hasLineBreak(prevOffset, attr.getStart())) {
                this.replaceLeftSpacesWithIndentation(indentLevel + 1, prevOffset, attr.getStart(), true, edits);
                alreadyIndented = true;
            } else if (this.isSplitAttributes() && !singleAttribute) {
                this.replaceLeftSpacesWithIndentation(indentLevel + this.getSplitAttributesIndentSize(), prevOffset, attr.getStart(), true, edits);
                alreadyIndented = true;
            }
        }
        int attributeNamelength = 0;
        if (attr.hasDelimiter()) {
            int delimiterOffset = attr.getDelimiterOffset();
            int attrNameEnd = attr.getNodeAttrName().getEnd();
            this.removeLeftSpaces(attrNameEnd, delimiterOffset, edits);
            if (attr.getNodeAttrValue() != null) {
                int attrValueStart = attr.getNodeAttrValue().getStart();
                this.removeLeftSpaces(delimiterOffset, attrValueStart, edits);
            }
            if (this.isMaxLineWidthSupported()) {
                int availableLineWidth = parentConstraints.getAvailableLineWidth();
                availableLineWidth = this.isPreserveAttributeLineBreaks() && this.hasLineBreak(prevOffset, attr.getStart()) ? this.getMaxLineWidth() - this.getTabSize() * (indentLevel + 1) : (this.isSplitAttributes() && !singleAttribute ? this.getMaxLineWidth() - this.getTabSize() * (indentLevel + this.getSplitAttributesIndentSize()) : --availableLineWidth);
                attributeNamelength = attrNameEnd - attr.getNodeAttrName().getStart() + 3;
                parentConstraints.setAvailableLineWidth(availableLineWidth - attributeNamelength);
            }
            this.formatAttributeValue(attr, parentConstraints, edits);
        }
        if (!alreadyIndented) {
            int from = prevOffset;
            int to = attr.getStart();
            if (this.isMaxLineWidthSupported() && parentConstraints.getAvailableLineWidth() < 0 && !this.isSplitAttributes()) {
                this.replaceLeftSpacesWithIndentation(indentLevel + 1, from, to, true, edits);
                int attrValuelength = attr.getValue() != null ? attr.getValue().length() : 0;
                parentConstraints.setAvailableLineWidth(this.getMaxLineWidth() - this.getTabSize() * (indentLevel + 1) - attributeNamelength - attrValuelength);
            } else {
                this.replaceLeftSpacesWithOneSpace(from, to, edits);
            }
        }
        String originalValue = attr.getOriginalValue();
        if (this.getEnforceQuoteStyle() == EnforceQuoteStyle.preferred && originalValue != null) {
            if (originalValue.charAt(0) != this.getQuotationAsChar() && StringUtils.isQuote(originalValue.charAt(0))) {
                this.replaceQuoteWithPreferred(attr.getNodeAttrValue().getStart(), attr.getNodeAttrValue().getStart() + 1, edits);
            }
            if (originalValue.charAt(originalValue.length() - 1) != this.getQuotationAsChar() && StringUtils.isQuote(originalValue.charAt(originalValue.length() - 1))) {
                this.replaceQuoteWithPreferred(attr.getNodeAttrValue().getEnd() - 1, attr.getNodeAttrValue().getEnd(), edits);
            }
        }
    }

    private void formatAttributeValue(DOMAttr attr, XMLFormattingConstraints parentConstraints, List<TextEdit> edits) {
        this.formatterDocument.formatAttributeValue(attr, parentConstraints, edits);
    }

    private void replaceQuoteWithPreferred(int from, int to, List<TextEdit> edits) {
        this.formatterDocument.replaceQuoteWithPreferred(from, to, edits);
    }

    private void replaceLeftSpacesWithOneSpace(int from, int to, List<TextEdit> edits) {
        this.formatterDocument.replaceLeftSpacesWithOneSpace(from, to, edits);
    }

    private void replaceLeftSpacesWithIndentation(int indentLevel, int leftLimit, int to, boolean addLineSeparator, List<TextEdit> edits) {
        this.formatterDocument.replaceLeftSpacesWithIndentation(indentLevel, leftLimit, to, addLineSeparator, edits);
    }

    private void removeLeftSpaces(int from, int to, List<TextEdit> edits) {
        this.formatterDocument.removeLeftSpaces(from, to, edits);
    }

    private boolean isSplitAttributes() {
        return this.formatterDocument.getSharedSettings().getFormattingSettings().isSplitAttributes();
    }

    private int getSplitAttributesIndentSize() {
        return this.formatterDocument.getSharedSettings().getFormattingSettings().getSplitAttributesIndentSize();
    }

    boolean isPreserveAttributeLineBreaks() {
        return this.formatterDocument.getSharedSettings().getFormattingSettings().isPreserveAttributeLineBreaks();
    }

    private boolean hasLineBreak(int prevOffset, int start) {
        return this.formatterDocument.hasLineBreak(prevOffset, start);
    }

    private char getQuotationAsChar() {
        return this.formatterDocument.getSharedSettings().getPreferences().getQuotationAsChar();
    }

    private EnforceQuoteStyle getEnforceQuoteStyle() {
        return this.formatterDocument.getSharedSettings().getFormattingSettings().getEnforceQuoteStyle();
    }

    private int getTabSize() {
        return this.formatterDocument.getSharedSettings().getFormattingSettings().getTabSize();
    }

    private int getMaxLineWidth() {
        return this.formatterDocument.getMaxLineWidth();
    }

    private boolean isMaxLineWidthSupported() {
        return this.formatterDocument.isMaxLineWidthSupported();
    }
}

