/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.references.participants;

import java.util.List;
import org.eclipse.lemminx.extensions.references.XMLReferencesPlugin;
import org.eclipse.lemminx.extensions.references.search.SearchEngine;
import org.eclipse.lemminx.extensions.references.search.SearchQuery;
import org.eclipse.lemminx.extensions.references.search.SearchQueryFactory;
import org.eclipse.lemminx.services.extensions.ILinkedEditingRangesParticipant;
import org.eclipse.lemminx.services.extensions.ILinkedEditingRangesRequest;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;

public class XMLReferencesLinkedEditingRangesParticipant
implements ILinkedEditingRangesParticipant {
    private final XMLReferencesPlugin plugin;

    public XMLReferencesLinkedEditingRangesParticipant(XMLReferencesPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public void findLinkedEditingRanges(ILinkedEditingRangesRequest request, List<Range> ranges, CancelChecker cancelChecker) {
        if (request.getNode() == null || request.getNode().isOwnerDocument()) {
            return;
        }
        SearchQuery query = SearchQueryFactory.createToQuery(request.getNode(), request.getOffset(), this.plugin.getReferencesSettings());
        if (query == null) {
            return;
        }
        query.setMatchNode(true);
        query.setSearchInIncludedFiles(false);
        int previousSize = ranges.size();
        SearchEngine.getInstance().search(query, (fromSearchNode, toSearchNode, expression) -> ranges.add(fromSearchNode.createRange(true)), cancelChecker);
        if (ranges.size() == previousSize) {
            return;
        }
        ranges.add(query.getSearchNode().createRange(true));
    }
}

