/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services.format.settings;

import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.settings.SharedSettings;
import org.eclipse.lsp4j.TextEdit;
import org.junit.jupiter.api.Test;

public class XMLFormatterJoinCDATALinesTest {
    @Test
    public void testCDATANotClosed() throws BadLocationException {
        String content = "<foo>\r\n<![CDATA[ \r\n</foo>";
        SharedSettings settings = new SharedSettings();
        String expected = content;
        XMLFormatterJoinCDATALinesTest.assertFormat(content, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testCDATAWithRange() throws BadLocationException {
        String content = "<foo>\r\n  <![CDATA[ |<bar>|\r\n  </bar>\r\n  ]]>\r\n</foo>";
        String expected = "<foo>\r\n  <![CDATA[ <bar>\r\n  </bar>\r\n  ]]>\r\n</foo>";
        SharedSettings settings = new SharedSettings();
        XMLFormatterJoinCDATALinesTest.assertFormat(content, expected, settings, new TextEdit[0]);
        XMLFormatterJoinCDATALinesTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testJoinCDATALinesSameLine() throws BadLocationException {
        String content = "<a>   <![CDATA[\r\n  <  \r\n]]>   </a>";
        String expected = "<a>   <![CDATA[<]]>   </a>";
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setJoinCDATALines(true);
        XMLFormatterJoinCDATALinesTest.assertFormat(content, expected, settings, XMLAssert.te(0, 15, 1, 2, ""), XMLAssert.te(1, 3, 2, 0, ""));
        XMLFormatterJoinCDATALinesTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testJoinCDATALinesEmpty() throws BadLocationException {
        String content = "<a>   <![CDATA[\r\n    \r\n]]>   </a>";
        String expected = "<a>   <![CDATA[]]>   </a>";
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setJoinCDATALines(true);
        XMLFormatterJoinCDATALinesTest.assertFormat(content, expected, settings, XMLAssert.te(0, 15, 2, 0, ""));
        XMLFormatterJoinCDATALinesTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testJoinCDATALinesWithText() throws BadLocationException {
        String content = "<a>  x  <![CDATA[\r\n<\r\n]]> y  </a>";
        String expected = "<a> x <![CDATA[<]]> y </a>";
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setJoinCDATALines(true);
        XMLFormatterJoinCDATALinesTest.assertFormat(content, expected, settings, XMLAssert.te(0, 3, 0, 5, " "), XMLAssert.te(0, 6, 0, 8, " "), XMLAssert.te(0, 17, 1, 0, ""), XMLAssert.te(1, 1, 2, 0, ""), XMLAssert.te(2, 5, 2, 7, " "));
        XMLFormatterJoinCDATALinesTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testJoinCDATALines() throws BadLocationException {
        String content = "<a>\r\n<![CDATA[\r\nline 1\r\n\r\n\r\nline 2\r\nline 3\r\n]]>   </a>";
        String expected = "<a>\r\n<![CDATA[line 1 line 2 line 3]]>   </a>";
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setJoinCDATALines(true);
        XMLFormatterJoinCDATALinesTest.assertFormat(content, expected, settings, XMLAssert.te(1, 9, 2, 0, ""), XMLAssert.te(2, 6, 5, 0, " "), XMLAssert.te(5, 6, 6, 0, " "), XMLAssert.te(6, 6, 7, 0, ""));
        XMLFormatterJoinCDATALinesTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testJoinCDATALinesMultiLine() throws BadLocationException {
        String content = "<a>\r\n<![CDATA[\r\nline 1\r\n\r\n\r\nline 2\r\nline 3 test test test test test test test test test test test test test test test test test test test test test test test test test test test test test test test test test test test\r\n]]>   </a>";
        String expected = "<a>\r\n<![CDATA[line 1 line 2 line 3 test test test test test test test test test test test\r\n  test test test test test test test test test test test test test test test\r\n  test test test test test test test test test]]>   </a>";
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setJoinCDATALines(true);
        settings.getFormattingSettings().setMaxLineWidth(80);
        XMLFormatterJoinCDATALinesTest.assertFormat(content, expected, settings, XMLAssert.te(1, 9, 2, 0, ""), XMLAssert.te(2, 6, 5, 0, " "), XMLAssert.te(5, 6, 6, 0, " "), XMLAssert.te(6, 61, 6, 62, "\r\n  "), XMLAssert.te(6, 136, 6, 137, "\r\n  "), XMLAssert.te(6, 181, 7, 0, ""));
        XMLFormatterJoinCDATALinesTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    private static void assertFormat(String unformatted, String expected, SharedSettings sharedSettings, TextEdit ... expectedEdits) throws BadLocationException {
        XMLFormatterJoinCDATALinesTest.assertFormat(unformatted, expected, sharedSettings, "test://test.html", expectedEdits);
    }

    private static void assertFormat(String unformatted, String expected, SharedSettings sharedSettings, String uri, TextEdit ... expectedEdits) throws BadLocationException {
        XMLFormatterJoinCDATALinesTest.assertFormat(unformatted, expected, sharedSettings, uri, true, expectedEdits);
    }

    private static void assertFormat(String unformatted, String expected, SharedSettings sharedSettings, String uri, Boolean considerRangeFormat, TextEdit ... expectedEdits) throws BadLocationException {
        XMLAssert.assertFormat(null, unformatted, expected, sharedSettings, uri, considerRangeFormat, expectedEdits);
    }
}

