/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services.format.settings;

import org.eclipse.lemminx.AbstractCacheBasedTest;
import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.settings.SharedSettings;
import org.eclipse.lsp4j.TextEdit;
import org.junit.jupiter.api.Test;

public class XMLFormatterSplitAttributesTest
extends AbstractCacheBasedTest {
    @Test
    public void splitAttributesIndentSize0() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setSplitAttributes(true);
        settings.getFormattingSettings().setSplitAttributesIndentSize(0);
        String content = "<root  a='a' b='b' c='c'/>\n";
        String expected = "<root\na='a'\nb='b'\nc='c' />";
        XMLFormatterSplitAttributesTest.assertFormat(content, expected, settings, XMLAssert.te(0, 5, 0, 7, "\n"), XMLAssert.te(0, 12, 0, 13, "\n"), XMLAssert.te(0, 18, 0, 19, "\n"), XMLAssert.te(0, 24, 0, 24, " "), XMLAssert.te(0, 26, 1, 0, ""));
        XMLFormatterSplitAttributesTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void splitAttributesIndentSizeNegative() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setSplitAttributes(true);
        settings.getFormattingSettings().setSplitAttributesIndentSize(-1);
        String content = "<root  a='a' b='b' c='c'/>\n";
        String expected = "<root\na='a'\nb='b'\nc='c' />";
        XMLFormatterSplitAttributesTest.assertFormat(content, expected, settings, XMLAssert.te(0, 5, 0, 7, "\n"), XMLAssert.te(0, 12, 0, 13, "\n"), XMLAssert.te(0, 18, 0, 19, "\n"), XMLAssert.te(0, 24, 0, 24, " "), XMLAssert.te(0, 26, 1, 0, ""));
        XMLFormatterSplitAttributesTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void splitAttributesIndentSize1() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setSplitAttributes(true);
        settings.getFormattingSettings().setSplitAttributesIndentSize(1);
        String content = "<root  a='a' b='b' c='c'/>\n";
        String expected = "<root\n  a='a'\n  b='b'\n  c='c' />";
        XMLFormatterSplitAttributesTest.assertFormat(content, expected, settings, XMLAssert.te(0, 5, 0, 7, "\n  "), XMLAssert.te(0, 12, 0, 13, "\n  "), XMLAssert.te(0, 18, 0, 19, "\n  "), XMLAssert.te(0, 24, 0, 24, " "), XMLAssert.te(0, 26, 1, 0, ""));
        XMLFormatterSplitAttributesTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void splitAttributesIndentSizeDefault() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setSplitAttributes(true);
        String content = "<root  a='a' b='b' c='c'/>\n";
        String expected = "<root\n    a='a'\n    b='b'\n    c='c' />";
        XMLFormatterSplitAttributesTest.assertFormat(content, expected, settings, XMLAssert.te(0, 5, 0, 7, "\n    "), XMLAssert.te(0, 12, 0, 13, "\n    "), XMLAssert.te(0, 18, 0, 19, "\n    "), XMLAssert.te(0, 24, 0, 24, " "), XMLAssert.te(0, 26, 1, 0, ""));
        XMLFormatterSplitAttributesTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testSplitAttributesNested() throws BadLocationException {
        String content = "<a k1=\"v1\" k2=\"v2\"><b aa=\"ok\" bb = \"oo\"></b></a>";
        String expected = "<a" + System.lineSeparator() + "    k1=\"v1\"" + System.lineSeparator() + "    k2=\"v2\">" + System.lineSeparator() + "  <b" + System.lineSeparator() + "      aa=\"ok\"" + System.lineSeparator() + "      bb=\"oo\"></b>" + System.lineSeparator() + "</a>";
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setSplitAttributes(true);
        XMLFormatterSplitAttributesTest.assertFormat(content, expected, settings, XMLAssert.te(0, 2, 0, 3, System.lineSeparator() + "    "), XMLAssert.te(0, 10, 0, 11, System.lineSeparator() + "    "), XMLAssert.te(0, 19, 0, 19, System.lineSeparator() + "  "), XMLAssert.te(0, 21, 0, 22, System.lineSeparator() + "      "), XMLAssert.te(0, 29, 0, 30, System.lineSeparator() + "      "), XMLAssert.te(0, 32, 0, 33, ""), XMLAssert.te(0, 34, 0, 35, ""), XMLAssert.te(0, 44, 0, 44, System.lineSeparator()));
        XMLFormatterSplitAttributesTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testNestedAttributesNoSplit() throws BadLocationException {
        String content = "<a k1=\"v1\" k2=\"v2\"><b aa=\"ok\" bb = \"oo\"></b></a>";
        String expected = "<a k1=\"v1\" k2=\"v2\">" + System.lineSeparator() + "  <b aa=\"ok\" bb=\"oo\"></b>" + System.lineSeparator() + "</a>";
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setSplitAttributes(false);
        XMLFormatterSplitAttributesTest.assertFormat(content, expected, settings, XMLAssert.te(0, 19, 0, 19, System.lineSeparator() + "  "), XMLAssert.te(0, 32, 0, 33, ""), XMLAssert.te(0, 34, 0, 35, ""), XMLAssert.te(0, 44, 0, 44, System.lineSeparator()));
        XMLFormatterSplitAttributesTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testSplitAttributesProlog() throws BadLocationException {
        String content;
        String expected = content = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setSplitAttributes(true);
        XMLFormatterSplitAttributesTest.assertFormat(content, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testSplitAttributesSingle() throws BadLocationException {
        String content;
        String expected = content = "<a k1=\"v1\"></a>";
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setSplitAttributes(true);
        XMLFormatterSplitAttributesTest.assertFormat(content, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testSplitAttributes() throws BadLocationException {
        String content = "<a k1=\"v1\" k2=\"v2\"></a>";
        String expected = "<a" + System.lineSeparator() + "    k1=\"v1\"" + System.lineSeparator() + "    k2=\"v2\"></a>";
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setSplitAttributes(true);
        XMLFormatterSplitAttributesTest.assertFormat(content, expected, settings, XMLAssert.te(0, 2, 0, 3, System.lineSeparator() + "    "), XMLAssert.te(0, 10, 0, 11, System.lineSeparator() + "    "));
        XMLFormatterSplitAttributesTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testEndTagMissingCloseBracket2() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setSpaceBeforeEmptyCloseTag(false);
        settings.getFormattingSettings().setSplitAttributes(true);
        String content = "<web-app \n         xmlns=\"http://xmlns.jcp.org/xml/ns/javaee\"\n         xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xsi:schemaLocation=\"http://xmlns.jcp.org/xml/ns/javaee \n                http://xmlns.jcp.org/xml/ns/javaee/web-app_3_1.xsd\"\n         version=\"3.1\">\n         <servlet>\n             <servlet-name>sssi</servlet-name>\n         </servlet\n</web-app>";
        String expected = "<web-app\n    xmlns=\"http://xmlns.jcp.org/xml/ns/javaee\"\n    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n    xsi:schemaLocation=\"http://xmlns.jcp.org/xml/ns/javaee http://xmlns.jcp.org/xml/ns/javaee/web-app_3_1.xsd\"\n    version=\"3.1\">\n  <servlet>\n    <servlet-name>sssi</servlet-name>\n  </servlet\n</web-app>";
        XMLFormatterSplitAttributesTest.assertFormat(content, expected, settings, XMLAssert.te(0, 8, 1, 9, "\n    "), XMLAssert.te(1, 51, 2, 9, "\n    "), XMLAssert.te(2, 62, 3, 9, "\n    "), XMLAssert.te(3, 63, 4, 16, " "), XMLAssert.te(4, 67, 5, 9, "\n    "), XMLAssert.te(5, 23, 6, 9, "\n  "), XMLAssert.te(6, 18, 7, 13, "\n    "), XMLAssert.te(7, 46, 8, 9, "\n  "));
        XMLFormatterSplitAttributesTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    private static void assertFormat(String unformatted, String expected, SharedSettings sharedSettings, TextEdit ... expectedEdits) throws BadLocationException {
        XMLFormatterSplitAttributesTest.assertFormat(unformatted, expected, sharedSettings, "test://test.html", expectedEdits);
    }

    private static void assertFormat(String unformatted, String expected, SharedSettings sharedSettings, String uri, TextEdit ... expectedEdits) throws BadLocationException {
        XMLFormatterSplitAttributesTest.assertFormat(unformatted, expected, sharedSettings, uri, true, expectedEdits);
    }

    private static void assertFormat(String unformatted, String expected, SharedSettings sharedSettings, String uri, Boolean considerRangeFormat, TextEdit ... expectedEdits) throws BadLocationException {
        XMLAssert.assertFormat(null, unformatted, expected, sharedSettings, uri, considerRangeFormat, expectedEdits);
    }
}

