/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.catalog;

import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.xerces.impl.XMLEntityManager;
import org.apache.xerces.util.URI;
import org.eclipse.lemminx.dom.DOMAttr;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMElement;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.extensions.catalog.CatalogCatalogEntry;
import org.eclipse.lemminx.extensions.catalog.CatalogEntry;
import org.eclipse.lemminx.extensions.catalog.URICatalogEntry;
import org.eclipse.lemminx.utils.DOMUtils;
import org.eclipse.lemminx.utils.FilesUtils;
import org.eclipse.lemminx.utils.StringUtils;
import org.eclipse.lsp4j.jsonrpc.validation.NonNull;

public class CatalogUtils {
    private static final Collection<String> HAS_URI_ATTRIBUTE = Arrays.asList("public", "system", "uri", "systemSuffix", "uriSuffix");
    private static final Collection<String> HAS_CATALOG_ATTRIBUTE = Arrays.asList("delegatePublic", "delegateSystem", "delegateUri", "nextCatalog");
    private static final String XML_BASE_ATTRIBUTE = "xml:base";
    private static final String CATALOG_ENTITY_NAME = "catalog";
    private static final String GROUP_ENTITY_NAME = "group";
    private static final String URI_ATTRIBUTE_NAME = "uri";
    private static final String CATALOG_ATTRIBUTE_NAME = "catalog";

    public static List<CatalogEntry> getCatalogEntries(DOMDocument document) {
        if (!DOMUtils.isCatalog(document)) {
            return Collections.emptyList();
        }
        for (DOMNode n : document.getChildren()) {
            if (!n.isElement() || !"catalog".equals(n.getNodeName())) continue;
            return CatalogUtils.collectCatalogEntries((DOMElement)n);
        }
        return Collections.emptyList();
    }

    public static DOMAttr getCatalogEntryURI(DOMElement element) {
        return element.getAttributeNode(URI_ATTRIBUTE_NAME);
    }

    public static DOMAttr getCatalogEntryCatalog(DOMElement element) {
        return element.getAttributeNode("catalog");
    }

    private static boolean isCatalogEntryWithURI(DOMElement element) {
        return HAS_URI_ATTRIBUTE.contains(element.getNodeName());
    }

    private static boolean isCatalogEntryWithCatalog(DOMElement element) {
        return HAS_CATALOG_ATTRIBUTE.contains(element.getNodeName());
    }

    private static boolean isGroupCatalogEntry(DOMElement element) {
        return GROUP_ENTITY_NAME.equals(element.getNodeName());
    }

    private static List<CatalogEntry> collectCatalogEntries(@NonNull DOMElement catalog) {
        ArrayList<CatalogEntry> entries = new ArrayList<CatalogEntry>();
        String baseURI = catalog.getAttribute(XML_BASE_ATTRIBUTE);
        baseURI = baseURI == null ? "" : baseURI;
        for (DOMNode node : catalog.getChildren()) {
            if (!node.isElement()) continue;
            DOMElement element = (DOMElement)node;
            CatalogEntry catalogEntry = CatalogUtils.createCatalogEntry(baseURI, element);
            if (catalogEntry != null) {
                entries.add(catalogEntry);
                continue;
            }
            if (!CatalogUtils.isGroupCatalogEntry(element)) continue;
            entries.addAll(CatalogUtils.collectGroupEntries(element, baseURI));
        }
        return entries;
    }

    private static List<CatalogEntry> collectGroupEntries(DOMElement group, @NonNull String baseURI) {
        ArrayList<CatalogEntry> entries = new ArrayList<CatalogEntry>();
        String groupSegment = group.getAttribute(XML_BASE_ATTRIBUTE);
        if (groupSegment != null) {
            baseURI = Paths.get(baseURI, groupSegment).toString();
        }
        for (DOMNode node : group.getChildren()) {
            DOMElement element;
            CatalogEntry catalogEntry;
            if (!node.isElement() || (catalogEntry = CatalogUtils.createCatalogEntry(baseURI, element = (DOMElement)node)) == null) continue;
            entries.add(catalogEntry);
        }
        return entries;
    }

    private static CatalogEntry createCatalogEntry(@NonNull String baseURI, DOMElement element) {
        if (CatalogUtils.isCatalogEntryWithURI(element)) {
            return new URICatalogEntry(baseURI, element);
        }
        if (CatalogUtils.isCatalogEntryWithCatalog(element)) {
            return new CatalogCatalogEntry(baseURI, element);
        }
        return null;
    }

    public static String getResolvedLocation(DOMDocument document, CatalogEntry catalogEntry) {
        String location = catalogEntry.getResolvedURI();
        if (StringUtils.isBlank(location)) {
            return null;
        }
        try {
            return XMLEntityManager.expandSystemId((String)location, (String)FilesUtils.removeFileScheme(document.getDocumentURI()), (boolean)false);
        }
        catch (URI.MalformedURIException e) {
            return location;
        }
    }
}

