/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel.participants.codeactions.nogrammarconstraints;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.commons.CodeActionFactory;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.extensions.contentmodel.participants.codeactions.nogrammarconstraints.NoGrammarConstraintsCodeAction;
import org.eclipse.lemminx.extensions.generators.FileContentGeneratorManager;
import org.eclipse.lemminx.extensions.generators.FileContentGeneratorSettings;
import org.eclipse.lemminx.services.extensions.codeaction.ICodeActionResolverRequest;
import org.eclipse.lemminx.services.extensions.codeaction.ICodeActionResolvesParticipant;
import org.eclipse.lemminx.settings.SharedSettings;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.TextDocumentEdit;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public abstract class AbstractGenerateGrammarAndAssociationResolveCodeActionParticipant
implements ICodeActionResolvesParticipant {
    private static final Logger LOGGER = Logger.getLogger(AbstractGenerateGrammarAndAssociationResolveCodeActionParticipant.class.getName());

    @Override
    public final CodeAction resolveCodeAction(ICodeActionResolverRequest request, CancelChecker cancelChecker) {
        try {
            DOMDocument document = request.getDocument();
            CodeAction resolved = request.getUnresolved();
            String grammarURI = request.getDataProperty("file");
            String grammarFileName = NoGrammarConstraintsCodeAction.getFileName(grammarURI);
            SharedSettings sharedSettings = request.getSharedSettings();
            TextDocumentEdit noNamespaceSchemaLocationEdit = this.createFileEdit(grammarFileName, document, sharedSettings);
            FileContentGeneratorManager generator = (FileContentGeneratorManager)request.getComponent(FileContentGeneratorManager.class);
            String schemaTemplate = generator.generate(document, sharedSettings, this.getFileContentGeneratorSettings(), cancelChecker);
            AbstractGenerateGrammarAndAssociationResolveCodeActionParticipant.updateGrammarFileAndBindIt(resolved, grammarURI, schemaTemplate, noNamespaceSchemaLocationEdit);
            return resolved;
        }
        catch (BadLocationException e) {
            LOGGER.log(Level.SEVERE, "In NoGrammarConstraintsCodeAction position error", e);
            return null;
        }
    }

    private static CodeAction updateGrammarFileAndBindIt(CodeAction codeAction, String grammarURI, String grammarContent, TextDocumentEdit boundEdit) {
        WorkspaceEdit createAndAddContentEdit = CodeActionFactory.createFileEdit(grammarURI, grammarContent);
        codeAction.setEdit(createAndAddContentEdit);
        codeAction.getEdit().getDocumentChanges().add(Either.forLeft((Object)boundEdit));
        return codeAction;
    }

    protected abstract TextDocumentEdit createFileEdit(String var1, DOMDocument var2, SharedSettings var3) throws BadLocationException;

    protected abstract FileContentGeneratorSettings getFileContentGeneratorSettings();
}

