/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.callgraph.launch;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICContainer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.linuxtools.internal.callgraph.launch.SystemTapLaunchShortcut;

public class ListTreeContentProvider
implements ITreeContentProvider {
    public Object[] getChildren(Object parentElement) {
        ArrayList<ICElement> output = new ArrayList<ICElement>();
        if (parentElement instanceof ICContainer) {
            try {
                ICElement[] list;
                for (ICElement item : list = ((ICContainer)parentElement).getChildren()) {
                    ICElement el;
                    if (item instanceof ICContainer) {
                        if (!this.checkForValidChildren((ICContainer)item)) continue;
                        output.add(item);
                        continue;
                    }
                    if (!(item instanceof ICElement) || !SystemTapLaunchShortcut.validElement(el = item)) continue;
                    output.add(el);
                }
                return output.toArray();
            }
            catch (CModelException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private boolean checkForValidChildren(ICContainer cont) {
        try {
            for (ICElement child : cont.getChildren()) {
                if (child != null && SystemTapLaunchShortcut.validElement(child)) {
                    return true;
                }
                if (!(child instanceof ICContainer) || !this.checkForValidChildren((ICContainer)child)) continue;
                return true;
            }
        }
        catch (CModelException e) {
            e.printStackTrace();
        }
        return false;
    }

    public Object getParent(Object element) {
        if (element instanceof ICElement) {
            return ((ICElement)element).getAncestor(12);
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof ICContainer) {
            try {
                if (((ICContainer)element).getChildren().length > 0) {
                    return true;
                }
            }
            catch (CModelException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof List) {
            for (Object element : (List)inputElement) {
                if (!(element instanceof ICContainer)) continue;
                try {
                    ICElement[] array = ((ICContainer)element).getChildren();
                    ArrayList<ICElement> output = new ArrayList<ICElement>();
                    for (ICElement item : array) {
                        if (item instanceof ICContainer && this.checkForValidChildren((ICContainer)item)) {
                            output.add(item);
                        }
                        if (!SystemTapLaunchShortcut.validElement(item)) continue;
                        output.add(item);
                    }
                    return output.toArray();
                }
                catch (CModelException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Object[] findElements(Object inputElement) {
        ArrayList<Object> output = new ArrayList<Object>();
        if (inputElement instanceof List) {
            for (Object element : (List)inputElement) {
                Object[] list;
                for (Object o : list = this.getChildren(element)) {
                    output.add(o);
                }
            }
        }
        return output.toArray();
    }
}

