/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tools.launch.core.properties;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class LinuxtoolsPathProperty {
    private static final String LINUXTOOLS_PATH_EXT_POINT = "LinuxtoolsPathOptions";
    private static final String LINUXTOOLS_PATH_OPTION = "option";
    private static final String LINUXTOOLS_PATH_OPTION_PATH = "path";
    private static final String LINUXTOOLS_PATH_OPTION_DEFAULT = "default";
    private String linuxtoolsPathDefault = "";
    private String linuxtoolsPrefixDefault = "";
    private boolean linuxtoolsPathSystemDefault = true;
    private static LinuxtoolsPathProperty instance = null;

    private void fillLinuxtoolsPath(String path) {
        if (path != null && !path.isEmpty()) {
            this.linuxtoolsPathSystemDefault = false;
            this.linuxtoolsPathDefault = path;
        }
    }

    private LinuxtoolsPathProperty() {
        IExtensionPoint extPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.linuxtools.tools.launch.core", LINUXTOOLS_PATH_EXT_POINT);
        if (extPoint != null) {
            IConfigurationElement[] configs;
            for (IConfigurationElement config : configs = extPoint.getConfigurationElements()) {
                String sdefault;
                if (!config.getName().equals(LINUXTOOLS_PATH_OPTION) || (sdefault = config.getAttribute(LINUXTOOLS_PATH_OPTION_DEFAULT)) == null || !sdefault.equals(Boolean.toString(true))) continue;
                this.fillLinuxtoolsPath(config.getAttribute(LINUXTOOLS_PATH_OPTION_PATH));
                break;
            }
        }
    }

    public static LinuxtoolsPathProperty getInstance() {
        if (instance == null) {
            instance = new LinuxtoolsPathProperty();
        }
        return instance;
    }

    public String getLinuxtoolsPath(IProject project) {
        if (project == null) {
            return "";
        }
        ScopedPreferenceStore store = new ScopedPreferenceStore((IScopeContext)new ProjectScope(project), "org.eclipse.linuxtools.tools.launch.core");
        boolean systemPathSelected = store.contains("org.eclipse.linuxtools.tools.launch.core.LinuxtoolsSystemEnvPath") ? store.getBoolean("org.eclipse.linuxtools.tools.launch.core.LinuxtoolsSystemEnvPath") : this.getLinuxtoolsPathSystemDefault();
        if (systemPathSelected) {
            return "";
        }
        String path = null;
        if (store.contains("org.eclipse.linuxtools.tools.launch.core.LinuxtoolsPath")) {
            path = store.getString("org.eclipse.linuxtools.tools.launch.core.LinuxtoolsPath");
        }
        if (path == null) {
            return this.getLinuxtoolsPathDefault();
        }
        return path;
    }

    public String getLinuxtoolsPrefix(IProject project) {
        if (project == null) {
            return "";
        }
        ScopedPreferenceStore store = new ScopedPreferenceStore((IScopeContext)new ProjectScope(project), "org.eclipse.linuxtools.tools.launch.core");
        String prefix = null;
        if (store.contains("org.eclipse.linuxtools.tools.launch.core.LinuxtoolsPrefix")) {
            prefix = store.getString("org.eclipse.linuxtools.tools.launch.core.LinuxtoolsPrefix");
        }
        if (prefix == null) {
            return this.getLinuxtoolsPrefixDefault();
        }
        return prefix;
    }

    public String getLinuxtoolsPathDefault() {
        return this.linuxtoolsPathDefault;
    }

    public String getLinuxtoolsPrefixDefault() {
        return this.linuxtoolsPrefixDefault;
    }

    public boolean getLinuxtoolsPathSystemDefault() {
        return this.linuxtoolsPathSystemDefault;
    }
}

