/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.internal.support;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swtchart.extensions.core.CustomSeriesListUI;
import org.eclipse.swtchart.extensions.model.ICustomSeries;

public class CustomSeriesEditingSupport
extends EditingSupport {
    private CustomSeriesListUI customSeriesListUI;
    private int columnIndex = 0;

    public CustomSeriesEditingSupport(CustomSeriesListUI seriesListUI, int columnIndex) {
        super((ColumnViewer)seriesListUI);
        this.customSeriesListUI = seriesListUI;
        this.columnIndex = columnIndex;
    }

    protected boolean canEdit(Object element) {
        return switch (this.columnIndex) {
            case 1 -> true;
            default -> false;
        };
    }

    protected CellEditor getCellEditor(Object element) {
        return switch (this.columnIndex) {
            case 1 -> new CheckboxCellEditor((Composite)this.customSeriesListUI.getTable());
            default -> new TextCellEditor((Composite)this.customSeriesListUI.getTable());
        };
    }

    protected Object getValue(Object element) {
        Boolean object = null;
        if (element instanceof ICustomSeries) {
            ICustomSeries customSeries = (ICustomSeries)element;
            switch (this.columnIndex) {
                case 1: {
                    object = customSeries.isDraw();
                    break;
                }
                default: {
                    object = null;
                }
            }
        }
        return object;
    }

    protected void setValue(Object element, Object object) {
        if (element instanceof ICustomSeries) {
            ICustomSeries customSeries = (ICustomSeries)element;
            switch (this.columnIndex) {
                case 1: {
                    customSeries.setDraw(Boolean.valueOf(object.toString()));
                }
            }
            this.refresh();
        }
    }

    private void refresh() {
        this.customSeriesListUI.refresh();
    }
}

