/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.emf.common.util;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.lsat.common.emf.common.util.UnsupportedURIException;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public final class URIHelper {
    public static final long UNKNOWN_CONTENT_LENGTH = -1L;

    private URIHelper() {
    }

    public static final String baseName(IResource resource) {
        String name = resource.getName();
        String extension = resource.getFileExtension();
        return extension == null ? name : name.substring(0, name.length() - extension.length() - 1);
    }

    public static final String baseName(File file) {
        String name = file.getName();
        return name.indexOf(46) < 0 ? name : name.substring(0, name.lastIndexOf(46));
    }

    public static final String baseName(URI uri) throws UnsupportedURIException {
        if (!uri.isHierarchical()) {
            throw new UnsupportedURIException("Only hierarchical URI's are supported: " + uri);
        }
        return uri.trimFileExtension().lastSegment();
    }

    public static URI asURI(Class<?> clazz, String resourceName) {
        if (!Platform.isRunning()) {
            return URIHelper.asURI(clazz.getResource(resourceName));
        }
        Bundle bundle = FrameworkUtil.getBundle(clazz);
        if (bundle == null) {
            return null;
        }
        String pathName = "/" + bundle.getSymbolicName() + "/" + URIHelper.resolveName(clazz, resourceName);
        return URI.createPlatformPluginURI((String)pathName, (boolean)true);
    }

    private static String resolveName(Class<?> clazz, String resourceName) {
        if (resourceName == null) {
            return resourceName;
        }
        if (!resourceName.startsWith("/")) {
            Class<?> c = clazz;
            while (c.isArray()) {
                c = c.getComponentType();
            }
            String baseName = c.getName();
            int index = baseName.lastIndexOf(46);
            if (index != -1) {
                resourceName = String.valueOf(baseName.substring(0, index).replace('.', '/')) + "/" + resourceName;
            }
        } else {
            resourceName = resourceName.substring(1);
        }
        return resourceName;
    }

    public static URI asURI(URL url) {
        if (url == null) {
            return null;
        }
        return URI.createURI((String)url.toString());
    }

    public static URI asURI(IResource resource) {
        if (resource == null) {
            return null;
        }
        return URI.createPlatformResourceURI((String)resource.getFullPath().toString(), (boolean)true);
    }

    public static URI asURI(File file) {
        if (file == null) {
            return null;
        }
        IResource resource = URIHelper.asIResource(file);
        return resource == null ? URI.createFileURI((String)file.getAbsolutePath()) : URIHelper.asURI(resource);
    }

    public static IResource asIResource(URI uri) throws UnsupportedURIException {
        if (uri == null) {
            return null;
        }
        if (uri.isPlatformResource()) {
            return URIHelper.getWorkspaceRoot().findMember(uri.toPlatformString(true), true);
        }
        if (uri.isFile()) {
            return URIHelper.asIResource(new File(uri.toFileString()));
        }
        throw new UnsupportedURIException("URI scheme is not supported: " + uri);
    }

    public static IResource asIResource(File file) {
        if (file == null) {
            return null;
        }
        IPath fileLocation = Path.fromOSString((String)file.getAbsolutePath());
        IWorkspaceRoot workspaceRoot = URIHelper.getWorkspaceRoot();
        IProject[] projects = workspaceRoot.getProjects();
        IResource resource = URIHelper.findIResource(fileLocation, (IContainer)workspaceRoot);
        int i = 0;
        while (resource == null && i < projects.length) {
            resource = URIHelper.findIResource(fileLocation, (IContainer)projects[i]);
            ++i;
        }
        return resource;
    }

    public static File asFile(URI uri) throws UnsupportedURIException {
        if (uri == null) {
            return null;
        }
        if (uri.isPlatformResource()) {
            return URIHelper.asFile(URIHelper.asIResource(uri));
        }
        if (uri.isFile()) {
            return new File(uri.toFileString());
        }
        throw new UnsupportedURIException("URI scheme is not supported: " + uri);
    }

    public static File asFile(IResource resource) {
        if (resource == null) {
            return null;
        }
        IPath location = resource.getLocation();
        if (location == null) {
            return null;
        }
        return location.toFile();
    }

    public static URI decorateScheme(URI uri, String decorationScheme) {
        if (URIHelper.isSchemeDecoratedWith(uri, decorationScheme)) {
            return uri;
        }
        if (uri.scheme() == null) {
            return URI.createURI((String)(String.valueOf(decorationScheme) + ':' + uri));
        }
        return URI.createURI((String)(String.valueOf(decorationScheme) + '+' + uri));
    }

    public static URI undecorateScheme(URI uri, String decorationScheme) {
        if (!URIHelper.isSchemeDecoratedWith(uri, decorationScheme)) {
            return uri;
        }
        return URI.createURI((String)uri.toString().substring(decorationScheme.length() + 1));
    }

    public static boolean isSchemeDecoratedWith(URI uri, String decorationScheme) {
        if (decorationScheme == null || !URI.validScheme((String)decorationScheme)) {
            throw new IllegalArgumentException("Not a valid scheme: " + decorationScheme);
        }
        String scheme = uri.scheme();
        return scheme != null && (decorationScheme.equals(scheme) || scheme.startsWith(String.valueOf(decorationScheme) + '+'));
    }

    public static URI getParent(URI uri) {
        return uri.trimSegments(1);
    }

    public static URI getProject(URI uri) throws UnsupportedURIException {
        if (uri == null) {
            return null;
        }
        if (uri.isPlatformResource()) {
            return uri.trimSegments(uri.segmentCount() - 2);
        }
        if (uri.isFile()) {
            IResource resource = URIHelper.asIResource(new File(uri.toFileString()));
            return resource == null ? null : URIHelper.asURI((IResource)resource.getProject());
        }
        throw new UnsupportedURIException("URI scheme is not supported: " + uri);
    }

    public static File getProject(File file) {
        if (file == null) {
            return null;
        }
        IResource resource = URIHelper.asIResource(file);
        return resource == null ? null : URIHelper.asFile((IResource)resource.getProject());
    }

    public static long determineContentLength(@NonNull URI uri) throws UnsupportedURIException {
        Assert.isNotNull((Object)uri, (String)"uri must not be null");
        if (uri.isPlatformResource()) {
            return URIHelper.determineContentLength(URIHelper.asIResource(uri));
        }
        if (uri.isFile()) {
            return URIHelper.determineContentLength(URIHelper.asFile(uri));
        }
        return -1L;
    }

    public static long determineContentLength(@NonNull IResource resource) throws UnsupportedURIException {
        block3: {
            Assert.isNotNull((Object)resource, (String)"resource must not be null");
            try {
                if (resource.exists()) break block3;
                return -1L;
            }
            catch (CoreException e) {
                throw new UnsupportedURIException(e);
            }
        }
        return EFS.getStore((java.net.URI)resource.getLocationURI()).fetchInfo(1024, null).getLength();
    }

    public static long determineContentLength(@NonNull File file) {
        Assert.isNotNull((Object)file, (String)"file must not be null");
        if (!file.exists()) {
            return -1L;
        }
        return file.length();
    }

    public static Map<String, String> getQueryParameters(URI uri) {
        String query = uri.query();
        if (query == null) {
            return Collections.emptyMap();
        }
        try {
            String[] paramParts = query.split("&");
            LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>(paramParts.length);
            String[] stringArray = paramParts;
            int n = paramParts.length;
            int n2 = 0;
            while (n2 < n) {
                String paramPart = stringArray[n2];
                String[] keyValue = paramPart.split("=", 2);
                String value = keyValue.length < 2 ? null : URLDecoder.decode(keyValue[1], StandardCharsets.UTF_8.toString());
                parameters.put(keyValue[0], value);
                ++n2;
            }
            return parameters;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Programming error: " + e.getMessage(), e);
        }
    }

    public static URI setQueryParameters(URI uri, Map<String, String> parameters) {
        String query = parameters.entrySet().stream().map(URIHelper::encodeQueryParameter).collect(Collectors.joining("&"));
        return uri.appendQuery(query);
    }

    private static String encodeQueryParameter(Map.Entry<String, String> param) {
        try {
            StringBuilder paramString = new StringBuilder();
            paramString.append(param.getKey());
            if (param.getValue() != null) {
                paramString.append('=').append(URLEncoder.encode(param.getValue(), StandardCharsets.UTF_8.toString()));
            }
            return paramString.toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Programming error: " + e.getMessage(), e);
        }
    }

    private static IResource findIResource(IPath resourceLocation, IContainer container) {
        IPath containerLocation = container.getLocation();
        if (!containerLocation.isPrefixOf(resourceLocation)) {
            return null;
        }
        IPath relativeLocation = resourceLocation.removeFirstSegments(containerLocation.segmentCount());
        return container.findMember(relativeLocation, true);
    }

    private static final IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public static void main(String[] args) {
        System.out.println(URIHelper.baseName(new File("File.txt")));
        System.out.println(URIHelper.baseName(URI.createFileURI((String)"URI.txt")));
    }
}

