/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.emf.ecore.resource;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.lsat.common.emf.common.util.DiagnosticUtil;
import org.eclipse.lsat.common.emf.ecore.resource.ResourceIOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public final class Persistor<T extends EObject> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Persistor.class);
    private static final Marker LOG_MARKER = MarkerFactory.getMarker((String)"PERSIST");
    private final ResourceSet resourceSet;
    private final Class<T> type;
    private final boolean multipleRootTypesAllowed;
    private final boolean ignoreProblems;

    Persistor(ResourceSet resourceSet, Class<T> type, boolean multipleRootTypesAllowed, boolean ignoreProblems) {
        this.resourceSet = resourceSet;
        this.type = type;
        this.multipleRootTypesAllowed = multipleRootTypesAllowed;
        this.ignoreProblems = ignoreProblems;
    }

    public T loadOne(URI aUri) throws IOException {
        return this.loadOne(aUri, null);
    }

    public T loadOne(URI aUri, Map<?, ?> options) throws IOException {
        List<T> contents = this.loadAll(aUri, options);
        if (contents.size() != 1) {
            throw new ResourceIOException("Number of models in file '" + aUri + "' not equal to 1; actual number: " + contents.size());
        }
        return (T)((EObject)contents.iterator().next());
    }

    public List<T> loadAll(URI aUri) throws IOException {
        return this.loadAll(aUri, null);
    }

    public List<T> loadAll(URI aUri, Map<?, ?> options) throws IOException {
        try {
            Resource resource = this.resourceSet.getResource(aUri, false);
            if (resource == null) {
                resource = this.resourceSet.createResource(aUri, "");
            }
            resource.load(options);
            Diagnostic resourceDiagnostic = EcoreUtil.computeDiagnostic((Resource)resource, (boolean)true);
            if (!this.ignoreProblems) {
                if (resourceDiagnostic.getSeverity() >= 4) {
                    throw new ResourceIOException("Failed to load resource with the following message(s):\n" + DiagnosticUtil.getFullMessage(resourceDiagnostic.getChildren()));
                }
                DiagnosticUtil.logFull(resourceDiagnostic.getChildren(), LOGGER);
            }
            EList rawContents = resource.getContents();
            if (this.type == null || EObject.class.equals(this.type) || !this.multipleRootTypesAllowed) {
                return rawContents;
            }
            ArrayList<EObject> contents = new ArrayList<EObject>(rawContents.size());
            for (EObject eObject : rawContents) {
                if (!this.type.isInstance(eObject)) continue;
                contents.add((EObject)this.type.cast(eObject));
            }
            return contents;
        }
        catch (WrappedException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw e;
        }
    }

    @SafeVarargs
    public final void save(URI aUri, EObject ... eObjects) throws IOException {
        this.save(aUri, null, false, Arrays.asList(eObjects));
    }

    @SafeVarargs
    public final void save(URI aUri, Collection<? extends EObject> ... eObjectCollections) throws IOException {
        this.save(aUri, null, false, eObjectCollections);
    }

    @SafeVarargs
    public final void save(URI uri, boolean unload, Collection<? extends EObject> ... eObjectCollections) throws IOException {
        this.save(uri, null, unload, eObjectCollections);
    }

    @SafeVarargs
    public final void save(URI aUri, Map<?, ?> options, EObject ... eObjects) throws IOException {
        this.save(aUri, options, false, Arrays.asList(eObjects));
    }

    @SafeVarargs
    public final void save(URI aUri, Map<?, ?> options, Collection<? extends EObject> ... eObjectCollections) throws IOException {
        this.save(aUri, options, false, eObjectCollections);
    }

    @SafeVarargs
    public final void save(URI uri, Map<?, ?> options, boolean unload, Collection<? extends EObject> ... eObjectCollections) throws IOException {
        Resource resource = this.resourceSet.createResource(uri);
        Collection<? extends EObject>[] collectionArray = eObjectCollections;
        int n = eObjectCollections.length;
        int n2 = 0;
        while (n2 < n) {
            Collection<? extends EObject> eObjects = collectionArray[n2];
            resource.getContents().addAll(eObjects);
            ++n2;
        }
        LOGGER.debug(LOG_MARKER, "Starting: Writing {}", (Object)uri.lastSegment());
        resource.save(options);
        if (unload) {
            resource.unload();
        }
        LOGGER.debug(LOG_MARKER, "Finished: Writing {}", (Object)uri.lastSegment());
    }
}

