/**
 */
package machine.provider;

import java.util.ArrayList;
import java.util.Collection;

import machine.util.MachineAdapterFactory;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class MachineItemProviderAdapterFactory extends MachineAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public MachineItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link machine.PeripheralType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PeripheralTypeItemProvider peripheralTypeItemProvider;

	/**
	 * This creates an adapter for a {@link machine.PeripheralType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPeripheralTypeAdapter() {
		if (peripheralTypeItemProvider == null) {
			peripheralTypeItemProvider = new PeripheralTypeItemProvider(this);
		}

		return peripheralTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link machine.SymbolicPosition} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SymbolicPositionItemProvider symbolicPositionItemProvider;

	/**
	 * This creates an adapter for a {@link machine.SymbolicPosition}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSymbolicPositionAdapter() {
		if (symbolicPositionItemProvider == null) {
			symbolicPositionItemProvider = new SymbolicPositionItemProvider(this);
		}

		return symbolicPositionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link machine.Resource} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ResourceItemProvider resourceItemProvider;

	/**
	 * This creates an adapter for a {@link machine.Resource}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createResourceAdapter() {
		if (resourceItemProvider == null) {
			resourceItemProvider = new ResourceItemProvider(this);
		}

		return resourceItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link machine.ActionType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ActionTypeItemProvider actionTypeItemProvider;

	/**
	 * This creates an adapter for a {@link machine.ActionType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createActionTypeAdapter() {
		if (actionTypeItemProvider == null) {
			actionTypeItemProvider = new ActionTypeItemProvider(this);
		}

		return actionTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link machine.Peripheral} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PeripheralItemProvider peripheralItemProvider;

	/**
	 * This creates an adapter for a {@link machine.Peripheral}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPeripheralAdapter() {
		if (peripheralItemProvider == null) {
			peripheralItemProvider = new PeripheralItemProvider(this);
		}

		return peripheralItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link machine.Machine} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MachineItemProvider machineItemProvider;

	/**
	 * This creates an adapter for a {@link machine.Machine}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMachineAdapter() {
		if (machineItemProvider == null) {
			machineItemProvider = new MachineItemProvider(this);
		}

		return machineItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link machine.Import} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ImportItemProvider importItemProvider;

	/**
	 * This creates an adapter for a {@link machine.Import}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createImportAdapter() {
		if (importItemProvider == null) {
			importItemProvider = new ImportItemProvider(this);
		}

		return importItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link machine.Profile} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ProfileItemProvider profileItemProvider;

	/**
	 * This creates an adapter for a {@link machine.Profile}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createProfileAdapter() {
		if (profileItemProvider == null) {
			profileItemProvider = new ProfileItemProvider(this);
		}

		return profileItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link machine.Axis} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AxisItemProvider axisItemProvider;

	/**
	 * This creates an adapter for a {@link machine.Axis}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAxisAdapter() {
		if (axisItemProvider == null) {
			axisItemProvider = new AxisItemProvider(this);
		}

		return axisItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link machine.Position} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PositionItemProvider positionItemProvider;

	/**
	 * This creates an adapter for a {@link machine.Position}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPositionAdapter() {
		if (positionItemProvider == null) {
			positionItemProvider = new PositionItemProvider(this);
		}

		return positionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link machine.SetPoint} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SetPointItemProvider setPointItemProvider;

	/**
	 * This creates an adapter for a {@link machine.SetPoint}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSetPointAdapter() {
		if (setPointItemProvider == null) {
			setPointItemProvider = new SetPointItemProvider(this);
		}

		return setPointItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link java.util.Map.Entry} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AxisPositionMapEntryItemProvider axisPositionMapEntryItemProvider;

	/**
	 * This creates an adapter for a {@link java.util.Map.Entry}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAxisPositionMapEntryAdapter() {
		if (axisPositionMapEntryItemProvider == null) {
			axisPositionMapEntryItemProvider = new AxisPositionMapEntryItemProvider(this);
		}

		return axisPositionMapEntryItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link java.util.Map.Entry} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AxisPositionsMapEntryItemProvider axisPositionsMapEntryItemProvider;

	/**
	 * This creates an adapter for a {@link java.util.Map.Entry}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAxisPositionsMapEntryAdapter() {
		if (axisPositionsMapEntryItemProvider == null) {
			axisPositionsMapEntryItemProvider = new AxisPositionsMapEntryItemProvider(this);
		}

		return axisPositionsMapEntryItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link machine.PathTargetReference} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PathTargetReferenceItemProvider pathTargetReferenceItemProvider;

	/**
	 * This creates an adapter for a {@link machine.PathTargetReference}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPathTargetReferenceAdapter() {
		if (pathTargetReferenceItemProvider == null) {
			pathTargetReferenceItemProvider = new PathTargetReferenceItemProvider(this);
		}

		return pathTargetReferenceItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link machine.UnidirectionalPath} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected UnidirectionalPathItemProvider unidirectionalPathItemProvider;

	/**
	 * This creates an adapter for a {@link machine.UnidirectionalPath}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createUnidirectionalPathAdapter() {
		if (unidirectionalPathItemProvider == null) {
			unidirectionalPathItemProvider = new UnidirectionalPathItemProvider(this);
		}

		return unidirectionalPathItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link machine.BidirectionalPath} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BidirectionalPathItemProvider bidirectionalPathItemProvider;

	/**
	 * This creates an adapter for a {@link machine.BidirectionalPath}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBidirectionalPathAdapter() {
		if (bidirectionalPathItemProvider == null) {
			bidirectionalPathItemProvider = new BidirectionalPathItemProvider(this);
		}

		return bidirectionalPathItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link machine.FullMeshPath} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FullMeshPathItemProvider fullMeshPathItemProvider;

	/**
	 * This creates an adapter for a {@link machine.FullMeshPath}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFullMeshPathAdapter() {
		if (fullMeshPathItemProvider == null) {
			fullMeshPathItemProvider = new FullMeshPathItemProvider(this);
		}

		return fullMeshPathItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link machine.PathAnnotation} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PathAnnotationItemProvider pathAnnotationItemProvider;

	/**
	 * This creates an adapter for a {@link machine.PathAnnotation}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPathAnnotationAdapter() {
		if (pathAnnotationItemProvider == null) {
			pathAnnotationItemProvider = new PathAnnotationItemProvider(this);
		}

		return pathAnnotationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link machine.ResourceItem} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ResourceItemItemProvider resourceItemItemProvider;

	/**
	 * This creates an adapter for a {@link machine.ResourceItem}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createResourceItemAdapter() {
		if (resourceItemItemProvider == null) {
			resourceItemItemProvider = new ResourceItemItemProvider(this);
		}

		return resourceItemItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link machine.Distance} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DistanceItemProvider distanceItemProvider;

	/**
	 * This creates an adapter for a {@link machine.Distance}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDistanceAdapter() {
		if (distanceItemProvider == null) {
			distanceItemProvider = new DistanceItemProvider(this);
		}

		return distanceItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>) || (((Class<?>)type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void dispose() {
		if (peripheralTypeItemProvider != null) peripheralTypeItemProvider.dispose();
		if (symbolicPositionItemProvider != null) symbolicPositionItemProvider.dispose();
		if (resourceItemProvider != null) resourceItemProvider.dispose();
		if (actionTypeItemProvider != null) actionTypeItemProvider.dispose();
		if (peripheralItemProvider != null) peripheralItemProvider.dispose();
		if (machineItemProvider != null) machineItemProvider.dispose();
		if (importItemProvider != null) importItemProvider.dispose();
		if (profileItemProvider != null) profileItemProvider.dispose();
		if (axisItemProvider != null) axisItemProvider.dispose();
		if (positionItemProvider != null) positionItemProvider.dispose();
		if (setPointItemProvider != null) setPointItemProvider.dispose();
		if (axisPositionMapEntryItemProvider != null) axisPositionMapEntryItemProvider.dispose();
		if (axisPositionsMapEntryItemProvider != null) axisPositionsMapEntryItemProvider.dispose();
		if (pathTargetReferenceItemProvider != null) pathTargetReferenceItemProvider.dispose();
		if (unidirectionalPathItemProvider != null) unidirectionalPathItemProvider.dispose();
		if (bidirectionalPathItemProvider != null) bidirectionalPathItemProvider.dispose();
		if (fullMeshPathItemProvider != null) fullMeshPathItemProvider.dispose();
		if (pathAnnotationItemProvider != null) pathAnnotationItemProvider.dispose();
		if (resourceItemItemProvider != null) resourceItemItemProvider.dispose();
		if (distanceItemProvider != null) distanceItemProvider.dispose();
	}

}
