/*
 * Decompiled with CFR 0.152.
 */
package machine.util;

import machine.HasResourcePeripheral;
import machine.IResource;
import machine.Peripheral;

public class ResourcePeripheralKey {
    private final IResource resource;
    private final Peripheral peripheral;

    public ResourcePeripheralKey(HasResourcePeripheral target) {
        this.resource = target.getResource();
        this.peripheral = target.getPeripheral();
    }

    public ResourcePeripheralKey(IResource resource, Peripheral peripheral) {
        this.resource = resource;
        this.peripheral = peripheral;
    }

    public static ResourcePeripheralKey createKey(HasResourcePeripheral target) {
        return new ResourcePeripheralKey(target);
    }

    public IResource getResource() {
        return this.resource;
    }

    public Peripheral getPeripheral() {
        return this.peripheral;
    }

    public String fqn() {
        return String.valueOf(this.resource.fqn()) + "." + this.peripheral.getName();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.peripheral == null ? 0 : this.peripheral.hashCode());
        result = 31 * result + (this.resource == null ? 0 : this.resource.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResourcePeripheralKey other = (ResourcePeripheralKey)obj;
        if (this.peripheral == null ? other.peripheral != null : !this.peripheral.equals(other.peripheral)) {
            return false;
        }
        return !(this.resource == null ? other.resource != null : !this.resource.equals(other.resource));
    }
}

