/**
 * Copyright (c) 2021 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Do not edit: This file is generated by Xtext
 */
grammar InternalMachine;

options {
	superClass=AbstractInternalAntlrParser;
}

@lexer::header {
package org.eclipse.lsat.machine.teditor.parser.antlr.internal;

// Hack: Use our own Lexer superclass by means of import. 
// Currently there is no other way to specify the superclass for the lexer.
import org.eclipse.xtext.parser.antlr.Lexer;
}

@parser::header {
package org.eclipse.lsat.machine.teditor.parser.antlr.internal;

import org.eclipse.xtext.*;
import org.eclipse.xtext.parser.*;
import org.eclipse.xtext.parser.impl.*;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.parser.antlr.AbstractInternalAntlrParser;
import org.eclipse.xtext.parser.antlr.XtextTokenStream;
import org.eclipse.xtext.parser.antlr.XtextTokenStream.HiddenTokens;
import org.eclipse.xtext.parser.antlr.AntlrDatatypeRuleToken;
import org.eclipse.lsat.machine.teditor.services.MachineGrammarAccess;

}

@parser::members {

 	private MachineGrammarAccess grammarAccess;

    public InternalMachineParser(TokenStream input, MachineGrammarAccess grammarAccess) {
        this(input);
        this.grammarAccess = grammarAccess;
        registerRules(grammarAccess.getGrammar());
    }

    @Override
    protected String getFirstRuleName() {
    	return "Machine";
   	}

   	@Override
   	protected MachineGrammarAccess getGrammarAccess() {
   		return grammarAccess;
   	}

}

@rulecatch {
    catch (RecognitionException re) {
        recover(input,re);
        appendSkippedTokens();
    }
}

// Entry rule entryRuleMachine
entryRuleMachine returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getMachineRule()); }
	iv_ruleMachine=ruleMachine
	{ $current=$iv_ruleMachine.current; }
	EOF;

// Rule Machine
ruleMachine returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getMachineAccess().getMachineAction_0(),
					$current);
			}
		)
		(
			(
				{
					newCompositeNode(grammarAccess.getMachineAccess().getImportsImportParserRuleCall_1_0());
				}
				lv_imports_1_0=ruleImport
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getMachineRule());
					}
					add(
						$current,
						"imports",
						lv_imports_1_0,
						"org.eclipse.lsat.machine.teditor.Machine.Import");
					afterParserOrEnumRuleCall();
				}
			)
		)*
		(
			otherlv_2='Machine'
			{
				newLeafNode(otherlv_2, grammarAccess.getMachineAccess().getMachineKeyword_2_0());
			}
			(
				(
					lv_type_3_0=RULE_ID
					{
						newLeafNode(lv_type_3_0, grammarAccess.getMachineAccess().getTypeIDTerminalRuleCall_2_1_0());
					}
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getMachineRule());
						}
						setWithLastConsumed(
							$current,
							"type",
							lv_type_3_0,
							"org.eclipse.xtext.common.Terminals.ID");
					}
				)
			)
		)?
		(
			otherlv_4='PathAnnotations'
			{
				newLeafNode(otherlv_4, grammarAccess.getMachineAccess().getPathAnnotationsKeyword_3_0());
			}
			otherlv_5='{'
			{
				newLeafNode(otherlv_5, grammarAccess.getMachineAccess().getLeftCurlyBracketKeyword_3_1());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getMachineAccess().getPathAnnotationsPathAnnotationParserRuleCall_3_2_0());
					}
					lv_pathAnnotations_6_0=rulePathAnnotation
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getMachineRule());
						}
						add(
							$current,
							"pathAnnotations",
							lv_pathAnnotations_6_0,
							"org.eclipse.lsat.machine.teditor.Machine.PathAnnotation");
						afterParserOrEnumRuleCall();
					}
				)
			)*
			otherlv_7='}'
			{
				newLeafNode(otherlv_7, grammarAccess.getMachineAccess().getRightCurlyBracketKeyword_3_3());
			}
		)?
		(
			(
				(
					{
						newCompositeNode(grammarAccess.getMachineAccess().getPeripheralTypesPeripheralTypeParserRuleCall_4_0_0());
					}
					lv_peripheralTypes_8_0=rulePeripheralType
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getMachineRule());
						}
						add(
							$current,
							"peripheralTypes",
							lv_peripheralTypes_8_0,
							"org.eclipse.lsat.machine.teditor.Machine.PeripheralType");
						afterParserOrEnumRuleCall();
					}
				)
			)
			    |
			(
				(
					{
						newCompositeNode(grammarAccess.getMachineAccess().getResourcesResourceParserRuleCall_4_1_0());
					}
					lv_resources_9_0=ruleResource
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getMachineRule());
						}
						add(
							$current,
							"resources",
							lv_resources_9_0,
							"org.eclipse.lsat.machine.teditor.Machine.Resource");
						afterParserOrEnumRuleCall();
					}
				)
			)
		)*
	)
;

// Entry rule entryRuleImport
entryRuleImport returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getImportRule()); }
	iv_ruleImport=ruleImport
	{ $current=$iv_ruleImport.current; }
	EOF;

// Rule Import
ruleImport returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		otherlv_0='import'
		{
			newLeafNode(otherlv_0, grammarAccess.getImportAccess().getImportKeyword_0());
		}
		(
			(
				lv_importURI_1_0=RULE_STRING
				{
					newLeafNode(lv_importURI_1_0, grammarAccess.getImportAccess().getImportURISTRINGTerminalRuleCall_1_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getImportRule());
					}
					setWithLastConsumed(
						$current,
						"importURI",
						lv_importURI_1_0,
						"org.eclipse.xtext.common.Terminals.STRING");
				}
			)
		)
	)
;

// Entry rule entryRulePathAnnotation
entryRulePathAnnotation returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getPathAnnotationRule()); }
	iv_rulePathAnnotation=rulePathAnnotation
	{ $current=$iv_rulePathAnnotation.current; }
	EOF;

// Rule PathAnnotation
rulePathAnnotation returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getPathAnnotationAccess().getPathAnnotationAction_0(),
					$current);
			}
		)
		(
			(
				lv_name_1_0=RULE_ID
				{
					newLeafNode(lv_name_1_0, grammarAccess.getPathAnnotationAccess().getNameIDTerminalRuleCall_1_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getPathAnnotationRule());
					}
					setWithLastConsumed(
						$current,
						"name",
						lv_name_1_0,
						"org.eclipse.xtext.common.Terminals.ID");
				}
			)
		)
	)
;

// Entry rule entryRulePeripheralType
entryRulePeripheralType returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getPeripheralTypeRule()); }
	iv_rulePeripheralType=rulePeripheralType
	{ $current=$iv_rulePeripheralType.current; }
	EOF;

// Rule PeripheralType
rulePeripheralType returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getPeripheralTypeAccess().getPeripheralTypeAction_0(),
					$current);
			}
		)
		otherlv_1='PeripheralType'
		{
			newLeafNode(otherlv_1, grammarAccess.getPeripheralTypeAccess().getPeripheralTypeKeyword_1());
		}
		(
			(
				lv_name_2_0=RULE_ID
				{
					newLeafNode(lv_name_2_0, grammarAccess.getPeripheralTypeAccess().getNameIDTerminalRuleCall_2_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getPeripheralTypeRule());
					}
					setWithLastConsumed(
						$current,
						"name",
						lv_name_2_0,
						"org.eclipse.xtext.common.Terminals.ID");
				}
			)
		)
		otherlv_3='{'
		{
			newLeafNode(otherlv_3, grammarAccess.getPeripheralTypeAccess().getLeftCurlyBracketKeyword_3());
		}
		(
			otherlv_4='Actions'
			{
				newLeafNode(otherlv_4, grammarAccess.getPeripheralTypeAccess().getActionsKeyword_4_0());
			}
			otherlv_5='{'
			{
				newLeafNode(otherlv_5, grammarAccess.getPeripheralTypeAccess().getLeftCurlyBracketKeyword_4_1());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getPeripheralTypeAccess().getActionsActionTypeParserRuleCall_4_2_0());
					}
					lv_actions_6_0=ruleActionType
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getPeripheralTypeRule());
						}
						add(
							$current,
							"actions",
							lv_actions_6_0,
							"org.eclipse.lsat.machine.teditor.Machine.ActionType");
						afterParserOrEnumRuleCall();
					}
				)
			)*
			otherlv_7='}'
			{
				newLeafNode(otherlv_7, grammarAccess.getPeripheralTypeAccess().getRightCurlyBracketKeyword_4_3());
			}
		)?
		(
			otherlv_8='SetPoints'
			{
				newLeafNode(otherlv_8, grammarAccess.getPeripheralTypeAccess().getSetPointsKeyword_5_0());
			}
			otherlv_9='{'
			{
				newLeafNode(otherlv_9, grammarAccess.getPeripheralTypeAccess().getLeftCurlyBracketKeyword_5_1());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getPeripheralTypeAccess().getSetPointsSetPointParserRuleCall_5_2_0());
					}
					lv_setPoints_10_0=ruleSetPoint
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getPeripheralTypeRule());
						}
						add(
							$current,
							"setPoints",
							lv_setPoints_10_0,
							"org.eclipse.lsat.machine.teditor.Machine.SetPoint");
						afterParserOrEnumRuleCall();
					}
				)
			)*
			otherlv_11='}'
			{
				newLeafNode(otherlv_11, grammarAccess.getPeripheralTypeAccess().getRightCurlyBracketKeyword_5_3());
			}
			otherlv_12='Axes'
			{
				newLeafNode(otherlv_12, grammarAccess.getPeripheralTypeAccess().getAxesKeyword_5_4());
			}
			otherlv_13='{'
			{
				newLeafNode(otherlv_13, grammarAccess.getPeripheralTypeAccess().getLeftCurlyBracketKeyword_5_5());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getPeripheralTypeAccess().getAxesAxisParserRuleCall_5_6_0());
					}
					lv_axes_14_0=ruleAxis
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getPeripheralTypeRule());
						}
						add(
							$current,
							"axes",
							lv_axes_14_0,
							"org.eclipse.lsat.machine.teditor.Machine.Axis");
						afterParserOrEnumRuleCall();
					}
				)
			)*
			otherlv_15='}'
			{
				newLeafNode(otherlv_15, grammarAccess.getPeripheralTypeAccess().getRightCurlyBracketKeyword_5_7());
			}
			(
				otherlv_16='Conversion'
				{
					newLeafNode(otherlv_16, grammarAccess.getPeripheralTypeAccess().getConversionKeyword_5_8_0());
				}
				(
					(
						lv_conversion_17_0=RULE_STRING
						{
							newLeafNode(lv_conversion_17_0, grammarAccess.getPeripheralTypeAccess().getConversionSTRINGTerminalRuleCall_5_8_1_0());
						}
						{
							if ($current==null) {
								$current = createModelElement(grammarAccess.getPeripheralTypeRule());
							}
							setWithLastConsumed(
								$current,
								"conversion",
								lv_conversion_17_0,
								"org.eclipse.xtext.common.Terminals.STRING");
						}
					)
				)
			)?
		)?
		otherlv_18='}'
		{
			newLeafNode(otherlv_18, grammarAccess.getPeripheralTypeAccess().getRightCurlyBracketKeyword_6());
		}
	)
;

// Entry rule entryRuleActionType
entryRuleActionType returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getActionTypeRule()); }
	iv_ruleActionType=ruleActionType
	{ $current=$iv_ruleActionType.current; }
	EOF;

// Rule ActionType
ruleActionType returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getActionTypeAccess().getActionTypeAction_0(),
					$current);
			}
		)
		(
			(
				lv_name_1_0=RULE_ID
				{
					newLeafNode(lv_name_1_0, grammarAccess.getActionTypeAccess().getNameIDTerminalRuleCall_1_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getActionTypeRule());
					}
					setWithLastConsumed(
						$current,
						"name",
						lv_name_1_0,
						"org.eclipse.xtext.common.Terminals.ID");
				}
			)
		)
	)
;

// Entry rule entryRuleSetPoint
entryRuleSetPoint returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getSetPointRule()); }
	iv_ruleSetPoint=ruleSetPoint
	{ $current=$iv_ruleSetPoint.current; }
	EOF;

// Rule SetPoint
ruleSetPoint returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getSetPointAccess().getSetPointAction_0(),
					$current);
			}
		)
		(
			(
				lv_name_1_0=RULE_ID
				{
					newLeafNode(lv_name_1_0, grammarAccess.getSetPointAccess().getNameIDTerminalRuleCall_1_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getSetPointRule());
					}
					setWithLastConsumed(
						$current,
						"name",
						lv_name_1_0,
						"org.eclipse.xtext.common.Terminals.ID");
				}
			)
		)
		(
			otherlv_2='['
			{
				newLeafNode(otherlv_2, grammarAccess.getSetPointAccess().getLeftSquareBracketKeyword_2_0());
			}
			(
				(
					lv_unit_3_0=RULE_ID
					{
						newLeafNode(lv_unit_3_0, grammarAccess.getSetPointAccess().getUnitIDTerminalRuleCall_2_1_0());
					}
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getSetPointRule());
						}
						setWithLastConsumed(
							$current,
							"unit",
							lv_unit_3_0,
							"org.eclipse.xtext.common.Terminals.ID");
					}
				)
			)
			otherlv_4=']'
			{
				newLeafNode(otherlv_4, grammarAccess.getSetPointAccess().getRightSquareBracketKeyword_2_2());
			}
		)?
	)
;

// Entry rule entryRuleAxis
entryRuleAxis returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getAxisRule()); }
	iv_ruleAxis=ruleAxis
	{ $current=$iv_ruleAxis.current; }
	EOF;

// Rule Axis
ruleAxis returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getAxisAccess().getAxisAction_0(),
					$current);
			}
		)
		(
			(
				lv_name_1_0=RULE_ID
				{
					newLeafNode(lv_name_1_0, grammarAccess.getAxisAccess().getNameIDTerminalRuleCall_1_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getAxisRule());
					}
					setWithLastConsumed(
						$current,
						"name",
						lv_name_1_0,
						"org.eclipse.xtext.common.Terminals.ID");
				}
			)
		)
		(
			otherlv_2='['
			{
				newLeafNode(otherlv_2, grammarAccess.getAxisAccess().getLeftSquareBracketKeyword_2_0());
			}
			(
				(
					lv_unit_3_0=RULE_ID
					{
						newLeafNode(lv_unit_3_0, grammarAccess.getAxisAccess().getUnitIDTerminalRuleCall_2_1_0());
					}
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getAxisRule());
						}
						setWithLastConsumed(
							$current,
							"unit",
							lv_unit_3_0,
							"org.eclipse.xtext.common.Terminals.ID");
					}
				)
			)
			otherlv_4=']'
			{
				newLeafNode(otherlv_4, grammarAccess.getAxisAccess().getRightSquareBracketKeyword_2_2());
			}
		)?
		(
			otherlv_5='moves'
			{
				newLeafNode(otherlv_5, grammarAccess.getAxisAccess().getMovesKeyword_3_0());
			}
			(
				(
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getAxisRule());
						}
					}
					otherlv_6=RULE_ID
					{
						newLeafNode(otherlv_6, grammarAccess.getAxisAccess().getSetPointsSetPointCrossReference_3_1_0());
					}
				)
			)
			(
				otherlv_7=','
				{
					newLeafNode(otherlv_7, grammarAccess.getAxisAccess().getCommaKeyword_3_2_0());
				}
				(
					(
						{
							if ($current==null) {
								$current = createModelElement(grammarAccess.getAxisRule());
							}
						}
						otherlv_8=RULE_ID
						{
							newLeafNode(otherlv_8, grammarAccess.getAxisAccess().getSetPointsSetPointCrossReference_3_2_1_0());
						}
					)
				)
			)*
		)?
	)
;

// Entry rule entryRuleResourceItem
entryRuleResourceItem returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getResourceItemRule()); }
	iv_ruleResourceItem=ruleResourceItem
	{ $current=$iv_ruleResourceItem.current; }
	EOF;

// Rule ResourceItem
ruleResourceItem returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getResourceItemAccess().getResourceItemAction_0(),
					$current);
			}
		)
		(
			(
				{
					newCompositeNode(grammarAccess.getResourceItemAccess().getNameIIDParserRuleCall_1_0());
				}
				lv_name_1_0=ruleIID
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getResourceItemRule());
					}
					set(
						$current,
						"name",
						lv_name_1_0,
						"org.eclipse.lsat.machine.teditor.Machine.IID");
					afterParserOrEnumRuleCall();
				}
			)
		)
	)
;

// Entry rule entryRuleResource
entryRuleResource returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getResourceRule()); }
	iv_ruleResource=ruleResource
	{ $current=$iv_ruleResource.current; }
	EOF;

// Rule Resource
ruleResource returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		otherlv_0='Resource'
		{
			newLeafNode(otherlv_0, grammarAccess.getResourceAccess().getResourceKeyword_0());
		}
		(
			(
				lv_name_1_0=RULE_ID
				{
					newLeafNode(lv_name_1_0, grammarAccess.getResourceAccess().getNameIDTerminalRuleCall_1_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getResourceRule());
					}
					setWithLastConsumed(
						$current,
						"name",
						lv_name_1_0,
						"org.eclipse.xtext.common.Terminals.ID");
				}
			)
		)
		(
			otherlv_2='('
			{
				newLeafNode(otherlv_2, grammarAccess.getResourceAccess().getLeftParenthesisKeyword_2_0());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getResourceAccess().getItemsResourceItemParserRuleCall_2_1_0());
					}
					lv_items_3_0=ruleResourceItem
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getResourceRule());
						}
						add(
							$current,
							"items",
							lv_items_3_0,
							"org.eclipse.lsat.machine.teditor.Machine.ResourceItem");
						afterParserOrEnumRuleCall();
					}
				)
			)
			(
				otherlv_4=','
				{
					newLeafNode(otherlv_4, grammarAccess.getResourceAccess().getCommaKeyword_2_2_0());
				}
				(
					(
						{
							newCompositeNode(grammarAccess.getResourceAccess().getItemsResourceItemParserRuleCall_2_2_1_0());
						}
						lv_items_5_0=ruleResourceItem
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getResourceRule());
							}
							add(
								$current,
								"items",
								lv_items_5_0,
								"org.eclipse.lsat.machine.teditor.Machine.ResourceItem");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)*
			otherlv_6=')'
			{
				newLeafNode(otherlv_6, grammarAccess.getResourceAccess().getRightParenthesisKeyword_2_3());
			}
		)?
		otherlv_7='{'
		{
			newLeafNode(otherlv_7, grammarAccess.getResourceAccess().getLeftCurlyBracketKeyword_3());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getResourceAccess().getPeripheralsPeripheralParserRuleCall_4_0());
				}
				lv_peripherals_8_0=rulePeripheral
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getResourceRule());
					}
					add(
						$current,
						"peripherals",
						lv_peripherals_8_0,
						"org.eclipse.lsat.machine.teditor.Machine.Peripheral");
					afterParserOrEnumRuleCall();
				}
			)
		)*
		otherlv_9='}'
		{
			newLeafNode(otherlv_9, grammarAccess.getResourceAccess().getRightCurlyBracketKeyword_5());
		}
	)
;

// Entry rule entryRulePeripheral
entryRulePeripheral returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getPeripheralRule()); }
	iv_rulePeripheral=rulePeripheral
	{ $current=$iv_rulePeripheral.current; }
	EOF;

// Rule Peripheral
rulePeripheral returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				lv_name_0_0=RULE_ID
				{
					newLeafNode(lv_name_0_0, grammarAccess.getPeripheralAccess().getNameIDTerminalRuleCall_0_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getPeripheralRule());
					}
					setWithLastConsumed(
						$current,
						"name",
						lv_name_0_0,
						"org.eclipse.xtext.common.Terminals.ID");
				}
			)
		)
		otherlv_1=':'
		{
			newLeafNode(otherlv_1, grammarAccess.getPeripheralAccess().getColonKeyword_1());
		}
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getPeripheralRule());
					}
				}
				otherlv_2=RULE_ID
				{
					newLeafNode(otherlv_2, grammarAccess.getPeripheralAccess().getTypePeripheralTypeCrossReference_2_0());
				}
			)
		)
		(
			otherlv_3='{'
			{
				newLeafNode(otherlv_3, grammarAccess.getPeripheralAccess().getLeftCurlyBracketKeyword_3_0());
			}
			(
				(
					otherlv_4='AxisPositions'
					{
						newLeafNode(otherlv_4, grammarAccess.getPeripheralAccess().getAxisPositionsKeyword_3_1_0_0());
					}
					otherlv_5='{'
					{
						newLeafNode(otherlv_5, grammarAccess.getPeripheralAccess().getLeftCurlyBracketKeyword_3_1_0_1());
					}
					(
						(
							{
								newCompositeNode(grammarAccess.getPeripheralAccess().getAxisPositionsAxisPositionsMapEntryParserRuleCall_3_1_0_2_0());
							}
							lv_axisPositions_6_0=ruleAxisPositionsMapEntry
							{
								if ($current==null) {
									$current = createModelElementForParent(grammarAccess.getPeripheralRule());
								}
								add(
									$current,
									"axisPositions",
									lv_axisPositions_6_0,
									"org.eclipse.lsat.machine.teditor.Machine.AxisPositionsMapEntry");
								afterParserOrEnumRuleCall();
							}
						)
					)*
					otherlv_7='}'
					{
						newLeafNode(otherlv_7, grammarAccess.getPeripheralAccess().getRightCurlyBracketKeyword_3_1_0_3());
					}
				)?
				(
					otherlv_8='SymbolicPositions'
					{
						newLeafNode(otherlv_8, grammarAccess.getPeripheralAccess().getSymbolicPositionsKeyword_3_1_1_0());
					}
					otherlv_9='{'
					{
						newLeafNode(otherlv_9, grammarAccess.getPeripheralAccess().getLeftCurlyBracketKeyword_3_1_1_1());
					}
					(
						(
							{
								newCompositeNode(grammarAccess.getPeripheralAccess().getPositionsSymbolicPositionParserRuleCall_3_1_1_2_0());
							}
							lv_positions_10_0=ruleSymbolicPosition
							{
								if ($current==null) {
									$current = createModelElementForParent(grammarAccess.getPeripheralRule());
								}
								add(
									$current,
									"positions",
									lv_positions_10_0,
									"org.eclipse.lsat.machine.teditor.Machine.SymbolicPosition");
								afterParserOrEnumRuleCall();
							}
						)
					)*
					otherlv_11='}'
					{
						newLeafNode(otherlv_11, grammarAccess.getPeripheralAccess().getRightCurlyBracketKeyword_3_1_1_3());
					}
				)?
				otherlv_12='Profiles'
				{
					newLeafNode(otherlv_12, grammarAccess.getPeripheralAccess().getProfilesKeyword_3_1_2());
				}
				otherlv_13='('
				{
					newLeafNode(otherlv_13, grammarAccess.getPeripheralAccess().getLeftParenthesisKeyword_3_1_3());
				}
				(
					(
						{
							newCompositeNode(grammarAccess.getPeripheralAccess().getProfilesProfileParserRuleCall_3_1_4_0());
						}
						lv_profiles_14_0=ruleProfile
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getPeripheralRule());
							}
							add(
								$current,
								"profiles",
								lv_profiles_14_0,
								"org.eclipse.lsat.machine.teditor.Machine.Profile");
							afterParserOrEnumRuleCall();
						}
					)
				)
				(
					otherlv_15=','
					{
						newLeafNode(otherlv_15, grammarAccess.getPeripheralAccess().getCommaKeyword_3_1_5_0());
					}
					(
						(
							{
								newCompositeNode(grammarAccess.getPeripheralAccess().getProfilesProfileParserRuleCall_3_1_5_1_0());
							}
							lv_profiles_16_0=ruleProfile
							{
								if ($current==null) {
									$current = createModelElementForParent(grammarAccess.getPeripheralRule());
								}
								add(
									$current,
									"profiles",
									lv_profiles_16_0,
									"org.eclipse.lsat.machine.teditor.Machine.Profile");
								afterParserOrEnumRuleCall();
							}
						)
					)
				)*
				otherlv_17=')'
				{
					newLeafNode(otherlv_17, grammarAccess.getPeripheralAccess().getRightParenthesisKeyword_3_1_6());
				}
				(
					otherlv_18='Distances'
					{
						newLeafNode(otherlv_18, grammarAccess.getPeripheralAccess().getDistancesKeyword_3_1_7_0());
					}
					otherlv_19='{'
					{
						newLeafNode(otherlv_19, grammarAccess.getPeripheralAccess().getLeftCurlyBracketKeyword_3_1_7_1());
					}
					(
						(
							{
								newCompositeNode(grammarAccess.getPeripheralAccess().getDistancesDistanceParserRuleCall_3_1_7_2_0());
							}
							lv_distances_20_0=ruleDistance
							{
								if ($current==null) {
									$current = createModelElementForParent(grammarAccess.getPeripheralRule());
								}
								add(
									$current,
									"distances",
									lv_distances_20_0,
									"org.eclipse.lsat.machine.teditor.Machine.Distance");
								afterParserOrEnumRuleCall();
							}
						)
					)*
					otherlv_21='}'
					{
						newLeafNode(otherlv_21, grammarAccess.getPeripheralAccess().getRightCurlyBracketKeyword_3_1_7_3());
					}
				)?
				(
					otherlv_22='Paths'
					{
						newLeafNode(otherlv_22, grammarAccess.getPeripheralAccess().getPathsKeyword_3_1_8_0());
					}
					otherlv_23='{'
					{
						newLeafNode(otherlv_23, grammarAccess.getPeripheralAccess().getLeftCurlyBracketKeyword_3_1_8_1());
					}
					(
						(
							{
								newCompositeNode(grammarAccess.getPeripheralAccess().getPathsPathParserRuleCall_3_1_8_2_0());
							}
							lv_paths_24_0=rulePath
							{
								if ($current==null) {
									$current = createModelElementForParent(grammarAccess.getPeripheralRule());
								}
								add(
									$current,
									"paths",
									lv_paths_24_0,
									"org.eclipse.lsat.machine.teditor.Machine.Path");
								afterParserOrEnumRuleCall();
							}
						)
					)*
					otherlv_25='}'
					{
						newLeafNode(otherlv_25, grammarAccess.getPeripheralAccess().getRightCurlyBracketKeyword_3_1_8_3());
					}
				)?
			)?
			otherlv_26='}'
			{
				newLeafNode(otherlv_26, grammarAccess.getPeripheralAccess().getRightCurlyBracketKeyword_3_2());
			}
		)?
	)
;

// Entry rule entryRuleDistance
entryRuleDistance returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getDistanceRule()); }
	iv_ruleDistance=ruleDistance
	{ $current=$iv_ruleDistance.current; }
	EOF;

// Rule Distance
ruleDistance returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getDistanceAccess().getDistanceAction_0(),
					$current);
			}
		)
		(
			(
				lv_name_1_0=RULE_ID
				{
					newLeafNode(lv_name_1_0, grammarAccess.getDistanceAccess().getNameIDTerminalRuleCall_1_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getDistanceRule());
					}
					setWithLastConsumed(
						$current,
						"name",
						lv_name_1_0,
						"org.eclipse.xtext.common.Terminals.ID");
				}
			)
		)
		(
			otherlv_2='['
			{
				newLeafNode(otherlv_2, grammarAccess.getDistanceAccess().getLeftSquareBracketKeyword_2_0());
			}
			(
				(
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getDistanceRule());
						}
					}
					otherlv_3=RULE_ID
					{
						newLeafNode(otherlv_3, grammarAccess.getDistanceAccess().getSettlingAxisCrossReference_2_1_0());
					}
				)
			)
			(
				otherlv_4=','
				{
					newLeafNode(otherlv_4, grammarAccess.getDistanceAccess().getCommaKeyword_2_2_0());
				}
				(
					(
						{
							if ($current==null) {
								$current = createModelElement(grammarAccess.getDistanceRule());
							}
						}
						otherlv_5=RULE_ID
						{
							newLeafNode(otherlv_5, grammarAccess.getDistanceAccess().getSettlingAxisCrossReference_2_2_1_0());
						}
					)
				)
			)*
			otherlv_6=']'
			{
				newLeafNode(otherlv_6, grammarAccess.getDistanceAccess().getRightSquareBracketKeyword_2_3());
			}
		)?
	)
;

// Entry rule entryRuleAxisPositionsMapEntry
entryRuleAxisPositionsMapEntry returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getAxisPositionsMapEntryRule()); }
	iv_ruleAxisPositionsMapEntry=ruleAxisPositionsMapEntry
	{ $current=$iv_ruleAxisPositionsMapEntry.current; }
	EOF;

// Rule AxisPositionsMapEntry
ruleAxisPositionsMapEntry returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getAxisPositionsMapEntryAccess().getAxisPositionsMapEntryAction_0(),
					$current);
			}
		)
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getAxisPositionsMapEntryRule());
					}
				}
				otherlv_1=RULE_ID
				{
					newLeafNode(otherlv_1, grammarAccess.getAxisPositionsMapEntryAccess().getKeyAxisCrossReference_1_0());
				}
			)
		)
		(
			otherlv_2='('
			{
				newLeafNode(otherlv_2, grammarAccess.getAxisPositionsMapEntryAccess().getLeftParenthesisKeyword_2_0());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getAxisPositionsMapEntryAccess().getValuePositionParserRuleCall_2_1_0());
					}
					lv_value_3_0=rulePosition
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getAxisPositionsMapEntryRule());
						}
						add(
							$current,
							"value",
							lv_value_3_0,
							"org.eclipse.lsat.machine.teditor.Machine.Position");
						afterParserOrEnumRuleCall();
					}
				)
			)
			(
				otherlv_4=','
				{
					newLeafNode(otherlv_4, grammarAccess.getAxisPositionsMapEntryAccess().getCommaKeyword_2_2_0());
				}
				(
					(
						{
							newCompositeNode(grammarAccess.getAxisPositionsMapEntryAccess().getValuePositionParserRuleCall_2_2_1_0());
						}
						lv_value_5_0=rulePosition
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getAxisPositionsMapEntryRule());
							}
							add(
								$current,
								"value",
								lv_value_5_0,
								"org.eclipse.lsat.machine.teditor.Machine.Position");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)*
			otherlv_6=')'
			{
				newLeafNode(otherlv_6, grammarAccess.getAxisPositionsMapEntryAccess().getRightParenthesisKeyword_2_3());
			}
		)?
	)
;

// Entry rule entryRulePosition
entryRulePosition returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getPositionRule()); }
	iv_rulePosition=rulePosition
	{ $current=$iv_rulePosition.current; }
	EOF;

// Rule Position
rulePosition returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getPositionAccess().getPositionAction_0(),
					$current);
			}
		)
		(
			(
				lv_name_1_0=RULE_ID
				{
					newLeafNode(lv_name_1_0, grammarAccess.getPositionAccess().getNameIDTerminalRuleCall_1_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getPositionRule());
					}
					setWithLastConsumed(
						$current,
						"name",
						lv_name_1_0,
						"org.eclipse.xtext.common.Terminals.ID");
				}
			)
		)
	)
;

// Entry rule entryRuleSymbolicPosition
entryRuleSymbolicPosition returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getSymbolicPositionRule()); }
	iv_ruleSymbolicPosition=ruleSymbolicPosition
	{ $current=$iv_ruleSymbolicPosition.current; }
	EOF;

// Rule SymbolicPosition
ruleSymbolicPosition returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getSymbolicPositionAccess().getSymbolicPositionAction_0(),
					$current);
			}
		)
		(
			(
				lv_name_1_0=RULE_ID
				{
					newLeafNode(lv_name_1_0, grammarAccess.getSymbolicPositionAccess().getNameIDTerminalRuleCall_1_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getSymbolicPositionRule());
					}
					setWithLastConsumed(
						$current,
						"name",
						lv_name_1_0,
						"org.eclipse.xtext.common.Terminals.ID");
				}
			)
		)
		(
			otherlv_2='('
			{
				newLeafNode(otherlv_2, grammarAccess.getSymbolicPositionAccess().getLeftParenthesisKeyword_2_0());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getSymbolicPositionAccess().getAxisPositionAxisPositionMapEntryParserRuleCall_2_1_0());
					}
					lv_axisPosition_3_0=ruleAxisPositionMapEntry
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getSymbolicPositionRule());
						}
						add(
							$current,
							"axisPosition",
							lv_axisPosition_3_0,
							"org.eclipse.lsat.machine.teditor.Machine.AxisPositionMapEntry");
						afterParserOrEnumRuleCall();
					}
				)
			)
			(
				otherlv_4=','
				{
					newLeafNode(otherlv_4, grammarAccess.getSymbolicPositionAccess().getCommaKeyword_2_2_0());
				}
				(
					(
						{
							newCompositeNode(grammarAccess.getSymbolicPositionAccess().getAxisPositionAxisPositionMapEntryParserRuleCall_2_2_1_0());
						}
						lv_axisPosition_5_0=ruleAxisPositionMapEntry
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getSymbolicPositionRule());
							}
							add(
								$current,
								"axisPosition",
								lv_axisPosition_5_0,
								"org.eclipse.lsat.machine.teditor.Machine.AxisPositionMapEntry");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)*
			otherlv_6=')'
			{
				newLeafNode(otherlv_6, grammarAccess.getSymbolicPositionAccess().getRightParenthesisKeyword_2_3());
			}
		)?
	)
;

// Entry rule entryRuleAxisPositionMapEntry
entryRuleAxisPositionMapEntry returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getAxisPositionMapEntryRule()); }
	iv_ruleAxisPositionMapEntry=ruleAxisPositionMapEntry
	{ $current=$iv_ruleAxisPositionMapEntry.current; }
	EOF;

// Rule AxisPositionMapEntry
ruleAxisPositionMapEntry returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getAxisPositionMapEntryAccess().getAxisPositionMapEntryAction_0(),
					$current);
			}
		)
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getAxisPositionMapEntryRule());
					}
				}
				otherlv_1=RULE_ID
				{
					newLeafNode(otherlv_1, grammarAccess.getAxisPositionMapEntryAccess().getKeyAxisCrossReference_1_0());
				}
			)
		)
		otherlv_2='.'
		{
			newLeafNode(otherlv_2, grammarAccess.getAxisPositionMapEntryAccess().getFullStopKeyword_2());
		}
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getAxisPositionMapEntryRule());
					}
				}
				otherlv_3=RULE_ID
				{
					newLeafNode(otherlv_3, grammarAccess.getAxisPositionMapEntryAccess().getValuePositionCrossReference_3_0());
				}
			)
		)
	)
;

// Entry rule entryRuleProfile
entryRuleProfile returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getProfileRule()); }
	iv_ruleProfile=ruleProfile
	{ $current=$iv_ruleProfile.current; }
	EOF;

// Rule Profile
ruleProfile returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getProfileAccess().getProfileAction_0(),
					$current);
			}
		)
		(
			(
				lv_name_1_0=RULE_ID
				{
					newLeafNode(lv_name_1_0, grammarAccess.getProfileAccess().getNameIDTerminalRuleCall_1_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getProfileRule());
					}
					setWithLastConsumed(
						$current,
						"name",
						lv_name_1_0,
						"org.eclipse.xtext.common.Terminals.ID");
				}
			)
		)
	)
;

// Entry rule entryRulePath
entryRulePath returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getPathRule()); }
	iv_rulePath=rulePath
	{ $current=$iv_rulePath.current; }
	EOF;

// Rule Path
rulePath returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getPathAccess().getUnidirectionalPathParserRuleCall_0());
		}
		this_UnidirectionalPath_0=ruleUnidirectionalPath
		{
			$current = $this_UnidirectionalPath_0.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getPathAccess().getBidirectionalPathParserRuleCall_1());
		}
		this_BidirectionalPath_1=ruleBidirectionalPath
		{
			$current = $this_BidirectionalPath_1.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getPathAccess().getFullMeshPathParserRuleCall_2());
		}
		this_FullMeshPath_2=ruleFullMeshPath
		{
			$current = $this_FullMeshPath_2.current;
			afterParserOrEnumRuleCall();
		}
	)
;

// Entry rule entryRuleUnidirectionalPath
entryRuleUnidirectionalPath returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getUnidirectionalPathRule()); }
	iv_ruleUnidirectionalPath=ruleUnidirectionalPath
	{ $current=$iv_ruleUnidirectionalPath.current; }
	EOF;

// Rule UnidirectionalPath
ruleUnidirectionalPath returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getUnidirectionalPathAccess().getUnidirectionalPathAction_0(),
					$current);
			}
		)
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getUnidirectionalPathRule());
					}
				}
				otherlv_1=RULE_ID
				{
					newLeafNode(otherlv_1, grammarAccess.getUnidirectionalPathAccess().getSourceSymbolicPositionCrossReference_1_0());
				}
			)
		)
		otherlv_2='-->'
		{
			newLeafNode(otherlv_2, grammarAccess.getUnidirectionalPathAccess().getHyphenMinusHyphenMinusGreaterThanSignKeyword_2());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getUnidirectionalPathAccess().getTargetPathTargetReferenceParserRuleCall_3_0());
				}
				lv_target_3_0=rulePathTargetReference
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getUnidirectionalPathRule());
					}
					set(
						$current,
						"target",
						lv_target_3_0,
						"org.eclipse.lsat.machine.teditor.Machine.PathTargetReference");
					afterParserOrEnumRuleCall();
				}
			)
		)
		(
			(
				otherlv_4='profiles'
				{
					newLeafNode(otherlv_4, grammarAccess.getUnidirectionalPathAccess().getProfilesKeyword_4_0_0());
				}
				(
					(
						{
							if ($current==null) {
								$current = createModelElement(grammarAccess.getUnidirectionalPathRule());
							}
						}
						otherlv_5=RULE_ID
						{
							newLeafNode(otherlv_5, grammarAccess.getUnidirectionalPathAccess().getProfilesProfileCrossReference_4_0_1_0());
						}
					)
				)
				(
					otherlv_6=','
					{
						newLeafNode(otherlv_6, grammarAccess.getUnidirectionalPathAccess().getCommaKeyword_4_0_2_0());
					}
					(
						(
							{
								if ($current==null) {
									$current = createModelElement(grammarAccess.getUnidirectionalPathRule());
								}
							}
							otherlv_7=RULE_ID
							{
								newLeafNode(otherlv_7, grammarAccess.getUnidirectionalPathAccess().getProfilesProfileCrossReference_4_0_2_1_0());
							}
						)
					)
				)*
			)
			    |
			(
				otherlv_8='profile'
				{
					newLeafNode(otherlv_8, grammarAccess.getUnidirectionalPathAccess().getProfileKeyword_4_1_0());
				}
				(
					(
						{
							if ($current==null) {
								$current = createModelElement(grammarAccess.getUnidirectionalPathRule());
							}
						}
						otherlv_9=RULE_ID
						{
							newLeafNode(otherlv_9, grammarAccess.getUnidirectionalPathAccess().getProfilesProfileCrossReference_4_1_1_0());
						}
					)
				)
			)
		)
		(
			otherlv_10='@'
			{
				newLeafNode(otherlv_10, grammarAccess.getUnidirectionalPathAccess().getCommercialAtKeyword_5_0());
			}
			(
				(
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getUnidirectionalPathRule());
						}
					}
					otherlv_11=RULE_ID
					{
						newLeafNode(otherlv_11, grammarAccess.getUnidirectionalPathAccess().getAnnotationsPathAnnotationCrossReference_5_1_0());
					}
				)
			)
		)*
	)
;

// Entry rule entryRuleBidirectionalPath
entryRuleBidirectionalPath returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getBidirectionalPathRule()); }
	iv_ruleBidirectionalPath=ruleBidirectionalPath
	{ $current=$iv_ruleBidirectionalPath.current; }
	EOF;

// Rule BidirectionalPath
ruleBidirectionalPath returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getBidirectionalPathAccess().getBidirectionalPathAction_0(),
					$current);
			}
		)
		(
			(
				{
					newCompositeNode(grammarAccess.getBidirectionalPathAccess().getEndPointsPathTargetReferenceParserRuleCall_1_0());
				}
				lv_endPoints_1_0=rulePathTargetReference
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getBidirectionalPathRule());
					}
					add(
						$current,
						"endPoints",
						lv_endPoints_1_0,
						"org.eclipse.lsat.machine.teditor.Machine.PathTargetReference");
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_2='<->'
		{
			newLeafNode(otherlv_2, grammarAccess.getBidirectionalPathAccess().getLessThanSignHyphenMinusGreaterThanSignKeyword_2());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getBidirectionalPathAccess().getEndPointsPathTargetReferenceParserRuleCall_3_0());
				}
				lv_endPoints_3_0=rulePathTargetReference
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getBidirectionalPathRule());
					}
					add(
						$current,
						"endPoints",
						lv_endPoints_3_0,
						"org.eclipse.lsat.machine.teditor.Machine.PathTargetReference");
					afterParserOrEnumRuleCall();
				}
			)
		)
		(
			(
				otherlv_4='profiles'
				{
					newLeafNode(otherlv_4, grammarAccess.getBidirectionalPathAccess().getProfilesKeyword_4_0_0());
				}
				(
					(
						{
							if ($current==null) {
								$current = createModelElement(grammarAccess.getBidirectionalPathRule());
							}
						}
						otherlv_5=RULE_ID
						{
							newLeafNode(otherlv_5, grammarAccess.getBidirectionalPathAccess().getProfilesProfileCrossReference_4_0_1_0());
						}
					)
				)
				(
					otherlv_6=','
					{
						newLeafNode(otherlv_6, grammarAccess.getBidirectionalPathAccess().getCommaKeyword_4_0_2_0());
					}
					(
						(
							{
								if ($current==null) {
									$current = createModelElement(grammarAccess.getBidirectionalPathRule());
								}
							}
							otherlv_7=RULE_ID
							{
								newLeafNode(otherlv_7, grammarAccess.getBidirectionalPathAccess().getProfilesProfileCrossReference_4_0_2_1_0());
							}
						)
					)
				)*
			)
			    |
			(
				otherlv_8='profile'
				{
					newLeafNode(otherlv_8, grammarAccess.getBidirectionalPathAccess().getProfileKeyword_4_1_0());
				}
				(
					(
						{
							if ($current==null) {
								$current = createModelElement(grammarAccess.getBidirectionalPathRule());
							}
						}
						otherlv_9=RULE_ID
						{
							newLeafNode(otherlv_9, grammarAccess.getBidirectionalPathAccess().getProfilesProfileCrossReference_4_1_1_0());
						}
					)
				)
			)
		)
		(
			otherlv_10='@'
			{
				newLeafNode(otherlv_10, grammarAccess.getBidirectionalPathAccess().getCommercialAtKeyword_5_0());
			}
			(
				(
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getBidirectionalPathRule());
						}
					}
					otherlv_11=RULE_ID
					{
						newLeafNode(otherlv_11, grammarAccess.getBidirectionalPathAccess().getAnnotationsPathAnnotationCrossReference_5_1_0());
					}
				)
			)
		)*
	)
;

// Entry rule entryRuleFullMeshPath
entryRuleFullMeshPath returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getFullMeshPathRule()); }
	iv_ruleFullMeshPath=ruleFullMeshPath
	{ $current=$iv_ruleFullMeshPath.current; }
	EOF;

// Rule FullMeshPath
ruleFullMeshPath returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getFullMeshPathAccess().getFullMeshPathAction_0(),
					$current);
			}
		)
		otherlv_1='FullMesh'
		{
			newLeafNode(otherlv_1, grammarAccess.getFullMeshPathAccess().getFullMeshKeyword_1());
		}
		otherlv_2='{'
		{
			newLeafNode(otherlv_2, grammarAccess.getFullMeshPathAccess().getLeftCurlyBracketKeyword_2());
		}
		(
			(
				otherlv_3='profiles'
				{
					newLeafNode(otherlv_3, grammarAccess.getFullMeshPathAccess().getProfilesKeyword_3_0_0());
				}
				(
					(
						{
							if ($current==null) {
								$current = createModelElement(grammarAccess.getFullMeshPathRule());
							}
						}
						otherlv_4=RULE_ID
						{
							newLeafNode(otherlv_4, grammarAccess.getFullMeshPathAccess().getProfilesProfileCrossReference_3_0_1_0());
						}
					)
				)
				(
					otherlv_5=','
					{
						newLeafNode(otherlv_5, grammarAccess.getFullMeshPathAccess().getCommaKeyword_3_0_2_0());
					}
					(
						(
							{
								if ($current==null) {
									$current = createModelElement(grammarAccess.getFullMeshPathRule());
								}
							}
							otherlv_6=RULE_ID
							{
								newLeafNode(otherlv_6, grammarAccess.getFullMeshPathAccess().getProfilesProfileCrossReference_3_0_2_1_0());
							}
						)
					)
				)*
			)
			    |
			(
				otherlv_7='profile'
				{
					newLeafNode(otherlv_7, grammarAccess.getFullMeshPathAccess().getProfileKeyword_3_1_0());
				}
				(
					(
						{
							if ($current==null) {
								$current = createModelElement(grammarAccess.getFullMeshPathRule());
							}
						}
						otherlv_8=RULE_ID
						{
							newLeafNode(otherlv_8, grammarAccess.getFullMeshPathAccess().getProfilesProfileCrossReference_3_1_1_0());
						}
					)
				)
			)
		)
		(
			otherlv_9='@'
			{
				newLeafNode(otherlv_9, grammarAccess.getFullMeshPathAccess().getCommercialAtKeyword_4_0());
			}
			(
				(
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getFullMeshPathRule());
						}
					}
					otherlv_10=RULE_ID
					{
						newLeafNode(otherlv_10, grammarAccess.getFullMeshPathAccess().getAnnotationsPathAnnotationCrossReference_4_1_0());
					}
				)
			)
		)*
		(
			(
				{
					newCompositeNode(grammarAccess.getFullMeshPathAccess().getEndPointsPathTargetReferenceParserRuleCall_5_0());
				}
				lv_endPoints_11_0=rulePathTargetReference
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getFullMeshPathRule());
					}
					add(
						$current,
						"endPoints",
						lv_endPoints_11_0,
						"org.eclipse.lsat.machine.teditor.Machine.PathTargetReference");
					afterParserOrEnumRuleCall();
				}
			)
		)*
		otherlv_12='}'
		{
			newLeafNode(otherlv_12, grammarAccess.getFullMeshPathAccess().getRightCurlyBracketKeyword_6());
		}
	)
;

// Entry rule entryRulePathTargetReference
entryRulePathTargetReference returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getPathTargetReferenceRule()); }
	iv_rulePathTargetReference=rulePathTargetReference
	{ $current=$iv_rulePathTargetReference.current; }
	EOF;

// Rule PathTargetReference
rulePathTargetReference returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getPathTargetReferenceAccess().getPathTargetReferenceAction_0(),
					$current);
			}
		)
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getPathTargetReferenceRule());
					}
				}
				otherlv_1=RULE_ID
				{
					newLeafNode(otherlv_1, grammarAccess.getPathTargetReferenceAccess().getPositionSymbolicPositionCrossReference_1_0());
				}
			)
		)
		(
			otherlv_2='['
			{
				newLeafNode(otherlv_2, grammarAccess.getPathTargetReferenceAccess().getLeftSquareBracketKeyword_2_0());
			}
			(
				(
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getPathTargetReferenceRule());
						}
					}
					otherlv_3=RULE_ID
					{
						newLeafNode(otherlv_3, grammarAccess.getPathTargetReferenceAccess().getSettlingAxisCrossReference_2_1_0());
					}
				)
			)
			(
				otherlv_4=','
				{
					newLeafNode(otherlv_4, grammarAccess.getPathTargetReferenceAccess().getCommaKeyword_2_2_0());
				}
				(
					(
						{
							if ($current==null) {
								$current = createModelElement(grammarAccess.getPathTargetReferenceRule());
							}
						}
						otherlv_5=RULE_ID
						{
							newLeafNode(otherlv_5, grammarAccess.getPathTargetReferenceAccess().getSettlingAxisCrossReference_2_2_1_0());
						}
					)
				)
			)*
			otherlv_6=']'
			{
				newLeafNode(otherlv_6, grammarAccess.getPathTargetReferenceAccess().getRightSquareBracketKeyword_2_3());
			}
		)?
	)
;

// Entry rule entryRuleIID
entryRuleIID returns [String current=null]:
	{ newCompositeNode(grammarAccess.getIIDRule()); }
	iv_ruleIID=ruleIID
	{ $current=$iv_ruleIID.current.getText(); }
	EOF;

// Rule IID
ruleIID returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		this_INT_0=RULE_INT
		{
			$current.merge(this_INT_0);
		}
		{
			newLeafNode(this_INT_0, grammarAccess.getIIDAccess().getINTTerminalRuleCall_0());
		}
		    |
		this_ID_1=RULE_ID
		{
			$current.merge(this_ID_1);
		}
		{
			newLeafNode(this_ID_1, grammarAccess.getIIDAccess().getIDTerminalRuleCall_1());
		}
	)
;

RULE_ID : '^'? ('a'..'z'|'A'..'Z'|'_') ('a'..'z'|'A'..'Z'|'_'|'0'..'9')*;

RULE_INT : ('0'..'9')+;

RULE_STRING : ('"' ('\\' .|~(('\\'|'"')))* '"'|'\'' ('\\' .|~(('\\'|'\'')))* '\'');

RULE_ML_COMMENT : '/*' ( options {greedy=false;} : . )*'*/';

RULE_SL_COMMENT : '//' ~(('\n'|'\r'))* ('\r'? '\n')?;

RULE_WS : (' '|'\t'|'\r'|'\n')+;

RULE_ANY_OTHER : .;
