/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.mpt.ui;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.lsat.common.emf.ecore.resource.Persistor;
import org.eclipse.lsat.common.emf.ecore.resource.PersistorFactory;
import org.eclipse.lsat.common.mpt.MaxPlusSpecification;
import org.eclipse.lsat.mpt.ui.Activator;
import org.eclipse.lsat.mpt.ui.Activity2DispatchingHelper;
import org.eclipse.lsat.mpt.ui.ActivityTransformationOptions;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class Activity2MaxPlusSpecificationJob
extends Job {
    private final ActivityTransformationOptions options;
    private final UISynchronize sync;
    private final Shell shell;
    private final Activity2DispatchingHelper helper;

    public Activity2MaxPlusSpecificationJob(ActivityTransformationOptions options, UISynchronize sync, Shell shell) {
        super("Activity2MaxPlusSpecificationJob");
        this.options = options;
        this.sync = sync;
        this.shell = shell;
        this.helper = new Activity2DispatchingHelper(options);
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            MaxPlusSpecification maxPlusSpecification = this.helper.createMaxPlusSpecification(monitor);
            if (monitor.isCanceled()) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            Persistor savePersistor = new PersistorFactory().getPersistor(EObject.class);
            final String outputFileName = this.options.getActivityFileName().concat("_").concat(this.options.getCifFileName());
            URI saveBaseURI = this.helper.getResultFolderURI().appendSegment(outputFileName);
            savePersistor.save(saveBaseURI.appendFileExtension("mpt"), new EObject[]{maxPlusSpecification});
            if (monitor.isCanceled()) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            monitor.worked(50);
            this.sync.asyncExec(new Runnable(){

                @Override
                public void run() {
                    new Activity2DispatchingHelper.SuccessDialog(Activity2MaxPlusSpecificationJob.this.shell, "Max-plus specification generation", "Generated max-plus specification \"" + outputFileName + ".mpt" + "\"").open();
                }
            });
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        catch (Exception e) {
            Status status = new Status(4, "org.eclipse.lsat.mpt.ui", e.getMessage(), (Throwable)e);
            Activator.getDefault().getLog().log((IStatus)status);
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Max-plus specification generation", (String)("Max-plus specification generation failed:\n" + e.getMessage() + "\n\nSee Error Log for details."));
                }
            });
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        finally {
            monitor.done();
        }
    }
}

