/**
 * Copyright (c) 2021 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Do not edit: This file is generated by Xtext
 */
grammar InternalSetting;

options {
	superClass=AbstractInternalAntlrParser;
}

@lexer::header {
package org.eclipse.lsat.setting.teditor.parser.antlr.internal;

// Hack: Use our own Lexer superclass by means of import. 
// Currently there is no other way to specify the superclass for the lexer.
import org.eclipse.xtext.parser.antlr.Lexer;
}

@parser::header {
package org.eclipse.lsat.setting.teditor.parser.antlr.internal;

import org.eclipse.xtext.*;
import org.eclipse.xtext.parser.*;
import org.eclipse.xtext.parser.impl.*;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.parser.antlr.AbstractInternalAntlrParser;
import org.eclipse.xtext.parser.antlr.XtextTokenStream;
import org.eclipse.xtext.parser.antlr.XtextTokenStream.HiddenTokens;
import org.eclipse.xtext.parser.antlr.AntlrDatatypeRuleToken;
import org.eclipse.lsat.setting.teditor.services.SettingGrammarAccess;

}

@parser::members {

 	private SettingGrammarAccess grammarAccess;

    public InternalSettingParser(TokenStream input, SettingGrammarAccess grammarAccess) {
        this(input);
        this.grammarAccess = grammarAccess;
        registerRules(grammarAccess.getGrammar());
    }

    @Override
    protected String getFirstRuleName() {
    	return "Settings";
   	}

   	@Override
   	protected SettingGrammarAccess getGrammarAccess() {
   		return grammarAccess;
   	}

}

@rulecatch {
    catch (RecognitionException re) {
        recover(input,re);
        appendSkippedTokens();
    }
}

// Entry rule entryRuleSettings
entryRuleSettings returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getSettingsRule()); }
	iv_ruleSettings=ruleSettings
	{ $current=$iv_ruleSettings.current; }
	EOF;

// Rule Settings
ruleSettings returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getSettingsAccess().getSettingsAction_0(),
					$current);
			}
		)
		(
			(
				{
					newCompositeNode(grammarAccess.getSettingsAccess().getImportsImportParserRuleCall_1_0());
				}
				lv_imports_1_0=ruleImport
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getSettingsRule());
					}
					add(
						$current,
						"imports",
						lv_imports_1_0,
						"org.eclipse.lsat.setting.teditor.Setting.Import");
					afterParserOrEnumRuleCall();
				}
			)
		)*
		(
			(
				{
					newCompositeNode(grammarAccess.getSettingsAccess().getDeclarationsDeclarationParserRuleCall_2_0());
				}
				lv_declarations_2_0=ruleDeclaration
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getSettingsRule());
					}
					add(
						$current,
						"declarations",
						lv_declarations_2_0,
						"org.eclipse.lsat.setting.teditor.Setting.Declaration");
					afterParserOrEnumRuleCall();
				}
			)
		)*
		(
			(
				{
					newCompositeNode(grammarAccess.getSettingsAccess().getPhysicalSettingsPhysicalSettingsParserRuleCall_3_0());
				}
				lv_physicalSettings_3_0=rulePhysicalSettings
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getSettingsRule());
					}
					add(
						$current,
						"physicalSettings",
						lv_physicalSettings_3_0,
						"org.eclipse.lsat.setting.teditor.Setting.PhysicalSettings");
					afterParserOrEnumRuleCall();
				}
			)
		)*
	)
;

// Entry rule entryRuleImport
entryRuleImport returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getImportRule()); }
	iv_ruleImport=ruleImport
	{ $current=$iv_ruleImport.current; }
	EOF;

// Rule Import
ruleImport returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		otherlv_0='import'
		{
			newLeafNode(otherlv_0, grammarAccess.getImportAccess().getImportKeyword_0());
		}
		(
			(
				lv_importURI_1_0=RULE_STRING
				{
					newLeafNode(lv_importURI_1_0, grammarAccess.getImportAccess().getImportURISTRINGTerminalRuleCall_1_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getImportRule());
					}
					setWithLastConsumed(
						$current,
						"importURI",
						lv_importURI_1_0,
						"org.eclipse.xtext.common.Terminals.STRING");
				}
			)
		)
	)
;

// Entry rule entryRulePhysicalSettings
entryRulePhysicalSettings returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getPhysicalSettingsRule()); }
	iv_rulePhysicalSettings=rulePhysicalSettings
	{ $current=$iv_rulePhysicalSettings.current; }
	EOF;

// Rule PhysicalSettings
rulePhysicalSettings returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getPhysicalSettingsAccess().getPhysicalSettingsAction_0(),
					$current);
			}
		)
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getPhysicalSettingsRule());
					}
				}
				{
					newCompositeNode(grammarAccess.getPhysicalSettingsAccess().getResourceIResourceCrossReference_1_0());
				}
				ruleResourceQualifiedName
				{
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_2='.'
		{
			newLeafNode(otherlv_2, grammarAccess.getPhysicalSettingsAccess().getFullStopKeyword_2());
		}
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getPhysicalSettingsRule());
					}
				}
				{
					newCompositeNode(grammarAccess.getPhysicalSettingsAccess().getPeripheralPeripheralCrossReference_3_0());
				}
				ruleIID
				{
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_4='{'
		{
			newLeafNode(otherlv_4, grammarAccess.getPhysicalSettingsAccess().getLeftCurlyBracketKeyword_4());
		}
		(
			otherlv_5='Timings'
			{
				newLeafNode(otherlv_5, grammarAccess.getPhysicalSettingsAccess().getTimingsKeyword_5_0());
			}
			otherlv_6='{'
			{
				newLeafNode(otherlv_6, grammarAccess.getPhysicalSettingsAccess().getLeftCurlyBracketKeyword_5_1());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getPhysicalSettingsAccess().getTimingSettingsTimingSettingsMapEntryParserRuleCall_5_2_0());
					}
					lv_timingSettings_7_0=ruleTimingSettingsMapEntry
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getPhysicalSettingsRule());
						}
						add(
							$current,
							"timingSettings",
							lv_timingSettings_7_0,
							"org.eclipse.lsat.setting.teditor.Setting.TimingSettingsMapEntry");
						afterParserOrEnumRuleCall();
					}
				)
			)*
			otherlv_8='}'
			{
				newLeafNode(otherlv_8, grammarAccess.getPhysicalSettingsAccess().getRightCurlyBracketKeyword_5_3());
			}
		)?
		(
			(
				{
					newCompositeNode(grammarAccess.getPhysicalSettingsAccess().getMotionSettingsMotionSettingsMapEntryParserRuleCall_6_0());
				}
				lv_motionSettings_9_0=ruleMotionSettingsMapEntry
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getPhysicalSettingsRule());
					}
					add(
						$current,
						"motionSettings",
						lv_motionSettings_9_0,
						"org.eclipse.lsat.setting.teditor.Setting.MotionSettingsMapEntry");
					afterParserOrEnumRuleCall();
				}
			)
		)*
		otherlv_10='}'
		{
			newLeafNode(otherlv_10, grammarAccess.getPhysicalSettingsAccess().getRightCurlyBracketKeyword_7());
		}
	)
;

// Entry rule entryRuleMotionSettingsMapEntry
entryRuleMotionSettingsMapEntry returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getMotionSettingsMapEntryRule()); }
	iv_ruleMotionSettingsMapEntry=ruleMotionSettingsMapEntry
	{ $current=$iv_ruleMotionSettingsMapEntry.current; }
	EOF;

// Rule MotionSettingsMapEntry
ruleMotionSettingsMapEntry returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getMotionSettingsMapEntryAccess().getMotionSettingsMapEntryAction_0(),
					$current);
			}
		)
		otherlv_1='Axis'
		{
			newLeafNode(otherlv_1, grammarAccess.getMotionSettingsMapEntryAccess().getAxisKeyword_1());
		}
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getMotionSettingsMapEntryRule());
					}
				}
				otherlv_2=RULE_ID
				{
					newLeafNode(otherlv_2, grammarAccess.getMotionSettingsMapEntryAccess().getKeyAxisCrossReference_2_0());
				}
			)
		)
		otherlv_3='{'
		{
			newLeafNode(otherlv_3, grammarAccess.getMotionSettingsMapEntryAccess().getLeftCurlyBracketKeyword_3());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getMotionSettingsMapEntryAccess().getValueMotionSettingsParserRuleCall_4_0());
				}
				lv_value_4_0=ruleMotionSettings
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getMotionSettingsMapEntryRule());
					}
					set(
						$current,
						"value",
						lv_value_4_0,
						"org.eclipse.lsat.setting.teditor.Setting.MotionSettings");
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_5='}'
		{
			newLeafNode(otherlv_5, grammarAccess.getMotionSettingsMapEntryAccess().getRightCurlyBracketKeyword_5());
		}
	)
;

// Entry rule entryRuleMotionSettings
entryRuleMotionSettings returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getMotionSettingsRule()); }
	iv_ruleMotionSettings=ruleMotionSettings
	{ $current=$iv_ruleMotionSettings.current; }
	EOF;

// Rule MotionSettings
ruleMotionSettings returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getMotionSettingsAccess().getMotionSettingsAction_0(),
					$current);
			}
		)
		otherlv_1='Profiles'
		{
			newLeafNode(otherlv_1, grammarAccess.getMotionSettingsAccess().getProfilesKeyword_1());
		}
		otherlv_2='{'
		{
			newLeafNode(otherlv_2, grammarAccess.getMotionSettingsAccess().getLeftCurlyBracketKeyword_2());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getMotionSettingsAccess().getProfileSettingsProfileSettingsMapEntryParserRuleCall_3_0());
				}
				lv_profileSettings_3_0=ruleProfileSettingsMapEntry
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getMotionSettingsRule());
					}
					add(
						$current,
						"profileSettings",
						lv_profileSettings_3_0,
						"org.eclipse.lsat.setting.teditor.Setting.ProfileSettingsMapEntry");
					afterParserOrEnumRuleCall();
				}
			)
		)*
		otherlv_4='}'
		{
			newLeafNode(otherlv_4, grammarAccess.getMotionSettingsAccess().getRightCurlyBracketKeyword_4());
		}
		(
			otherlv_5='Positions'
			{
				newLeafNode(otherlv_5, grammarAccess.getMotionSettingsAccess().getPositionsKeyword_5_0());
			}
			otherlv_6='{'
			{
				newLeafNode(otherlv_6, grammarAccess.getMotionSettingsAccess().getLeftCurlyBracketKeyword_5_1());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getMotionSettingsAccess().getLocationSettingsLocationSettingsMapEntryParserRuleCall_5_2_0());
					}
					lv_locationSettings_7_0=ruleLocationSettingsMapEntry
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getMotionSettingsRule());
						}
						add(
							$current,
							"locationSettings",
							lv_locationSettings_7_0,
							"org.eclipse.lsat.setting.teditor.Setting.LocationSettingsMapEntry");
						afterParserOrEnumRuleCall();
					}
				)
			)*
			otherlv_8='}'
			{
				newLeafNode(otherlv_8, grammarAccess.getMotionSettingsAccess().getRightCurlyBracketKeyword_5_3());
			}
		)?
		(
			otherlv_9='Distances'
			{
				newLeafNode(otherlv_9, grammarAccess.getMotionSettingsAccess().getDistancesKeyword_6_0());
			}
			otherlv_10='{'
			{
				newLeafNode(otherlv_10, grammarAccess.getMotionSettingsAccess().getLeftCurlyBracketKeyword_6_1());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getMotionSettingsAccess().getDistanceSettingsDistanceSettingsMapEntryParserRuleCall_6_2_0());
					}
					lv_distanceSettings_11_0=ruleDistanceSettingsMapEntry
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getMotionSettingsRule());
						}
						add(
							$current,
							"distanceSettings",
							lv_distanceSettings_11_0,
							"org.eclipse.lsat.setting.teditor.Setting.DistanceSettingsMapEntry");
						afterParserOrEnumRuleCall();
					}
				)
			)*
			otherlv_12='}'
			{
				newLeafNode(otherlv_12, grammarAccess.getMotionSettingsAccess().getRightCurlyBracketKeyword_6_3());
			}
		)?
	)
;

// Entry rule entryRuleProfileSettingsMapEntry
entryRuleProfileSettingsMapEntry returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getProfileSettingsMapEntryRule()); }
	iv_ruleProfileSettingsMapEntry=ruleProfileSettingsMapEntry
	{ $current=$iv_ruleProfileSettingsMapEntry.current; }
	EOF;

// Rule ProfileSettingsMapEntry
ruleProfileSettingsMapEntry returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getProfileSettingsMapEntryRule());
					}
				}
				otherlv_0=RULE_ID
				{
					newLeafNode(otherlv_0, grammarAccess.getProfileSettingsMapEntryAccess().getKeyProfileCrossReference_0_0());
				}
			)
		)
		(
			(
				{
					newCompositeNode(grammarAccess.getProfileSettingsMapEntryAccess().getValueMotionProfileSettingsParserRuleCall_1_0());
				}
				lv_value_1_0=ruleMotionProfileSettings
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getProfileSettingsMapEntryRule());
					}
					set(
						$current,
						"value",
						lv_value_1_0,
						"org.eclipse.lsat.setting.teditor.Setting.MotionProfileSettings");
					afterParserOrEnumRuleCall();
				}
			)
		)
	)
;

// Entry rule entryRuleLocationSettingsMapEntry
entryRuleLocationSettingsMapEntry returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getLocationSettingsMapEntryRule()); }
	iv_ruleLocationSettingsMapEntry=ruleLocationSettingsMapEntry
	{ $current=$iv_ruleLocationSettingsMapEntry.current; }
	EOF;

// Rule LocationSettingsMapEntry
ruleLocationSettingsMapEntry returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getLocationSettingsMapEntryRule());
					}
				}
				otherlv_0=RULE_ID
				{
					newLeafNode(otherlv_0, grammarAccess.getLocationSettingsMapEntryAccess().getKeyPositionCrossReference_0_0());
				}
			)
		)
		(
			(
				{
					newCompositeNode(grammarAccess.getLocationSettingsMapEntryAccess().getValuePhysicalLocationParserRuleCall_1_0());
				}
				lv_value_1_0=rulePhysicalLocation
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getLocationSettingsMapEntryRule());
					}
					set(
						$current,
						"value",
						lv_value_1_0,
						"org.eclipse.lsat.setting.teditor.Setting.PhysicalLocation");
					afterParserOrEnumRuleCall();
				}
			)
		)
	)
;

// Entry rule entryRuleDistanceSettingsMapEntry
entryRuleDistanceSettingsMapEntry returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getDistanceSettingsMapEntryRule()); }
	iv_ruleDistanceSettingsMapEntry=ruleDistanceSettingsMapEntry
	{ $current=$iv_ruleDistanceSettingsMapEntry.current; }
	EOF;

// Rule DistanceSettingsMapEntry
ruleDistanceSettingsMapEntry returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getDistanceSettingsMapEntryRule());
					}
				}
				otherlv_0=RULE_ID
				{
					newLeafNode(otherlv_0, grammarAccess.getDistanceSettingsMapEntryAccess().getKeyDistanceCrossReference_0_0());
				}
			)
		)
		otherlv_1='='
		{
			newLeafNode(otherlv_1, grammarAccess.getDistanceSettingsMapEntryAccess().getEqualsSignKeyword_1());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getDistanceSettingsMapEntryAccess().getValueExpressionParserRuleCall_2_0());
				}
				lv_value_2_0=ruleExpression
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getDistanceSettingsMapEntryRule());
					}
					set(
						$current,
						"value",
						lv_value_2_0,
						"org.eclipse.lsat.setting.teditor.Setting.Expression");
					afterParserOrEnumRuleCall();
				}
			)
		)
	)
;

// Entry rule entryRuleTimingSettingsMapEntry
entryRuleTimingSettingsMapEntry returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getTimingSettingsMapEntryRule()); }
	iv_ruleTimingSettingsMapEntry=ruleTimingSettingsMapEntry
	{ $current=$iv_ruleTimingSettingsMapEntry.current; }
	EOF;

// Rule TimingSettingsMapEntry
ruleTimingSettingsMapEntry returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getTimingSettingsMapEntryRule());
					}
				}
				otherlv_0=RULE_ID
				{
					newLeafNode(otherlv_0, grammarAccess.getTimingSettingsMapEntryAccess().getKeyActionTypeCrossReference_0_0());
				}
			)
		)
		otherlv_1='='
		{
			newLeafNode(otherlv_1, grammarAccess.getTimingSettingsMapEntryAccess().getEqualsSignKeyword_1());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getTimingSettingsMapEntryAccess().getValueTimingParserRuleCall_2_0());
				}
				lv_value_2_0=ruleTiming
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getTimingSettingsMapEntryRule());
					}
					set(
						$current,
						"value",
						lv_value_2_0,
						"org.eclipse.lsat.setting.teditor.Setting.Timing");
					afterParserOrEnumRuleCall();
				}
			)
		)
	)
;

// Entry rule entryRuleMotionProfileSettings
entryRuleMotionProfileSettings returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getMotionProfileSettingsRule()); }
	iv_ruleMotionProfileSettings=ruleMotionProfileSettings
	{ $current=$iv_ruleMotionProfileSettings.current; }
	EOF;

// Rule MotionProfileSettings
ruleMotionProfileSettings returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getMotionProfileSettingsAccess().getMotionProfileSettingsAction_0(),
					$current);
			}
		)
		(
			(
				lv_motionProfile_1_0=RULE_ID
				{
					newLeafNode(lv_motionProfile_1_0, grammarAccess.getMotionProfileSettingsAccess().getMotionProfileIDTerminalRuleCall_1_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getMotionProfileSettingsRule());
					}
					setWithLastConsumed(
						$current,
						"motionProfile",
						lv_motionProfile_1_0,
						"org.eclipse.xtext.common.Terminals.ID");
				}
			)
		)?
		otherlv_2='('
		{
			newLeafNode(otherlv_2, grammarAccess.getMotionProfileSettingsAccess().getLeftParenthesisKeyword_2());
		}
		(
			(
				(
					{
						newCompositeNode(grammarAccess.getMotionProfileSettingsAccess().getMotionArgumentsMotionArgumentsMapEntryParserRuleCall_3_0_0());
					}
					lv_motionArguments_3_0=ruleMotionArgumentsMapEntry
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getMotionProfileSettingsRule());
						}
						add(
							$current,
							"motionArguments",
							lv_motionArguments_3_0,
							"org.eclipse.lsat.setting.teditor.Setting.MotionArgumentsMapEntry");
						afterParserOrEnumRuleCall();
					}
				)
			)
			(
				otherlv_4=','
				{
					newLeafNode(otherlv_4, grammarAccess.getMotionProfileSettingsAccess().getCommaKeyword_3_1_0());
				}
				(
					(
						{
							newCompositeNode(grammarAccess.getMotionProfileSettingsAccess().getMotionArgumentsMotionArgumentsMapEntryParserRuleCall_3_1_1_0());
						}
						lv_motionArguments_5_0=ruleMotionArgumentsMapEntry
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getMotionProfileSettingsRule());
							}
							add(
								$current,
								"motionArguments",
								lv_motionArguments_5_0,
								"org.eclipse.lsat.setting.teditor.Setting.MotionArgumentsMapEntry");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)*
		)?
		otherlv_6=')'
		{
			newLeafNode(otherlv_6, grammarAccess.getMotionProfileSettingsAccess().getRightParenthesisKeyword_4());
		}
	)
;

// Entry rule entryRuleMotionArgumentsMapEntry
entryRuleMotionArgumentsMapEntry returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getMotionArgumentsMapEntryRule()); }
	iv_ruleMotionArgumentsMapEntry=ruleMotionArgumentsMapEntry
	{ $current=$iv_ruleMotionArgumentsMapEntry.current; }
	EOF;

// Rule MotionArgumentsMapEntry
ruleMotionArgumentsMapEntry returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				lv_key_0_0=RULE_ID
				{
					newLeafNode(lv_key_0_0, grammarAccess.getMotionArgumentsMapEntryAccess().getKeyIDTerminalRuleCall_0_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getMotionArgumentsMapEntryRule());
					}
					setWithLastConsumed(
						$current,
						"key",
						lv_key_0_0,
						"org.eclipse.xtext.common.Terminals.ID");
				}
			)
		)
		otherlv_1='='
		{
			newLeafNode(otherlv_1, grammarAccess.getMotionArgumentsMapEntryAccess().getEqualsSignKeyword_1());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getMotionArgumentsMapEntryAccess().getValueExpressionParserRuleCall_2_0());
				}
				lv_value_2_0=ruleExpression
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getMotionArgumentsMapEntryRule());
					}
					set(
						$current,
						"value",
						lv_value_2_0,
						"org.eclipse.lsat.setting.teditor.Setting.Expression");
					afterParserOrEnumRuleCall();
				}
			)
		)
	)
;

// Entry rule entryRulePhysicalLocation
entryRulePhysicalLocation returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getPhysicalLocationRule()); }
	iv_rulePhysicalLocation=rulePhysicalLocation
	{ $current=$iv_rulePhysicalLocation.current; }
	EOF;

// Rule PhysicalLocation
rulePhysicalLocation returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			otherlv_0='='
			{
				newLeafNode(otherlv_0, grammarAccess.getPhysicalLocationAccess().getEqualsSignKeyword_0_0());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getPhysicalLocationAccess().getDefaultExpExpressionParserRuleCall_0_1_0());
					}
					lv_defaultExp_1_0=ruleExpression
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getPhysicalLocationRule());
						}
						set(
							$current,
							"defaultExp",
							lv_defaultExp_1_0,
							"org.eclipse.lsat.setting.teditor.Setting.Expression");
						afterParserOrEnumRuleCall();
					}
				)
			)
		)
		    |
		(
			otherlv_2='('
			{
				newLeafNode(otherlv_2, grammarAccess.getPhysicalLocationAccess().getLeftParenthesisKeyword_1_0());
			}
			(
				otherlv_3='min'
				{
					newLeafNode(otherlv_3, grammarAccess.getPhysicalLocationAccess().getMinKeyword_1_1_0());
				}
				otherlv_4='='
				{
					newLeafNode(otherlv_4, grammarAccess.getPhysicalLocationAccess().getEqualsSignKeyword_1_1_1());
				}
				(
					(
						{
							newCompositeNode(grammarAccess.getPhysicalLocationAccess().getMinExpExpressionParserRuleCall_1_1_2_0());
						}
						lv_minExp_5_0=ruleExpression
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getPhysicalLocationRule());
							}
							set(
								$current,
								"minExp",
								lv_minExp_5_0,
								"org.eclipse.lsat.setting.teditor.Setting.Expression");
							afterParserOrEnumRuleCall();
						}
					)
				)
				otherlv_6=','
				{
					newLeafNode(otherlv_6, grammarAccess.getPhysicalLocationAccess().getCommaKeyword_1_1_3());
				}
			)?
			(
				otherlv_7='max'
				{
					newLeafNode(otherlv_7, grammarAccess.getPhysicalLocationAccess().getMaxKeyword_1_2_0());
				}
				otherlv_8='='
				{
					newLeafNode(otherlv_8, grammarAccess.getPhysicalLocationAccess().getEqualsSignKeyword_1_2_1());
				}
				(
					(
						{
							newCompositeNode(grammarAccess.getPhysicalLocationAccess().getMaxExpExpressionParserRuleCall_1_2_2_0());
						}
						lv_maxExp_9_0=ruleExpression
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getPhysicalLocationRule());
							}
							set(
								$current,
								"maxExp",
								lv_maxExp_9_0,
								"org.eclipse.lsat.setting.teditor.Setting.Expression");
							afterParserOrEnumRuleCall();
						}
					)
				)
				otherlv_10=','
				{
					newLeafNode(otherlv_10, grammarAccess.getPhysicalLocationAccess().getCommaKeyword_1_2_3());
				}
			)?
			otherlv_11='default'
			{
				newLeafNode(otherlv_11, grammarAccess.getPhysicalLocationAccess().getDefaultKeyword_1_3());
			}
			otherlv_12='='
			{
				newLeafNode(otherlv_12, grammarAccess.getPhysicalLocationAccess().getEqualsSignKeyword_1_4());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getPhysicalLocationAccess().getDefaultExpExpressionParserRuleCall_1_5_0());
					}
					lv_defaultExp_13_0=ruleExpression
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getPhysicalLocationRule());
						}
						set(
							$current,
							"defaultExp",
							lv_defaultExp_13_0,
							"org.eclipse.lsat.setting.teditor.Setting.Expression");
						afterParserOrEnumRuleCall();
					}
				)
			)
			otherlv_14=')'
			{
				newLeafNode(otherlv_14, grammarAccess.getPhysicalLocationAccess().getRightParenthesisKeyword_1_6());
			}
		)
	)
;

// Entry rule entryRuleTiming
entryRuleTiming returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getTimingRule()); }
	iv_ruleTiming=ruleTiming
	{ $current=$iv_ruleTiming.current; }
	EOF;

// Rule Timing
ruleTiming returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getTimingAccess().getFixedValueParserRuleCall_0());
		}
		this_FixedValue_0=ruleFixedValue
		{
			$current = $this_FixedValue_0.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getTimingAccess().getArrayParserRuleCall_1());
		}
		this_Array_1=ruleArray
		{
			$current = $this_Array_1.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getTimingAccess().getTriangularDistributionParserRuleCall_2());
		}
		this_TriangularDistribution_2=ruleTriangularDistribution
		{
			$current = $this_TriangularDistribution_2.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getTimingAccess().getPertDistributionParserRuleCall_3());
		}
		this_PertDistribution_3=rulePertDistribution
		{
			$current = $this_PertDistribution_3.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getTimingAccess().getNormalDistributionParserRuleCall_4());
		}
		this_NormalDistribution_4=ruleNormalDistribution
		{
			$current = $this_NormalDistribution_4.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getTimingAccess().getEnumeratedDistributionParserRuleCall_5());
		}
		this_EnumeratedDistribution_5=ruleEnumeratedDistribution
		{
			$current = $this_EnumeratedDistribution_5.current;
			afterParserOrEnumRuleCall();
		}
	)
;

// Entry rule entryRuleFixedValue
entryRuleFixedValue returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getFixedValueRule()); }
	iv_ruleFixedValue=ruleFixedValue
	{ $current=$iv_ruleFixedValue.current; }
	EOF;

// Rule FixedValue
ruleFixedValue returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				newCompositeNode(grammarAccess.getFixedValueAccess().getValueExpExpressionParserRuleCall_0());
			}
			lv_valueExp_0_0=ruleExpression
			{
				if ($current==null) {
					$current = createModelElementForParent(grammarAccess.getFixedValueRule());
				}
				set(
					$current,
					"valueExp",
					lv_valueExp_0_0,
					"org.eclipse.lsat.setting.teditor.Setting.Expression");
				afterParserOrEnumRuleCall();
			}
		)
	)
;

// Entry rule entryRuleArray
entryRuleArray returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getArrayRule()); }
	iv_ruleArray=ruleArray
	{ $current=$iv_ruleArray.current; }
	EOF;

// Rule Array
ruleArray returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		otherlv_0='Array'
		{
			newLeafNode(otherlv_0, grammarAccess.getArrayAccess().getArrayKeyword_0());
		}
		otherlv_1='('
		{
			newLeafNode(otherlv_1, grammarAccess.getArrayAccess().getLeftParenthesisKeyword_1());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getArrayAccess().getValuesExpExpressionParserRuleCall_2_0());
				}
				lv_valuesExp_2_0=ruleExpression
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getArrayRule());
					}
					add(
						$current,
						"valuesExp",
						lv_valuesExp_2_0,
						"org.eclipse.lsat.setting.teditor.Setting.Expression");
					afterParserOrEnumRuleCall();
				}
			)
		)
		(
			otherlv_3=','
			{
				newLeafNode(otherlv_3, grammarAccess.getArrayAccess().getCommaKeyword_3_0());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getArrayAccess().getValuesExpExpressionParserRuleCall_3_1_0());
					}
					lv_valuesExp_4_0=ruleExpression
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getArrayRule());
						}
						add(
							$current,
							"valuesExp",
							lv_valuesExp_4_0,
							"org.eclipse.lsat.setting.teditor.Setting.Expression");
						afterParserOrEnumRuleCall();
					}
				)
			)
		)*
		otherlv_5=')'
		{
			newLeafNode(otherlv_5, grammarAccess.getArrayAccess().getRightParenthesisKeyword_4());
		}
	)
;

// Entry rule entryRuleTriangularDistribution
entryRuleTriangularDistribution returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getTriangularDistributionRule()); }
	iv_ruleTriangularDistribution=ruleTriangularDistribution
	{ $current=$iv_ruleTriangularDistribution.current; }
	EOF;

// Rule TriangularDistribution
ruleTriangularDistribution returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		otherlv_0='Triangular'
		{
			newLeafNode(otherlv_0, grammarAccess.getTriangularDistributionAccess().getTriangularKeyword_0());
		}
		otherlv_1='('
		{
			newLeafNode(otherlv_1, grammarAccess.getTriangularDistributionAccess().getLeftParenthesisKeyword_1());
		}
		otherlv_2='min'
		{
			newLeafNode(otherlv_2, grammarAccess.getTriangularDistributionAccess().getMinKeyword_2());
		}
		otherlv_3='='
		{
			newLeafNode(otherlv_3, grammarAccess.getTriangularDistributionAccess().getEqualsSignKeyword_3());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getTriangularDistributionAccess().getMinExpExpressionParserRuleCall_4_0());
				}
				lv_minExp_4_0=ruleExpression
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getTriangularDistributionRule());
					}
					set(
						$current,
						"minExp",
						lv_minExp_4_0,
						"org.eclipse.lsat.setting.teditor.Setting.Expression");
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_5=','
		{
			newLeafNode(otherlv_5, grammarAccess.getTriangularDistributionAccess().getCommaKeyword_5());
		}
		otherlv_6='max'
		{
			newLeafNode(otherlv_6, grammarAccess.getTriangularDistributionAccess().getMaxKeyword_6());
		}
		otherlv_7='='
		{
			newLeafNode(otherlv_7, grammarAccess.getTriangularDistributionAccess().getEqualsSignKeyword_7());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getTriangularDistributionAccess().getMaxExpExpressionParserRuleCall_8_0());
				}
				lv_maxExp_8_0=ruleExpression
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getTriangularDistributionRule());
					}
					set(
						$current,
						"maxExp",
						lv_maxExp_8_0,
						"org.eclipse.lsat.setting.teditor.Setting.Expression");
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_9=','
		{
			newLeafNode(otherlv_9, grammarAccess.getTriangularDistributionAccess().getCommaKeyword_9());
		}
		otherlv_10='mode'
		{
			newLeafNode(otherlv_10, grammarAccess.getTriangularDistributionAccess().getModeKeyword_10());
		}
		otherlv_11='='
		{
			newLeafNode(otherlv_11, grammarAccess.getTriangularDistributionAccess().getEqualsSignKeyword_11());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getTriangularDistributionAccess().getModeExpExpressionParserRuleCall_12_0());
				}
				lv_modeExp_12_0=ruleExpression
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getTriangularDistributionRule());
					}
					set(
						$current,
						"modeExp",
						lv_modeExp_12_0,
						"org.eclipse.lsat.setting.teditor.Setting.Expression");
					afterParserOrEnumRuleCall();
				}
			)
		)
		(
			otherlv_13=','
			{
				newLeafNode(otherlv_13, grammarAccess.getTriangularDistributionAccess().getCommaKeyword_13_0());
			}
			otherlv_14='default'
			{
				newLeafNode(otherlv_14, grammarAccess.getTriangularDistributionAccess().getDefaultKeyword_13_1());
			}
			otherlv_15='='
			{
				newLeafNode(otherlv_15, grammarAccess.getTriangularDistributionAccess().getEqualsSignKeyword_13_2());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getTriangularDistributionAccess().getDefaultExpExpressionParserRuleCall_13_3_0());
					}
					lv_defaultExp_16_0=ruleExpression
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getTriangularDistributionRule());
						}
						set(
							$current,
							"defaultExp",
							lv_defaultExp_16_0,
							"org.eclipse.lsat.setting.teditor.Setting.Expression");
						afterParserOrEnumRuleCall();
					}
				)
			)
		)?
		otherlv_17=')'
		{
			newLeafNode(otherlv_17, grammarAccess.getTriangularDistributionAccess().getRightParenthesisKeyword_14());
		}
	)
;

// Entry rule entryRulePertDistribution
entryRulePertDistribution returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getPertDistributionRule()); }
	iv_rulePertDistribution=rulePertDistribution
	{ $current=$iv_rulePertDistribution.current; }
	EOF;

// Rule PertDistribution
rulePertDistribution returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		otherlv_0='Pert'
		{
			newLeafNode(otherlv_0, grammarAccess.getPertDistributionAccess().getPertKeyword_0());
		}
		otherlv_1='('
		{
			newLeafNode(otherlv_1, grammarAccess.getPertDistributionAccess().getLeftParenthesisKeyword_1());
		}
		otherlv_2='min'
		{
			newLeafNode(otherlv_2, grammarAccess.getPertDistributionAccess().getMinKeyword_2());
		}
		otherlv_3='='
		{
			newLeafNode(otherlv_3, grammarAccess.getPertDistributionAccess().getEqualsSignKeyword_3());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getPertDistributionAccess().getMinExpExpressionParserRuleCall_4_0());
				}
				lv_minExp_4_0=ruleExpression
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getPertDistributionRule());
					}
					set(
						$current,
						"minExp",
						lv_minExp_4_0,
						"org.eclipse.lsat.setting.teditor.Setting.Expression");
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_5=','
		{
			newLeafNode(otherlv_5, grammarAccess.getPertDistributionAccess().getCommaKeyword_5());
		}
		otherlv_6='max'
		{
			newLeafNode(otherlv_6, grammarAccess.getPertDistributionAccess().getMaxKeyword_6());
		}
		otherlv_7='='
		{
			newLeafNode(otherlv_7, grammarAccess.getPertDistributionAccess().getEqualsSignKeyword_7());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getPertDistributionAccess().getMaxExpExpressionParserRuleCall_8_0());
				}
				lv_maxExp_8_0=ruleExpression
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getPertDistributionRule());
					}
					set(
						$current,
						"maxExp",
						lv_maxExp_8_0,
						"org.eclipse.lsat.setting.teditor.Setting.Expression");
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_9=','
		{
			newLeafNode(otherlv_9, grammarAccess.getPertDistributionAccess().getCommaKeyword_9());
		}
		otherlv_10='mode'
		{
			newLeafNode(otherlv_10, grammarAccess.getPertDistributionAccess().getModeKeyword_10());
		}
		otherlv_11='='
		{
			newLeafNode(otherlv_11, grammarAccess.getPertDistributionAccess().getEqualsSignKeyword_11());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getPertDistributionAccess().getModeExpExpressionParserRuleCall_12_0());
				}
				lv_modeExp_12_0=ruleExpression
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getPertDistributionRule());
					}
					set(
						$current,
						"modeExp",
						lv_modeExp_12_0,
						"org.eclipse.lsat.setting.teditor.Setting.Expression");
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_13=','
		{
			newLeafNode(otherlv_13, grammarAccess.getPertDistributionAccess().getCommaKeyword_13());
		}
		otherlv_14='gamma'
		{
			newLeafNode(otherlv_14, grammarAccess.getPertDistributionAccess().getGammaKeyword_14());
		}
		otherlv_15='='
		{
			newLeafNode(otherlv_15, grammarAccess.getPertDistributionAccess().getEqualsSignKeyword_15());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getPertDistributionAccess().getGammaExpExpressionParserRuleCall_16_0());
				}
				lv_gammaExp_16_0=ruleExpression
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getPertDistributionRule());
					}
					set(
						$current,
						"gammaExp",
						lv_gammaExp_16_0,
						"org.eclipse.lsat.setting.teditor.Setting.Expression");
					afterParserOrEnumRuleCall();
				}
			)
		)
		(
			otherlv_17=','
			{
				newLeafNode(otherlv_17, grammarAccess.getPertDistributionAccess().getCommaKeyword_17_0());
			}
			otherlv_18='default'
			{
				newLeafNode(otherlv_18, grammarAccess.getPertDistributionAccess().getDefaultKeyword_17_1());
			}
			otherlv_19='='
			{
				newLeafNode(otherlv_19, grammarAccess.getPertDistributionAccess().getEqualsSignKeyword_17_2());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getPertDistributionAccess().getDefaultExpExpressionParserRuleCall_17_3_0());
					}
					lv_defaultExp_20_0=ruleExpression
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getPertDistributionRule());
						}
						set(
							$current,
							"defaultExp",
							lv_defaultExp_20_0,
							"org.eclipse.lsat.setting.teditor.Setting.Expression");
						afterParserOrEnumRuleCall();
					}
				)
			)
		)?
		otherlv_21=')'
		{
			newLeafNode(otherlv_21, grammarAccess.getPertDistributionAccess().getRightParenthesisKeyword_18());
		}
	)
;

// Entry rule entryRuleNormalDistribution
entryRuleNormalDistribution returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getNormalDistributionRule()); }
	iv_ruleNormalDistribution=ruleNormalDistribution
	{ $current=$iv_ruleNormalDistribution.current; }
	EOF;

// Rule NormalDistribution
ruleNormalDistribution returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		otherlv_0='Normal'
		{
			newLeafNode(otherlv_0, grammarAccess.getNormalDistributionAccess().getNormalKeyword_0());
		}
		otherlv_1='('
		{
			newLeafNode(otherlv_1, grammarAccess.getNormalDistributionAccess().getLeftParenthesisKeyword_1());
		}
		otherlv_2='mean'
		{
			newLeafNode(otherlv_2, grammarAccess.getNormalDistributionAccess().getMeanKeyword_2());
		}
		otherlv_3='='
		{
			newLeafNode(otherlv_3, grammarAccess.getNormalDistributionAccess().getEqualsSignKeyword_3());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getNormalDistributionAccess().getMeanExpExpressionParserRuleCall_4_0());
				}
				lv_meanExp_4_0=ruleExpression
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getNormalDistributionRule());
					}
					set(
						$current,
						"meanExp",
						lv_meanExp_4_0,
						"org.eclipse.lsat.setting.teditor.Setting.Expression");
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_5=','
		{
			newLeafNode(otherlv_5, grammarAccess.getNormalDistributionAccess().getCommaKeyword_5());
		}
		otherlv_6='sd'
		{
			newLeafNode(otherlv_6, grammarAccess.getNormalDistributionAccess().getSdKeyword_6());
		}
		otherlv_7='='
		{
			newLeafNode(otherlv_7, grammarAccess.getNormalDistributionAccess().getEqualsSignKeyword_7());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getNormalDistributionAccess().getSdExpExpressionParserRuleCall_8_0());
				}
				lv_sdExp_8_0=ruleExpression
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getNormalDistributionRule());
					}
					set(
						$current,
						"sdExp",
						lv_sdExp_8_0,
						"org.eclipse.lsat.setting.teditor.Setting.Expression");
					afterParserOrEnumRuleCall();
				}
			)
		)
		(
			otherlv_9=','
			{
				newLeafNode(otherlv_9, grammarAccess.getNormalDistributionAccess().getCommaKeyword_9_0());
			}
			otherlv_10='default'
			{
				newLeafNode(otherlv_10, grammarAccess.getNormalDistributionAccess().getDefaultKeyword_9_1());
			}
			otherlv_11='='
			{
				newLeafNode(otherlv_11, grammarAccess.getNormalDistributionAccess().getEqualsSignKeyword_9_2());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getNormalDistributionAccess().getDefaultExpExpressionParserRuleCall_9_3_0());
					}
					lv_defaultExp_12_0=ruleExpression
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getNormalDistributionRule());
						}
						set(
							$current,
							"defaultExp",
							lv_defaultExp_12_0,
							"org.eclipse.lsat.setting.teditor.Setting.Expression");
						afterParserOrEnumRuleCall();
					}
				)
			)
		)?
		otherlv_13=')'
		{
			newLeafNode(otherlv_13, grammarAccess.getNormalDistributionAccess().getRightParenthesisKeyword_10());
		}
	)
;

// Entry rule entryRuleEnumeratedDistribution
entryRuleEnumeratedDistribution returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getEnumeratedDistributionRule()); }
	iv_ruleEnumeratedDistribution=ruleEnumeratedDistribution
	{ $current=$iv_ruleEnumeratedDistribution.current; }
	EOF;

// Rule EnumeratedDistribution
ruleEnumeratedDistribution returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		otherlv_0='Enumerated'
		{
			newLeafNode(otherlv_0, grammarAccess.getEnumeratedDistributionAccess().getEnumeratedKeyword_0());
		}
		otherlv_1='('
		{
			newLeafNode(otherlv_1, grammarAccess.getEnumeratedDistributionAccess().getLeftParenthesisKeyword_1());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getEnumeratedDistributionAccess().getValuesExpExpressionParserRuleCall_2_0());
				}
				lv_valuesExp_2_0=ruleExpression
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getEnumeratedDistributionRule());
					}
					add(
						$current,
						"valuesExp",
						lv_valuesExp_2_0,
						"org.eclipse.lsat.setting.teditor.Setting.Expression");
					afterParserOrEnumRuleCall();
				}
			)
		)
		(
			otherlv_3=','
			{
				newLeafNode(otherlv_3, grammarAccess.getEnumeratedDistributionAccess().getCommaKeyword_3_0());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getEnumeratedDistributionAccess().getValuesExpExpressionParserRuleCall_3_1_0());
					}
					lv_valuesExp_4_0=ruleExpression
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getEnumeratedDistributionRule());
						}
						add(
							$current,
							"valuesExp",
							lv_valuesExp_4_0,
							"org.eclipse.lsat.setting.teditor.Setting.Expression");
						afterParserOrEnumRuleCall();
					}
				)
			)
		)*
		(
			otherlv_5=','
			{
				newLeafNode(otherlv_5, grammarAccess.getEnumeratedDistributionAccess().getCommaKeyword_4_0());
			}
			otherlv_6='default'
			{
				newLeafNode(otherlv_6, grammarAccess.getEnumeratedDistributionAccess().getDefaultKeyword_4_1());
			}
			otherlv_7='='
			{
				newLeafNode(otherlv_7, grammarAccess.getEnumeratedDistributionAccess().getEqualsSignKeyword_4_2());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getEnumeratedDistributionAccess().getDefaultExpExpressionParserRuleCall_4_3_0());
					}
					lv_defaultExp_8_0=ruleExpression
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getEnumeratedDistributionRule());
						}
						set(
							$current,
							"defaultExp",
							lv_defaultExp_8_0,
							"org.eclipse.lsat.setting.teditor.Setting.Expression");
						afterParserOrEnumRuleCall();
					}
				)
			)
		)?
		otherlv_9=')'
		{
			newLeafNode(otherlv_9, grammarAccess.getEnumeratedDistributionAccess().getRightParenthesisKeyword_5());
		}
	)
;

// Entry rule entryRuleDeclaration
entryRuleDeclaration returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getDeclarationRule()); }
	iv_ruleDeclaration=ruleDeclaration
	{ $current=$iv_ruleDeclaration.current; }
	EOF;

// Rule Declaration
ruleDeclaration returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getDeclarationAccess().getDeclarationAction_0(),
					$current);
			}
		)
		otherlv_1='val'
		{
			newLeafNode(otherlv_1, grammarAccess.getDeclarationAccess().getValKeyword_1());
		}
		(
			(
				lv_name_2_0=RULE_ID
				{
					newLeafNode(lv_name_2_0, grammarAccess.getDeclarationAccess().getNameIDTerminalRuleCall_2_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getDeclarationRule());
					}
					setWithLastConsumed(
						$current,
						"name",
						lv_name_2_0,
						"org.eclipse.xtext.common.Terminals.ID");
				}
			)
		)
		otherlv_3='='
		{
			newLeafNode(otherlv_3, grammarAccess.getDeclarationAccess().getEqualsSignKeyword_3());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getDeclarationAccess().getExpressionExpressionParserRuleCall_4_0());
				}
				lv_expression_4_0=ruleExpression
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getDeclarationRule());
					}
					set(
						$current,
						"expression",
						lv_expression_4_0,
						"org.eclipse.lsat.setting.teditor.Setting.Expression");
					afterParserOrEnumRuleCall();
				}
			)
		)
	)
;

// Entry rule entryRuleExpression
entryRuleExpression returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getExpressionRule()); }
	iv_ruleExpression=ruleExpression
	{ $current=$iv_ruleExpression.current; }
	EOF;

// Rule Expression
ruleExpression returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	{
		newCompositeNode(grammarAccess.getExpressionAccess().getPlusOrMinusParserRuleCall());
	}
	this_PlusOrMinus_0=rulePlusOrMinus
	{
		$current = $this_PlusOrMinus_0.current;
		afterParserOrEnumRuleCall();
	}
;

// Entry rule entryRulePlusOrMinus
entryRulePlusOrMinus returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getPlusOrMinusRule()); }
	iv_rulePlusOrMinus=rulePlusOrMinus
	{ $current=$iv_rulePlusOrMinus.current; }
	EOF;

// Rule PlusOrMinus
rulePlusOrMinus returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getPlusOrMinusAccess().getMulOrDivParserRuleCall_0());
		}
		this_MulOrDiv_0=ruleMulOrDiv
		{
			$current = $this_MulOrDiv_0.current;
			afterParserOrEnumRuleCall();
		}
		(
			(
				(
					(
						{
							$current = forceCreateModelElementAndSet(
								grammarAccess.getPlusOrMinusAccess().getAddLeftAction_1_0_0_0(),
								$current);
						}
					)
					otherlv_2='+'
					{
						newLeafNode(otherlv_2, grammarAccess.getPlusOrMinusAccess().getPlusSignKeyword_1_0_0_1());
					}
				)
				    |
				(
					(
						{
							$current = forceCreateModelElementAndSet(
								grammarAccess.getPlusOrMinusAccess().getSubtractLeftAction_1_0_1_0(),
								$current);
						}
					)
					otherlv_4='-'
					{
						newLeafNode(otherlv_4, grammarAccess.getPlusOrMinusAccess().getHyphenMinusKeyword_1_0_1_1());
					}
				)
			)
			(
				(
					{
						newCompositeNode(grammarAccess.getPlusOrMinusAccess().getRightMulOrDivParserRuleCall_1_1_0());
					}
					lv_right_5_0=ruleMulOrDiv
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getPlusOrMinusRule());
						}
						set(
							$current,
							"right",
							lv_right_5_0,
							"org.eclipse.lsat.setting.teditor.Setting.MulOrDiv");
						afterParserOrEnumRuleCall();
					}
				)
			)
		)*
	)
;

// Entry rule entryRuleMulOrDiv
entryRuleMulOrDiv returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getMulOrDivRule()); }
	iv_ruleMulOrDiv=ruleMulOrDiv
	{ $current=$iv_ruleMulOrDiv.current; }
	EOF;

// Rule MulOrDiv
ruleMulOrDiv returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getMulOrDivAccess().getPrimaryParserRuleCall_0());
		}
		this_Primary_0=rulePrimary
		{
			$current = $this_Primary_0.current;
			afterParserOrEnumRuleCall();
		}
		(
			(
				(
					(
						{
							$current = forceCreateModelElementAndSet(
								grammarAccess.getMulOrDivAccess().getMultiplyLeftAction_1_0_0_0(),
								$current);
						}
					)
					otherlv_2='*'
					{
						newLeafNode(otherlv_2, grammarAccess.getMulOrDivAccess().getAsteriskKeyword_1_0_0_1());
					}
				)
				    |
				(
					(
						{
							$current = forceCreateModelElementAndSet(
								grammarAccess.getMulOrDivAccess().getDivideLeftAction_1_0_1_0(),
								$current);
						}
					)
					otherlv_4='/'
					{
						newLeafNode(otherlv_4, grammarAccess.getMulOrDivAccess().getSolidusKeyword_1_0_1_1());
					}
				)
			)
			(
				(
					{
						newCompositeNode(grammarAccess.getMulOrDivAccess().getRightPrimaryParserRuleCall_1_1_0());
					}
					lv_right_5_0=rulePrimary
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getMulOrDivRule());
						}
						set(
							$current,
							"right",
							lv_right_5_0,
							"org.eclipse.lsat.setting.teditor.Setting.Primary");
						afterParserOrEnumRuleCall();
					}
				)
			)
		)*
	)
;

// Entry rule entryRulePrimary
entryRulePrimary returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getPrimaryRule()); }
	iv_rulePrimary=rulePrimary
	{ $current=$iv_rulePrimary.current; }
	EOF;

// Rule Primary
rulePrimary returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			otherlv_0='('
			{
				newLeafNode(otherlv_0, grammarAccess.getPrimaryAccess().getLeftParenthesisKeyword_0_0());
			}
			{
				newCompositeNode(grammarAccess.getPrimaryAccess().getExpressionParserRuleCall_0_1());
			}
			this_Expression_1=ruleExpression
			{
				$current = $this_Expression_1.current;
				afterParserOrEnumRuleCall();
			}
			otherlv_2=')'
			{
				newLeafNode(otherlv_2, grammarAccess.getPrimaryAccess().getRightParenthesisKeyword_0_2());
			}
		)
		    |
		{
			newCompositeNode(grammarAccess.getPrimaryAccess().getAtomicParserRuleCall_1());
		}
		this_Atomic_3=ruleAtomic
		{
			$current = $this_Atomic_3.current;
			afterParserOrEnumRuleCall();
		}
	)
;

// Entry rule entryRuleAtomic
entryRuleAtomic returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getAtomicRule()); }
	iv_ruleAtomic=ruleAtomic
	{ $current=$iv_ruleAtomic.current; }
	EOF;

// Rule Atomic
ruleAtomic returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				{
					$current = forceCreateModelElement(
						grammarAccess.getAtomicAccess().getBigDecimalConstantAction_0_0(),
						$current);
				}
			)
			(
				(
					{
						newCompositeNode(grammarAccess.getAtomicAccess().getValueEBigDecimalParserRuleCall_0_1_0());
					}
					lv_value_1_0=ruleEBigDecimal
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getAtomicRule());
						}
						set(
							$current,
							"value",
							lv_value_1_0,
							"org.eclipse.lsat.setting.teditor.Setting.EBigDecimal");
						afterParserOrEnumRuleCall();
					}
				)
			)
		)
		    |
		(
			(
				{
					$current = forceCreateModelElement(
						grammarAccess.getAtomicAccess().getDeclarationRefAction_1_0(),
						$current);
				}
			)
			(
				(
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getAtomicRule());
						}
					}
					otherlv_3=RULE_ID
					{
						newLeafNode(otherlv_3, grammarAccess.getAtomicAccess().getDeclarationDeclarationCrossReference_1_1_0());
					}
				)
			)
		)
	)
;

// Entry rule entryRuleEBigDecimal
entryRuleEBigDecimal returns [String current=null]:
	{ newCompositeNode(grammarAccess.getEBigDecimalRule()); }
	iv_ruleEBigDecimal=ruleEBigDecimal
	{ $current=$iv_ruleEBigDecimal.current.getText(); }
	EOF;

// Rule EBigDecimal
ruleEBigDecimal returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			kw='-'
			{
				$current.merge(kw);
				newLeafNode(kw, grammarAccess.getEBigDecimalAccess().getHyphenMinusKeyword_0());
			}
		)?
		this_INT_1=RULE_INT
		{
			$current.merge(this_INT_1);
		}
		{
			newLeafNode(this_INT_1, grammarAccess.getEBigDecimalAccess().getINTTerminalRuleCall_1());
		}
		(
			kw='.'
			{
				$current.merge(kw);
				newLeafNode(kw, grammarAccess.getEBigDecimalAccess().getFullStopKeyword_2_0());
			}
			this_INT_3=RULE_INT
			{
				$current.merge(this_INT_3);
			}
			{
				newLeafNode(this_INT_3, grammarAccess.getEBigDecimalAccess().getINTTerminalRuleCall_2_1());
			}
		)?
		(
			(
				kw='E'
				{
					$current.merge(kw);
					newLeafNode(kw, grammarAccess.getEBigDecimalAccess().getEKeyword_3_0_0());
				}
				    |
				kw='e'
				{
					$current.merge(kw);
					newLeafNode(kw, grammarAccess.getEBigDecimalAccess().getEKeyword_3_0_1());
				}
			)
			(
				kw='-'
				{
					$current.merge(kw);
					newLeafNode(kw, grammarAccess.getEBigDecimalAccess().getHyphenMinusKeyword_3_1());
				}
			)?
			this_INT_7=RULE_INT
			{
				$current.merge(this_INT_7);
			}
			{
				newLeafNode(this_INT_7, grammarAccess.getEBigDecimalAccess().getINTTerminalRuleCall_3_2());
			}
		)?
	)
;

// Entry rule entryRuleIID
entryRuleIID returns [String current=null]:
	{ newCompositeNode(grammarAccess.getIIDRule()); }
	iv_ruleIID=ruleIID
	{ $current=$iv_ruleIID.current.getText(); }
	EOF;

// Rule IID
ruleIID returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		this_INT_0=RULE_INT
		{
			$current.merge(this_INT_0);
		}
		{
			newLeafNode(this_INT_0, grammarAccess.getIIDAccess().getINTTerminalRuleCall_0());
		}
		    |
		this_ID_1=RULE_ID
		{
			$current.merge(this_ID_1);
		}
		{
			newLeafNode(this_ID_1, grammarAccess.getIIDAccess().getIDTerminalRuleCall_1());
		}
	)
;

// Entry rule entryRuleResourceQualifiedName
entryRuleResourceQualifiedName returns [String current=null]:
	{ newCompositeNode(grammarAccess.getResourceQualifiedNameRule()); }
	iv_ruleResourceQualifiedName=ruleResourceQualifiedName
	{ $current=$iv_ruleResourceQualifiedName.current.getText(); }
	EOF;

// Rule ResourceQualifiedName
ruleResourceQualifiedName returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getResourceQualifiedNameAccess().getIIDParserRuleCall_0());
		}
		this_IID_0=ruleIID
		{
			$current.merge(this_IID_0);
		}
		{
			afterParserOrEnumRuleCall();
		}
		(
			kw='.'
			{
				$current.merge(kw);
				newLeafNode(kw, grammarAccess.getResourceQualifiedNameAccess().getFullStopKeyword_1_0());
			}
			{
				newCompositeNode(grammarAccess.getResourceQualifiedNameAccess().getIIDParserRuleCall_1_1());
			}
			this_IID_2=ruleIID
			{
				$current.merge(this_IID_2);
			}
			{
				afterParserOrEnumRuleCall();
			}
		)?
	)
;

RULE_ID : '^'? ('a'..'z'|'A'..'Z'|'_') ('a'..'z'|'A'..'Z'|'_'|'0'..'9')*;

RULE_INT : ('0'..'9')+;

RULE_STRING : ('"' ('\\' .|~(('\\'|'"')))* '"'|'\'' ('\\' .|~(('\\'|'\'')))* '\'');

RULE_ML_COMMENT : '/*' ( options {greedy=false;} : . )*'*/';

RULE_SL_COMMENT : '//' ~(('\n'|'\r'))* ('\r'? '\n')?;

RULE_WS : (' '|'\t'|'\r'|'\n')+;

RULE_ANY_OTHER : .;
