/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.timinganalysis.ui.launch;

import java.util.stream.Stream;
import org.eclipse.core.resources.IFile;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.lsat.timinganalysis.ui.launch.TimingAnalysisLaunchAttributes;
import org.eclipse.lsat.timinganalysis.ui.launch.TimingAnalysisLaunchJob;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class TimingAnalysisLaunchShortcut
implements ILaunchShortcut,
TimingAnalysisLaunchAttributes {
    private static final String SETTING = "setting";
    private static final String DISPATCHING = "dispatching";
    private final String chartType;

    private TimingAnalysisLaunchShortcut(String chartType) {
        this.chartType = chartType;
    }

    public void launch(ISelection selection, String mode) {
        if (selection instanceof IStructuredSelection) {
            IFile[] files = (IFile[])Stream.of(((IStructuredSelection)selection).toArray()).map(f -> (IFile)f).toArray(IFile[]::new);
            this.doLaunch(files, mode);
        }
    }

    public void launch(IEditorPart editor, String mode) {
        if (editor.getEditorInput() instanceof FileEditorInput) {
            IFile file = ((FileEditorInput)editor.getEditorInput()).getFile();
            this.doLaunch(new IFile[]{file}, mode);
        }
    }

    protected void doLaunch(IFile[] files, String mode) {
        if (TimingAnalysisLaunchShortcut.checkValid(files)) {
            TimingAnalysisLaunchJob job = new TimingAnalysisLaunchJob(files, mode, this.chartType);
            job.setUser(true);
            job.schedule();
        }
    }

    private static boolean checkValid(IFile[] files) {
        if (files.length == 1) {
            return true;
        }
        if (files.length == 2 && 1L == Stream.of(files).filter(f -> DISPATCHING.equals(f.getFileExtension())).count() && 1L == Stream.of(files).filter(f -> SETTING.equals(f.getFileExtension())).count()) {
            return true;
        }
        TimingAnalysisLaunchShortcut.informUser();
        return false;
    }

    private static void informUser() {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        MessageDialog.openError((Shell)shell, (String)"Wrong selection for timing analysis", (String)"Please select one dispatching and/or one setting file");
    }

    /* synthetic */ TimingAnalysisLaunchShortcut(String string, TimingAnalysisLaunchShortcut timingAnalysisLaunchShortcut) {
        this(string);
    }

    public static class CriticalPath
    extends TimingAnalysisLaunchShortcut {
        public CriticalPath() {
            super(TimingAnalysisLaunchAttributes.CRITICAL_PATH, null);
        }
    }

    public static class GanttChart
    extends TimingAnalysisLaunchShortcut {
        public GanttChart() {
            super(TimingAnalysisLaunchAttributes.GANTT_CHART, null);
        }
    }

    public static class StochasticImpact
    extends TimingAnalysisLaunchShortcut {
        public StochasticImpact() {
            super(TimingAnalysisLaunchAttributes.STOCHASTIC_IMPACT, null);
        }
    }
}

