/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.ludus.backend.graph.jgrapht;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.lsat.common.ludus.backend.games.GameGraph;
import org.eclipse.lsat.common.ludus.backend.games.GameSubgraph;
import org.eclipse.lsat.common.ludus.backend.games.StrategyVector;
import org.eclipse.lsat.common.ludus.backend.graph.jgrapht.JGraphTEdge;
import org.eclipse.lsat.common.ludus.backend.graph.jgrapht.JGraphTVertex;
import org.jgrapht.Graph;
import org.jgrapht.graph.AsSubgraph;
import org.jgrapht.graph.DefaultDirectedGraph;

public class JGraphTGraph
implements GameGraph<JGraphTVertex, JGraphTEdge>,
GameSubgraph<JGraphTVertex, JGraphTEdge>,
Serializable {
    private static final long serialVersionUID = -1306760703066967345L;
    private final Graph<JGraphTVertex, JGraphTEdge> graph;
    private final Set<JGraphTVertex> verticesP0;
    private final Set<JGraphTVertex> verticesP1;

    public JGraphTGraph() {
        this.graph = new DefaultDirectedGraph(JGraphTEdge.class);
        this.verticesP0 = new HashSet<JGraphTVertex>();
        this.verticesP1 = new HashSet<JGraphTVertex>();
    }

    public JGraphTGraph(JGraphTGraph gameGraph) {
        this.graph = gameGraph.graph;
        this.verticesP0 = gameGraph.getV0();
        this.verticesP1 = gameGraph.getV1();
    }

    public JGraphTGraph(AsSubgraph<JGraphTVertex, JGraphTEdge> directedGraph, Set<JGraphTVertex> V0, Set<JGraphTVertex> V1) {
        this.graph = directedGraph;
        this.verticesP0 = V0;
        this.verticesP1 = V1;
    }

    public void addToV0(JGraphTVertex ... vertices) {
        JGraphTVertex[] jGraphTVertexArray = vertices;
        int n = vertices.length;
        int n2 = 0;
        while (n2 < n) {
            JGraphTVertex v = jGraphTVertexArray[n2];
            this.graph.addVertex((Object)v);
            this.verticesP0.add(v);
            ++n2;
        }
    }

    public void addToV1(JGraphTVertex ... vertices) {
        JGraphTVertex[] jGraphTVertexArray = vertices;
        int n = vertices.length;
        int n2 = 0;
        while (n2 < n) {
            JGraphTVertex v = jGraphTVertexArray[n2];
            this.graph.addVertex((Object)v);
            this.verticesP1.add(v);
            ++n2;
        }
    }

    public JGraphTEdge addEdge(JGraphTVertex source, JGraphTVertex target) {
        return (JGraphTEdge)this.graph.addEdge((Object)source, (Object)target);
    }

    protected Graph<JGraphTVertex, JGraphTEdge> getGraph() {
        return this.graph;
    }

    @Override
    public Set<JGraphTVertex> getV0() {
        return this.verticesP0;
    }

    @Override
    public Set<JGraphTVertex> getV1() {
        return this.verticesP1;
    }

    @Override
    public Set<JGraphTVertex> getVertices() {
        return this.graph.vertexSet();
    }

    @Override
    public Set<JGraphTEdge> getEdges() {
        return this.graph.edgeSet();
    }

    @Override
    public Set<JGraphTEdge> incomingEdgesOf(JGraphTVertex v) {
        return this.graph.incomingEdgesOf((Object)v);
    }

    @Override
    public Set<JGraphTEdge> outgoingEdgesOf(JGraphTVertex v) {
        return this.graph.outgoingEdgesOf((Object)v);
    }

    @Override
    public JGraphTVertex getEdgeSource(JGraphTEdge e) {
        return (JGraphTVertex)this.graph.getEdgeSource((Object)e);
    }

    @Override
    public JGraphTVertex getEdgeTarget(JGraphTEdge e) {
        return (JGraphTVertex)this.graph.getEdgeTarget((Object)e);
    }

    @Override
    public JGraphTEdge getEdge(JGraphTVertex source, JGraphTVertex target) {
        return (JGraphTEdge)this.graph.getEdge((Object)source, (Object)target);
    }

    public JGraphTGraph getSubgraph(Set<JGraphTVertex> subgraphVertices) {
        AsSubgraph subGraph = new AsSubgraph(this.getGraph(), subgraphVertices, null);
        HashSet<JGraphTVertex> v0 = new HashSet<JGraphTVertex>(this.getV0());
        v0.retainAll(subgraphVertices);
        HashSet<JGraphTVertex> v1 = new HashSet<JGraphTVertex>(this.getV1());
        v1.retainAll(subgraphVertices);
        return new JGraphTGraph((AsSubgraph<JGraphTVertex, JGraphTEdge>)subGraph, v0, v1);
    }

    public JGraphTGraph getSwappedSubgraph(Set<JGraphTVertex> subgraphVertices) {
        AsSubgraph subGraph = new AsSubgraph(this.getGraph(), subgraphVertices, null);
        HashSet<JGraphTVertex> v0 = new HashSet<JGraphTVertex>(this.getV0());
        v0.retainAll(subgraphVertices);
        HashSet<JGraphTVertex> v1 = new HashSet<JGraphTVertex>(this.getV1());
        v1.retainAll(subgraphVertices);
        return new JGraphTGraph((AsSubgraph<JGraphTVertex, JGraphTEdge>)subGraph, v1, v0);
    }

    public JGraphTGraph getSubgraphRestrictEdges(Set<JGraphTEdge> subgraphEdges) {
        AsSubgraph subGraph = new AsSubgraph(this.getGraph(), null, subgraphEdges);
        return new JGraphTGraph((AsSubgraph<JGraphTVertex, JGraphTEdge>)subGraph, this.getV1(), this.getV0());
    }

    @Override
    public GameGraph<JGraphTVertex, JGraphTEdge> getSubgraph(StrategyVector<JGraphTVertex, JGraphTEdge> strategyVector) {
        JGraphTGraph subGraph = new JGraphTGraph();
        for (JGraphTVertex v : this.getVertices()) {
            JGraphTVertex succ = strategyVector.getSuccessor(v);
            if (this.getV0().contains(v)) {
                subGraph.addToV0(v);
            } else {
                subGraph.addToV1(v);
            }
            subGraph.addEdge(v, succ);
        }
        return subGraph;
    }
}

