/**
 * Copyright (c) 2021 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Do not edit: This file is generated by Xtext
 */
package org.eclipse.lsat.setting.teditor.serializer;

import com.google.inject.Inject;
import common.CommonPackage;
import common.Import;
import distributions.DistributionsPackage;
import distributions.EnumeratedDistribution;
import distributions.GammaDistribution;
import distributions.LogNormalDistribution;
import distributions.NormalDistribution;
import distributions.PertDistribution;
import distributions.PoissonDistribution;
import distributions.TriangularDistribution;
import expressions.Add;
import expressions.BigDecimalConstant;
import expressions.Declaration;
import expressions.DeclarationRef;
import expressions.Divide;
import expressions.ExpressionsPackage;
import expressions.Modulo;
import expressions.Multiply;
import expressions.Subtract;
import java.util.Map;
import java.util.Set;
import mathfunctions.AbsExpression;
import mathfunctions.ExpExpression;
import mathfunctions.LogExpression;
import mathfunctions.MathFunctionsPackage;
import mathfunctions.MaxExpression;
import mathfunctions.MinExpression;
import mathfunctions.SqrtExpression;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.lsat.setting.teditor.services.SettingGrammarAccess;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Parameter;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.serializer.ISerializationContext;
import org.eclipse.xtext.serializer.acceptor.SequenceFeeder;
import org.eclipse.xtext.serializer.sequencer.AbstractDelegatingSemanticSequencer;
import org.eclipse.xtext.serializer.sequencer.ITransientValueService.ValueTransient;
import setting.MotionProfileSettings;
import setting.MotionSettings;
import setting.MoveAdjustments;
import setting.PhysicalLocation;
import setting.PhysicalSettings;
import setting.SettingPackage;
import setting.Settings;
import setting.TimeDeclaration;
import timing.Array;
import timing.Scalar;
import timing.TimingPackage;
import trigonometry.AcosExpression;
import trigonometry.AsinExpression;
import trigonometry.Atan2Expression;
import trigonometry.AtanExpression;
import trigonometry.CosExpression;
import trigonometry.PiConstant;
import trigonometry.SinExpression;
import trigonometry.TanExpression;
import trigonometry.TrigonometryPackage;

@SuppressWarnings("all")
public abstract class AbstractSettingSemanticSequencer extends AbstractDelegatingSemanticSequencer {

    @Inject
    private SettingGrammarAccess grammarAccess;

    @Override
    public void sequence(ISerializationContext context, EObject semanticObject) {
        EPackage epackage = semanticObject.eClass().getEPackage();
        ParserRule rule = context.getParserRule();
        Action action = context.getAssignedAction();
        Set<Parameter> parameters = context.getEnabledBooleanParameters();
        if (epackage == CommonPackage.eINSTANCE)
            switch (semanticObject.eClass().getClassifierID()) {
            case CommonPackage.IMPORT:
                sequence_Import(context, (Import) semanticObject); 
                return; 
            }
        else if (epackage == DistributionsPackage.eINSTANCE)
            switch (semanticObject.eClass().getClassifierID()) {
            case DistributionsPackage.ENUMERATED_DISTRIBUTION:
                sequence_EnumeratedDistribution(context, (EnumeratedDistribution) semanticObject); 
                return; 
            case DistributionsPackage.GAMMA_DISTRIBUTION:
                sequence_GammaDistribution(context, (GammaDistribution) semanticObject); 
                return; 
            case DistributionsPackage.LOG_NORMAL_DISTRIBUTION:
                sequence_LogNormalDistribution(context, (LogNormalDistribution) semanticObject); 
                return; 
            case DistributionsPackage.NORMAL_DISTRIBUTION:
                sequence_NormalDistribution(context, (NormalDistribution) semanticObject); 
                return; 
            case DistributionsPackage.PERT_DISTRIBUTION:
                sequence_PertDistribution(context, (PertDistribution) semanticObject); 
                return; 
            case DistributionsPackage.POISSON_DISTRIBUTION:
                sequence_PoissonDistribution(context, (PoissonDistribution) semanticObject); 
                return; 
            case DistributionsPackage.TRIANGULAR_DISTRIBUTION:
                sequence_TriangularDistribution(context, (TriangularDistribution) semanticObject); 
                return; 
            }
        else if (epackage == ExpressionsPackage.eINSTANCE)
            switch (semanticObject.eClass().getClassifierID()) {
            case ExpressionsPackage.ADD:
                sequence_PlusOrMinus(context, (Add) semanticObject); 
                return; 
            case ExpressionsPackage.BIG_DECIMAL_CONSTANT:
                sequence_Atomic(context, (BigDecimalConstant) semanticObject); 
                return; 
            case ExpressionsPackage.DECLARATION:
                sequence_Declaration(context, (Declaration) semanticObject); 
                return; 
            case ExpressionsPackage.DECLARATION_REF:
                sequence_Atomic(context, (DeclarationRef) semanticObject); 
                return; 
            case ExpressionsPackage.DIVIDE:
                sequence_MulOrDivOrMod(context, (Divide) semanticObject); 
                return; 
            case ExpressionsPackage.MODULO:
                sequence_MulOrDivOrMod(context, (Modulo) semanticObject); 
                return; 
            case ExpressionsPackage.MULTIPLY:
                sequence_MulOrDivOrMod(context, (Multiply) semanticObject); 
                return; 
            case ExpressionsPackage.SUBTRACT:
                sequence_PlusOrMinus(context, (Subtract) semanticObject); 
                return; 
            }
        else if (epackage == MathFunctionsPackage.eINSTANCE)
            switch (semanticObject.eClass().getClassifierID()) {
            case MathFunctionsPackage.ABS_EXPRESSION:
                sequence_AbsExpression(context, (AbsExpression) semanticObject); 
                return; 
            case MathFunctionsPackage.EXP_EXPRESSION:
                sequence_ExpExpression(context, (ExpExpression) semanticObject); 
                return; 
            case MathFunctionsPackage.LOG_EXPRESSION:
                sequence_LogExpression(context, (LogExpression) semanticObject); 
                return; 
            case MathFunctionsPackage.MAX_EXPRESSION:
                sequence_MaxExpression(context, (MaxExpression) semanticObject); 
                return; 
            case MathFunctionsPackage.MIN_EXPRESSION:
                sequence_MinExpression(context, (MinExpression) semanticObject); 
                return; 
            case MathFunctionsPackage.SQRT_EXPRESSION:
                sequence_SqrtExpression(context, (SqrtExpression) semanticObject); 
                return; 
            }
        else if (epackage == SettingPackage.eINSTANCE)
            switch (semanticObject.eClass().getClassifierID()) {
            case SettingPackage.DISTANCE_SETTINGS_MAP_ENTRY:
                sequence_DistanceSettingsMapEntry(context, (Map.Entry & EObject) semanticObject); 
                return; 
            case SettingPackage.LOCATION_SETTINGS_MAP_ENTRY:
                sequence_LocationSettingsMapEntry(context, (Map.Entry & EObject) semanticObject); 
                return; 
            case SettingPackage.MOTION_ARGUMENTS_MAP_ENTRY:
                sequence_MotionArgumentsMapEntry(context, (Map.Entry & EObject) semanticObject); 
                return; 
            case SettingPackage.MOTION_PROFILE_SETTINGS:
                sequence_MotionProfileSettings(context, (MotionProfileSettings) semanticObject); 
                return; 
            case SettingPackage.MOTION_SETTINGS:
                sequence_MotionSettings(context, (MotionSettings) semanticObject); 
                return; 
            case SettingPackage.MOTION_SETTINGS_MAP_ENTRY:
                sequence_MotionSettingsMapEntry(context, (Map.Entry & EObject) semanticObject); 
                return; 
            case SettingPackage.MOVE_ADJUSTMENTS:
                sequence_MoveAdjustments(context, (MoveAdjustments) semanticObject); 
                return; 
            case SettingPackage.PHYSICAL_LOCATION:
                sequence_PhysicalLocation(context, (PhysicalLocation) semanticObject); 
                return; 
            case SettingPackage.PHYSICAL_SETTINGS:
                sequence_PhysicalSettings(context, (PhysicalSettings) semanticObject); 
                return; 
            case SettingPackage.PROFILE_SETTINGS_MAP_ENTRY:
                sequence_ProfileSettingsMapEntry(context, (Map.Entry & EObject) semanticObject); 
                return; 
            case SettingPackage.SETTINGS:
                sequence_Settings(context, (Settings) semanticObject); 
                return; 
            case SettingPackage.TIME_DECLARATION:
                sequence_TimeDeclaration(context, (TimeDeclaration) semanticObject); 
                return; 
            case SettingPackage.TIMING_SETTINGS_MAP_ENTRY:
                sequence_TimingSettingsMapEntry(context, (Map.Entry & EObject) semanticObject); 
                return; 
            }
        else if (epackage == TimingPackage.eINSTANCE)
            switch (semanticObject.eClass().getClassifierID()) {
            case TimingPackage.ARRAY:
                sequence_Array(context, (Array) semanticObject); 
                return; 
            case TimingPackage.SCALAR:
                sequence_Scalar(context, (Scalar) semanticObject); 
                return; 
            }
        else if (epackage == TrigonometryPackage.eINSTANCE)
            switch (semanticObject.eClass().getClassifierID()) {
            case TrigonometryPackage.ACOS_EXPRESSION:
                sequence_AcosExpression(context, (AcosExpression) semanticObject); 
                return; 
            case TrigonometryPackage.ASIN_EXPRESSION:
                sequence_AsinExpression(context, (AsinExpression) semanticObject); 
                return; 
            case TrigonometryPackage.ATAN2_EXPRESSION:
                sequence_Atan2Expression(context, (Atan2Expression) semanticObject); 
                return; 
            case TrigonometryPackage.ATAN_EXPRESSION:
                sequence_AtanExpression(context, (AtanExpression) semanticObject); 
                return; 
            case TrigonometryPackage.COS_EXPRESSION:
                sequence_CosExpression(context, (CosExpression) semanticObject); 
                return; 
            case TrigonometryPackage.PI_CONSTANT:
                sequence_PiConstant(context, (PiConstant) semanticObject); 
                return; 
            case TrigonometryPackage.SIN_EXPRESSION:
                sequence_SinExpression(context, (SinExpression) semanticObject); 
                return; 
            case TrigonometryPackage.TAN_EXPRESSION:
                sequence_TanExpression(context, (TanExpression) semanticObject); 
                return; 
            }
        if (errorAcceptor != null)
            errorAcceptor.accept(diagnosticProvider.createInvalidContextOrTypeDiagnostic(semanticObject, context));
    }

    /**
     * <pre>
     * Contexts:
     *     Expression returns AbsExpression
     *     PlusOrMinus returns AbsExpression
     *     PlusOrMinus.Add_1_0_0_0 returns AbsExpression
     *     PlusOrMinus.Subtract_1_0_1_0 returns AbsExpression
     *     MulOrDivOrMod returns AbsExpression
     *     MulOrDivOrMod.Multiply_1_0_0_0 returns AbsExpression
     *     MulOrDivOrMod.Divide_1_0_1_0 returns AbsExpression
     *     MulOrDivOrMod.Modulo_1_0_2_0 returns AbsExpression
     *     Primary returns AbsExpression
     *     MathFunction returns AbsExpression
     *     AbsExpression returns AbsExpression
     *
     * Constraint:
     *     value=Expression
     * </pre>
     */
                protected void sequence_AbsExpression(ISerializationContext context, AbsExpression semanticObject) {
    if (errorAcceptor != null) {
        if (transientValues.isValueTransient(semanticObject, MathFunctionsPackage.Literals.MATH_FUNCTION_ONE_INPUT__VALUE) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, MathFunctionsPackage.Literals.MATH_FUNCTION_ONE_INPUT__VALUE));
    }
    SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
    feeder.accept(grammarAccess.getAbsExpressionAccess().getValueExpressionParserRuleCall_3_0(), semanticObject.getValue());
    feeder.finish();
    }
    

    /**
     * <pre>
     * Contexts:
     *     Expression returns AcosExpression
     *     PlusOrMinus returns AcosExpression
     *     PlusOrMinus.Add_1_0_0_0 returns AcosExpression
     *     PlusOrMinus.Subtract_1_0_1_0 returns AcosExpression
     *     MulOrDivOrMod returns AcosExpression
     *     MulOrDivOrMod.Multiply_1_0_0_0 returns AcosExpression
     *     MulOrDivOrMod.Divide_1_0_1_0 returns AcosExpression
     *     MulOrDivOrMod.Modulo_1_0_2_0 returns AcosExpression
     *     Primary returns AcosExpression
     *     Trigonometry returns AcosExpression
     *     AcosExpression returns AcosExpression
     *
     * Constraint:
     *     value=Expression
     * </pre>
     */
                protected void sequence_AcosExpression(ISerializationContext context, AcosExpression semanticObject) {
    if (errorAcceptor != null) {
        if (transientValues.isValueTransient(semanticObject, TrigonometryPackage.Literals.TRIGONOMETRY_ONE_INPUT__VALUE) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, TrigonometryPackage.Literals.TRIGONOMETRY_ONE_INPUT__VALUE));
    }
    SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
    feeder.accept(grammarAccess.getAcosExpressionAccess().getValueExpressionParserRuleCall_3_0(), semanticObject.getValue());
    feeder.finish();
    }
    

    /**
     * <pre>
     * Contexts:
     *     Timing returns Array
     *     Array returns Array
     *
     * Constraint:
     *     (valuesExp+=Expression valuesExp+=Expression*)
     * </pre>
     */
                protected void sequence_Array(ISerializationContext context, Array semanticObject) {
    genericSequencer.createSequence(context, semanticObject);
    }
    

    /**
     * <pre>
     * Contexts:
     *     Expression returns AsinExpression
     *     PlusOrMinus returns AsinExpression
     *     PlusOrMinus.Add_1_0_0_0 returns AsinExpression
     *     PlusOrMinus.Subtract_1_0_1_0 returns AsinExpression
     *     MulOrDivOrMod returns AsinExpression
     *     MulOrDivOrMod.Multiply_1_0_0_0 returns AsinExpression
     *     MulOrDivOrMod.Divide_1_0_1_0 returns AsinExpression
     *     MulOrDivOrMod.Modulo_1_0_2_0 returns AsinExpression
     *     Primary returns AsinExpression
     *     Trigonometry returns AsinExpression
     *     AsinExpression returns AsinExpression
     *
     * Constraint:
     *     value=Expression
     * </pre>
     */
                protected void sequence_AsinExpression(ISerializationContext context, AsinExpression semanticObject) {
    if (errorAcceptor != null) {
        if (transientValues.isValueTransient(semanticObject, TrigonometryPackage.Literals.TRIGONOMETRY_ONE_INPUT__VALUE) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, TrigonometryPackage.Literals.TRIGONOMETRY_ONE_INPUT__VALUE));
    }
    SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
    feeder.accept(grammarAccess.getAsinExpressionAccess().getValueExpressionParserRuleCall_3_0(), semanticObject.getValue());
    feeder.finish();
    }
    

    /**
     * <pre>
     * Contexts:
     *     Expression returns Atan2Expression
     *     PlusOrMinus returns Atan2Expression
     *     PlusOrMinus.Add_1_0_0_0 returns Atan2Expression
     *     PlusOrMinus.Subtract_1_0_1_0 returns Atan2Expression
     *     MulOrDivOrMod returns Atan2Expression
     *     MulOrDivOrMod.Multiply_1_0_0_0 returns Atan2Expression
     *     MulOrDivOrMod.Divide_1_0_1_0 returns Atan2Expression
     *     MulOrDivOrMod.Modulo_1_0_2_0 returns Atan2Expression
     *     Primary returns Atan2Expression
     *     Trigonometry returns Atan2Expression
     *     Atan2Expression returns Atan2Expression
     *
     * Constraint:
     *     (y=Expression x=Expression)
     * </pre>
     */
                protected void sequence_Atan2Expression(ISerializationContext context, Atan2Expression semanticObject) {
    if (errorAcceptor != null) {
        if (transientValues.isValueTransient(semanticObject, TrigonometryPackage.Literals.TRIGONOMETRY_TWO_INPUTS__Y) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, TrigonometryPackage.Literals.TRIGONOMETRY_TWO_INPUTS__Y));
        if (transientValues.isValueTransient(semanticObject, TrigonometryPackage.Literals.TRIGONOMETRY_TWO_INPUTS__X) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, TrigonometryPackage.Literals.TRIGONOMETRY_TWO_INPUTS__X));
    }
    SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
    feeder.accept(grammarAccess.getAtan2ExpressionAccess().getYExpressionParserRuleCall_3_0(), semanticObject.getY());
    feeder.accept(grammarAccess.getAtan2ExpressionAccess().getXExpressionParserRuleCall_5_0(), semanticObject.getX());
    feeder.finish();
    }
    

    /**
     * <pre>
     * Contexts:
     *     Expression returns AtanExpression
     *     PlusOrMinus returns AtanExpression
     *     PlusOrMinus.Add_1_0_0_0 returns AtanExpression
     *     PlusOrMinus.Subtract_1_0_1_0 returns AtanExpression
     *     MulOrDivOrMod returns AtanExpression
     *     MulOrDivOrMod.Multiply_1_0_0_0 returns AtanExpression
     *     MulOrDivOrMod.Divide_1_0_1_0 returns AtanExpression
     *     MulOrDivOrMod.Modulo_1_0_2_0 returns AtanExpression
     *     Primary returns AtanExpression
     *     Trigonometry returns AtanExpression
     *     AtanExpression returns AtanExpression
     *
     * Constraint:
     *     value=Expression
     * </pre>
     */
                protected void sequence_AtanExpression(ISerializationContext context, AtanExpression semanticObject) {
    if (errorAcceptor != null) {
        if (transientValues.isValueTransient(semanticObject, TrigonometryPackage.Literals.TRIGONOMETRY_ONE_INPUT__VALUE) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, TrigonometryPackage.Literals.TRIGONOMETRY_ONE_INPUT__VALUE));
    }
    SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
    feeder.accept(grammarAccess.getAtanExpressionAccess().getValueExpressionParserRuleCall_3_0(), semanticObject.getValue());
    feeder.finish();
    }
    

    /**
     * <pre>
     * Contexts:
     *     Expression returns BigDecimalConstant
     *     PlusOrMinus returns BigDecimalConstant
     *     PlusOrMinus.Add_1_0_0_0 returns BigDecimalConstant
     *     PlusOrMinus.Subtract_1_0_1_0 returns BigDecimalConstant
     *     MulOrDivOrMod returns BigDecimalConstant
     *     MulOrDivOrMod.Multiply_1_0_0_0 returns BigDecimalConstant
     *     MulOrDivOrMod.Divide_1_0_1_0 returns BigDecimalConstant
     *     MulOrDivOrMod.Modulo_1_0_2_0 returns BigDecimalConstant
     *     Primary returns BigDecimalConstant
     *     Atomic returns BigDecimalConstant
     *
     * Constraint:
     *     value=EBigDecimal
     * </pre>
     */
                protected void sequence_Atomic(ISerializationContext context, BigDecimalConstant semanticObject) {
    if (errorAcceptor != null) {
        if (transientValues.isValueTransient(semanticObject, ExpressionsPackage.Literals.BIG_DECIMAL_CONSTANT__VALUE) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, ExpressionsPackage.Literals.BIG_DECIMAL_CONSTANT__VALUE));
    }
    SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
    feeder.accept(grammarAccess.getAtomicAccess().getValueEBigDecimalParserRuleCall_0_1_0(), semanticObject.getValue());
    feeder.finish();
    }
    

    /**
     * <pre>
     * Contexts:
     *     Expression returns DeclarationRef
     *     PlusOrMinus returns DeclarationRef
     *     PlusOrMinus.Add_1_0_0_0 returns DeclarationRef
     *     PlusOrMinus.Subtract_1_0_1_0 returns DeclarationRef
     *     MulOrDivOrMod returns DeclarationRef
     *     MulOrDivOrMod.Multiply_1_0_0_0 returns DeclarationRef
     *     MulOrDivOrMod.Divide_1_0_1_0 returns DeclarationRef
     *     MulOrDivOrMod.Modulo_1_0_2_0 returns DeclarationRef
     *     Primary returns DeclarationRef
     *     Atomic returns DeclarationRef
     *
     * Constraint:
     *     declaration=[Declaration|ID]
     * </pre>
     */
                protected void sequence_Atomic(ISerializationContext context, DeclarationRef semanticObject) {
    if (errorAcceptor != null) {
        if (transientValues.isValueTransient(semanticObject, ExpressionsPackage.Literals.DECLARATION_REF__DECLARATION) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, ExpressionsPackage.Literals.DECLARATION_REF__DECLARATION));
    }
    SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
    feeder.accept(grammarAccess.getAtomicAccess().getDeclarationDeclarationIDTerminalRuleCall_1_1_0_1(), semanticObject.eGet(ExpressionsPackage.Literals.DECLARATION_REF__DECLARATION, false));
    feeder.finish();
    }
    

    /**
     * <pre>
     * Contexts:
     *     Expression returns CosExpression
     *     PlusOrMinus returns CosExpression
     *     PlusOrMinus.Add_1_0_0_0 returns CosExpression
     *     PlusOrMinus.Subtract_1_0_1_0 returns CosExpression
     *     MulOrDivOrMod returns CosExpression
     *     MulOrDivOrMod.Multiply_1_0_0_0 returns CosExpression
     *     MulOrDivOrMod.Divide_1_0_1_0 returns CosExpression
     *     MulOrDivOrMod.Modulo_1_0_2_0 returns CosExpression
     *     Primary returns CosExpression
     *     Trigonometry returns CosExpression
     *     CosExpression returns CosExpression
     *
     * Constraint:
     *     value=Expression
     * </pre>
     */
                protected void sequence_CosExpression(ISerializationContext context, CosExpression semanticObject) {
    if (errorAcceptor != null) {
        if (transientValues.isValueTransient(semanticObject, TrigonometryPackage.Literals.TRIGONOMETRY_ONE_INPUT__VALUE) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, TrigonometryPackage.Literals.TRIGONOMETRY_ONE_INPUT__VALUE));
    }
    SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
    feeder.accept(grammarAccess.getCosExpressionAccess().getValueExpressionParserRuleCall_3_0(), semanticObject.getValue());
    feeder.finish();
    }
    

    /**
     * <pre>
     * Contexts:
     *     Declaration returns Declaration
     *
     * Constraint:
     *     (name=ID expression=Expression)
     * </pre>
     */
                protected void sequence_Declaration(ISerializationContext context, Declaration semanticObject) {
    if (errorAcceptor != null) {
        if (transientValues.isValueTransient(semanticObject, ExpressionsPackage.Literals.DECLARATION__NAME) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, ExpressionsPackage.Literals.DECLARATION__NAME));
        if (transientValues.isValueTransient(semanticObject, ExpressionsPackage.Literals.DECLARATION__EXPRESSION) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, ExpressionsPackage.Literals.DECLARATION__EXPRESSION));
    }
    SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
    feeder.accept(grammarAccess.getDeclarationAccess().getNameIDTerminalRuleCall_2_0(), semanticObject.getName());
    feeder.accept(grammarAccess.getDeclarationAccess().getExpressionExpressionParserRuleCall_4_0(), semanticObject.getExpression());
    feeder.finish();
    }
    

    /**
     * <pre>
     * Contexts:
     *     DistanceSettingsMapEntry returns DistanceSettingsMapEntry
     *
     * Constraint:
     *     (key=[Distance|ID] value=Expression)
     * </pre>
     */
                protected <T extends Map.Entry & EObject> void sequence_DistanceSettingsMapEntry(ISerializationContext context, T semanticObject) {
    if (errorAcceptor != null) {
        if (transientValues.isValueTransient((EObject) semanticObject, SettingPackage.Literals.DISTANCE_SETTINGS_MAP_ENTRY__KEY) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing((EObject) semanticObject, SettingPackage.Literals.DISTANCE_SETTINGS_MAP_ENTRY__KEY));
        if (transientValues.isValueTransient((EObject) semanticObject, SettingPackage.Literals.DISTANCE_SETTINGS_MAP_ENTRY__VALUE) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing((EObject) semanticObject, SettingPackage.Literals.DISTANCE_SETTINGS_MAP_ENTRY__VALUE));
    }
    SequenceFeeder feeder = createSequencerFeeder(context, (EObject) semanticObject);
    feeder.accept(grammarAccess.getDistanceSettingsMapEntryAccess().getKeyDistanceIDTerminalRuleCall_0_0_1(), semanticObject.eGet(SettingPackage.Literals.DISTANCE_SETTINGS_MAP_ENTRY__KEY, false));
    feeder.accept(grammarAccess.getDistanceSettingsMapEntryAccess().getValueExpressionParserRuleCall_2_0(), semanticObject.getValue());
    feeder.finish();
    }
    

    /**
     * <pre>
     * Contexts:
     *     Expression returns EnumeratedDistribution
     *     PlusOrMinus returns EnumeratedDistribution
     *     PlusOrMinus.Add_1_0_0_0 returns EnumeratedDistribution
     *     PlusOrMinus.Subtract_1_0_1_0 returns EnumeratedDistribution
     *     MulOrDivOrMod returns EnumeratedDistribution
     *     MulOrDivOrMod.Multiply_1_0_0_0 returns EnumeratedDistribution
     *     MulOrDivOrMod.Divide_1_0_1_0 returns EnumeratedDistribution
     *     MulOrDivOrMod.Modulo_1_0_2_0 returns EnumeratedDistribution
     *     Primary returns EnumeratedDistribution
     *     Distribution returns EnumeratedDistribution
     *     EnumeratedDistribution returns EnumeratedDistribution
     *
     * Constraint:
     *     (valuesExp+=Expression valuesExp+=Expression* defaultExp=Expression?)
     * </pre>
     */
                protected void sequence_EnumeratedDistribution(ISerializationContext context, EnumeratedDistribution semanticObject) {
    genericSequencer.createSequence(context, semanticObject);
    }
    

    /**
     * <pre>
     * Contexts:
     *     Expression returns ExpExpression
     *     PlusOrMinus returns ExpExpression
     *     PlusOrMinus.Add_1_0_0_0 returns ExpExpression
     *     PlusOrMinus.Subtract_1_0_1_0 returns ExpExpression
     *     MulOrDivOrMod returns ExpExpression
     *     MulOrDivOrMod.Multiply_1_0_0_0 returns ExpExpression
     *     MulOrDivOrMod.Divide_1_0_1_0 returns ExpExpression
     *     MulOrDivOrMod.Modulo_1_0_2_0 returns ExpExpression
     *     Primary returns ExpExpression
     *     MathFunction returns ExpExpression
     *     ExpExpression returns ExpExpression
     *
     * Constraint:
     *     value=Expression
     * </pre>
     */
                protected void sequence_ExpExpression(ISerializationContext context, ExpExpression semanticObject) {
    if (errorAcceptor != null) {
        if (transientValues.isValueTransient(semanticObject, MathFunctionsPackage.Literals.MATH_FUNCTION_ONE_INPUT__VALUE) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, MathFunctionsPackage.Literals.MATH_FUNCTION_ONE_INPUT__VALUE));
    }
    SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
    feeder.accept(grammarAccess.getExpExpressionAccess().getValueExpressionParserRuleCall_3_0(), semanticObject.getValue());
    feeder.finish();
    }
    

    /**
     * <pre>
     * Contexts:
     *     Expression returns GammaDistribution
     *     PlusOrMinus returns GammaDistribution
     *     PlusOrMinus.Add_1_0_0_0 returns GammaDistribution
     *     PlusOrMinus.Subtract_1_0_1_0 returns GammaDistribution
     *     MulOrDivOrMod returns GammaDistribution
     *     MulOrDivOrMod.Multiply_1_0_0_0 returns GammaDistribution
     *     MulOrDivOrMod.Divide_1_0_1_0 returns GammaDistribution
     *     MulOrDivOrMod.Modulo_1_0_2_0 returns GammaDistribution
     *     Primary returns GammaDistribution
     *     Distribution returns GammaDistribution
     *     GammaDistribution returns GammaDistribution
     *
     * Constraint:
     *     (scaleExp=Expression shapeExp=Expression inverseCumAccuracyExp=Expression? defaultExp=Expression?)
     * </pre>
     */
                protected void sequence_GammaDistribution(ISerializationContext context, GammaDistribution semanticObject) {
    genericSequencer.createSequence(context, semanticObject);
    }
    

    /**
     * <pre>
     * Contexts:
     *     Import returns Import
     *
     * Constraint:
     *     importURI=STRING
     * </pre>
     */
                protected void sequence_Import(ISerializationContext context, Import semanticObject) {
    if (errorAcceptor != null) {
        if (transientValues.isValueTransient(semanticObject, CommonPackage.Literals.IMPORT__IMPORT_URI) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, CommonPackage.Literals.IMPORT__IMPORT_URI));
    }
    SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
    feeder.accept(grammarAccess.getImportAccess().getImportURISTRINGTerminalRuleCall_1_0(), semanticObject.getImportURI());
    feeder.finish();
    }
    

    /**
     * <pre>
     * Contexts:
     *     LocationSettingsMapEntry returns LocationSettingsMapEntry
     *
     * Constraint:
     *     (key=[Position|ID] value=PhysicalLocation)
     * </pre>
     */
                protected <T extends Map.Entry & EObject> void sequence_LocationSettingsMapEntry(ISerializationContext context, T semanticObject) {
    if (errorAcceptor != null) {
        if (transientValues.isValueTransient((EObject) semanticObject, SettingPackage.Literals.LOCATION_SETTINGS_MAP_ENTRY__KEY) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing((EObject) semanticObject, SettingPackage.Literals.LOCATION_SETTINGS_MAP_ENTRY__KEY));
        if (transientValues.isValueTransient((EObject) semanticObject, SettingPackage.Literals.LOCATION_SETTINGS_MAP_ENTRY__VALUE) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing((EObject) semanticObject, SettingPackage.Literals.LOCATION_SETTINGS_MAP_ENTRY__VALUE));
    }
    SequenceFeeder feeder = createSequencerFeeder(context, (EObject) semanticObject);
    feeder.accept(grammarAccess.getLocationSettingsMapEntryAccess().getKeyPositionIDTerminalRuleCall_0_0_1(), semanticObject.eGet(SettingPackage.Literals.LOCATION_SETTINGS_MAP_ENTRY__KEY, false));
    feeder.accept(grammarAccess.getLocationSettingsMapEntryAccess().getValuePhysicalLocationParserRuleCall_1_0(), semanticObject.getValue());
    feeder.finish();
    }
    

    /**
     * <pre>
     * Contexts:
     *     Expression returns LogExpression
     *     PlusOrMinus returns LogExpression
     *     PlusOrMinus.Add_1_0_0_0 returns LogExpression
     *     PlusOrMinus.Subtract_1_0_1_0 returns LogExpression
     *     MulOrDivOrMod returns LogExpression
     *     MulOrDivOrMod.Multiply_1_0_0_0 returns LogExpression
     *     MulOrDivOrMod.Divide_1_0_1_0 returns LogExpression
     *     MulOrDivOrMod.Modulo_1_0_2_0 returns LogExpression
     *     Primary returns LogExpression
     *     MathFunction returns LogExpression
     *     LogExpression returns LogExpression
     *
     * Constraint:
     *     value=Expression
     * </pre>
     */
                protected void sequence_LogExpression(ISerializationContext context, LogExpression semanticObject) {
    if (errorAcceptor != null) {
        if (transientValues.isValueTransient(semanticObject, MathFunctionsPackage.Literals.MATH_FUNCTION_ONE_INPUT__VALUE) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, MathFunctionsPackage.Literals.MATH_FUNCTION_ONE_INPUT__VALUE));
    }
    SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
    feeder.accept(grammarAccess.getLogExpressionAccess().getValueExpressionParserRuleCall_3_0(), semanticObject.getValue());
    feeder.finish();
    }
    

    /**
     * <pre>
     * Contexts:
     *     Expression returns LogNormalDistribution
     *     PlusOrMinus returns LogNormalDistribution
     *     PlusOrMinus.Add_1_0_0_0 returns LogNormalDistribution
     *     PlusOrMinus.Subtract_1_0_1_0 returns LogNormalDistribution
     *     MulOrDivOrMod returns LogNormalDistribution
     *     MulOrDivOrMod.Multiply_1_0_0_0 returns LogNormalDistribution
     *     MulOrDivOrMod.Divide_1_0_1_0 returns LogNormalDistribution
     *     MulOrDivOrMod.Modulo_1_0_2_0 returns LogNormalDistribution
     *     Primary returns LogNormalDistribution
     *     Distribution returns LogNormalDistribution
     *     LogNormalDistribution returns LogNormalDistribution
     *
     * Constraint:
     *     (scaleExp=Expression shapeExp=Expression inverseCumAccuracyExp=Expression? defaultExp=Expression?)
     * </pre>
     */
                protected void sequence_LogNormalDistribution(ISerializationContext context, LogNormalDistribution semanticObject) {
    genericSequencer.createSequence(context, semanticObject);
    }
    

    /**
     * <pre>
     * Contexts:
     *     Expression returns MaxExpression
     *     PlusOrMinus returns MaxExpression
     *     PlusOrMinus.Add_1_0_0_0 returns MaxExpression
     *     PlusOrMinus.Subtract_1_0_1_0 returns MaxExpression
     *     MulOrDivOrMod returns MaxExpression
     *     MulOrDivOrMod.Multiply_1_0_0_0 returns MaxExpression
     *     MulOrDivOrMod.Divide_1_0_1_0 returns MaxExpression
     *     MulOrDivOrMod.Modulo_1_0_2_0 returns MaxExpression
     *     Primary returns MaxExpression
     *     MathFunction returns MaxExpression
     *     MaxExpression returns MaxExpression
     *
     * Constraint:
     *     (a=Expression b=Expression)
     * </pre>
     */
                protected void sequence_MaxExpression(ISerializationContext context, MaxExpression semanticObject) {
    if (errorAcceptor != null) {
        if (transientValues.isValueTransient(semanticObject, MathFunctionsPackage.Literals.MATH_FUNCTION_TWO_INPUTS__A) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, MathFunctionsPackage.Literals.MATH_FUNCTION_TWO_INPUTS__A));
        if (transientValues.isValueTransient(semanticObject, MathFunctionsPackage.Literals.MATH_FUNCTION_TWO_INPUTS__B) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, MathFunctionsPackage.Literals.MATH_FUNCTION_TWO_INPUTS__B));
    }
    SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
    feeder.accept(grammarAccess.getMaxExpressionAccess().getAExpressionParserRuleCall_3_0(), semanticObject.getA());
    feeder.accept(grammarAccess.getMaxExpressionAccess().getBExpressionParserRuleCall_5_0(), semanticObject.getB());
    feeder.finish();
    }
    

    /**
     * <pre>
     * Contexts:
     *     Expression returns MinExpression
     *     PlusOrMinus returns MinExpression
     *     PlusOrMinus.Add_1_0_0_0 returns MinExpression
     *     PlusOrMinus.Subtract_1_0_1_0 returns MinExpression
     *     MulOrDivOrMod returns MinExpression
     *     MulOrDivOrMod.Multiply_1_0_0_0 returns MinExpression
     *     MulOrDivOrMod.Divide_1_0_1_0 returns MinExpression
     *     MulOrDivOrMod.Modulo_1_0_2_0 returns MinExpression
     *     Primary returns MinExpression
     *     MathFunction returns MinExpression
     *     MinExpression returns MinExpression
     *
     * Constraint:
     *     (a=Expression b=Expression)
     * </pre>
     */
                protected void sequence_MinExpression(ISerializationContext context, MinExpression semanticObject) {
    if (errorAcceptor != null) {
        if (transientValues.isValueTransient(semanticObject, MathFunctionsPackage.Literals.MATH_FUNCTION_TWO_INPUTS__A) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, MathFunctionsPackage.Literals.MATH_FUNCTION_TWO_INPUTS__A));
        if (transientValues.isValueTransient(semanticObject, MathFunctionsPackage.Literals.MATH_FUNCTION_TWO_INPUTS__B) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, MathFunctionsPackage.Literals.MATH_FUNCTION_TWO_INPUTS__B));
    }
    SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
    feeder.accept(grammarAccess.getMinExpressionAccess().getAExpressionParserRuleCall_3_0(), semanticObject.getA());
    feeder.accept(grammarAccess.getMinExpressionAccess().getBExpressionParserRuleCall_5_0(), semanticObject.getB());
    feeder.finish();
    }
    

    /**
     * <pre>
     * Contexts:
     *     MotionArgumentsMapEntry returns MotionArgumentsMapEntry
     *
     * Constraint:
     *     (key=ID value=Expression)
     * </pre>
     */
                protected <T extends Map.Entry & EObject> void sequence_MotionArgumentsMapEntry(ISerializationContext context, T semanticObject) {
    if (errorAcceptor != null) {
        if (transientValues.isValueTransient((EObject) semanticObject, SettingPackage.Literals.MOTION_ARGUMENTS_MAP_ENTRY__KEY) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing((EObject) semanticObject, SettingPackage.Literals.MOTION_ARGUMENTS_MAP_ENTRY__KEY));
        if (transientValues.isValueTransient((EObject) semanticObject, SettingPackage.Literals.MOTION_ARGUMENTS_MAP_ENTRY__VALUE) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing((EObject) semanticObject, SettingPackage.Literals.MOTION_ARGUMENTS_MAP_ENTRY__VALUE));
    }
    SequenceFeeder feeder = createSequencerFeeder(context, (EObject) semanticObject);
    feeder.accept(grammarAccess.getMotionArgumentsMapEntryAccess().getKeyIDTerminalRuleCall_0_0(), semanticObject.getKey());
    feeder.accept(grammarAccess.getMotionArgumentsMapEntryAccess().getValueExpressionParserRuleCall_2_0(), semanticObject.getValue());
    feeder.finish();
    }
    

    /**
     * <pre>
     * Contexts:
     *     MotionProfileSettings returns MotionProfileSettings
     *
     * Constraint:
     *     (motionProfile=ID? (motionArguments+=MotionArgumentsMapEntry motionArguments+=MotionArgumentsMapEntry*)?)
     * </pre>
     */
                protected void sequence_MotionProfileSettings(ISerializationContext context, MotionProfileSettings semanticObject) {
    genericSequencer.createSequence(context, semanticObject);
    }
    

    /**
     * <pre>
     * Contexts:
     *     MotionSettingsMapEntry returns MotionSettingsMapEntry
     *
     * Constraint:
     *     (key=[Axis|ID] value=MotionSettings)
     * </pre>
     */
                protected <T extends Map.Entry & EObject> void sequence_MotionSettingsMapEntry(ISerializationContext context, T semanticObject) {
    if (errorAcceptor != null) {
        if (transientValues.isValueTransient((EObject) semanticObject, SettingPackage.Literals.MOTION_SETTINGS_MAP_ENTRY__KEY) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing((EObject) semanticObject, SettingPackage.Literals.MOTION_SETTINGS_MAP_ENTRY__KEY));
        if (transientValues.isValueTransient((EObject) semanticObject, SettingPackage.Literals.MOTION_SETTINGS_MAP_ENTRY__VALUE) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing((EObject) semanticObject, SettingPackage.Literals.MOTION_SETTINGS_MAP_ENTRY__VALUE));
    }
    SequenceFeeder feeder = createSequencerFeeder(context, (EObject) semanticObject);
    feeder.accept(grammarAccess.getMotionSettingsMapEntryAccess().getKeyAxisIDTerminalRuleCall_2_0_1(), semanticObject.eGet(SettingPackage.Literals.MOTION_SETTINGS_MAP_ENTRY__KEY, false));
    feeder.accept(grammarAccess.getMotionSettingsMapEntryAccess().getValueMotionSettingsParserRuleCall_4_0(), semanticObject.getValue());
    feeder.finish();
    }
    

    /**
     * <pre>
     * Contexts:
     *     MotionSettings returns MotionSettings
     *
     * Constraint:
     *     (profileSettings+=ProfileSettingsMapEntry* locationSettings+=LocationSettingsMapEntry* distanceSettings+=DistanceSettingsMapEntry*)
     * </pre>
     */
                protected void sequence_MotionSettings(ISerializationContext context, MotionSettings semanticObject) {
    genericSequencer.createSequence(context, semanticObject);
    }
    

    /**
     * <pre>
     * Contexts:
     *     MoveAdjustments returns MoveAdjustments
     *
     * Constraint:
     *     (timeDeclaration=TimeDeclaration adjustExpression=Expression profile=[Profile|ID]?)
     * </pre>
     */
                protected void sequence_MoveAdjustments(ISerializationContext context, MoveAdjustments semanticObject) {
    genericSequencer.createSequence(context, semanticObject);
    }
    

    /**
     * <pre>
     * Contexts:
     *     Expression returns Divide
     *     PlusOrMinus returns Divide
     *     PlusOrMinus.Add_1_0_0_0 returns Divide
     *     PlusOrMinus.Subtract_1_0_1_0 returns Divide
     *     MulOrDivOrMod returns Divide
     *     MulOrDivOrMod.Multiply_1_0_0_0 returns Divide
     *     MulOrDivOrMod.Divide_1_0_1_0 returns Divide
     *     MulOrDivOrMod.Modulo_1_0_2_0 returns Divide
     *     Primary returns Divide
     *
     * Constraint:
     *     (left=MulOrDivOrMod_Divide_1_0_1_0 right=Primary)
     * </pre>
     */
                protected void sequence_MulOrDivOrMod(ISerializationContext context, Divide semanticObject) {
    if (errorAcceptor != null) {
        if (transientValues.isValueTransient(semanticObject, ExpressionsPackage.Literals.BINARY_EXPRESSION__LEFT) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, ExpressionsPackage.Literals.BINARY_EXPRESSION__LEFT));
        if (transientValues.isValueTransient(semanticObject, ExpressionsPackage.Literals.BINARY_EXPRESSION__RIGHT) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, ExpressionsPackage.Literals.BINARY_EXPRESSION__RIGHT));
    }
    SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
    feeder.accept(grammarAccess.getMulOrDivOrModAccess().getDivideLeftAction_1_0_1_0(), semanticObject.getLeft());
    feeder.accept(grammarAccess.getMulOrDivOrModAccess().getRightPrimaryParserRuleCall_1_1_0(), semanticObject.getRight());
    feeder.finish();
    }
    

    /**
     * <pre>
     * Contexts:
     *     Expression returns Modulo
     *     PlusOrMinus returns Modulo
     *     PlusOrMinus.Add_1_0_0_0 returns Modulo
     *     PlusOrMinus.Subtract_1_0_1_0 returns Modulo
     *     MulOrDivOrMod returns Modulo
     *     MulOrDivOrMod.Multiply_1_0_0_0 returns Modulo
     *     MulOrDivOrMod.Divide_1_0_1_0 returns Modulo
     *     MulOrDivOrMod.Modulo_1_0_2_0 returns Modulo
     *     Primary returns Modulo
     *
     * Constraint:
     *     (left=MulOrDivOrMod_Modulo_1_0_2_0 right=Primary)
     * </pre>
     */
                protected void sequence_MulOrDivOrMod(ISerializationContext context, Modulo semanticObject) {
    if (errorAcceptor != null) {
        if (transientValues.isValueTransient(semanticObject, ExpressionsPackage.Literals.BINARY_EXPRESSION__LEFT) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, ExpressionsPackage.Literals.BINARY_EXPRESSION__LEFT));
        if (transientValues.isValueTransient(semanticObject, ExpressionsPackage.Literals.BINARY_EXPRESSION__RIGHT) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, ExpressionsPackage.Literals.BINARY_EXPRESSION__RIGHT));
    }
    SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
    feeder.accept(grammarAccess.getMulOrDivOrModAccess().getModuloLeftAction_1_0_2_0(), semanticObject.getLeft());
    feeder.accept(grammarAccess.getMulOrDivOrModAccess().getRightPrimaryParserRuleCall_1_1_0(), semanticObject.getRight());
    feeder.finish();
    }
    

    /**
     * <pre>
     * Contexts:
     *     Expression returns Multiply
     *     PlusOrMinus returns Multiply
     *     PlusOrMinus.Add_1_0_0_0 returns Multiply
     *     PlusOrMinus.Subtract_1_0_1_0 returns Multiply
     *     MulOrDivOrMod returns Multiply
     *     MulOrDivOrMod.Multiply_1_0_0_0 returns Multiply
     *     MulOrDivOrMod.Divide_1_0_1_0 returns Multiply
     *     MulOrDivOrMod.Modulo_1_0_2_0 returns Multiply
     *     Primary returns Multiply
     *
     * Constraint:
     *     (left=MulOrDivOrMod_Multiply_1_0_0_0 right=Primary)
     * </pre>
     */
                protected void sequence_MulOrDivOrMod(ISerializationContext context, Multiply semanticObject) {
    if (errorAcceptor != null) {
        if (transientValues.isValueTransient(semanticObject, ExpressionsPackage.Literals.BINARY_EXPRESSION__LEFT) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, ExpressionsPackage.Literals.BINARY_EXPRESSION__LEFT));
        if (transientValues.isValueTransient(semanticObject, ExpressionsPackage.Literals.BINARY_EXPRESSION__RIGHT) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, ExpressionsPackage.Literals.BINARY_EXPRESSION__RIGHT));
    }
    SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
    feeder.accept(grammarAccess.getMulOrDivOrModAccess().getMultiplyLeftAction_1_0_0_0(), semanticObject.getLeft());
    feeder.accept(grammarAccess.getMulOrDivOrModAccess().getRightPrimaryParserRuleCall_1_1_0(), semanticObject.getRight());
    feeder.finish();
    }
    

    /**
     * <pre>
     * Contexts:
     *     Expression returns NormalDistribution
     *     PlusOrMinus returns NormalDistribution
     *     PlusOrMinus.Add_1_0_0_0 returns NormalDistribution
     *     PlusOrMinus.Subtract_1_0_1_0 returns NormalDistribution
     *     MulOrDivOrMod returns NormalDistribution
     *     MulOrDivOrMod.Multiply_1_0_0_0 returns NormalDistribution
     *     MulOrDivOrMod.Divide_1_0_1_0 returns NormalDistribution
     *     MulOrDivOrMod.Modulo_1_0_2_0 returns NormalDistribution
     *     Primary returns NormalDistribution
     *     Distribution returns NormalDistribution
     *     NormalDistribution returns NormalDistribution
     *
     * Constraint:
     *     (meanExp=Expression sdExp=Expression defaultExp=Expression?)
     * </pre>
     */
                protected void sequence_NormalDistribution(ISerializationContext context, NormalDistribution semanticObject) {
    genericSequencer.createSequence(context, semanticObject);
    }
    

    /**
     * <pre>
     * Contexts:
     *     Expression returns PertDistribution
     *     PlusOrMinus returns PertDistribution
     *     PlusOrMinus.Add_1_0_0_0 returns PertDistribution
     *     PlusOrMinus.Subtract_1_0_1_0 returns PertDistribution
     *     MulOrDivOrMod returns PertDistribution
     *     MulOrDivOrMod.Multiply_1_0_0_0 returns PertDistribution
     *     MulOrDivOrMod.Divide_1_0_1_0 returns PertDistribution
     *     MulOrDivOrMod.Modulo_1_0_2_0 returns PertDistribution
     *     Primary returns PertDistribution
     *     Distribution returns PertDistribution
     *     PertDistribution returns PertDistribution
     *
     * Constraint:
     *     (minExp=Expression maxExp=Expression modeExp=Expression gammaExp=Expression defaultExp=Expression?)
     * </pre>
     */
                protected void sequence_PertDistribution(ISerializationContext context, PertDistribution semanticObject) {
    genericSequencer.createSequence(context, semanticObject);
    }
    

    /**
     * <pre>
     * Contexts:
     *     PhysicalLocation returns PhysicalLocation
     *
     * Constraint:
     *     (defaultExp=Expression | (minExp=Expression? maxExp=Expression? defaultExp=Expression))
     * </pre>
     */
                protected void sequence_PhysicalLocation(ISerializationContext context, PhysicalLocation semanticObject) {
    genericSequencer.createSequence(context, semanticObject);
    }
    

    /**
     * <pre>
     * Contexts:
     *     PhysicalSettings returns PhysicalSettings
     *
     * Constraint:
     *     (
     *         resource=[IResource|ResourceQualifiedName] 
     *         peripheral=[Peripheral|IID] 
     *         timingSettings+=TimingSettingsMapEntry* 
     *         motionSettings+=MotionSettingsMapEntry* 
     *         moveAdjustments+=MoveAdjustments*
     *     )
     * </pre>
     */
                protected void sequence_PhysicalSettings(ISerializationContext context, PhysicalSettings semanticObject) {
    genericSequencer.createSequence(context, semanticObject);
    }
    

    /**
     * <pre>
     * Contexts:
     *     Expression returns PiConstant
     *     PlusOrMinus returns PiConstant
     *     PlusOrMinus.Add_1_0_0_0 returns PiConstant
     *     PlusOrMinus.Subtract_1_0_1_0 returns PiConstant
     *     MulOrDivOrMod returns PiConstant
     *     MulOrDivOrMod.Multiply_1_0_0_0 returns PiConstant
     *     MulOrDivOrMod.Divide_1_0_1_0 returns PiConstant
     *     MulOrDivOrMod.Modulo_1_0_2_0 returns PiConstant
     *     Primary returns PiConstant
     *     Trigonometry returns PiConstant
     *     PiConstant returns PiConstant
     *
     * Constraint:
     *     {PiConstant}
     * </pre>
     */
                protected void sequence_PiConstant(ISerializationContext context, PiConstant semanticObject) {
    genericSequencer.createSequence(context, semanticObject);
    }
    

    /**
     * <pre>
     * Contexts:
     *     Expression returns Add
     *     PlusOrMinus returns Add
     *     PlusOrMinus.Add_1_0_0_0 returns Add
     *     PlusOrMinus.Subtract_1_0_1_0 returns Add
     *     MulOrDivOrMod returns Add
     *     MulOrDivOrMod.Multiply_1_0_0_0 returns Add
     *     MulOrDivOrMod.Divide_1_0_1_0 returns Add
     *     MulOrDivOrMod.Modulo_1_0_2_0 returns Add
     *     Primary returns Add
     *
     * Constraint:
     *     (left=PlusOrMinus_Add_1_0_0_0 right=MulOrDivOrMod)
     * </pre>
     */
                protected void sequence_PlusOrMinus(ISerializationContext context, Add semanticObject) {
    if (errorAcceptor != null) {
        if (transientValues.isValueTransient(semanticObject, ExpressionsPackage.Literals.BINARY_EXPRESSION__LEFT) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, ExpressionsPackage.Literals.BINARY_EXPRESSION__LEFT));
        if (transientValues.isValueTransient(semanticObject, ExpressionsPackage.Literals.BINARY_EXPRESSION__RIGHT) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, ExpressionsPackage.Literals.BINARY_EXPRESSION__RIGHT));
    }
    SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
    feeder.accept(grammarAccess.getPlusOrMinusAccess().getAddLeftAction_1_0_0_0(), semanticObject.getLeft());
    feeder.accept(grammarAccess.getPlusOrMinusAccess().getRightMulOrDivOrModParserRuleCall_1_1_0(), semanticObject.getRight());
    feeder.finish();
    }
    

    /**
     * <pre>
     * Contexts:
     *     Expression returns Subtract
     *     PlusOrMinus returns Subtract
     *     PlusOrMinus.Add_1_0_0_0 returns Subtract
     *     PlusOrMinus.Subtract_1_0_1_0 returns Subtract
     *     MulOrDivOrMod returns Subtract
     *     MulOrDivOrMod.Multiply_1_0_0_0 returns Subtract
     *     MulOrDivOrMod.Divide_1_0_1_0 returns Subtract
     *     MulOrDivOrMod.Modulo_1_0_2_0 returns Subtract
     *     Primary returns Subtract
     *
     * Constraint:
     *     (left=PlusOrMinus_Subtract_1_0_1_0 right=MulOrDivOrMod)
     * </pre>
     */
                protected void sequence_PlusOrMinus(ISerializationContext context, Subtract semanticObject) {
    if (errorAcceptor != null) {
        if (transientValues.isValueTransient(semanticObject, ExpressionsPackage.Literals.BINARY_EXPRESSION__LEFT) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, ExpressionsPackage.Literals.BINARY_EXPRESSION__LEFT));
        if (transientValues.isValueTransient(semanticObject, ExpressionsPackage.Literals.BINARY_EXPRESSION__RIGHT) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, ExpressionsPackage.Literals.BINARY_EXPRESSION__RIGHT));
    }
    SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
    feeder.accept(grammarAccess.getPlusOrMinusAccess().getSubtractLeftAction_1_0_1_0(), semanticObject.getLeft());
    feeder.accept(grammarAccess.getPlusOrMinusAccess().getRightMulOrDivOrModParserRuleCall_1_1_0(), semanticObject.getRight());
    feeder.finish();
    }
    

    /**
     * <pre>
     * Contexts:
     *     Expression returns PoissonDistribution
     *     PlusOrMinus returns PoissonDistribution
     *     PlusOrMinus.Add_1_0_0_0 returns PoissonDistribution
     *     PlusOrMinus.Subtract_1_0_1_0 returns PoissonDistribution
     *     MulOrDivOrMod returns PoissonDistribution
     *     MulOrDivOrMod.Multiply_1_0_0_0 returns PoissonDistribution
     *     MulOrDivOrMod.Divide_1_0_1_0 returns PoissonDistribution
     *     MulOrDivOrMod.Modulo_1_0_2_0 returns PoissonDistribution
     *     Primary returns PoissonDistribution
     *     Distribution returns PoissonDistribution
     *     PoissonDistribution returns PoissonDistribution
     *
     * Constraint:
     *     (pExp=Expression epsilonExp=Expression? defaultExp=Expression?)
     * </pre>
     */
                protected void sequence_PoissonDistribution(ISerializationContext context, PoissonDistribution semanticObject) {
    genericSequencer.createSequence(context, semanticObject);
    }
    

    /**
     * <pre>
     * Contexts:
     *     ProfileSettingsMapEntry returns ProfileSettingsMapEntry
     *
     * Constraint:
     *     (key=[Profile|ID] value=MotionProfileSettings)
     * </pre>
     */
                protected <T extends Map.Entry & EObject> void sequence_ProfileSettingsMapEntry(ISerializationContext context, T semanticObject) {
    if (errorAcceptor != null) {
        if (transientValues.isValueTransient((EObject) semanticObject, SettingPackage.Literals.PROFILE_SETTINGS_MAP_ENTRY__KEY) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing((EObject) semanticObject, SettingPackage.Literals.PROFILE_SETTINGS_MAP_ENTRY__KEY));
        if (transientValues.isValueTransient((EObject) semanticObject, SettingPackage.Literals.PROFILE_SETTINGS_MAP_ENTRY__VALUE) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing((EObject) semanticObject, SettingPackage.Literals.PROFILE_SETTINGS_MAP_ENTRY__VALUE));
    }
    SequenceFeeder feeder = createSequencerFeeder(context, (EObject) semanticObject);
    feeder.accept(grammarAccess.getProfileSettingsMapEntryAccess().getKeyProfileIDTerminalRuleCall_0_0_1(), semanticObject.eGet(SettingPackage.Literals.PROFILE_SETTINGS_MAP_ENTRY__KEY, false));
    feeder.accept(grammarAccess.getProfileSettingsMapEntryAccess().getValueMotionProfileSettingsParserRuleCall_1_0(), semanticObject.getValue());
    feeder.finish();
    }
    

    /**
     * <pre>
     * Contexts:
     *     Timing returns Scalar
     *     Scalar returns Scalar
     *
     * Constraint:
     *     valueExp=Expression
     * </pre>
     */
                protected void sequence_Scalar(ISerializationContext context, Scalar semanticObject) {
    if (errorAcceptor != null) {
        if (transientValues.isValueTransient(semanticObject, TimingPackage.Literals.SCALAR__VALUE_EXP) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, TimingPackage.Literals.SCALAR__VALUE_EXP));
    }
    SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
    feeder.accept(grammarAccess.getScalarAccess().getValueExpExpressionParserRuleCall_0(), semanticObject.getValueExp());
    feeder.finish();
    }
    

    /**
     * <pre>
     * Contexts:
     *     Settings returns Settings
     *
     * Constraint:
     *     (imports+=Import* declarations+=Declaration* physicalSettings+=PhysicalSettings*)
     * </pre>
     */
                protected void sequence_Settings(ISerializationContext context, Settings semanticObject) {
    genericSequencer.createSequence(context, semanticObject);
    }
    

    /**
     * <pre>
     * Contexts:
     *     Expression returns SinExpression
     *     PlusOrMinus returns SinExpression
     *     PlusOrMinus.Add_1_0_0_0 returns SinExpression
     *     PlusOrMinus.Subtract_1_0_1_0 returns SinExpression
     *     MulOrDivOrMod returns SinExpression
     *     MulOrDivOrMod.Multiply_1_0_0_0 returns SinExpression
     *     MulOrDivOrMod.Divide_1_0_1_0 returns SinExpression
     *     MulOrDivOrMod.Modulo_1_0_2_0 returns SinExpression
     *     Primary returns SinExpression
     *     Trigonometry returns SinExpression
     *     SinExpression returns SinExpression
     *
     * Constraint:
     *     value=Expression
     * </pre>
     */
                protected void sequence_SinExpression(ISerializationContext context, SinExpression semanticObject) {
    if (errorAcceptor != null) {
        if (transientValues.isValueTransient(semanticObject, TrigonometryPackage.Literals.TRIGONOMETRY_ONE_INPUT__VALUE) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, TrigonometryPackage.Literals.TRIGONOMETRY_ONE_INPUT__VALUE));
    }
    SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
    feeder.accept(grammarAccess.getSinExpressionAccess().getValueExpressionParserRuleCall_3_0(), semanticObject.getValue());
    feeder.finish();
    }
    

    /**
     * <pre>
     * Contexts:
     *     Expression returns SqrtExpression
     *     PlusOrMinus returns SqrtExpression
     *     PlusOrMinus.Add_1_0_0_0 returns SqrtExpression
     *     PlusOrMinus.Subtract_1_0_1_0 returns SqrtExpression
     *     MulOrDivOrMod returns SqrtExpression
     *     MulOrDivOrMod.Multiply_1_0_0_0 returns SqrtExpression
     *     MulOrDivOrMod.Divide_1_0_1_0 returns SqrtExpression
     *     MulOrDivOrMod.Modulo_1_0_2_0 returns SqrtExpression
     *     Primary returns SqrtExpression
     *     MathFunction returns SqrtExpression
     *     SqrtExpression returns SqrtExpression
     *
     * Constraint:
     *     value=Expression
     * </pre>
     */
                protected void sequence_SqrtExpression(ISerializationContext context, SqrtExpression semanticObject) {
    if (errorAcceptor != null) {
        if (transientValues.isValueTransient(semanticObject, MathFunctionsPackage.Literals.MATH_FUNCTION_ONE_INPUT__VALUE) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, MathFunctionsPackage.Literals.MATH_FUNCTION_ONE_INPUT__VALUE));
    }
    SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
    feeder.accept(grammarAccess.getSqrtExpressionAccess().getValueExpressionParserRuleCall_3_0(), semanticObject.getValue());
    feeder.finish();
    }
    

    /**
     * <pre>
     * Contexts:
     *     Expression returns TanExpression
     *     PlusOrMinus returns TanExpression
     *     PlusOrMinus.Add_1_0_0_0 returns TanExpression
     *     PlusOrMinus.Subtract_1_0_1_0 returns TanExpression
     *     MulOrDivOrMod returns TanExpression
     *     MulOrDivOrMod.Multiply_1_0_0_0 returns TanExpression
     *     MulOrDivOrMod.Divide_1_0_1_0 returns TanExpression
     *     MulOrDivOrMod.Modulo_1_0_2_0 returns TanExpression
     *     Primary returns TanExpression
     *     Trigonometry returns TanExpression
     *     TanExpression returns TanExpression
     *
     * Constraint:
     *     value=Expression
     * </pre>
     */
                protected void sequence_TanExpression(ISerializationContext context, TanExpression semanticObject) {
    if (errorAcceptor != null) {
        if (transientValues.isValueTransient(semanticObject, TrigonometryPackage.Literals.TRIGONOMETRY_ONE_INPUT__VALUE) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, TrigonometryPackage.Literals.TRIGONOMETRY_ONE_INPUT__VALUE));
    }
    SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
    feeder.accept(grammarAccess.getTanExpressionAccess().getValueExpressionParserRuleCall_3_0(), semanticObject.getValue());
    feeder.finish();
    }
    

    /**
     * <pre>
     * Contexts:
     *     TimeDeclaration returns TimeDeclaration
     *
     * Constraint:
     *     name=ID
     * </pre>
     */
                protected void sequence_TimeDeclaration(ISerializationContext context, TimeDeclaration semanticObject) {
    if (errorAcceptor != null) {
        if (transientValues.isValueTransient(semanticObject, ExpressionsPackage.Literals.DECLARATION__NAME) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, ExpressionsPackage.Literals.DECLARATION__NAME));
    }
    SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
    feeder.accept(grammarAccess.getTimeDeclarationAccess().getNameIDTerminalRuleCall_0(), semanticObject.getName());
    feeder.finish();
    }
    

    /**
     * <pre>
     * Contexts:
     *     TimingSettingsMapEntry returns TimingSettingsMapEntry
     *
     * Constraint:
     *     (key=[ActionType|ID] value=Timing)
     * </pre>
     */
                protected <T extends Map.Entry & EObject> void sequence_TimingSettingsMapEntry(ISerializationContext context, T semanticObject) {
    if (errorAcceptor != null) {
        if (transientValues.isValueTransient((EObject) semanticObject, SettingPackage.Literals.TIMING_SETTINGS_MAP_ENTRY__KEY) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing((EObject) semanticObject, SettingPackage.Literals.TIMING_SETTINGS_MAP_ENTRY__KEY));
        if (transientValues.isValueTransient((EObject) semanticObject, SettingPackage.Literals.TIMING_SETTINGS_MAP_ENTRY__VALUE) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing((EObject) semanticObject, SettingPackage.Literals.TIMING_SETTINGS_MAP_ENTRY__VALUE));
    }
    SequenceFeeder feeder = createSequencerFeeder(context, (EObject) semanticObject);
    feeder.accept(grammarAccess.getTimingSettingsMapEntryAccess().getKeyActionTypeIDTerminalRuleCall_0_0_1(), semanticObject.eGet(SettingPackage.Literals.TIMING_SETTINGS_MAP_ENTRY__KEY, false));
    feeder.accept(grammarAccess.getTimingSettingsMapEntryAccess().getValueTimingParserRuleCall_2_0(), semanticObject.getValue());
    feeder.finish();
    }
    

    /**
     * <pre>
     * Contexts:
     *     Expression returns TriangularDistribution
     *     PlusOrMinus returns TriangularDistribution
     *     PlusOrMinus.Add_1_0_0_0 returns TriangularDistribution
     *     PlusOrMinus.Subtract_1_0_1_0 returns TriangularDistribution
     *     MulOrDivOrMod returns TriangularDistribution
     *     MulOrDivOrMod.Multiply_1_0_0_0 returns TriangularDistribution
     *     MulOrDivOrMod.Divide_1_0_1_0 returns TriangularDistribution
     *     MulOrDivOrMod.Modulo_1_0_2_0 returns TriangularDistribution
     *     Primary returns TriangularDistribution
     *     Distribution returns TriangularDistribution
     *     TriangularDistribution returns TriangularDistribution
     *
     * Constraint:
     *     (minExp=Expression maxExp=Expression modeExp=Expression defaultExp=Expression?)
     * </pre>
     */
                protected void sequence_TriangularDistribution(ISerializationContext context, TriangularDistribution semanticObject) {
    genericSequencer.createSequence(context, semanticObject);
    }
    

}
