/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.edit;

import java.io.File;
import java.net.URI;
import java.util.List;
import java.util.function.Predicate;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.test.AllCleanRule;
import org.eclipse.lsp4e.test.TestUtils;
import org.eclipse.lsp4e.tests.mock.MockLanguageServer;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.TextDocumentContentChangeEvent;
import org.eclipse.lsp4j.TextDocumentSyncKind;
import org.eclipse.lsp4j.TextDocumentSyncOptions;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class DocumentDidChangeTest {
    @Rule
    public AllCleanRule clear = new AllCleanRule();
    private IProject project;

    @Before
    public void setUp() throws CoreException {
        this.project = TestUtils.createProject("DocumentDidChangeTest" + System.currentTimeMillis());
    }

    @Test
    public void testIncrementalSync() throws Exception {
        MockLanguageServer.INSTANCE.getInitializeResult().getCapabilities().setTextDocumentSync(TextDocumentSyncKind.Incremental);
        IFile testFile = TestUtils.createUniqueTestFile(this.project, "");
        IEditorPart editor = TestUtils.openEditor(testFile);
        ITextViewer viewer = TestUtils.getTextViewer(editor);
        LanguageServiceAccessor.getLanguageServers((IDocument)viewer.getDocument(), (Predicate)new Predicate<ServerCapabilities>(){

            @Override
            public boolean test(ServerCapabilities t) {
                TextDocumentSyncKind syncKind = DocumentDidChangeTest.this.getDocumentSyncKind(t);
                Assert.assertEquals((Object)TextDocumentSyncKind.Incremental, (Object)syncKind);
                return true;
            }
        });
        viewer.getDocument().replace(0, 0, "Hello");
        TestUtils.waitForCondition(1000, TestUtils.numberOfChangesIs(1));
        DidChangeTextDocumentParams lastChange = (DidChangeTextDocumentParams)MockLanguageServer.INSTANCE.getDidChangeEvents().get(0);
        Assert.assertNotNull((Object)lastChange.getContentChanges());
        Assert.assertEquals((long)1L, (long)lastChange.getContentChanges().size());
        TextDocumentContentChangeEvent change0 = (TextDocumentContentChangeEvent)lastChange.getContentChanges().get(0);
        Range range = change0.getRange();
        Assert.assertNotNull((Object)range);
        Assert.assertEquals((long)0L, (long)range.getStart().getLine());
        Assert.assertEquals((long)0L, (long)range.getStart().getCharacter());
        Assert.assertEquals((long)0L, (long)range.getEnd().getLine());
        Assert.assertEquals((long)0L, (long)range.getEnd().getCharacter());
        Assert.assertEquals((Object)0, (Object)change0.getRangeLength());
        Assert.assertEquals((Object)"Hello", (Object)change0.getText());
        viewer.getDocument().replace(5, 0, " ");
        TestUtils.waitForCondition(1000, TestUtils.numberOfChangesIs(2));
        lastChange = (DidChangeTextDocumentParams)MockLanguageServer.INSTANCE.getDidChangeEvents().get(1);
        Assert.assertNotNull((Object)lastChange.getContentChanges());
        Assert.assertEquals((long)1L, (long)lastChange.getContentChanges().size());
        change0 = (TextDocumentContentChangeEvent)lastChange.getContentChanges().get(0);
        range = change0.getRange();
        Assert.assertNotNull((Object)range);
        Assert.assertEquals((long)0L, (long)range.getStart().getLine());
        Assert.assertEquals((long)5L, (long)range.getStart().getCharacter());
        Assert.assertEquals((long)0L, (long)range.getEnd().getLine());
        Assert.assertEquals((long)5L, (long)range.getEnd().getCharacter());
        Assert.assertEquals((Object)0, (Object)change0.getRangeLength());
        Assert.assertEquals((Object)" ", (Object)change0.getText());
        viewer.getDocument().replace(0, 5, "Hallo");
        TestUtils.waitForCondition(1000, TestUtils.numberOfChangesIs(3));
        lastChange = (DidChangeTextDocumentParams)MockLanguageServer.INSTANCE.getDidChangeEvents().get(2);
        Assert.assertNotNull((Object)lastChange.getContentChanges());
        Assert.assertEquals((long)1L, (long)lastChange.getContentChanges().size());
        change0 = (TextDocumentContentChangeEvent)lastChange.getContentChanges().get(0);
        range = change0.getRange();
        Assert.assertNotNull((Object)range);
        Assert.assertEquals((long)0L, (long)range.getStart().getLine());
        Assert.assertEquals((long)0L, (long)range.getStart().getCharacter());
        Assert.assertEquals((long)0L, (long)range.getEnd().getLine());
        Assert.assertEquals((long)5L, (long)range.getEnd().getCharacter());
        Assert.assertEquals((Object)5, (Object)change0.getRangeLength());
        Assert.assertEquals((Object)"Hallo", (Object)change0.getText());
    }

    @Test
    public void testIncrementalSync_deleteLastLine() throws Exception {
        MockLanguageServer.INSTANCE.getInitializeResult().getCapabilities().setTextDocumentSync(TextDocumentSyncKind.Incremental);
        String multiLineText = "line1\nline2\nline3\n";
        IFile testFile = TestUtils.createUniqueTestFile(this.project, multiLineText);
        IEditorPart editor = TestUtils.openEditor(testFile);
        ITextViewer viewer = TestUtils.getTextViewer(editor);
        LanguageServiceAccessor.getLanguageServers((IDocument)viewer.getDocument(), (Predicate)new Predicate<ServerCapabilities>(){

            @Override
            public boolean test(ServerCapabilities t) {
                Assert.assertEquals((Object)TextDocumentSyncKind.Incremental, (Object)DocumentDidChangeTest.this.getDocumentSyncKind(t));
                return true;
            }
        });
        viewer.getDocument().replace("line1\nline2\n".length(), "line3\n".length(), "");
        TestUtils.waitForCondition(1000, TestUtils.numberOfChangesIs(1));
        DidChangeTextDocumentParams lastChange = (DidChangeTextDocumentParams)MockLanguageServer.INSTANCE.getDidChangeEvents().get(0);
        Assert.assertNotNull((Object)lastChange.getContentChanges());
        Assert.assertEquals((long)1L, (long)lastChange.getContentChanges().size());
        TextDocumentContentChangeEvent change0 = (TextDocumentContentChangeEvent)lastChange.getContentChanges().get(0);
        Range range = change0.getRange();
        Assert.assertNotNull((Object)range);
        Assert.assertEquals((long)2L, (long)range.getStart().getLine());
        Assert.assertEquals((long)0L, (long)range.getStart().getCharacter());
        Assert.assertEquals((long)3L, (long)range.getEnd().getLine());
        Assert.assertEquals((long)0L, (long)range.getEnd().getCharacter());
        Assert.assertEquals((Object)6, (Object)change0.getRangeLength());
        Assert.assertEquals((Object)"", (Object)change0.getText());
    }

    @Test
    public void testIncrementalEditOrdering() throws Exception {
        MockLanguageServer.INSTANCE.getInitializeResult().getCapabilities().setTextDocumentSync(TextDocumentSyncKind.Incremental);
        IFile testFile = TestUtils.createUniqueTestFile(this.project, "");
        IEditorPart editor = TestUtils.openEditor(testFile);
        ITextViewer viewer = TestUtils.getTextViewer(editor);
        StyledText text = viewer.getTextWidget();
        int i = 0;
        while (i < 500) {
            text.append(String.valueOf(i) + "\n");
            ++i;
        }
        TestUtils.waitForCondition(10000, TestUtils.numberOfChangesIs(500));
        List changes = MockLanguageServer.INSTANCE.getDidChangeEvents();
        int i2 = 0;
        while (i2 < 500) {
            String delta = ((TextDocumentContentChangeEvent)((DidChangeTextDocumentParams)changes.get(i2)).getContentChanges().get(0)).getText();
            Assert.assertEquals((Object)(String.valueOf(i2) + "\n"), (Object)delta);
            ++i2;
        }
    }

    @Test
    public void testFullSync() throws Exception {
        MockLanguageServer.INSTANCE.getInitializeResult().getCapabilities().setTextDocumentSync(TextDocumentSyncKind.Full);
        IFile testFile = TestUtils.createUniqueTestFile(this.project, "");
        IEditorPart editor = TestUtils.openEditor(testFile);
        ITextViewer viewer = TestUtils.getTextViewer(editor);
        LanguageServiceAccessor.getLanguageServers((IDocument)viewer.getDocument(), (Predicate)new Predicate<ServerCapabilities>(){

            @Override
            public boolean test(ServerCapabilities t) {
                Assert.assertEquals((Object)TextDocumentSyncKind.Full, (Object)DocumentDidChangeTest.this.getDocumentSyncKind(t));
                return true;
            }
        });
        String text = "Hello";
        viewer.getDocument().replace(0, 0, text);
        TestUtils.waitForCondition(1000, TestUtils.numberOfChangesIs(1));
        DidChangeTextDocumentParams lastChange = (DidChangeTextDocumentParams)MockLanguageServer.INSTANCE.getDidChangeEvents().get(0);
        Assert.assertNotNull((Object)lastChange.getContentChanges());
        Assert.assertEquals((long)1L, (long)lastChange.getContentChanges().size());
        TextDocumentContentChangeEvent change0 = (TextDocumentContentChangeEvent)lastChange.getContentChanges().get(0);
        Assert.assertEquals((Object)text, (Object)change0.getText());
        viewer.getDocument().replace(5, 0, " World");
        TestUtils.waitForCondition(1000, TestUtils.numberOfChangesIs(2));
        lastChange = (DidChangeTextDocumentParams)MockLanguageServer.INSTANCE.getDidChangeEvents().get(1);
        Assert.assertNotNull((Object)lastChange.getContentChanges());
        Assert.assertEquals((long)1L, (long)lastChange.getContentChanges().size());
        change0 = (TextDocumentContentChangeEvent)lastChange.getContentChanges().get(0);
        Assert.assertEquals((Object)"Hello World", (Object)change0.getText());
    }

    @Test
    public void testFullSyncExternalFile() throws Exception {
        MockLanguageServer.INSTANCE.getInitializeResult().getCapabilities().setTextDocumentSync(TextDocumentSyncKind.Full);
        File file = TestUtils.createTempFile("testFullSyncExternalFile", ".lspt");
        IEditorPart editor = IDE.openEditorOnFileStore((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFileStore)EFS.getStore((URI)file.toURI()));
        ITextViewer viewer = TestUtils.getTextViewer(editor);
        LanguageServiceAccessor.getLanguageServers((IDocument)viewer.getDocument(), (Predicate)new Predicate<ServerCapabilities>(){

            @Override
            public boolean test(ServerCapabilities t) {
                Assert.assertEquals((Object)TextDocumentSyncKind.Full, (Object)DocumentDidChangeTest.this.getDocumentSyncKind(t));
                return true;
            }
        });
        String text = "Hello";
        viewer.getDocument().replace(0, 0, text);
        TestUtils.waitForCondition(1000, TestUtils.numberOfChangesIs(1));
        DidChangeTextDocumentParams lastChange = (DidChangeTextDocumentParams)MockLanguageServer.INSTANCE.getDidChangeEvents().get(0);
        Assert.assertNotNull((Object)lastChange.getContentChanges());
        Assert.assertEquals((long)1L, (long)lastChange.getContentChanges().size());
        TextDocumentContentChangeEvent change0 = (TextDocumentContentChangeEvent)lastChange.getContentChanges().get(0);
        Assert.assertEquals((Object)text, (Object)change0.getText());
        viewer.getDocument().replace(5, 0, " World");
        TestUtils.waitForCondition(1000, TestUtils.numberOfChangesIs(2));
        lastChange = (DidChangeTextDocumentParams)MockLanguageServer.INSTANCE.getDidChangeEvents().get(1);
        Assert.assertNotNull((Object)lastChange.getContentChanges());
        Assert.assertEquals((long)1L, (long)lastChange.getContentChanges().size());
        change0 = (TextDocumentContentChangeEvent)lastChange.getContentChanges().get(0);
        Assert.assertEquals((Object)"Hello World", (Object)change0.getText());
    }

    private TextDocumentSyncKind getDocumentSyncKind(ServerCapabilities t) {
        TextDocumentSyncKind syncKind = null;
        if (t.getTextDocumentSync().isLeft()) {
            syncKind = (TextDocumentSyncKind)t.getTextDocumentSync().getLeft();
        } else if (t.getTextDocumentSync().isRight()) {
            syncKind = ((TextDocumentSyncOptions)t.getTextDocumentSync().getRight()).getChange();
        }
        return syncKind;
    }
}

