/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.folding;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.lsp4e.test.utils.AllCleanRule;
import org.eclipse.lsp4e.test.utils.TestUtils;
import org.eclipse.lsp4e.tests.mock.MockLanguageServer;
import org.eclipse.lsp4j.FoldingRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.tests.harness.util.DisplayHelper;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class FoldingTest {
    @Rule
    public final AllCleanRule clear = new AllCleanRule();

    @Test
    public void testImportsFoldedByDefault() throws CoreException {
        IFile file = TestUtils.createUniqueTestFile(null, "import\nimport\nimport\nvisible\n");
        FoldingRange foldingRange = new FoldingRange(0, 2);
        foldingRange.setKind("imports");
        MockLanguageServer.INSTANCE.setFoldingRanges(List.of(foldingRange));
        IEditorPart editor = TestUtils.openEditor(file);
        DisplayHelper.waitAndAssertCondition((Display)editor.getSite().getShell().getDisplay(), () -> Assert.assertEquals((Object)"import\nvisible", (Object)((StyledText)editor.getAdapter(Control.class)).getText().trim()));
    }
}

