/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.debug.debugmodel;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.lsp4e.debug.debugmodel.DSPDebugElement;
import org.eclipse.lsp4e.debug.debugmodel.DSPThread;
import org.eclipse.lsp4e.debug.debugmodel.DSPVariable;
import org.eclipse.lsp4j.debug.EvaluateArguments;
import org.eclipse.lsp4j.debug.Scope;
import org.eclipse.lsp4j.debug.ScopesArguments;
import org.eclipse.lsp4j.debug.ScopesResponse;
import org.eclipse.lsp4j.debug.StackFrame;

public class DSPStackFrame
extends DSPDebugElement
implements IStackFrame {
    private final DSPThread thread;
    private StackFrame stackFrame;
    private final int depth;
    private IVariable[] cachedVariables;

    public DSPStackFrame(DSPThread thread, StackFrame stackFrame, int depth) {
        super(thread.getDebugTarget());
        this.thread = thread;
        this.stackFrame = stackFrame;
        this.depth = depth;
    }

    public DSPStackFrame replace(StackFrame newStackFrame, int newDepth) {
        if (newDepth == this.depth && Objects.equals(newStackFrame.getSource(), this.stackFrame.getSource())) {
            this.stackFrame = newStackFrame;
            this.cachedVariables = null;
            return this;
        }
        return new DSPStackFrame(this.thread, newStackFrame, newDepth);
    }

    public void terminate() throws DebugException {
        this.getDebugTarget().terminate();
    }

    public boolean isTerminated() {
        return this.getDebugTarget().isTerminated();
    }

    public boolean canTerminate() {
        return this.getDebugTarget().canTerminate();
    }

    public void suspend() throws DebugException {
        this.getThread().suspend();
    }

    public void resume() throws DebugException {
        this.getThread().resume();
    }

    public boolean isSuspended() {
        return this.getDebugTarget().isSuspended();
    }

    public boolean canSuspend() {
        return this.getThread().canSuspend();
    }

    public boolean canResume() {
        return this.getThread().canResume();
    }

    public void stepReturn() throws DebugException {
        this.getThread().stepReturn();
    }

    public void stepOver() throws DebugException {
        this.getThread().stepOver();
    }

    public void stepInto() throws DebugException {
        this.getThread().stepInto();
    }

    public boolean isStepping() {
        return this.getThread().isStepping();
    }

    public boolean canStepReturn() {
        return this.getThread().canStepReturn();
    }

    public boolean canStepOver() {
        return this.getThread().canStepOver();
    }

    public boolean canStepInto() {
        return this.getThread().canStepInto();
    }

    public boolean hasVariables() throws DebugException {
        return true;
    }

    public boolean hasRegisterGroups() throws DebugException {
        return false;
    }

    public IVariable[] getVariables() throws DebugException {
        if (this.cachedVariables == null) {
            ScopesArguments arguments = new ScopesArguments();
            arguments.setFrameId(this.stackFrame.getId());
            Scope[] scopes = ((ScopesResponse)DSPStackFrame.complete(this.getDebugTarget().getDebugProtocolServer().scopes(arguments))).getScopes();
            ArrayList<DSPVariable> vars = new ArrayList<DSPVariable>();
            Scope[] scopeArray = scopes;
            int n = scopes.length;
            int n2 = 0;
            while (n2 < n) {
                Scope scope = scopeArray[n2];
                DSPVariable variable = new DSPVariable(this.getDebugTarget(), -1, scope.getName(), "", scope.getVariablesReference());
                vars.add(variable);
                ++n2;
            }
            this.cachedVariables = vars.toArray(new IVariable[vars.size()]);
        }
        return this.cachedVariables;
    }

    public DSPThread getThread() {
        return this.thread;
    }

    public IRegisterGroup[] getRegisterGroups() throws DebugException {
        return null;
    }

    public String getName() throws DebugException {
        return this.stackFrame.getName();
    }

    public int getLineNumber() throws DebugException {
        return this.stackFrame.getLine();
    }

    public int getCharStart() throws DebugException {
        return -1;
    }

    public int getCharEnd() throws DebugException {
        return -1;
    }

    public String getSourceName() {
        return this.stackFrame.getSource().getPath();
    }

    public Integer getFrameId() {
        return this.stackFrame.getId();
    }

    public int getFrameInstructionAddressBits() {
        String addr = this.stackFrame.getInstructionPointerReference();
        if (addr == null || addr.length() > 10) {
            return 64;
        }
        return 32;
    }

    public BigInteger getFrameInstructionAddress() {
        String addr = this.stackFrame.getInstructionPointerReference();
        if (addr == null || addr.length() == 0) {
            return BigInteger.ZERO;
        }
        if (addr.startsWith("0x")) {
            addr = addr.substring(2);
        }
        return new BigInteger(addr, 16);
    }

    public String toString() {
        return "StackFrame [depth=" + this.depth + ", line=" + this.stackFrame.getLine() + ", thread=" + String.valueOf((Object)this.thread) + ", stackFrame=" + String.valueOf(this.stackFrame) + "]";
    }

    public int getDepth() {
        return this.depth;
    }

    public CompletableFuture<IVariable> evaluate(String expression) {
        EvaluateArguments args = new EvaluateArguments();
        args.setContext("hover");
        args.setFrameId(this.getFrameId());
        args.setExpression(expression);
        CompletableFuture evaluate = this.getDebugProtocolServer().evaluate(args);
        CompletionStage future = evaluate.thenApply(res -> new DSPVariable(this.getDebugTarget(), res.getVariablesReference(), expression, res.getResult(), res.getVariablesReference()));
        return future;
    }
}

