/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.declaration;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.operations.declaration.LSBasedHyperlink;
import org.eclipse.lsp4e.test.utils.AllCleanRule;
import org.eclipse.lsp4e.test.utils.TestUtils;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.LocationLink;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class LSBasedHyperlinkTest {
    private static String locationType = "Open Declaration";
    @Rule
    public AllCleanRule clear = new AllCleanRule();
    private IProject project;

    @Before
    public void setUp() throws CoreException {
        this.project = TestUtils.createProject("HyperlinkLabelTest");
    }

    @Test
    public void testHyperlinkLabelNoLocation() {
        Location location = new Location();
        LSBasedHyperlink hyperlink = new LSBasedHyperlink(location, null, locationType);
        Assert.assertEquals((Object)locationType, (Object)hyperlink.getHyperlinkText());
    }

    @Test
    public void testHyperlinkLabelForFileLocation() throws URISyntaxException {
        Location location = new Location();
        location.setUri("file:///Users/someuser/testfile");
        LSBasedHyperlink hyperlink = new LSBasedHyperlink(location, null, locationType);
        Assert.assertEquals((Object)("Open Declaration - testfile - " + String.valueOf(Path.of(new URI(location.getUri())))), (Object)hyperlink.getHyperlinkText());
    }

    @Test
    public void testHyperlinkLabelForFileLocationLink() throws URISyntaxException {
        LocationLink location = new LocationLink();
        location.setTargetUri("file:///Users/someuser/testfile");
        LSBasedHyperlink hyperlink = new LSBasedHyperlink(location, null, locationType);
        Assert.assertEquals((Object)("Open Declaration - testfile - " + String.valueOf(Path.of(new URI(location.getTargetUri())))), (Object)hyperlink.getHyperlinkText());
    }

    @Test
    public void testHyperlinkLabelForIntroBasedLocationWithoutLabel() {
        Location location = new Location();
        location.setUri("http://org.eclipse.ui.intro/execute?command=mycommand%28bindingKey%3DLorg%2Ftest%2Fmvctest%2FMyComponent%3B%2CprojectName%3Dmvctest%29");
        LSBasedHyperlink hyperlink = new LSBasedHyperlink(location, null, locationType);
        Assert.assertEquals((Object)"Open Declaration", (Object)hyperlink.getHyperlinkText());
    }

    @Test
    public void testHyperlinkLabelForIntroBasedLocationLinkWithLabel() {
        LocationLink location = new LocationLink();
        location.setTargetUri("http://org.eclipse.ui.intro/execute?command=org.springframework.tooling.ls.eclipse.commons.commands.OpenJavaElementInEditor%28bindingKey%3DLorg%2Ftest%2Fmvctest%2FMyComponent%3B%2CprojectName%3Dmvctest%29&label=MyComponent+-+org.test.mvctest");
        LSBasedHyperlink hyperlink = new LSBasedHyperlink(location, null, locationType);
        Assert.assertEquals((Object)"Open Declaration - MyComponent - org.test.mvctest", (Object)hyperlink.getHyperlinkText());
    }

    @Test
    public void testHyperlinkLabelForRandomURLLocation() {
        Location location = new Location();
        location.setUri("http://eclipse.org");
        LSBasedHyperlink hyperlink = new LSBasedHyperlink(location, null, locationType);
        Assert.assertEquals((Object)"Open Declaration - http://eclipse.org", (Object)hyperlink.getHyperlinkText());
    }

    @Test
    public void testHyperlinkLabelForRandomURLLocationLink() {
        LocationLink location = new LocationLink();
        location.setTargetUri("http://eclipse.org");
        LSBasedHyperlink hyperlink = new LSBasedHyperlink(location, null, locationType);
        Assert.assertEquals((Object)"Open Declaration - http://eclipse.org", (Object)hyperlink.getHyperlinkText());
    }

    @Test
    public void testHyperlinkLabelForFileInProject() throws Exception {
        IFile file = TestUtils.createFile(this.project, "my-test.txt", "Example Text");
        LocationLink location = new LocationLink();
        location.setTargetUri(LSPEclipseUtils.toUri((File)new File(file.getLocation().toOSString())).toASCIIString());
        LSBasedHyperlink hyperlink = new LSBasedHyperlink(location, null, locationType);
        Assert.assertEquals((Object)("Open Declaration - my-test.txt - " + this.project.getName()), (Object)hyperlink.getHyperlinkText());
    }
}

