/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.typeHierarchy;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServerWrapper;
import org.eclipse.lsp4e.LanguageServers;
import org.eclipse.lsp4e.internal.ArrayUtil;
import org.eclipse.lsp4e.internal.Pair;
import org.eclipse.lsp4e.ui.Messages;
import org.eclipse.lsp4e.ui.views.HierarchyViewInput;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TypeHierarchyItem;
import org.eclipse.lsp4j.TypeHierarchyPrepareParams;
import org.eclipse.lsp4j.TypeHierarchySubtypesParams;
import org.eclipse.lsp4j.TypeHierarchySupertypesParams;
import org.eclipse.lsp4j.services.TextDocumentService;
import org.eclipse.ui.PlatformUI;

public class TypeHierarchyViewContentProvider
implements ITreeContentProvider {
    private @Nullable TreeViewer treeViewer;
    private @Nullable LanguageServerWrapper languageServerWrapper;
    private List<TypeHierarchyItem> hierarchyItems = Collections.emptyList();
    public boolean showSuperTypes = true;
    public @Nullable IDocument document;

    public Object[] getElements(@Nullable Object inputElement) {
        if (this.hierarchyItems.isEmpty()) {
            return new Object[]{Messages.TH_no_type_hierarchy};
        }
        return this.hierarchyItems.toArray();
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof TypeHierarchyItem) {
            TypeHierarchyItem parentItem = (TypeHierarchyItem)parentElement;
            if (this.languageServerWrapper != null) {
                try {
                    return (Object[])((CompletableFuture)this.languageServerWrapper.execute(ls -> {
                        TextDocumentService textDocumentService = ls.getTextDocumentService();
                        return this.showSuperTypes ? textDocumentService.typeHierarchySupertypes(new TypeHierarchySupertypesParams(parentItem)) : textDocumentService.typeHierarchySubtypes(new TypeHierarchySubtypesParams(parentItem));
                    }).thenApply(list -> list == null ? ArrayUtil.NO_OBJECTS : list.toArray())).get(500L, TimeUnit.MILLISECONDS);
                }
                catch (Exception e) {
                    LanguageServerPlugin.logError(e);
                }
            }
        }
        return ArrayUtil.NO_OBJECTS;
    }

    public @Nullable Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        return true;
    }

    public void inputChanged(Viewer viewer, @Nullable Object oldInput, @Nullable Object newInput) {
        super.inputChanged(viewer, oldInput, newInput);
        if (newInput instanceof HierarchyViewInput) {
            HierarchyViewInput viewInput = (HierarchyViewInput)newInput;
            try {
                this.initialise(viewInput.getDocument(), viewInput.getOffset(), (TreeViewer)viewer);
            }
            catch (BadLocationException e) {
                this.handleRootError();
            }
        } else {
            this.handleRootError();
        }
    }

    private void initialise(IDocument document, int offset, TreeViewer viewer) throws BadLocationException {
        LanguageServers.LanguageServerDocumentExecutor executor = (LanguageServers.LanguageServerDocumentExecutor)LanguageServers.forDocument(document).withCapability(ServerCapabilities::getTypeHierarchyProvider);
        if (!executor.anyMatching()) {
            this.handleRootError();
            return;
        }
        TypeHierarchyPrepareParams prepareParams = TypeHierarchyViewContentProvider.toTypeHierarchyPrepareParams(offset, document);
        if (prepareParams == null) {
            return;
        }
        ((CompletableFuture)executor.computeFirst((w, ls) -> ls.getTextDocumentService().prepareTypeHierarchy(prepareParams).thenApply(result -> new Pair<LanguageServerWrapper, List>((LanguageServerWrapper)w, (List)result))).thenAccept(o -> o.ifPresentOrElse(p -> {
            this.languageServerWrapper = (LanguageServerWrapper)p.first();
            if (!((List)p.second()).isEmpty()) {
                this.hierarchyItems = (List)p.second();
                this.treeViewer = viewer;
                PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
                    TreeViewer treeViewer = this.treeViewer;
                    if (treeViewer != null) {
                        treeViewer.refresh();
                        treeViewer.expandToLevel(2);
                        if (!this.hierarchyItems.isEmpty()) {
                            treeViewer.getControl().setEnabled(true);
                            treeViewer.setSelection((ISelection)new StructuredSelection((Object)this.hierarchyItems.get(0)));
                        }
                    }
                });
            }
        }, this::handleRootError))).handle((result, error) -> {
            if (error != null) {
                this.handleRootError();
            }
            return result;
        });
    }

    private static @Nullable TypeHierarchyPrepareParams toTypeHierarchyPrepareParams(int offset, IDocument document) throws BadLocationException {
        Position position = LSPEclipseUtils.toPosition(offset, document);
        TextDocumentIdentifier documentIdentifier = LSPEclipseUtils.toTextDocumentIdentifier(document);
        if (documentIdentifier == null) {
            return null;
        }
        return new TypeHierarchyPrepareParams(documentIdentifier, position);
    }

    private void handleRootError() {
        this.hierarchyItems = Collections.emptyList();
        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
            if (this.treeViewer != null) {
                this.treeViewer.refresh();
            }
        });
    }

    public void dispose() {
        if (this.treeViewer != null) {
            this.treeViewer.getControl().dispose();
            this.treeViewer = null;
        }
    }
}

