/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.completion;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.lsp4e.operations.completion.LSCompletionProposal;
import org.eclipse.lsp4e.test.completion.AbstractCompletionTest;
import org.eclipse.lsp4e.test.utils.TestUtils;
import org.eclipse.lsp4e.tests.mock.MockLanguageServer;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.swt.graphics.Point;
import org.junit.Assert;
import org.junit.Test;

public class InsertReplaceCompletionTest
extends AbstractCompletionTest {
    @Test
    public void testInsert() throws Exception {
        IFile file = TestUtils.createUniqueTestFile(this.project, "line1\nlineInsertHere");
        ITextViewer viewer = TestUtils.openTextViewer(file);
        MockLanguageServer.INSTANCE.setCompletionList(new CompletionList(false, List.of(this.createCompletionItemWithInsertReplace("Inserted", CompletionItemKind.Text, new Range(new Position(1, 4), new Position(1, 4 + "InsertHere".length())), new Range(new Position(0, 0), new Position(0, 0))))));
        int invokeOffset = viewer.getDocument().getLength() - "InsertHere".length();
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, invokeOffset);
        LSCompletionProposal lsCompletionProposal = (LSCompletionProposal)proposals[0];
        lsCompletionProposal.apply(viewer, '\n', 0, invokeOffset);
        Assert.assertEquals((Object)"line1\nlineInserted", (Object)viewer.getDocument().get());
        Assert.assertEquals((Object)new Point(viewer.getDocument().getLength(), 0), (Object)lsCompletionProposal.getSelection(viewer.getDocument()));
    }
}

