/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.internal.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.lsp4mp.commons.MicroProfilePropertiesScope;
import org.eclipse.lsp4mp.commons.metadata.ConfigurationMetadata;
import org.eclipse.lsp4mp.commons.metadata.ItemHint;
import org.eclipse.lsp4mp.commons.metadata.ItemMetadata;
import org.eclipse.lsp4mp.jdt.core.IPropertiesCollector;

public class PropertiesCollector
implements IPropertiesCollector {
    private final ConfigurationMetadata configuration;
    private final Map<String, ItemHint> hintsCache;
    private final boolean onlySources;

    public PropertiesCollector(ConfigurationMetadata configuration, List<MicroProfilePropertiesScope> scopes) {
        this.configuration = configuration;
        this.configuration.setProperties(new ArrayList<ItemMetadata>());
        this.configuration.setHints(new ArrayList<ItemHint>());
        this.hintsCache = new HashMap<String, ItemHint>();
        this.onlySources = MicroProfilePropertiesScope.isOnlySources(scopes);
    }

    @Override
    public ItemMetadata addItemMetadata(String name, String type, String description, String sourceType, String sourceField, String sourceMethod, String defaultValue, String extensionName, boolean binary, int phase) {
        ItemMetadata property = new ItemMetadata();
        property.setName(name);
        property.setType(type);
        property.setDescription(description);
        property.setSourceType(sourceType);
        property.setSourceField(sourceField);
        property.setSourceMethod(sourceMethod);
        property.setDefaultValue(defaultValue);
        property.setExtensionName(extensionName);
        if (!binary) {
            property.setSource(Boolean.TRUE);
        }
        property.setPhase(phase);
        property.setRequired(defaultValue == null);
        this.configuration.getProperties().add(property);
        return property;
    }

    @Override
    public boolean hasItemHint(String hint) {
        return this.hintsCache.containsKey(hint);
    }

    private void addItemHint(ItemHint itemHint) {
        this.configuration.getHints().add(itemHint);
        this.hintsCache.put(itemHint.getName(), itemHint);
    }

    @Override
    public ItemHint getItemHint(String hint) {
        ItemHint itemHint = this.hintsCache.get(hint);
        if (itemHint != null) {
            return itemHint;
        }
        itemHint = new ItemHint();
        itemHint.setName(hint);
        itemHint.setValues(new ArrayList<ItemHint.ValueHint>());
        this.addItemHint(itemHint);
        return itemHint;
    }

    @Override
    public void merge(ConfigurationMetadata metadata, IPropertiesCollector.MergingStrategy mergingStrategy) {
        List<ItemMetadata> properties = metadata.getProperties();
        if (properties == null) {
            return;
        }
        for (ItemMetadata property : properties) {
            this.merge(property, mergingStrategy);
        }
        List<ItemHint> hints = metadata.getHints();
        if (hints != null) {
            for (ItemHint itemHint : hints) {
                this.addItemHint(itemHint);
            }
        }
    }

    public void merge(ItemMetadata property, IPropertiesCollector.MergingStrategy mergingStrategy) {
        if (this.onlySources && (property.getSource() == null || !property.getSource().booleanValue())) {
            return;
        }
        switch (mergingStrategy) {
            case IGNORE_IF_EXISTS: {
                this.mergeWithIgnoreIfExists(property);
                break;
            }
            case REPLACE: {
                this.mergeWithReplace(property);
                break;
            }
            default: {
                this.addProperty(property);
            }
        }
    }

    private void mergeWithIgnoreIfExists(ItemMetadata property) {
        Optional<ItemMetadata> configProperty = this.getExistingProperty(property);
        if (configProperty.isPresent()) {
            return;
        }
        this.addProperty(property);
    }

    private Optional<ItemMetadata> getExistingProperty(ItemMetadata property) {
        List<ItemMetadata> configProperties = this.configuration.getProperties();
        Optional<ItemMetadata> configProperty = configProperties.stream().filter(cp -> cp.getName().equals(property.getName())).findFirst();
        return configProperty;
    }

    private void mergeWithReplace(ItemMetadata property) {
        Optional<ItemMetadata> configProperty = this.getExistingProperty(property);
        if (configProperty.isPresent()) {
            this.configuration.getProperties().remove(configProperty.get());
        }
        this.addProperty(property);
    }

    private void addProperty(ItemMetadata property) {
        this.configuration.getProperties().add(property);
    }
}

