/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.internal.restclient.java;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.lsp4j.CodeLens;
import org.eclipse.lsp4mp.commons.MicroProfileJavaCodeLensParams;
import org.eclipse.lsp4mp.jdt.core.java.codelens.IJavaCodeLensParticipant;
import org.eclipse.lsp4mp.jdt.core.java.codelens.JavaCodeLensContext;
import org.eclipse.lsp4mp.jdt.core.jaxrs.JaxRsUtils;
import org.eclipse.lsp4mp.jdt.core.project.JDTMicroProfileProject;
import org.eclipse.lsp4mp.jdt.core.project.JDTMicroProfileProjectManager;
import org.eclipse.lsp4mp.jdt.core.utils.AnnotationUtils;
import org.eclipse.lsp4mp.jdt.core.utils.IJDTUtils;
import org.eclipse.lsp4mp.jdt.core.utils.JDTTypeUtils;

public class MicroProfileRestClientCodeLensParticipant
implements IJavaCodeLensParticipant {
    @Override
    public boolean isAdaptedForCodeLens(JavaCodeLensContext context, IProgressMonitor monitor) throws CoreException {
        MicroProfileJavaCodeLensParams params = context.getParams();
        if (!params.isUrlCodeLensEnabled()) {
            return false;
        }
        IJavaProject javaProject = context.getJavaProject();
        return JDTTypeUtils.findType(javaProject, "org.eclipse.microprofile.rest.client.inject.RegisterRestClient") != null;
    }

    @Override
    public List<CodeLens> collectCodeLens(JavaCodeLensContext context, IProgressMonitor monitor) throws CoreException {
        ITypeRoot typeRoot = context.getTypeRoot();
        IJavaElement[] elements = typeRoot.getChildren();
        IJDTUtils utils = context.getUtils();
        MicroProfileJavaCodeLensParams params = context.getParams();
        ArrayList<CodeLens> lenses = new ArrayList<CodeLens>();
        JDTMicroProfileProject mpProject = JDTMicroProfileProjectManager.getInstance().getJDTMicroProfileProject(context.getJavaProject());
        MicroProfileRestClientCodeLensParticipant.collectURLCodeLenses(elements, null, null, mpProject, lenses, params, utils, monitor);
        return lenses;
    }

    private static void collectURLCodeLenses(IJavaElement[] elements, String baseURL, String rootPath, JDTMicroProfileProject mpProject, Collection<CodeLens> lenses, MicroProfileJavaCodeLensParams params, IJDTUtils utils, IProgressMonitor monitor) throws JavaModelException {
        IJavaElement[] iJavaElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            String openURICommandId;
            CodeLens lens;
            IMethod method;
            IJavaElement parentType;
            IJavaElement element = iJavaElementArray[n2];
            if (monitor.isCanceled()) {
                return;
            }
            if (element.getElementType() == 7) {
                IType type = (IType)element;
                String url = MicroProfileRestClientCodeLensParticipant.getBaseURL(type, mpProject);
                if (url != null) {
                    String pathValue = JaxRsUtils.getJaxRsPathValue((IAnnotatable)type);
                    MicroProfileRestClientCodeLensParticipant.collectURLCodeLenses(type.getChildren(), url, pathValue, mpProject, lenses, params, utils, monitor);
                }
            } else if (!(element.getElementType() != 9 || utils.isHiddenGeneratedElement(element) || (parentType = element.getAncestor(7)) != null && JDTTypeUtils.overlaps(((ISourceReference)parentType).getNameRange(), ((ISourceReference)element).getNameRange()) || baseURL == null || !JaxRsUtils.isJaxRsRequestMethod(method = (IMethod)element) || (lens = JaxRsUtils.createURLCodeLens(baseURL, rootPath, openURICommandId = params.getOpenURICommand(), (IMethod)element, utils)) == null)) {
                lenses.add(lens);
            }
            ++n2;
        }
    }

    private static String getBaseURL(IType type, JDTMicroProfileProject mpProject) throws JavaModelException {
        IAnnotation registerRestClientAnnotation = AnnotationUtils.getAnnotation((IAnnotatable)type, "org.eclipse.microprofile.rest.client.inject.RegisterRestClient");
        if (registerRestClientAnnotation == null) {
            return null;
        }
        String baseURIFromConfig = MicroProfileRestClientCodeLensParticipant.getBaseURIFromConfig(type, mpProject);
        if (baseURIFromConfig != null) {
            return baseURIFromConfig;
        }
        String baseURLFromConfig = MicroProfileRestClientCodeLensParticipant.getBaseURLFromConfig(type, mpProject);
        if (baseURLFromConfig != null) {
            return baseURLFromConfig;
        }
        String baseURIFromAnnotation = AnnotationUtils.getAnnotationMemberValue(registerRestClientAnnotation, "baseUri");
        return baseURIFromAnnotation;
    }

    private static String getBaseURIFromConfig(IType type, JDTMicroProfileProject mpProject) {
        String property = type.getFullyQualifiedName() + "/mp-rest/uri";
        return mpProject.getProperty(property, null);
    }

    private static String getBaseURLFromConfig(IType type, JDTMicroProfileProject mpProject) {
        String property = type.getFullyQualifiedName() + "/mp-rest/url";
        return mpProject.getProperty(property, null);
    }
}

