/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.core.java.corrections.proposal;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.core.manipulation.dom.ASTResolving;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.lsp4mp.jdt.core.java.corrections.proposal.LinkedCorrectionProposal;

public class InsertAnnotationAttributeProposal
extends LinkedCorrectionProposal {
    private final Annotation fAnnotation;
    private final Set<String> attributes;

    public InsertAnnotationAttributeProposal(String label, ICompilationUnit targetCU, Annotation annotation, int relevance, String ... attributes) {
        super(label, "quickfix", targetCU, (ASTRewrite)null, relevance);
        this.fAnnotation = annotation;
        this.attributes = new HashSet<String>(Arrays.asList(attributes));
    }

    @Override
    protected ASTRewrite getRewrite() throws CoreException {
        ListRewrite listRewrite;
        AST ast = this.fAnnotation.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        this.createImportRewrite((CompilationUnit)this.fAnnotation.getRoot());
        if (this.fAnnotation instanceof NormalAnnotation) {
            listRewrite = rewrite.getListRewrite((ASTNode)this.fAnnotation, NormalAnnotation.VALUES_PROPERTY);
        } else {
            NormalAnnotation newAnnotation = ast.newNormalAnnotation();
            newAnnotation.setTypeName((Name)rewrite.createMoveTarget((ASTNode)this.fAnnotation.getTypeName()));
            rewrite.replace((ASTNode)this.fAnnotation, (ASTNode)newAnnotation, null);
            listRewrite = rewrite.getListRewrite((ASTNode)newAnnotation, NormalAnnotation.VALUES_PROPERTY);
        }
        this.addDefinedAtributes(this.fAnnotation.resolveTypeBinding(), listRewrite);
        return rewrite;
    }

    private void addDefinedAtributes(ITypeBinding binding, ListRewrite listRewriter) {
        HashSet<String> implementedAttribs = new HashSet<String>();
        if (this.fAnnotation instanceof NormalAnnotation) {
            List list = ((NormalAnnotation)this.fAnnotation).values();
            int i = 0;
            while (i < list.size()) {
                MemberValuePair curr = (MemberValuePair)list.get(i);
                implementedAttribs.add(curr.getName().getIdentifier());
                ++i;
            }
        } else if (this.fAnnotation instanceof SingleMemberAnnotation) {
            implementedAttribs.add("value");
        }
        ASTRewrite rewriter = listRewriter.getASTRewrite();
        AST ast = rewriter.getAST();
        ContextSensitiveImportRewriteContext context = null;
        BodyDeclaration bodyDeclaration = ASTResolving.findParentBodyDeclaration((ASTNode)listRewriter.getParent());
        if (bodyDeclaration != null) {
            context = new ContextSensitiveImportRewriteContext((ASTNode)bodyDeclaration, this.getImportRewrite());
        }
        IMethodBinding[] declaredMethods = binding.getDeclaredMethods();
        int i = 0;
        while (i < declaredMethods.length) {
            IMethodBinding curr = declaredMethods[i];
            if (!implementedAttribs.contains(curr.getName()) && this.attributes.contains(curr.getName())) {
                MemberValuePair pair = ast.newMemberValuePair();
                pair.setName(ast.newSimpleName(curr.getName()));
                pair.setValue(this.newDefaultExpression(ast, curr.getReturnType(), (ImportRewrite.ImportRewriteContext)context));
                listRewriter.insertLast((ASTNode)pair, null);
            }
            ++i;
        }
    }

    private Expression newDefaultExpression(AST ast, ITypeBinding type, ImportRewrite.ImportRewriteContext context) {
        if (type.isPrimitive()) {
            String name = type.getName();
            if ("boolean".equals(name)) {
                return ast.newBooleanLiteral(false);
            }
            return ast.newNumberLiteral("0");
        }
        if (type == ast.resolveWellKnownType("java.lang.String")) {
            return ast.newStringLiteral();
        }
        if (type.isArray()) {
            ArrayInitializer initializer = ast.newArrayInitializer();
            initializer.expressions().add(this.newDefaultExpression(ast, type.getElementType(), context));
            return initializer;
        }
        if (type.isAnnotation()) {
            MarkerAnnotation annotation = ast.newMarkerAnnotation();
            annotation.setTypeName(ast.newName(this.getImportRewrite().addImport(type, context)));
            return annotation;
        }
        return ast.newNullLiteral();
    }
}

