/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.core.project;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.lsp4mp.jdt.core.project.IConfigSource;
import org.eclipse.lsp4mp.jdt.core.project.MicroProfileConfigPropertyInformation;

public abstract class AbstractConfigSource<T>
implements IConfigSource {
    private static final Logger LOGGER = Logger.getLogger(AbstractConfigSource.class.getName());
    private static final int DEFAULT_ORDINAL = 100;
    private final String configFileName;
    private final String profile;
    private final int ordinal;
    private final IJavaProject javaProject;
    private Path outputConfigFile;
    private Path sourceConfigFile;
    private FileTime lastModified;
    private T config;
    private Map<String, List<MicroProfileConfigPropertyInformation>> propertyInformations;

    public AbstractConfigSource(String configFileName, int ordinal, IJavaProject javaProject) {
        this(configFileName, null, ordinal, javaProject);
    }

    public AbstractConfigSource(String configFileName, IJavaProject javaProject) {
        this(configFileName, null, javaProject);
    }

    public AbstractConfigSource(String configFileName, String profile, IJavaProject javaProject) {
        this(configFileName, profile, 100, javaProject);
    }

    public AbstractConfigSource(String configFileName, String profile, int ordinal, IJavaProject javaProject) {
        this.configFileName = configFileName;
        this.profile = profile;
        this.ordinal = ordinal;
        this.javaProject = javaProject;
        this.init();
    }

    private void init() {
        T config = this.getConfig();
        if (config != null && this.propertyInformations == null) {
            this.propertyInformations = this.loadPropertyInformations();
        }
    }

    private Path getOutputConfigFile() {
        if (this.outputConfigFile != null && Files.exists(this.outputConfigFile, new LinkOption[0])) {
            return this.outputConfigFile;
        }
        this.sourceConfigFile = null;
        this.outputConfigFile = null;
        if (this.javaProject.getProject() != null && this.javaProject.getProject().isAccessible()) {
            try {
                List sourceEntries = Stream.of(((JavaProject)this.javaProject).getResolvedClasspath(true)).filter(entry -> !entry.isTest()).filter(entry -> entry.getEntryKind() == 3 && entry.getOutputLocation() != null).distinct().collect(Collectors.toList());
                for (IClasspathEntry sourceEntry : sourceEntries) {
                    IPath source = sourceEntry.getPath();
                    File sourceFile = this.javaProject.getProject().getLocation().append(source.removeFirstSegments(1)).append(this.configFileName).toFile();
                    if (sourceFile.exists()) {
                        this.sourceConfigFile = sourceFile.toPath();
                    }
                    IPath output = sourceEntry.getOutputLocation();
                    File outputFile = this.javaProject.getProject().getLocation().append(output.removeFirstSegments(1)).append(this.configFileName).toFile();
                    if (!outputFile.exists()) continue;
                    this.outputConfigFile = outputFile.toPath();
                }
                return this.outputConfigFile;
            }
            catch (JavaModelException e) {
                LOGGER.log(Level.SEVERE, "Error while getting configuration", e);
                return null;
            }
        }
        return null;
    }

    @Override
    public String getConfigFileName() {
        return this.configFileName;
    }

    @Override
    public String getProfile() {
        return this.profile;
    }

    @Override
    public int getOrdinal() {
        return this.ordinal;
    }

    @Override
    public String getSourceConfigFileURI() {
        this.getOutputConfigFile();
        if (this.sourceConfigFile != null) {
            URI uri = this.sourceConfigFile.toFile().toURI();
            return AbstractConfigSource.fixURI(uri);
        }
        return null;
    }

    private static String fixURI(URI uri) {
        String uriString = uri.toString();
        return uriString.replaceFirst("file:/([^/])", "file:///$1");
    }

    protected final T getConfig() {
        block14: {
            Path configFile = this.getOutputConfigFile();
            if (configFile == null) {
                this.reset();
                return null;
            }
            try {
                FileTime currentLastModified = Files.getLastModifiedTime(configFile, new LinkOption[0]);
                if (currentLastModified.equals(this.lastModified)) break block14;
                this.reset();
                try {
                    Throwable throwable = null;
                    Object var4_7 = null;
                    try (FileInputStream input = new FileInputStream(configFile.toFile());){
                        this.config = this.loadConfig(input);
                        this.lastModified = Files.getLastModifiedTime(configFile, new LinkOption[0]);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    this.reset();
                    LOGGER.log(Level.SEVERE, "Error while loading properties from '" + configFile + "'.", e);
                }
            }
            catch (IOException e1) {
                LOGGER.log(Level.SEVERE, "Error while getting last modified time for '" + configFile + "'.", e1);
            }
        }
        return this.config;
    }

    @Override
    public Integer getPropertyAsInt(String key) {
        String property = this.getProperty(key);
        if (property != null && !property.trim().isEmpty()) {
            try {
                return Integer.parseInt(property.trim());
            }
            catch (NumberFormatException e) {
                LOGGER.log(Level.SEVERE, "Error while converting '" + property.trim() + "' as Integer for key '" + key + "'", e);
                return null;
            }
        }
        return null;
    }

    private void reset() {
        this.config = null;
        this.propertyInformations = null;
    }

    @Override
    public List<MicroProfileConfigPropertyInformation> getPropertyInformations(String propertyKey) {
        this.init();
        return this.propertyInformations != null ? this.propertyInformations.get(propertyKey) : null;
    }

    protected abstract T loadConfig(InputStream var1) throws IOException;

    protected abstract Map<String, List<MicroProfileConfigPropertyInformation>> loadPropertyInformations();
}

