/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.core.project;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.lsp4mp.jdt.core.project.IConfigSource;
import org.eclipse.lsp4mp.jdt.core.project.IConfigSourceProvider;
import org.eclipse.lsp4mp.jdt.core.project.MicroProfileConfigPropertyInformation;
import org.eclipse.lsp4mp.jdt.internal.core.ConfigSourceProviderRegistry;

public class JDTMicroProfileProject {
    private static final Logger LOGGER = Logger.getLogger(JDTMicroProfileProject.class.getName());
    private IJavaProject javaProject;
    private List<IConfigSource> configSources;

    public JDTMicroProfileProject(IJavaProject javaProject) {
        this.javaProject = javaProject;
    }

    public String getProperty(String propertyKey, String defaultValue) {
        for (IConfigSource configSource : this.getConfigSources()) {
            String propertyValue = configSource.getProperty(propertyKey);
            if (propertyValue == null) continue;
            return propertyValue;
        }
        return defaultValue;
    }

    public String getProperty(String propertyKey) {
        return this.getProperty(propertyKey, null);
    }

    public Integer getPropertyAsInteger(String key, Integer defaultValue) {
        for (IConfigSource configSource : this.getConfigSources()) {
            Integer property = configSource.getPropertyAsInt(key);
            if (property == null) continue;
            return property;
        }
        return defaultValue;
    }

    public List<MicroProfileConfigPropertyInformation> getPropertyInformations(String propertyKey) {
        HashMap<String, MicroProfileConfigPropertyInformation> propertyToInfoMap = new HashMap<String, MicroProfileConfigPropertyInformation>();
        List<IConfigSource> configSources = this.getConfigSources();
        int i = configSources.size() - 1;
        while (i >= 0) {
            IConfigSource configSource = configSources.get(i);
            List<MicroProfileConfigPropertyInformation> propertyInformations = configSource.getPropertyInformations(propertyKey);
            if (propertyInformations != null) {
                for (MicroProfileConfigPropertyInformation propertyInformation : propertyInformations) {
                    propertyToInfoMap.put(propertyInformation.getPropertyNameWithProfile(), propertyInformation);
                }
            }
            --i;
        }
        return propertyToInfoMap.values().stream().sorted((a, b) -> a.getPropertyNameWithProfile().compareTo(b.getPropertyNameWithProfile())).collect(Collectors.toList());
    }

    public List<IConfigSource> getConfigSources() {
        if (this.configSources == null) {
            this.configSources = this.loadConfigSources(this.javaProject);
        }
        return this.configSources;
    }

    public void evictConfigSourcesCache() {
        this.configSources = null;
    }

    private synchronized List<IConfigSource> loadConfigSources(IJavaProject javaProject) {
        if (this.configSources != null) {
            return this.configSources;
        }
        ArrayList<IConfigSource> configSources = new ArrayList<IConfigSource>();
        try {
            HashSet<IPath> outputLocationAlreadyProcessed = new HashSet<IPath>();
            IClasspathEntry[] iClasspathEntryArray = javaProject.getResolvedClasspath(true);
            int n = iClasspathEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry sourceEntry = iClasspathEntryArray[n2];
                if (!sourceEntry.isTest() && sourceEntry.getEntryKind() == 3 && sourceEntry.getOutputLocation() != null) {
                    IPath output = sourceEntry.getOutputLocation();
                    IPath outputLocation = javaProject.getProject().getLocation().append(output.removeFirstSegments(1));
                    if (!outputLocationAlreadyProcessed.contains(outputLocation)) {
                        outputLocationAlreadyProcessed.add(outputLocation);
                        File outputFile = outputLocation.toFile();
                        if (outputFile.exists() && outputFile.isDirectory()) {
                            for (IConfigSourceProvider provider : ConfigSourceProviderRegistry.getInstance().getProviders()) {
                                configSources.addAll(provider.getConfigSources(javaProject, outputFile));
                            }
                        }
                    }
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            LOGGER.log(Level.WARNING, "Error while loading config sources", e);
        }
        Collections.sort(configSources, (a, b) -> b.getOrdinal() - a.getOrdinal());
        return configSources;
    }

    public boolean hasProperty(String property) {
        List<IConfigSource> configSources = this.getConfigSources();
        for (IConfigSource configSource : configSources) {
            if (configSource.getPropertyInformations(property) == null) continue;
            return true;
        }
        return false;
    }
}

