/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.internal.config.java;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.TextDocumentItem;
import org.eclipse.lsp4mp.commons.MicroProfileCodeActionFactory;
import org.eclipse.lsp4mp.jdt.core.java.codeaction.IJavaCodeActionParticipant;
import org.eclipse.lsp4mp.jdt.core.java.codeaction.JavaCodeActionContext;
import org.eclipse.lsp4mp.jdt.core.project.IConfigSource;
import org.eclipse.lsp4mp.jdt.core.project.JDTMicroProfileProject;
import org.eclipse.lsp4mp.jdt.core.project.JDTMicroProfileProjectManager;
import org.eclipse.lsp4mp.jdt.core.utils.AnnotationUtils;
import org.eclipse.lsp4mp.jdt.core.utils.IJDTUtils;
import org.eclipse.lsp4mp.ls.commons.CodeActionFactory;

public class NoValueAssignedToPropertyQuickFix
implements IJavaCodeActionParticipant {
    private static final String CODE_ACTION_LABEL = "Insert ''{0}'' property in ''{1}''";

    @Override
    public List<? extends CodeAction> getCodeActions(JavaCodeActionContext context, Diagnostic diagnostic, IProgressMonitor monitor) throws CoreException {
        ArrayList<CodeAction> codeActions = new ArrayList<CodeAction>();
        IJavaProject javaProject = context.getJavaProject();
        String lineSeparator = context.getCompilationUnit().findRecommendedLineSeparator();
        if (lineSeparator == null) {
            lineSeparator = System.lineSeparator();
        }
        String propertyName = NoValueAssignedToPropertyQuickFix.getPropertyName(diagnostic, context);
        String insertText = String.valueOf(propertyName) + "=" + lineSeparator;
        JDTMicroProfileProject mpProject = JDTMicroProfileProjectManager.getInstance().getJDTMicroProfileProject(javaProject);
        List<IConfigSource> configSources = mpProject.getConfigSources();
        for (IConfigSource configSource : configSources) {
            String uri = configSource.getSourceConfigFileURI();
            if (uri == null) continue;
            TextDocumentItem document = new TextDocumentItem(uri, "properties", 0, insertText);
            CodeAction codeAction = CodeActionFactory.insert(NoValueAssignedToPropertyQuickFix.getTitle(propertyName, configSource.getConfigFileName()), new Position(0, 0), insertText, document, diagnostic);
            codeActions.add(codeAction);
        }
        if (context.getParams().isCommandConfigurationUpdateSupported()) {
            codeActions.add(MicroProfileCodeActionFactory.createAddToUnassignedExcludedCodeAction(propertyName, diagnostic));
        }
        return codeActions;
    }

    private static String getPropertyName(Diagnostic diagnostic, JavaCodeActionContext context) throws JavaModelException {
        JsonObject data;
        JsonElement name;
        if (diagnostic.getData() != null && (name = (data = (JsonObject)diagnostic.getData()).get("name")) != null) {
            return name.getAsString();
        }
        Position hoverPosition = diagnostic.getRange().getStart();
        IJDTUtils utils = context.getUtils();
        ITypeRoot typeRoot = context.getTypeRoot();
        int offset = utils.toOffset(typeRoot.getBuffer(), hoverPosition.getLine(), hoverPosition.getCharacter());
        IJavaElement hoverElement = typeRoot.getElementAt(offset);
        IAnnotation configPropertyAnnotation = AnnotationUtils.getAnnotation((IAnnotatable)hoverElement, "org.eclipse.microprofile.config.inject.ConfigProperty");
        return AnnotationUtils.getAnnotationMemberValue(configPropertyAnnotation, "name");
    }

    private static String getTitle(String propertyName, String configFileName) {
        return MessageFormat.format(CODE_ACTION_LABEL, propertyName, configFileName);
    }
}

