/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.internal.acquire;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.internal.acquire.HeapDumpProviderDescriptor;
import org.eclipse.mat.internal.acquire.HeapDumpProviderRegistry;
import org.eclipse.mat.internal.acquire.VmInfoDescriptor;
import org.eclipse.mat.query.annotations.descriptors.IAnnotatedObjectDescriptor;
import org.eclipse.mat.query.registry.AnnotatedObjectArgumentsSet;
import org.eclipse.mat.query.registry.ArgumentDescriptor;
import org.eclipse.mat.query.registry.ArgumentFactory;
import org.eclipse.mat.snapshot.acquire.IHeapDumpProvider;
import org.eclipse.mat.ui.MemoryAnalyserPlugin;
import org.eclipse.mat.ui.Messages;
import org.eclipse.mat.ui.accessibility.AccessibleCompositeAdapter;
import org.eclipse.mat.ui.internal.acquire.AcquireDialog;
import org.eclipse.mat.ui.internal.acquire.ProviderArgumentsTable;
import org.eclipse.mat.ui.internal.browser.QueryContextHelp;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.MessageUtil;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class ProviderConfigurationWizardPage
extends WizardPage
implements ProviderArgumentsTable.ITableListener,
AcquireDialog.ProcessSelectionListener {
    public static final String HIDE_QUERY_HELP = "pref:HideQueryHelp";
    private ProviderArgumentsTable table;
    private Table availableProvidersTable;
    private AcquireDialog acquireDialog;
    private QueryContextHelp helpPopup;
    private boolean changed;
    private boolean applied;

    public ProviderConfigurationWizardPage(AcquireDialog acquireDialog) {
        super(Messages.ProviderConfigurationDialog_ConfigureProvidersDialogTitle, Messages.ProviderConfigurationDialog_ConfigureProvidersDialogTitle, null);
        this.acquireDialog = acquireDialog;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 16);
        composite.setLayout((Layout)new GridLayout(1, false));
        GridDataFactory.fillDefaults().grab(true, true).span(1, 1).applyTo((Control)composite);
        Label providersLabel = new Label(composite, 0);
        providersLabel.setText(Messages.ProviderConfigurationDialog_AvailableProvidersLabel);
        GridDataFactory.swtDefaults().span(1, 1).applyTo((Control)providersLabel);
        this.createProvidersTable(composite);
        Label argumentsLabel = new Label(composite, 0);
        argumentsLabel.setText(Messages.ProviderConfigurationDialog_ConfigurableParameteresLabel);
        GridDataFactory.swtDefaults().span(1, 1).applyTo((Control)argumentsLabel);
        this.createArgumentsTable(composite);
        this.availableProvidersTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.item instanceof TableItem) {
                    AnnotatedObjectArgumentsSet argumentsSet = (AnnotatedObjectArgumentsSet)((TableItem)e.item).getData();
                    ProviderConfigurationWizardPage.this.table.providerSelected(argumentsSet);
                    ProviderConfigurationWizardPage.this.onFocus(null);
                    IPreferenceStore prefs = MemoryAnalyserPlugin.getDefault().getPreferenceStore();
                    if (!prefs.getBoolean(ProviderConfigurationWizardPage.HIDE_QUERY_HELP) || ProviderConfigurationWizardPage.this.helpPopup != null && ProviderConfigurationWizardPage.this.helpPopup.getShell() != null) {
                        ProviderConfigurationWizardPage.this.relocateHelp(true);
                    }
                }
            }
        });
        this.acquireDialog.addProcessSelectionListener(this);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.mat.ui.help.acquire_arguments");
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                ProviderConfigurationWizardPage.this.relocateHelp(false);
            }
        };
        this.getShell().addListener(11, listener);
        this.getShell().addListener(10, listener);
        this.setControl((Control)composite);
    }

    public IWizardPage getNextPage() {
        try {
            if (this.changed) {
                this.applied = true;
                this.applyChanges();
                this.onError(null);
            }
        }
        catch (SnapshotException e) {
            this.onError(e.getLocalizedMessage());
            return null;
        }
        return super.getNextPage();
    }

    private void applyChanges() throws SnapshotException {
        AnnotatedObjectArgumentsSet currentSet = this.table.getArgumentSet();
        if (currentSet != null) {
            this.applyProviderChanges(currentSet);
        }
        TableItem[] tableItemArray = this.availableProvidersTable.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            AnnotatedObjectArgumentsSet argumentSet = (AnnotatedObjectArgumentsSet)item.getData();
            if (argumentSet != currentSet) {
                try {
                    this.applyProviderChanges(argumentSet);
                }
                catch (SnapshotException snapshotException) {
                    // empty catch block
                }
            }
            ++n2;
        }
    }

    private void applyProviderChanges(AnnotatedObjectArgumentsSet argumentSet) throws SnapshotException {
        try {
            HeapDumpProviderDescriptor providerDescriptor = (HeapDumpProviderDescriptor)argumentSet.getDescriptor();
            IHeapDumpProvider impl = providerDescriptor.getHeapDumpProvider();
            for (ArgumentDescriptor parameter : providerDescriptor.getArguments()) {
                Object value = argumentSet.getArgumentValue(parameter);
                if (value == null && parameter.isMandatory() && (value = parameter.getDefaultValue()) == null) {
                    throw new SnapshotException(MessageUtil.format((String)Messages.ProviderConfigurationDialog_MissingParameterErrorMessage, (Object[])new Object[]{parameter.getName()}));
                }
                if (value == null) {
                    if (!argumentSet.getValues().containsKey(parameter)) continue;
                    if (MemoryAnalyserPlugin.getDefault().isDebugging()) {
                        Logger.getLogger(this.getClass().getName()).log(Level.INFO, MessageUtil.format((String)"Setting null value for: {0}", (Object[])new Object[]{parameter.getName()}));
                    }
                    if (parameter.isBoolean()) {
                        parameter.getField().set(impl, parameter.getDefaultValue());
                        continue;
                    }
                    parameter.getField().set(impl, null);
                    continue;
                }
                try {
                    int ii;
                    if (value instanceof ArgumentFactory) {
                        parameter.getField().set(impl, ((ArgumentFactory)value).build(parameter));
                        continue;
                    }
                    if (parameter.isArray()) {
                        List list = (List)value;
                        Object array = Array.newInstance(parameter.getType(), list.size());
                        ii = 0;
                        for (Object v : list) {
                            Array.set(array, ii++, v);
                        }
                        parameter.getField().set(impl, array);
                        continue;
                    }
                    if (parameter.isList()) {
                        List source = (List)value;
                        ArrayList target = new ArrayList(source.size());
                        ii = 0;
                        while (ii < source.size()) {
                            Object v;
                            v = source.get(ii);
                            if (v instanceof ArgumentFactory) {
                                v = ((ArgumentFactory)v).build(parameter);
                            }
                            target.add(v);
                            ++ii;
                        }
                        parameter.getField().set(impl, target);
                        continue;
                    }
                    parameter.getField().set(impl, value);
                }
                catch (IllegalArgumentException e) {
                    throw new SnapshotException(MessageUtil.format((String)Messages.ProviderConfigurationDialog_IllegalArgumentErrorMessage, (Object[])new Object[]{value, value.getClass().getName(), parameter.getName(), parameter.getType().getName()}), (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    throw new SnapshotException(MessageUtil.format((String)"Unable to access field {0} of type {1}", (Object[])new Object[]{parameter.getName(), parameter.getType().getName()}), (Throwable)e);
                }
            }
        }
        catch (IProgressListener.OperationCanceledException e) {
            throw e;
        }
        catch (SnapshotException e) {
            throw e;
        }
        catch (Exception e) {
            throw SnapshotException.rethrow((Throwable)e);
        }
    }

    private void createProvidersTable(Composite parent) {
        Composite tableComposite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, false).indent(0, 0).applyTo((Control)tableComposite);
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        tableComposite.setLayout((Layout)tableColumnLayout);
        this.availableProvidersTable = new Table(tableComposite, 68356);
        TableColumn column1 = new TableColumn(this.availableProvidersTable, 0);
        column1.setText(Messages.ProviderConfigurationDialog_NameColumnHeader);
        tableColumnLayout.setColumnData((Widget)column1, (ColumnLayoutData)new ColumnWeightData(0, 200));
        TableColumn column2 = new TableColumn(this.availableProvidersTable, 0);
        column2.setText(Messages.ProviderConfigurationDialog_DescriptionColumnHeader);
        tableColumnLayout.setColumnData((Widget)column2, (ColumnLayoutData)new ColumnWeightData(100, 250));
        this.availableProvidersTable.setHeaderVisible(true);
        this.availableProvidersTable.setLinesVisible(true);
        AccessibleCompositeAdapter.access(this.availableProvidersTable);
        Collection providers = HeapDumpProviderRegistry.instance().getHeapDumpProviders();
        for (HeapDumpProviderDescriptor heapDumpProviderDescriptor : providers) {
            TableItem item = new TableItem(this.availableProvidersTable, 0, 0);
            item.setData((Object)new AnnotatedObjectArgumentsSet((IAnnotatedObjectDescriptor)heapDumpProviderDescriptor));
            item.setText(0, heapDumpProviderDescriptor.getName());
            if (heapDumpProviderDescriptor.getHelp() == null) continue;
            item.setText(1, heapDumpProviderDescriptor.getHelp());
        }
        tableComposite.layout();
        tableComposite.pack();
    }

    private void createArgumentsTable(Composite parent) {
        ScrolledComposite composite = new ScrolledComposite(parent, 2816);
        composite.setLayout((Layout)new GridLayout());
        composite.setExpandHorizontal(true);
        composite.setExpandVertical(true);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        Composite tableComposite = new Composite((Composite)composite, 0);
        GridDataFactory.fillDefaults().grab(true, true).indent(0, 0).applyTo((Control)tableComposite);
        Dialog.applyDialogFont((Control)composite);
        this.table = new ProviderArgumentsTable(tableComposite, 65540);
        this.table.addListener(this);
        tableComposite.layout();
        tableComposite.pack();
        composite.setContent((Control)tableComposite);
        GridDataFactory.fillDefaults().hint(300, 100).grab(true, true).span(1, 2).applyTo((Control)composite);
    }

    public void relocateHelp(final boolean create) {
        final AnnotatedObjectArgumentsSet argumentSet = this.table.getArgumentSet();
        if (argumentSet == null) {
            return;
        }
        if (argumentSet.getDescriptor().isHelpAvailable() && (create || this.helpPopup != null && this.helpPopup.getShell() != null)) {
            if (this.getShell() == null) {
                this.helpPopup.close();
                return;
            }
            this.getShell().getDisplay().timerExec(100, new Runnable(){

                @Override
                public void run() {
                    if (ProviderConfigurationWizardPage.this.getShell() != null && !ProviderConfigurationWizardPage.this.getShell().isDisposed()) {
                        Rectangle myBounds = ProviderConfigurationWizardPage.this.getShell().getBounds();
                        Rectangle helpBounds = new Rectangle(myBounds.x, myBounds.y + myBounds.height, myBounds.width, -1);
                        if (ProviderConfigurationWizardPage.this.helpPopup != null) {
                            if (!create) {
                                ProviderConfigurationWizardPage.this.helpPopup.resize(helpBounds);
                                return;
                            }
                            ProviderConfigurationWizardPage.this.helpPopup.close();
                        }
                        ProviderConfigurationWizardPage.this.helpPopup = new QueryContextHelp(ProviderConfigurationWizardPage.this.getShell(), argumentSet.getDescriptor(), helpBounds);
                        ProviderConfigurationWizardPage.this.helpPopup.open();
                    }
                }
            });
        }
    }

    public void setVisible(boolean f) {
        if (!f) {
            if (this.applied) {
                this.applied = false;
                this.getControl().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ProviderConfigurationWizardPage.this.acquireDialog.refresh();
                    }
                });
            }
            if (this.helpPopup != null) {
                this.helpPopup.close();
            }
        } else {
            IPreferenceStore prefs = MemoryAnalyserPlugin.getDefault().getPreferenceStore();
            if (!prefs.getBoolean(HIDE_QUERY_HELP)) {
                this.relocateHelp(true);
            }
        }
        super.setVisible(f);
    }

    @Override
    public void onInputChanged() {
        this.onError(null);
        this.getContainer().updateButtons();
    }

    @Override
    public void onValueChanged() {
        if (!this.changed) {
            this.acquireDialog.clearSelection();
            this.changed = true;
        }
        this.getContainer().updateButtons();
    }

    @Override
    public void onError(String message) {
        this.setErrorMessage(message);
        this.onFocus(null);
        this.getContainer().updateButtons();
    }

    @Override
    public void onFocus(String message) {
        if (this.getErrorMessage() != null) {
            this.setMessage(this.getErrorMessage(), 3);
        } else if (message != null) {
            this.setMessage(message, 1);
        } else {
            IAnnotatedObjectDescriptor providerDescriptor = this.table.getProviderDescriptor();
            if (providerDescriptor != null) {
                this.setMessage(providerDescriptor.getName());
            } else {
                this.setMessage(null);
            }
        }
    }

    public boolean canFlipToNextPage() {
        boolean exec = false;
        AnnotatedObjectArgumentsSet argumentSet = this.table.getArgumentSet();
        if (argumentSet != null) {
            exec |= argumentSet.isExecutable();
        } else {
            TableItem[] tableItemArray = this.availableProvidersTable.getItems();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                argumentSet = (AnnotatedObjectArgumentsSet)item.getData();
                exec |= argumentSet.isExecutable();
                ++n2;
            }
        }
        return exec && this.getErrorMessage() == null;
    }

    public boolean isPageComplete() {
        return this.getErrorMessage() == null;
    }

    public void performHelp() {
        String helpUrl;
        AnnotatedObjectArgumentsSet currentSet = this.table.getArgumentSet();
        if (currentSet != null && (helpUrl = currentSet.getDescriptor().getHelpUrl()) != null) {
            PlatformUI.getWorkbench().getHelpSystem().displayHelpResource(helpUrl);
        }
        this.relocateHelp(true);
        PlatformUI.getWorkbench().getHelpSystem().displayHelp("org.eclipse.mat.ui.help.acquire_arguments");
    }

    @Override
    public void processSelected(AnnotatedObjectArgumentsSet argumentSet) {
        if (argumentSet == null) {
            AnnotatedObjectArgumentsSet prev = this.table.getArgumentSet();
            this.table.providerSelected(null);
            this.table.providerSelected(prev);
            return;
        }
        IAnnotatedObjectDescriptor newProviderDescriptor = argumentSet.getDescriptor();
        if (newProviderDescriptor instanceof VmInfoDescriptor) {
            IHeapDumpProvider prov = ((VmInfoDescriptor)newProviderDescriptor).getVmInfo().getHeapDumpProvider();
            int index = 0;
            TableItem[] tableItemArray = this.availableProvidersTable.getItems();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                AnnotatedObjectArgumentsSet argumentSet2 = (AnnotatedObjectArgumentsSet)item.getData();
                IAnnotatedObjectDescriptor desc2 = argumentSet2.getDescriptor();
                if (desc2 instanceof HeapDumpProviderDescriptor && prov.equals(((HeapDumpProviderDescriptor)desc2).getHeapDumpProvider())) {
                    this.availableProvidersTable.setSelection(index);
                    this.table.providerSelected(argumentSet2);
                    break;
                }
                ++index;
                ++n2;
            }
        }
    }
}

