/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.event;

import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.birt.chart.computation.GObjectFactory;
import org.eclipse.birt.chart.computation.IGObjectFactory;
import org.eclipse.birt.chart.event.ChartEvent;
import org.eclipse.birt.chart.event.PrimitiveRenderEvent;
import org.eclipse.birt.chart.event.StructureSource;
import org.eclipse.birt.chart.model.attribute.Cursor;
import org.eclipse.birt.chart.model.attribute.TriggerCondition;
import org.eclipse.birt.chart.model.data.Action;
import org.eclipse.birt.chart.model.data.Trigger;

public final class InteractionEvent
extends ChartEvent {
    private static final long serialVersionUID = -3554746649816942383L;
    private PrimitiveRenderEvent _pre = null;
    private final LinkedHashMap<TriggerCondition, Action> _lhmTriggers = new LinkedHashMap();
    private transient Cursor cursor = null;
    private static final IGObjectFactory goFactory = GObjectFactory.instance();
    private short zOrder = 0;

    public InteractionEvent(Object source) {
        super(source);
        if (!(source instanceof StructureSource)) {
            throw new IllegalArgumentException();
        }
    }

    public StructureSource getStructureSource() {
        return (StructureSource)super.getSource();
    }

    public final void setHotSpot(PrimitiveRenderEvent pre) {
        this._pre = pre;
    }

    public final PrimitiveRenderEvent getHotSpot() {
        return this._pre;
    }

    public final void addTrigger(Trigger t) {
        this._lhmTriggers.put(t.getCondition(), t.getAction());
    }

    public final Action getAction(TriggerCondition tc) {
        return this._lhmTriggers.get((Object)tc);
    }

    public final Trigger[] getTriggers() {
        if (this._lhmTriggers.isEmpty()) {
            return null;
        }
        Trigger[] tga = new Trigger[this._lhmTriggers.size()];
        int i = 0;
        for (Map.Entry<TriggerCondition, Action> entry : this._lhmTriggers.entrySet()) {
            TriggerCondition tcKey = entry.getKey();
            Action acValue = entry.getValue();
            tga[i++] = goFactory.createTrigger(tcKey, acValue);
        }
        return tga;
    }

    @Override
    public void reset() {
        this._pre = null;
        this._lhmTriggers.clear();
    }

    public final void reuse(StructureSource oNewSource) {
        this.source = oNewSource;
        this._lhmTriggers.clear();
    }

    public Cursor getCursor() {
        return this.cursor;
    }

    public void setCursor(Cursor cursor) {
        this.cursor = cursor;
    }

    public short getZOrder() {
        return this.zOrder;
    }

    public void setZOrder(short zOrder) {
        this.zOrder = zOrder;
    }
}

