/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import org.eclipse.birt.core.archive.RAFolderInputStream;
import org.eclipse.birt.core.archive.RAFolderOutputStream;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.core.archive.RAOutputStream;
import org.eclipse.birt.core.archive.compound.ArchiveEntry;

public class FolderArchiveEntry
extends ArchiveEntry {
    protected File file;
    RAInputStream in;
    RAOutputStream out;

    public FolderArchiveEntry(String name, File file, HashSet<RAFolderInputStream> inputs, HashSet<RAFolderOutputStream> outputs) throws IOException {
        super(name);
        this.file = file;
        this.out = new RAFolderOutputStream(outputs, file, true);
        this.in = new RAFolderInputStream(inputs, file);
    }

    @Override
    public long getLength() throws IOException {
        return this.file.length();
    }

    @Override
    public void setLength(long length) throws IOException {
    }

    @Override
    public int read(long pos, byte[] b, int off, int len) throws IOException {
        this.in.seek(pos);
        return this.in.read(b, off, len);
    }

    @Override
    public void write(long pos, byte[] b, int off, int len) throws IOException {
        this.out.seek(pos);
        this.out.write(b, off, len);
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        if (this.in != null) {
            this.in.close();
            this.in = null;
        }
        if (this.out != null) {
            this.out.close();
            this.out = null;
        }
    }
}

