/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.snapshot;

import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.MultipleSnapshotsException;
import org.eclipse.mat.snapshot.SnapshotFactory;
import org.eclipse.mat.snapshot.SnapshotInfo;
import org.eclipse.mat.ui.MemoryAnalyserPlugin;
import org.eclipse.mat.ui.Messages;
import org.eclipse.mat.ui.SnapshotHistoryService;
import org.eclipse.mat.ui.snapshot.RuntimeSelector;
import org.eclipse.mat.ui.util.ErrorHelper;
import org.eclipse.mat.ui.util.ProgressMonitorWrapper;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.MessageUtil;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressConstants;

public abstract class ParseHeapDumpJob
extends Job {
    private final IPath path;
    private final Map<String, String> arguments;

    private static Map<String, String> defaultArguments() {
        HashMap<String, String> args = new HashMap<String, String>();
        IPreferenceStore prefs = MemoryAnalyserPlugin.getDefault().getPreferenceStore();
        if (prefs.getBoolean("keep_unreachable_objects")) {
            args.put("keep_unreachable_objects", Boolean.TRUE.toString());
        }
        if (prefs.getBoolean("discardEnable")) {
            int ratio = prefs.getInt("discard_ratio_percentage");
            args.put("discard_ratio", Integer.toString(ratio));
            int offset = prefs.getInt("discard_offset_percentage");
            args.put("discard_offset", Integer.toString(offset));
            String pattern = prefs.getString("discard_pattern");
            args.put("discard_pattern", pattern);
            int seed = prefs.getInt("discard_seed");
            args.put("discard_seed", Integer.toString(seed));
        }
        return args;
    }

    public ParseHeapDumpJob(IPath path) {
        this(path, ParseHeapDumpJob.defaultArguments());
    }

    public ParseHeapDumpJob(IPath path, Map<String, String> args) {
        super(MessageUtil.format((String)Messages.ParseHeapDumpJob_ParsingHeapDumpFrom, (Object[])new Object[]{path.toOSString()}));
        this.path = path;
        this.arguments = args;
        this.setUser(true);
        this.setRule(new ParseRule(path));
    }

    protected IStatus run(IProgressMonitor monitor) {
        this.setProperty(IProgressConstants.PROPERTY_IN_DIALOG, Boolean.TRUE);
        try {
            ISnapshot snap;
            block6: {
                SnapshotHistoryService.getInstance().addVisitedPath("org.eclipse.mat.ui.editors.HeapEditor", this.path.toOSString());
                snap = null;
                try {
                    snap = SnapshotFactory.openSnapshot((File)this.path.toFile(), this.arguments, (IProgressListener)new ProgressMonitorWrapper(monitor));
                }
                catch (MultipleSnapshotsException mre) {
                    Display display = PlatformUI.getWorkbench().getDisplay();
                    RuntimeSelector runtimeSelector = new RuntimeSelector(mre, display);
                    String selectedId = runtimeSelector.getSelectedRuntimeId();
                    if (selectedId == null) break block6;
                    this.arguments.put("snapshot_identifier", selectedId);
                    snap = SnapshotFactory.openSnapshot((File)this.path.toFile(), this.arguments, (IProgressListener)new ProgressMonitorWrapper(monitor));
                }
            }
            if (snap == null) {
                return Status.CANCEL_STATUS;
            }
            final ISnapshot snapshot = snap;
            SnapshotInfo source = snapshot.getSnapshotInfo();
            SnapshotInfo destination = new SnapshotInfo(source.getPath(), source.getPrefix(), source.getJvmInfo(), source.getIdentifierSize(), source.getCreationDate(), source.getNumberOfObjects(), source.getNumberOfGCRoots(), source.getNumberOfClasses(), source.getNumberOfClassLoaders(), source.getUsedHeapSize());
            this.copyPropertyIfSet(source, destination, "$heapFormat");
            this.copyPropertyIfSet(source, destination, "$useCompressedOops");
            this.copyPropertyIfSet(source, destination, "$runtimeId");
            SnapshotHistoryService.getInstance().addVisitedPath("org.eclipse.mat.ui.editors.HeapEditor", this.path.toOSString(), (Serializable)destination);
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ParseHeapDumpJob.this.finished(snapshot);
                }
            });
            return Status.OK_STATUS;
        }
        catch (IProgressListener.OperationCanceledException e) {
            return Status.CANCEL_STATUS;
        }
        catch (SnapshotException e) {
            return ErrorHelper.createErrorStatus(e);
        }
    }

    private void copyPropertyIfSet(SnapshotInfo source, SnapshotInfo destination, String key) {
        Serializable value = source.getProperty(key);
        if (value != null) {
            destination.setProperty(key, value);
        }
    }

    public boolean isModal() {
        Boolean isModal = (Boolean)this.getProperty(IProgressConstants.PROPERTY_IN_DIALOG);
        if (isModal == null) {
            return false;
        }
        return isModal;
    }

    protected abstract void finished(ISnapshot var1);

    static class ParseRule
    implements ISchedulingRule {
        IPath path;

        public ParseRule(IPath filename) {
            this.path = filename;
        }

        public boolean contains(ISchedulingRule rule) {
            return rule instanceof ParseRule && ((ParseRule)rule).path.equals((Object)this.path);
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return this.contains(rule);
        }
    }
}

