/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.cheatsheets.composite.views;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.internal.cheatsheets.CheatSheetPlugin;
import org.eclipse.ui.internal.cheatsheets.Messages;
import org.eclipse.ui.internal.cheatsheets.registry.CheatSheetRegistryReader;
import org.eclipse.ui.internal.provisional.cheatsheets.TaskExplorer;
import org.osgi.framework.Bundle;

public class TaskExplorerManager {
    private static TaskExplorerManager instance;
    private Map<String, Image> images;

    private TaskExplorerManager() {
    }

    public static TaskExplorerManager getInstance() {
        if (instance == null) {
            instance = new TaskExplorerManager();
        }
        return instance;
    }

    public TaskExplorer getExplorer(String explorerKind) {
        CheatSheetRegistryReader.TaskExplorerNode explorerInfo = CheatSheetRegistryReader.getInstance().findTaskExplorer(explorerKind);
        if (explorerInfo != null) {
            String message;
            TaskExplorer explorerInstance = null;
            Class extClass = null;
            String className = explorerInfo.getClassName();
            try {
                Bundle bundle = Platform.getBundle((String)explorerInfo.getPluginId());
                extClass = bundle.loadClass(className);
            }
            catch (Exception e) {
                message = NLS.bind((String)Messages.ERROR_LOADING_CLASS, (Object[])new Object[]{className});
                CheatSheetPlugin.getPlugin().getLog().error(message, (Throwable)e);
            }
            try {
                if (extClass != null) {
                    Constructor c = extClass.getConstructor(new Class[0]);
                    explorerInstance = (TaskExplorer)c.newInstance(new Object[0]);
                }
            }
            catch (Exception e) {
                message = NLS.bind((String)Messages.ERROR_CREATING_CLASS, (Object[])new Object[]{className});
                CheatSheetPlugin.getPlugin().getLog().error(message, (Throwable)e);
            }
            return explorerInstance;
        }
        return null;
    }

    private ImageDescriptor getImageDescriptor(String explorerKind) {
        CheatSheetRegistryReader.TaskExplorerNode explorerInfo = CheatSheetRegistryReader.getInstance().findTaskExplorer(explorerKind);
        if (explorerInfo == null) {
            return null;
        }
        String iconPath = explorerInfo.getIconPath();
        if (iconPath == null) {
            return null;
        }
        Bundle bundle = Platform.getBundle((String)explorerInfo.getPluginId());
        URL url = FileLocator.find((Bundle)bundle, (IPath)IPath.fromOSString((String)iconPath), null);
        try {
            url = FileLocator.resolve((URL)url);
            return ImageDescriptor.createFromURL((URL)url);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private Map<String, Image> getImages() {
        if (this.images == null) {
            this.initImages();
        }
        return this.images;
    }

    private void initImages() {
        if (this.images == null) {
            String[] ids;
            this.images = new HashMap<String, Image>();
            String[] stringArray = ids = CheatSheetRegistryReader.getInstance().getExplorerIds();
            int n = ids.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                ImageDescriptor descriptor = this.getImageDescriptor(id);
                if (descriptor != null) {
                    this.images.put(id, descriptor.createImage());
                }
                ++n2;
            }
        }
    }

    public String getName(String explorerKind) {
        CheatSheetRegistryReader.TaskExplorerNode explorerInfo = CheatSheetRegistryReader.getInstance().findTaskExplorer(explorerKind);
        if (explorerInfo != null) {
            return explorerInfo.getName();
        }
        return null;
    }

    public Image getImage(String id) {
        return this.getImages().get(id);
    }
}

