/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.dtfj;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.Image;
import com.ibm.dtfj.image.ImageAddressSpace;
import com.ibm.dtfj.image.ImageFactory;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.ImageProcess;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.dtfj.java.JavaClass;
import com.ibm.dtfj.java.JavaClassLoader;
import com.ibm.dtfj.java.JavaField;
import com.ibm.dtfj.java.JavaHeap;
import com.ibm.dtfj.java.JavaLocation;
import com.ibm.dtfj.java.JavaMethod;
import com.ibm.dtfj.java.JavaMonitor;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.dtfj.java.JavaRuntime;
import com.ibm.dtfj.java.JavaStackFrame;
import com.ibm.dtfj.java.JavaThread;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.dtfj.DTFJIndexBuilder;
import org.eclipse.mat.dtfj.MessageFormat;
import org.eclipse.mat.dtfj.Messages;
import org.eclipse.mat.parser.IObjectReader;
import org.eclipse.mat.parser.model.AbstractObjectImpl;
import org.eclipse.mat.parser.model.ClassImpl;
import org.eclipse.mat.parser.model.ClassLoaderImpl;
import org.eclipse.mat.parser.model.InstanceImpl;
import org.eclipse.mat.parser.model.ObjectArrayImpl;
import org.eclipse.mat.parser.model.PrimitiveArrayImpl;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.SnapshotInfo;
import org.eclipse.mat.snapshot.model.Field;
import org.eclipse.mat.snapshot.model.FieldDescriptor;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.ObjectReference;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.VoidProgressListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DTFJHeapObjectReader
implements IObjectReader {
    private static final int LARGE_ARRAY_SIZE = 1000;
    private static final boolean getExtraInfo = true;
    private File file;
    private DTFJIndexBuilder.RuntimeInfo dtfjInfo;
    private ISnapshot snapshot;
    private static final boolean throwExceptions = true;

    public void close() throws IOException {
        DTFJIndexBuilder.DumpCache.releaseDump(this.file, this.dtfjInfo, true);
        this.snapshot = null;
    }

    public <A> A getAddon(Class<A> addon) throws SnapshotException {
        ImageFactory factory = this.dtfjInfo.getImageFactory();
        Image image = this.dtfjInfo.getImage();
        ImageAddressSpace addrSpace = this.dtfjInfo.getImageAddressSpace();
        ImageProcess process = this.dtfjInfo.getImageProcess();
        JavaRuntime jvm = this.dtfjInfo.getJavaRuntime();
        if (image != null && addon.isAssignableFrom(image.getClass())) {
            return addon.cast(image);
        }
        if (jvm != null && addon.isAssignableFrom(jvm.getClass())) {
            return addon.cast(jvm);
        }
        if (addrSpace != null && addon.isAssignableFrom(addrSpace.getClass())) {
            return addon.cast(addrSpace);
        }
        if (process != null && addon.isAssignableFrom(process.getClass())) {
            return addon.cast(process);
        }
        if (factory != null && addon.isAssignableFrom(factory.getClass())) {
            return addon.cast(factory);
        }
        if (addon.isAssignableFrom(ObjectAddressReference.class)) {
            return addon.cast((Object)new ObjectAddressReference());
        }
        return null;
    }

    public void open(ISnapshot snapshot) throws IOException, SnapshotException {
        this.file = new File(snapshot.getSnapshotInfo().getPath());
        this.snapshot = snapshot;
        SnapshotInfo snapinfo = snapshot.getSnapshotInfo();
        DTFJIndexBuilder.RuntimeInfo info = DTFJIndexBuilder.DumpCache.getDump(this.file, snapinfo.getProperty("$heapFormat"));
        Serializable runtimeId = snapinfo.getProperty("$runtimeId");
        this.dtfjInfo = DTFJIndexBuilder.getRuntime(info.getImageFactory(), info.getImage(), runtimeId, null);
    }

    public IObject read(int objectId, ISnapshot snapshot) throws SnapshotException, IOException {
        long addr = snapshot.mapIdToAddress(objectId);
        return this.read(addr, objectId, snapshot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IObject read(long addr, int objectId, ISnapshot snapshot) throws SnapshotException, IOException {
        try {
            Image image = this.dtfjInfo.getImage();
            synchronized (image) {
                IObject ret;
                ClassImpl cls;
                if (objectId != -1 && ((cls = (ClassImpl)snapshot.getClassOf(objectId)).getName().contains("(") || cls.getName().equals("<stack frame>")) && (ret = this.createObject2(snapshot, objectId, addr, cls)) != null) {
                    return ret;
                }
                JavaObject jo = this.getJavaObjectByAddress0(addr);
                Object inst = (objectId == -1 ? jo.isArray() : snapshot.isArray(objectId)) ? this.createArray(snapshot, objectId, addr, jo) : this.createObject(snapshot, objectId, addr, jo);
                return inst;
            }
        }
        catch (MemoryAccessException e) {
            throw new SnapshotException(MessageFormat.format(Messages.DTFJHeapObjectReader_ErrorReadingObjectAtIndex, objectId, DTFJHeapObjectReader.format(addr)), (Throwable)e);
        }
        catch (CorruptDataException e) {
            throw new SnapshotException(MessageFormat.format(Messages.DTFJHeapObjectReader_ErrorReadingObjectAtIndex, objectId, DTFJHeapObjectReader.format(addr)), (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new SnapshotException(MessageFormat.format(Messages.DTFJHeapObjectReader_ErrorReadingObjectAtIndex, objectId, DTFJHeapObjectReader.format(addr)), (Throwable)e);
        }
    }

    private IObject createObject2(ISnapshot snapshot, int objectId, long addr, ClassImpl cls) {
        long prevFrameAddress = 0L;
        Iterator i = this.dtfjInfo.getJavaRuntime().getThreads();
        while (i.hasNext()) {
            Object next = i.next();
            if (next instanceof CorruptData) continue;
            JavaThread jt = (JavaThread)next;
            int pointerSize = snapshot.getSnapshotInfo().getIdentifierSize() * 8;
            int totalDepth = 0;
            Iterator j = jt.getStackFrames();
            while (j.hasNext()) {
                j.next();
                ++totalDepth;
            }
            int depth = 0;
            Iterator j2 = jt.getStackFrames();
            while (j2.hasNext()) {
                Object next2 = j2.next();
                if (!(next2 instanceof CorruptData)) {
                    long currAddr;
                    JavaStackFrame jsf = (JavaStackFrame)next2;
                    prevFrameAddress = currAddr = DTFJIndexBuilder.getFrameAddress(jsf, prevFrameAddress, pointerSize);
                    if (currAddr == addr) {
                        long locaddr;
                        boolean nativ;
                        int compLevel;
                        int lineNumber;
                        String fileName;
                        Field f;
                        JavaLocation jl;
                        ArrayList<Field> fields = new ArrayList<Field>();
                        boolean useMethodName = false;
                        ClassImpl cls1 = cls;
                        while (cls1 != null && !useMethodName) {
                            for (FieldDescriptor fd : cls1.getFieldDescriptors()) {
                                if (!fd.getName().equals("methodName")) continue;
                                useMethodName = true;
                                break;
                            }
                            cls1 = cls1.getSuperClass();
                        }
                        if (useMethodName) {
                            String methodName;
                            try {
                                jl = jsf.getLocation();
                                JavaMethod jm = jl.getMethod();
                                JavaClass jc = jm.getDeclaringClass();
                                String name = jc.getName().replace('/', '.');
                                methodName = String.valueOf(name) + "." + DTFJIndexBuilder.getMethodName(jl.getMethod(), (IProgressListener)new VoidProgressListener());
                            }
                            catch (DataUnavailable e) {
                                methodName = null;
                            }
                            catch (CorruptDataException e) {
                                methodName = null;
                            }
                            f = new Field("methodName", 2, methodName);
                            fields.add(f);
                        }
                        try {
                            jl = jsf.getLocation();
                            fileName = jl.getFilename();
                        }
                        catch (DataUnavailable e) {
                            fileName = null;
                        }
                        catch (CorruptDataException e) {
                            fileName = null;
                        }
                        f = new Field("fileName", 2, (Object)fileName);
                        fields.add(f);
                        try {
                            JavaLocation jl2 = jsf.getLocation();
                            lineNumber = jl2.getLineNumber();
                        }
                        catch (DataUnavailable e) {
                            lineNumber = -1;
                        }
                        catch (CorruptDataException e) {
                            lineNumber = -1;
                        }
                        f = new Field("lineNumber", 10, (Object)lineNumber);
                        fields.add(f);
                        try {
                            JavaLocation jl3 = jsf.getLocation();
                            compLevel = jl3.getCompilationLevel();
                        }
                        catch (ClassCastException e) {
                            compLevel = 0;
                        }
                        catch (CorruptDataException e) {
                            compLevel = 0;
                        }
                        f = new Field("compilationLevel", 10, (Object)compLevel);
                        fields.add(f);
                        try {
                            JavaLocation jl4 = jsf.getLocation();
                            nativ = Modifier.isNative(jl4.getMethod().getModifiers());
                        }
                        catch (ClassCastException e) {
                            nativ = false;
                        }
                        catch (CorruptDataException e) {
                            nativ = false;
                        }
                        Field f2 = new Field("native", 4, (Object)nativ);
                        fields.add(f2);
                        try {
                            JavaLocation jl5 = jsf.getLocation();
                            locaddr = jl5.getAddress().getAddress();
                        }
                        catch (ClassCastException e) {
                            locaddr = 0L;
                        }
                        catch (CorruptDataException e) {
                            locaddr = 0L;
                        }
                        f = new Field("locationAddress", 11, (Object)locaddr);
                        fields.add(f);
                        f = new Field("frameNumber", 10, (Object)depth);
                        fields.add(f);
                        f = new Field("stackDepth", 10, (Object)(totalDepth - depth));
                        fields.add(f);
                        InstanceImpl inst = new InstanceImpl(objectId, addr, cls, fields);
                        return inst;
                    }
                }
                ++depth;
            }
        }
        return null;
    }

    private JavaObject getJavaObjectByAddress0(long addr) throws CorruptDataException, MemoryAccessException {
        ImagePointer ip = this.dtfjInfo.getImageAddressSpace().getPointer(addr);
        try {
            JavaObject jo = this.dtfjInfo.getJavaRuntime().getObjectAtAddress(ip);
            return jo;
        }
        catch (DataUnavailable e) {
            return this.getJavaObjectByAddress(addr);
        }
        catch (LinkageError e) {
            return this.getJavaObjectByAddress(addr);
        }
    }

    private JavaObject getJavaObjectByAddress(long addr) {
        Object next;
        Iterator i = this.dtfjInfo.getJavaRuntime().getThreads();
        while (i.hasNext()) {
            JavaObject jo;
            JavaThread thrd;
            long thAddr;
            next = i.next();
            if (next instanceof CorruptData || addr != (thAddr = DTFJIndexBuilder.getThreadAddress(thrd = (JavaThread)next, null))) continue;
            try {
                jo = thrd.getObject();
            }
            catch (CorruptDataException e) {
                jo = null;
            }
            return jo;
        }
        i = this.dtfjInfo.getJavaRuntime().getMonitors();
        while (i.hasNext()) {
            JavaMonitor mon;
            JavaObject jo;
            next = i.next();
            if (next instanceof CorruptData || (jo = (mon = (JavaMonitor)next).getObject()) == null || jo.getID().getAddress() != addr) continue;
            return jo;
        }
        i = this.dtfjInfo.getJavaRuntime().getJavaClassLoaders();
        while (i.hasNext()) {
            next = i.next();
            if (next instanceof CorruptData) continue;
            JavaClassLoader ldr = (JavaClassLoader)next;
            try {
                JavaObject jo = ldr.getObject();
                if (jo == null || jo.getID().getAddress() != addr) continue;
                return jo;
            }
            catch (CorruptDataException jo) {
                // empty catch block
            }
        }
        i = this.dtfjInfo.getJavaRuntime().getHeaps();
        while (i.hasNext()) {
            next = i.next();
            if (next instanceof CorruptData) continue;
            JavaHeap jh = (JavaHeap)next;
            Iterator j = jh.getObjects();
            while (j.hasNext()) {
                JavaObject jo;
                Object next2 = j.next();
                if (next2 instanceof CorruptData || (jo = (JavaObject)next2).getID().getAddress() != addr) continue;
                return jo;
            }
        }
        throw new IllegalArgumentException(MessageFormat.format(Messages.DTFJHeapObjectReader_JavaObjectAtAddressNotFound, DTFJHeapObjectReader.format(addr)));
    }

    private InstanceImpl createObject(ISnapshot snapshot, int objectId, long addr, JavaObject jo) throws CorruptDataException, MemoryAccessException, SnapshotException {
        ClassImpl cls = this.findClass(snapshot, objectId, jo, addr);
        int nFields = 0;
        ClassImpl cls2 = cls;
        while (cls2 != null) {
            nFields += cls2.getFieldDescriptors().size();
            cls2 = cls2.getSuperClass();
        }
        ArrayList<Field> fields = new ArrayList<Field>(nFields);
        if (nFields > 0) {
            JavaClass jc = jo.getJavaClass();
            while (jc != null) {
                Iterator ii = jc.getDeclaredFields();
                while (ii.hasNext()) {
                    JavaField jf;
                    Object next = ii.next();
                    if (next instanceof CorruptData || Modifier.isStatic((jf = (JavaField)next).getModifiers())) continue;
                    Object val = null;
                    try {
                        Object o = jf.get(jo);
                        if (o instanceof JavaObject) {
                            JavaObject jo2 = (JavaObject)o;
                            long addr2 = jo2.getID().getAddress();
                            val = new ObjectReference(snapshot, addr2);
                        } else if (o instanceof Number || o instanceof Character || o instanceof Boolean || o == null) {
                            val = o;
                        }
                    }
                    catch (CorruptDataException e) {
                        this.logOrThrow(e);
                    }
                    catch (MemoryAccessException e) {
                        this.logOrThrow(e);
                    }
                    Field f = new Field(jf.getName(), DTFJIndexBuilder.signatureToType(jf.getSignature()), val);
                    fields.add(f);
                }
                jc = this.getSuperclass(jc);
            }
        }
        Object inst = snapshot.isClassLoader(objectId) ? new ClassLoaderImpl(objectId, addr, cls, fields) : new InstanceImpl(objectId, addr, cls, fields);
        return inst;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ClassImpl findClass(ISnapshot snapshot, int objectId, JavaObject jo, long addr) throws CorruptDataException, SnapshotException {
        if (objectId != -1) return (ClassImpl)snapshot.getClassOf(objectId);
        JavaClass jc = jo.getJavaClass();
        if (jc == null) throw new SnapshotException(MessageFormat.format(Messages.DTFJHeapObjectReader_ErrorReadingObjectAtIndex, objectId, DTFJHeapObjectReader.format(addr)));
        JavaObject jco = jc.getObject();
        long caddr = jco != null ? jco.getID().getAddress() : jc.getID().getAddress();
        int clsId = snapshot.mapAddressToId(caddr);
        IObject cls1 = snapshot.getObject(clsId);
        if (!(cls1 instanceof ClassImpl)) throw new SnapshotException(MessageFormat.format(Messages.DTFJHeapObjectReader_ErrorReadingObjectAtIndex, objectId, DTFJHeapObjectReader.format(addr)));
        return (ClassImpl)cls1;
    }

    private JavaClass getSuperclass(JavaClass jc) throws CorruptDataException {
        try {
            return jc.getSuperclass();
        }
        catch (CorruptDataException e) {
            return null;
        }
    }

    private IObject createArray(ISnapshot snapshot, int objectId, long addr, JavaObject jo) throws CorruptDataException, MemoryAccessException, SnapshotException {
        ClassImpl cls = this.findClass(snapshot, objectId, jo, addr);
        int offset = 0;
        int length = jo.getArraySize();
        JavaClass arrayClass = jo.getJavaClass();
        if (DTFJIndexBuilder.isPrimitiveArray(arrayClass)) {
            String typeName = arrayClass.getName();
            int type = this.getArrayType(typeName);
            Object res = length < 1000 ? this.getPrimitiveData(jo, type, offset, length) : new DeferredReadArray(objectId, addr, jo);
            PrimitiveArrayImpl ret = new PrimitiveArrayImpl(objectId, addr, cls, length, type);
            ret.setInfo(res);
            return ret;
        }
        Serializable format = snapshot.getSnapshotInfo().getProperty("$heapFormat");
        Object res = !"DTFJ-PHD".equals(format) && length < 1000 ? (Object)this.getObjectData(jo, offset, length) : new DeferredReadArray(objectId, addr, jo);
        ObjectArrayImpl ret = new ObjectArrayImpl(objectId, addr, cls, length);
        ret.setInfo(res);
        return ret;
    }

    private long[] getObjectData(JavaObject jo, int offset, int length) throws CorruptDataException, MemoryAccessException {
        JavaObject[] temp = new JavaObject[length];
        try {
            jo.arraycopy(offset, (Object)temp, 0, length);
        }
        catch (MemoryAccessException e) {
            this.logOrThrow(e);
        }
        long[] res = new long[length];
        int i = 0;
        while (i < length) {
            long addr2;
            res[i] = addr2 = temp[i] == null ? 0L : temp[i].getID().getAddress();
            ++i;
        }
        return res;
    }

    private int getArrayType(String typeName) {
        int type;
        if (typeName.equals("[Z") || typeName.equals("[boolean")) {
            type = 4;
        } else if (typeName.equals("[B") || typeName.equals("[byte")) {
            type = 8;
        } else if (typeName.equals("[C") || typeName.equals("[char")) {
            type = 5;
        } else if (typeName.equals("[S") || typeName.equals("[short")) {
            type = 9;
        } else if (typeName.equals("[I") || typeName.equals("[int")) {
            type = 10;
        } else if (typeName.equals("[F") || typeName.equals("[float")) {
            type = 6;
        } else if (typeName.equals("[J") || typeName.equals("[long")) {
            type = 11;
        } else if (typeName.equals("[D") || typeName.equals("[double")) {
            type = 7;
        } else {
            int type2 = 8;
            throw new IllegalArgumentException(MessageFormat.format(Messages.DTFJHeapObjectReader_UnexpectedTypeName, typeName));
        }
        return type;
    }

    private Object getPrimitiveData(JavaObject jo, int type, int offset, int length) throws CorruptDataException, MemoryAccessException {
        Object[] res;
        switch (type) {
            case 4: {
                res = new boolean[length];
                try {
                    jo.arraycopy(offset, (Object)res, 0, length);
                }
                catch (MemoryAccessException e) {
                    this.logOrThrow(e);
                }
                break;
            }
            case 8: {
                res = new byte[length];
                try {
                    jo.arraycopy(offset, (Object)res, 0, length);
                }
                catch (MemoryAccessException e) {
                    this.logOrThrow(e);
                }
                break;
            }
            case 5: {
                res = new char[length];
                try {
                    jo.arraycopy(offset, (Object)res, 0, length);
                }
                catch (MemoryAccessException e) {
                    this.logOrThrow(e);
                }
                break;
            }
            case 9: {
                res = new short[length];
                try {
                    jo.arraycopy(offset, (Object)res, 0, length);
                }
                catch (MemoryAccessException e) {
                    this.logOrThrow(e);
                }
                break;
            }
            case 10: {
                res = new int[length];
                try {
                    jo.arraycopy(offset, (Object)res, 0, length);
                }
                catch (MemoryAccessException e) {
                    this.logOrThrow(e);
                }
                break;
            }
            case 6: {
                res = new float[length];
                try {
                    jo.arraycopy(offset, (Object)res, 0, length);
                }
                catch (MemoryAccessException e) {
                    this.logOrThrow(e);
                }
                break;
            }
            case 11: {
                res = new long[length];
                try {
                    jo.arraycopy(offset, (Object)res, 0, length);
                }
                catch (MemoryAccessException e) {
                    this.logOrThrow(e);
                }
                break;
            }
            case 7: {
                res = new double[length];
                try {
                    jo.arraycopy(offset, (Object)res, 0, length);
                }
                catch (MemoryAccessException e) {
                    this.logOrThrow(e);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException(MessageFormat.format(Messages.DTFJHeapObjectReader_UnexpectedType, type));
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object readPrimitiveArrayContent(PrimitiveArrayImpl array, int offset, int length) throws IOException, SnapshotException {
        Object res;
        block7: {
            Object info = array.getInfo();
            if (info instanceof DeferredReadArray) {
                DeferredReadArray da = (DeferredReadArray)info;
                try {
                    Image image = this.dtfjInfo.getImage();
                    synchronized (image) {
                        res = this.getPrimitiveData(da.getJo(), array.getType(), offset, length);
                        break block7;
                    }
                }
                catch (CorruptDataException e) {
                    IOException e1 = new IOException(MessageFormat.format(Messages.DTFJHeapObjectReader_ErrorReadingPrimitiveArray, da.getObjectId(), DTFJHeapObjectReader.format(da.getAddr()), offset, length));
                    e1.initCause(e);
                    throw e1;
                }
                catch (MemoryAccessException e) {
                    IOException e1 = new IOException(MessageFormat.format(Messages.DTFJHeapObjectReader_ErrorReadingPrimitiveArray, da.getObjectId(), DTFJHeapObjectReader.format(da.getAddr()), offset, length));
                    e1.initCause(e);
                    throw e1;
                }
            }
            res = Array.newInstance(info.getClass().getComponentType(), length);
            System.arraycopy(info, offset, res, 0, length);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] readObjectArrayContent(ObjectArrayImpl array, int offset, int length) throws IOException, SnapshotException {
        long[] res;
        block7: {
            Object info = array.getInfo();
            if (info instanceof DeferredReadArray) {
                DeferredReadArray da = (DeferredReadArray)info;
                try {
                    Image image = this.dtfjInfo.getImage();
                    synchronized (image) {
                        res = this.getObjectData(da.getJo(), offset, length);
                        break block7;
                    }
                }
                catch (CorruptDataException e) {
                    IOException e1 = new IOException(MessageFormat.format(Messages.DTFJHeapObjectReader_ErrorReadingObjectArray, da.getObjectId(), DTFJHeapObjectReader.format(da.getAddr()), offset, length));
                    e1.initCause(e);
                    throw e1;
                }
                catch (MemoryAccessException e) {
                    IOException e1 = new IOException(MessageFormat.format(Messages.DTFJHeapObjectReader_ErrorReadingObjectArray, da.getObjectId(), DTFJHeapObjectReader.format(da.getAddr()), offset, length));
                    e1.initCause(e);
                    throw e1;
                }
            }
            res = new long[length];
            System.arraycopy(info, offset, res, 0, length);
        }
        return res;
    }

    private static String format(long address) {
        return "0x" + Long.toHexString(address);
    }

    private void logOrThrow(MemoryAccessException e) throws MemoryAccessException {
        throw e;
    }

    private void logOrThrow(CorruptDataException e) throws CorruptDataException {
        throw e;
    }

    static class DeferredReadArray {
        private int objectId;
        private long addr;
        private JavaObject jo;

        public DeferredReadArray(int objectId, long addr, JavaObject jo) {
            this.setObjectId(objectId);
            this.setAddr(addr);
            this.setJo(jo);
        }

        private void setObjectId(int objectId) {
            this.objectId = objectId;
        }

        int getObjectId() {
            return this.objectId;
        }

        private void setAddr(long addr) {
            this.addr = addr;
        }

        long getAddr() {
            return this.addr;
        }

        private void setJo(JavaObject jo) {
            this.jo = jo;
        }

        JavaObject getJo() {
            return this.jo;
        }
    }

    class ObjectAddressReference
    extends ObjectReference {
        private static final long serialVersionUID = 1L;

        public ObjectAddressReference() {
            super(DTFJHeapObjectReader.this.snapshot, 0L);
        }

        public IObject getObject() throws SnapshotException {
            try {
                IObject o = DTFJHeapObjectReader.this.read(this.getObjectAddress(), -1, DTFJHeapObjectReader.this.snapshot);
                ((AbstractObjectImpl)o).setSnapshot(DTFJHeapObjectReader.this.snapshot);
                return o;
            }
            catch (IOException e) {
                throw new SnapshotException((Throwable)e);
            }
        }
    }
}

