/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.reactive.streams.operators.tck.spi;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.eclipse.microprofile.reactive.streams.operators.ProcessorBuilder;
import org.eclipse.microprofile.reactive.streams.operators.tck.spi.AbstractStageVerification;
import org.eclipse.microprofile.reactive.streams.operators.tck.spi.QuietRuntimeException;
import org.eclipse.microprofile.reactive.streams.operators.tck.spi.ReactiveStreamsSpiVerification;
import org.reactivestreams.Processor;
import org.reactivestreams.Publisher;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DistinctStageVerification
extends AbstractStageVerification {
    DistinctStageVerification(ReactiveStreamsSpiVerification.VerificationDeps deps) {
        super(deps);
    }

    @Test
    public void distinctStageShouldReturnDistinctElements() {
        Assert.assertEquals((Collection)((Collection)this.await(this.rs.of((Object[])new Integer[]{1, 2, 2, 3, 2, 1, 3}).distinct().toList().run(this.getEngine()))), Arrays.asList(1, 2, 3));
    }

    @Test
    public void distinctStageShouldReturnAnEmptyStreamWhenCalledOnEmptyStreams() {
        Assert.assertEquals((Collection)((Collection)this.await(this.rs.empty().distinct().toList().run(this.getEngine()))), Collections.emptyList());
    }

    @Test(expectedExceptions={QuietRuntimeException.class}, expectedExceptionsMessageRegExp="failed")
    public void distinctStageShouldPropagateUpstreamExceptions() {
        this.await(this.rs.failed((Throwable)new QuietRuntimeException("failed")).distinct().toList().run(this.getEngine()));
    }

    @Test(expectedExceptions={QuietRuntimeException.class}, expectedExceptionsMessageRegExp="failed")
    public void distinctStageShouldPropagateExceptionsThrownByEquals() {
        CompletableFuture cancelled = new CompletableFuture();
        class ObjectThatThrowsFromEquals {
            ObjectThatThrowsFromEquals() {
            }

            public int hashCode() {
                return 1;
            }

            public boolean equals(Object obj) {
                throw new QuietRuntimeException("failed");
            }
        }
        CompletionStage result = this.rs.of((Object[])new ObjectThatThrowsFromEquals[]{new ObjectThatThrowsFromEquals(), new ObjectThatThrowsFromEquals()}).onTerminate(() -> cancelled.complete(null)).distinct().toList().run(this.getEngine());
        this.await(cancelled);
        this.await(result);
    }

    @Test
    public void distinctStageShouldPropagateCancel() {
        CompletableFuture cancelled = new CompletableFuture();
        this.await(this.infiniteStream().onTerminate(() -> cancelled.complete(null)).distinct().cancel().run(this.getEngine()));
        this.await(cancelled);
    }

    @Test
    public void distinctStageBuilderShouldBeReusable() {
        ProcessorBuilder distinct = this.rs.builder().distinct();
        Assert.assertEquals((Collection)((Collection)this.await(this.rs.of((Object[])new Integer[]{1, 2, 2, 3}).via(distinct).toList().run(this.getEngine()))), Arrays.asList(1, 2, 3));
        Assert.assertEquals((Collection)((Collection)this.await(this.rs.of((Object[])new Integer[]{3, 3, 4, 5}).via(distinct).toList().run(this.getEngine()))), Arrays.asList(3, 4, 5));
    }

    @Override
    List<Object> reactiveStreamsTckVerifiers() {
        return Collections.singletonList(new ProcessorVerification());
    }

    public class ProcessorVerification
    extends AbstractStageVerification.StageProcessorVerification<Integer> {
        public Processor<Integer, Integer> createIdentityProcessor(int bufferSize) {
            return DistinctStageVerification.this.rs.builder().distinct().buildRs(DistinctStageVerification.this.getEngine());
        }

        @Override
        public Publisher<Integer> createFailedPublisher() {
            return DistinctStageVerification.this.rs.failed((Throwable)new RuntimeException("failed")).distinct().buildRs(DistinctStageVerification.this.getEngine());
        }

        public Integer createElement(int element) {
            return element;
        }
    }
}

