/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.reactive.streams.operators.tck.spi;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.eclipse.microprofile.reactive.streams.operators.ProcessorBuilder;
import org.eclipse.microprofile.reactive.streams.operators.tck.spi.AbstractStageVerification;
import org.eclipse.microprofile.reactive.streams.operators.tck.spi.QuietRuntimeException;
import org.eclipse.microprofile.reactive.streams.operators.tck.spi.ReactiveStreamsSpiVerification;
import org.reactivestreams.Processor;
import org.testng.Assert;
import org.testng.annotations.Test;

public class FlatMapCompletionStageVerification
extends AbstractStageVerification {
    FlatMapCompletionStageVerification(ReactiveStreamsSpiVerification.VerificationDeps deps) {
        super(deps);
    }

    @Test
    public void flatMapCsStageShouldMapFutures() throws Exception {
        CompletableFuture<Integer> one = new CompletableFuture<Integer>();
        CompletableFuture<Integer> two = new CompletableFuture<Integer>();
        CompletableFuture<Integer> three = new CompletableFuture<Integer>();
        CompletionStage result = this.rs.of((Object[])new CompletableFuture[]{one, two, three}).flatMapCompletionStage(Function.identity()).toList().run(this.getEngine());
        Thread.sleep(100L);
        one.complete(1);
        two.complete(2);
        three.complete(3);
        Assert.assertEquals((Collection)((Collection)this.await(result)), Arrays.asList(1, 2, 3));
    }

    @Test
    public void flatMapCsStageShouldMaintainOrderOfFutures() throws Exception {
        CompletableFuture<Integer> one = new CompletableFuture<Integer>();
        CompletableFuture<Integer> two = new CompletableFuture<Integer>();
        CompletableFuture<Integer> three = new CompletableFuture<Integer>();
        CompletionStage result = this.rs.of((Object[])new CompletableFuture[]{one, two, three}).flatMapCompletionStage(Function.identity()).toList().run(this.getEngine());
        three.complete(3);
        Thread.sleep(100L);
        two.complete(2);
        Thread.sleep(100L);
        one.complete(1);
        Assert.assertEquals((Collection)((Collection)this.await(result)), Arrays.asList(1, 2, 3));
    }

    @Test
    public void flatMapCsStageShouldOnlyMapOneElementAtATime() throws Exception {
        CompletableFuture<Integer> one = new CompletableFuture<Integer>();
        CompletableFuture<Integer> two = new CompletableFuture<Integer>();
        CompletableFuture<Integer> three = new CompletableFuture<Integer>();
        AtomicInteger concurrentMaps = new AtomicInteger(0);
        CompletionStage result = this.rs.of((Object[])new CompletableFuture[]{one, two, three}).flatMapCompletionStage(i -> {
            Assert.assertEquals((int)1, (int)concurrentMaps.incrementAndGet());
            return i;
        }).toList().run(this.getEngine());
        Thread.sleep(100L);
        concurrentMaps.decrementAndGet();
        one.complete(1);
        Thread.sleep(100L);
        concurrentMaps.decrementAndGet();
        two.complete(2);
        Thread.sleep(100L);
        concurrentMaps.decrementAndGet();
        three.complete(3);
        Assert.assertEquals((Collection)((Collection)this.await(result)), Arrays.asList(1, 2, 3));
    }

    @Test(expectedExceptions={QuietRuntimeException.class}, expectedExceptionsMessageRegExp="failed")
    public void flatMapCsStageShouldPropagateUpstreamErrors() {
        this.await(this.rs.failed((Throwable)new QuietRuntimeException("failed")).flatMapCompletionStage(CompletableFuture::completedFuture).toList().run(this.getEngine()));
    }

    @Test(expectedExceptions={QuietRuntimeException.class}, expectedExceptionsMessageRegExp="failed")
    public void flatMapCsStageShouldHandleErrorsThrownByCallback() {
        CompletableFuture cancelled = new CompletableFuture();
        CompletionStage result = this.infiniteStream().onTerminate(() -> cancelled.complete(null)).flatMapCompletionStage(i -> {
            throw new QuietRuntimeException("failed");
        }).toList().run(this.getEngine());
        this.await(cancelled);
        this.await(result);
    }

    @Test(expectedExceptions={QuietRuntimeException.class}, expectedExceptionsMessageRegExp="failed")
    public void flatMapCsStageShouldHandleFailedCompletionStages() {
        CompletableFuture cancelled = new CompletableFuture();
        CompletionStage result = this.infiniteStream().onTerminate(() -> cancelled.complete(null)).flatMapCompletionStage(i -> {
            CompletableFuture failed = new CompletableFuture();
            failed.completeExceptionally(new QuietRuntimeException("failed"));
            return failed;
        }).toList().run(this.getEngine());
        this.await(cancelled);
        this.await(result);
    }

    @Test
    public void flatMapCsStageShouldPropagateCancel() {
        CompletableFuture cancelled = new CompletableFuture();
        this.await(this.infiniteStream().onTerminate(() -> cancelled.complete(null)).flatMapCompletionStage(CompletableFuture::completedFuture).cancel().run(this.getEngine()));
        this.await(cancelled);
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void flatMapCsStageShouldFailIfNullIsReturned() {
        CompletableFuture cancelled = new CompletableFuture();
        CompletionStage result = this.infiniteStream().onTerminate(() -> cancelled.complete(null)).flatMapCompletionStage(t -> CompletableFuture.completedFuture(null)).toList().run(this.getEngine());
        this.await(cancelled);
        this.await(result);
    }

    @Test
    public void flatMapCsStageBuilderShouldBeResuable() {
        ProcessorBuilder mapper = this.rs.builder().flatMapCompletionStage(i -> CompletableFuture.completedFuture(i + 1));
        Assert.assertEquals((Collection)((Collection)this.await(this.rs.of((Object[])new Integer[]{1, 2, 3}).via(mapper).toList().run(this.getEngine()))), Arrays.asList(2, 3, 4));
        Assert.assertEquals((Collection)((Collection)this.await(this.rs.of((Object[])new Integer[]{4, 5, 6}).via(mapper).toList().run(this.getEngine()))), Arrays.asList(5, 6, 7));
    }

    @Override
    List<Object> reactiveStreamsTckVerifiers() {
        return Collections.singletonList(new ProcessorVerification());
    }

    public class ProcessorVerification
    extends AbstractStageVerification.StageProcessorVerification<Integer> {
        public Processor<Integer, Integer> createIdentityProcessor(int bufferSize) {
            return FlatMapCompletionStageVerification.this.rs.builder().flatMapCompletionStage(CompletableFuture::completedFuture).buildRs(FlatMapCompletionStageVerification.this.getEngine());
        }

        public Integer createElement(int element) {
            return element;
        }
    }
}

