/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.etl;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import org.eclipse.epsilon.common.parse.problem.ParseProblem;
import org.eclipse.epsilon.eol.IEolExecutableModule;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.context.Variable;
import org.eclipse.epsilon.eol.models.IModel;
import org.eclipse.qvtd.compiler.internal.etl.QvtMtcExecutionException;

public abstract class EpsilonTask {
    protected URI sourceURI;
    protected List<IModel> models;
    protected IEolExecutableModule module;
    protected Object result;

    public abstract IEolExecutableModule createModule();

    public URI getSourceURI() {
        return this.sourceURI;
    }

    public void setSourceURI(URI sourceURI) {
        this.sourceURI = sourceURI;
    }

    public List<IModel> getModels() {
        return this.models;
    }

    public void setModels(List<IModel> models) {
        this.models = models;
    }

    public void addModel(IModel model) {
        this.models.add(model);
    }

    public void removeModel(IModel model) {
        this.models.remove(model);
    }

    public void removeAllModels() {
        this.models.clear();
    }

    public List<IModel> getModuleModels() {
        return this.module.getContext().getModelRepository().getModels();
    }

    public void postProcess() {
    }

    public void preProcess() {
    }

    public void execute() throws QvtMtcExecutionException {
        this.execute(Collections.emptyList());
    }

    public void execute(List<Variable> parameters) throws QvtMtcExecutionException {
        this.module = this.createModule();
        try {
            this.module.parse(this.sourceURI);
        }
        catch (Exception e) {
            throw new QvtMtcExecutionException("There was an error loading the source.", e.getCause());
        }
        if (this.module.getParseProblems().size() > 0) {
            StringBuilder sb = new StringBuilder();
            for (ParseProblem problem : this.module.getParseProblems()) {
                sb.append(String.valueOf(problem.toString()) + "\\n");
            }
            throw new QvtMtcExecutionException("Parse errors occured: " + sb.toString());
        }
        for (IModel model : this.getModels()) {
            this.module.getContext().getModelRepository().addModel(model);
        }
        for (Variable param : parameters) {
            this.module.getContext().getFrameStack().put(param);
        }
        this.preProcess();
        try {
            this.result = this.execute(this.module);
        }
        catch (EolRuntimeException e) {
            throw new QvtMtcExecutionException(e.getMessage(), e.getCause());
        }
        this.postProcess();
        for (IModel model : this.getModels()) {
            if (model.isStoredOnDisposal()) {
                model.store();
            }
            this.module.getContext().getModelRepository().removeModel(model);
        }
    }

    protected Object execute(IEolExecutableModule module) throws EolRuntimeException {
        return module.execute();
    }

    public Object getResult() {
        return this.result;
    }
}

