/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts.merger;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.ContentsAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.ScheduleManager;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.merger.AbstractMerger;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.merger.Correlator;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.merger.RegionMerger;
import org.eclipse.qvtd.pivot.qvtschedule.ClassDatum;
import org.eclipse.qvtd.pivot.qvtschedule.MappingRegion;
import org.eclipse.qvtd.pivot.qvtschedule.NavigableEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.NodeConnection;
import org.eclipse.qvtd.pivot.qvtschedule.Region;
import org.eclipse.qvtd.pivot.qvtschedule.ScheduledRegion;
import org.eclipse.qvtd.pivot.qvtschedule.impl.NamedMappingRegionImpl;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

public class LateConsumerMerger
extends AbstractMerger {
    protected final @NonNull ScheduleManager scheduleManager;
    protected final @NonNull ScheduledRegion scheduledRegion;
    protected final @NonNull List<@NonNull Region> allRegions = new ArrayList<Region>();
    private ContentsAnalysis contentsAnalysis;
    private final @NonNull Map<@NonNull MappingRegion, @NonNull List<@NonNull MappingRegion>> newRegion2oldRegions = new HashMap<MappingRegion, List<MappingRegion>>();
    protected final @NonNull LateStrategy LateStrategy_INSTANCE = new LateStrategy();

    public static @NonNull Map<@NonNull MappingRegion, @NonNull List<@NonNull MappingRegion>> merge(@NonNull ScheduleManager scheduleManager, @NonNull ScheduledRegion scheduledRegion) {
        LateConsumerMerger lateMerger = new LateConsumerMerger(scheduleManager, scheduledRegion);
        lateMerger.merge();
        lateMerger.prune();
        scheduleManager.writeDebugGraphs("8-late", true, true, false);
        return lateMerger.getMerges();
    }

    public LateConsumerMerger(@NonNull ScheduleManager scheduleManager, @NonNull ScheduledRegion scheduledRegion) {
        this.scheduleManager = scheduleManager;
        this.scheduledRegion = scheduledRegion;
        this.gatherRegions((Region)scheduledRegion);
    }

    private void gatherRegions(@NonNull Region parentRegion) {
        for (Region childRegion : parentRegion.getCallableChildren()) {
            this.allRegions.add(childRegion);
            this.gatherRegions(childRegion);
        }
    }

    protected @NonNull ContentsAnalysis getContentsAnalysis() {
        ContentsAnalysis contentsAnalysis2 = this.contentsAnalysis;
        if (contentsAnalysis2 == null) {
            contentsAnalysis2 = this.contentsAnalysis = new ContentsAnalysis(this.scheduleManager);
            for (Region region : this.allRegions) {
                contentsAnalysis2.addRegion(region);
            }
        }
        return contentsAnalysis2;
    }

    public @NonNull Map<@NonNull MappingRegion, @NonNull List<@NonNull MappingRegion>> getMerges() {
        return this.newRegion2oldRegions;
    }

    private void merge() {
        this.mergeHierarchy((Region)this.scheduledRegion);
    }

    private void mergeHierarchy(@NonNull Region parentRegion) {
        for (Region childRegion : parentRegion.getCallableChildren()) {
            this.mergeHierarchy(childRegion);
            this.mergeRegion(childRegion);
        }
    }

    private void mergeRegion(@NonNull Region parentRegion) {
        for (NodeConnection nodeConnection : parentRegion.getRootConnections()) {
            Iterable<@NonNull List<@NonNull MappingRegion>> consecutiveRegionRuns = this.selectConsecutiveRegionRuns(nodeConnection);
            for (List<MappingRegion> consecutiveRegionRun : consecutiveRegionRuns) {
                StringBuilder s = new StringBuilder();
                s.append(Iterables.size(consecutiveRegionRun));
                for (Region region : consecutiveRegionRun) {
                    s.append(" " + region);
                }
                this.mergeRegions(consecutiveRegionRun);
            }
        }
    }

    protected void mergeRegions(@NonNull List<@NonNull MappingRegion> consecutiveRegionRun) {
        ArrayList<@NonNull MappingRegion> residualInputRegions = new ArrayList<MappingRegion>(consecutiveRegionRun);
        while (residualInputRegions.size() >= 2) {
            MappingRegion primaryRegion = (MappingRegion)residualInputRegions.remove(0);
            if (LATE.isActive()) {
                LATE.println("Correlating primary: " + primaryRegion + "@[" + primaryRegion.getIndexRangeText() + "]");
            }
            if (primaryRegion.getIntermediateConnections().size() > 0) {
                if (FAILURE.isActive()) {
                    FAILURE.println("Intermediate connections not yet supported");
                }
                return;
            }
            RegionMerger regionMerger = null;
            int i = 0;
            while (i < residualInputRegions.size()) {
                MappingRegion secondaryRegion = (MappingRegion)residualInputRegions.get(i);
                if (LATE.isActive()) {
                    LATE.println("Correlating secondary: " + secondaryRegion + "@[" + secondaryRegion.getIndexRangeText() + "]");
                }
                if (secondaryRegion.getIntermediateConnections().size() > 0) {
                    if (FAILURE.isActive()) {
                        FAILURE.println("Intermediate connections not yet supported");
                    }
                } else {
                    Correlator correlator = Correlator.correlate(secondaryRegion, primaryRegion, this.LateStrategy_INSTANCE, null);
                    if (correlator != null) {
                        boolean doMerge = false;
                        if (!this.isSharedHead((Region)primaryRegion, (Region)secondaryRegion)) {
                            doMerge = true;
                        } else {
                            if (LATE.isActive()) {
                                LATE.println("Correlating inverse");
                            }
                            if (Correlator.correlate(primaryRegion, secondaryRegion, this.LateStrategy_INSTANCE, correlator.getNode2Node()) != null) {
                                doMerge = true;
                            }
                        }
                        if (doMerge) {
                            if (regionMerger == null) {
                                regionMerger = new LateRegionMerger(this.scheduleManager, primaryRegion);
                            }
                            regionMerger.addSecondaryRegion(secondaryRegion, correlator.getNode2Node());
                        }
                    }
                }
                ++i;
            }
            if (regionMerger == null) continue;
            regionMerger.prune();
            MappingRegion mergedRegion = regionMerger.create();
            regionMerger.check(mergedRegion);
            ((LateRegionMerger)regionMerger).install(this.getContentsAnalysis(), mergedRegion);
            ArrayList<@NonNull MappingRegion> oldRegions = new ArrayList<MappingRegion>();
            oldRegions.add(primaryRegion);
            oldRegions.addAll(regionMerger.getSecondaryRegions());
            this.newRegion2oldRegions.put(mergedRegion, oldRegions);
            residualInputRegions.removeAll(oldRegions);
            for (Region region : oldRegions) {
                Iterator iterator = region.getIndexes().iterator();
                while (iterator.hasNext()) {
                    int index = (Integer)iterator.next();
                    mergedRegion.addIndex(index);
                }
            }
            this.scheduleManager.writeDebugGraphs((Region)mergedRegion, null);
        }
    }

    private void prune() {
        for (List<MappingRegion> oldRegions : this.newRegion2oldRegions.values()) {
            for (MappingRegion mappingRegion : oldRegions) {
            }
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected @NonNull Iterable<@NonNull List<@NonNull MappingRegion>> selectConsecutiveRegionRuns(@NonNull NodeConnection nodeConnection) {
        HashMap<@NonNull Integer, @NonNull MappingRegion> index2region = new HashMap<Integer, MappingRegion>();
        for (Region targetRegion : nodeConnection.getTargetRegions()) {
            if (!(targetRegion instanceof MappingRegion)) continue;
            @NonNull List indexes = targetRegion.getIndexes();
            index2region.put((Integer)indexes.get(indexes.size() - 1), (MappingRegion)targetRegion);
        }
        ArrayList<@NonNull K> orderedIndexes = new ArrayList(index2region.keySet());
        Collections.sort(orderedIndexes);
        ArrayList<@NonNull List<@NonNull MappingRegion>> consecutiveRegionRuns = new ArrayList<List<MappingRegion>>();
        ArrayList<MappingRegion> consecutiveRegionRun = null;
        for (Integer index : orderedIndexes) {
            MappingRegion childRegion = (MappingRegion)index2region.get(index);
            assert (childRegion != null);
            if (consecutiveRegionRun == null || ((MappingRegion)consecutiveRegionRun.get(consecutiveRegionRun.size() - 1)).getLastIndex() + 1 != index) {
                consecutiveRegionRun = new ArrayList<MappingRegion>();
                consecutiveRegionRuns.add(consecutiveRegionRun);
            }
            consecutiveRegionRun.add(childRegion);
        }
        int i = consecutiveRegionRuns.size();
        while (--i >= 0) {
            @NonNull List consecutiveRegionRun2 = (List)consecutiveRegionRuns.get(i);
            if (consecutiveRegionRun2.size() > 1) continue;
            consecutiveRegionRuns.remove(i);
        }
        return consecutiveRegionRuns;
    }

    public static class LateMergedMappingRegion
    extends NamedMappingRegionImpl {
        public LateMergedMappingRegion(@NonNull ScheduleManager scheduleManager, @NonNull String name) {
            scheduleManager.addMappingRegion((MappingRegion)this);
            this.setName(name);
            this.setSymbolNameSuffix("_lc");
        }
    }

    protected static class LateRegionMerger
    extends RegionMerger {
        protected LateRegionMerger(@NonNull ScheduleManager scheduleManager, @NonNull MappingRegion primaryRegion) {
            super(scheduleManager, primaryRegion);
        }

        @Override
        protected @NonNull MappingRegion createNewRegion(@NonNull String newName) {
            return new LateMergedMappingRegion(this.scheduleManager, newName);
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        public void install(@NonNull ContentsAnalysis contentsAnalysis, @NonNull MappingRegion mergedRegion) {
            ScheduledRegion invokingRegion = QVTscheduleUtil.getContainingScheduledRegion((Region)this.primaryRegion);
            @NonNull ArrayList callableParents = Lists.newArrayList((Iterable)this.primaryRegion.getCallableParents());
            contentsAnalysis.removeRegion((Region)this.primaryRegion);
            for (Region callableParent : callableParents) {
                callableParent.replaceCallToChild((Region)this.primaryRegion, (Region)mergedRegion);
            }
            this.scheduleManager.setScheduledRegion(this.primaryRegion, invokingRegion);
            for (MappingRegion secondaryRegion : this.secondaryRegions) {
                contentsAnalysis.removeRegion((Region)secondaryRegion);
                assert (invokingRegion == secondaryRegion.getScheduledRegion());
                for (Region callableParent : callableParents) {
                    callableParent.removeCallToChild((Region)secondaryRegion);
                }
                this.scheduleManager.setScheduledRegion(secondaryRegion, invokingRegion);
            }
            contentsAnalysis.addRegion((Region)mergedRegion);
            this.scheduleManager.setScheduledRegion(mergedRegion, invokingRegion);
            for (Node oldHeadNode : QVTscheduleUtil.getHeadNodes((Region)this.primaryRegion)) {
                NodeConnection incomingConnection = oldHeadNode.getIncomingConnection();
                if (incomingConnection == null) continue;
                Node newHeadNode = this.getNodeMerger(oldHeadNode).getNewNode();
                incomingConnection.addPassedTargetNode(newHeadNode);
                incomingConnection.removeTargetRegion((Region)this.primaryRegion);
                for (Region secondaryRegion : this.secondaryRegions) {
                    incomingConnection.removeTargetRegion(secondaryRegion);
                }
            }
        }
    }

    private class LateStrategy
    extends Correlator.AbstractCorrelationStrategy {
        private LateStrategy() {
        }

        @Override
        public boolean navigableEdgesMatch(@NonNull NavigableEdge secondaryEdge, @Nullable NavigableEdge primaryEdge) {
            if (secondaryEdge.isSecondary()) {
                return true;
            }
            Property property = secondaryEdge.getProperty();
            if (primaryEdge == null) {
                if (!secondaryEdge.isMatched()) {
                    return true;
                }
                if (property.isIsMany() && ((CollectionType)property.getType()).getLower().intValue() == 0) {
                    return true;
                }
                if (secondaryEdge.isConstant()) {
                    if (this.debugFailures) {
                        FAILURE.println("Missing constant : " + secondaryEdge);
                    }
                    return false;
                }
                if (secondaryEdge.isLoaded()) {
                    if (this.debugFailures) {
                        FAILURE.println("Missing loaded : " + secondaryEdge);
                    }
                    return false;
                }
                if (secondaryEdge.isNew()) {
                    return true;
                }
                if (secondaryEdge.isOld()) {
                    if (!secondaryEdge.getEdgeTarget().isRequired()) {
                        return true;
                    }
                    if (!property.isIsRequired()) {
                        return true;
                    }
                    ClassDatum classDatum = QVTscheduleUtil.getClassDatum((Node)secondaryEdge.getEdgeTarget());
                    Iterable<@NonNull NavigableEdge> realizedEdges = LateConsumerMerger.this.getContentsAnalysis().getNewEdges(secondaryEdge, classDatum);
                    if (realizedEdges != null) {
                        int firstIndex = secondaryEdge.getOwningRegion().getFirstIndex();
                        for (NavigableEdge realizedEdge : realizedEdges) {
                            Region region = realizedEdge.getOwningRegion();
                            int lastIndex = region.getLastIndex();
                            if (lastIndex < firstIndex) continue;
                            if (this.debugFailures) {
                                FAILURE.println("Not ready : " + realizedEdge);
                            }
                            return false;
                        }
                        return true;
                    }
                    this.toString();
                }
                if (this.debugFailures) {
                    FAILURE.println("Missing predicated match for : " + secondaryEdge);
                }
                return false;
            }
            assert (primaryEdge.getProperty() == property);
            if (!primaryEdge.isUnconditional()) {
                return true;
            }
            if (secondaryEdge.isConstant() || primaryEdge.isConstant()) {
                if (secondaryEdge.isConstant() != primaryEdge.isConstant()) {
                    System.out.println("Inconsistent constant: " + secondaryEdge + ", " + primaryEdge);
                }
                return true;
            }
            if (secondaryEdge.isLoaded() || primaryEdge.isLoaded()) {
                if (secondaryEdge.isLoaded() != primaryEdge.isLoaded()) {
                    System.out.println("Inconsistent loaded: " + secondaryEdge + ", " + primaryEdge);
                }
                return true;
            }
            if (secondaryEdge.isNew() || primaryEdge.isNew()) {
                if (secondaryEdge.isNew() == primaryEdge.isNew()) {
                    System.out.println("Inconsistent new: " + secondaryEdge + ", " + primaryEdge);
                }
                return true;
            }
            if (secondaryEdge.isOld() || primaryEdge.isOld()) {
                if (secondaryEdge.isOld() != primaryEdge.isOld()) {
                    System.out.println("Inconsistent old: " + secondaryEdge + ", " + primaryEdge);
                }
                return true;
            }
            if (this.debugFailures) {
                FAILURE.println("Inconsistent edges : " + secondaryEdge + ", " + primaryEdge);
            }
            return false;
        }

        @Override
        public boolean navigableNodesMatch(@NonNull Node secondaryNode, @Nullable Node primaryNode) {
            if (!secondaryNode.isRequired() || !secondaryNode.isUnconditional()) {
                return true;
            }
            if (primaryNode == null) {
                return true;
            }
            if (!primaryNode.isRequired() || !primaryNode.isUnconditional()) {
                return true;
            }
            if (secondaryNode.isConstant() || primaryNode.isConstant()) {
                if (secondaryNode.isConstant() != primaryNode.isConstant()) {
                    System.out.println("Inconsistent constant: " + secondaryNode + ", " + primaryNode);
                }
                return true;
            }
            if (secondaryNode.isLoaded() || primaryNode.isLoaded()) {
                if (secondaryNode.isLoaded() != primaryNode.isLoaded()) {
                    System.out.println("Inconsistent loaded: " + secondaryNode + ", " + primaryNode);
                }
                return true;
            }
            if (secondaryNode.isNew() || primaryNode.isNew()) {
                if (secondaryNode.isNew() == primaryNode.isNew()) {
                    System.out.println("Inconsistent new: " + secondaryNode + ", " + primaryNode);
                }
                return true;
            }
            if (secondaryNode.isOld() || primaryNode.isOld()) {
                if (secondaryNode.isOld() != primaryNode.isOld()) {
                    System.out.println("Inconsistent old: " + secondaryNode + ", " + primaryNode);
                }
                return true;
            }
            if (this.debugFailures) {
                FAILURE.println("Inconsistent nodes : " + secondaryNode + ", " + primaryNode);
            }
            return false;
        }
    }
}

