/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.ui.wizards.project;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.m2m.internal.qvt.oml.ui.QVTUIPlugin;
import org.eclipse.m2m.internal.qvt.oml.ui.wizards.project.Messages;
import org.eclipse.m2m.internal.qvt.oml.ui.wizards.project.QVTProjectFieldData;
import org.eclipse.m2m.internal.qvt.oml.ui.wizards.project.SourceContainerUpdater;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;

public class NewQVTProjectCreationPage
extends WizardNewProjectCreationPage {
    private QVTProjectFieldData fCreationData;
    private Text fSourceText;
    private Text fOutputText;
    private Button fSimpleProject;
    private Button fSimplePlugin;
    private Button fJavaPlugin = null;
    private Group fJavaSettingsGroup;
    private Label fSourceLabel;
    private Label fOutputLabel;
    private Label fQvtSourceContainerLabel;
    private Text fQvtSourceContainerText;

    public NewQVTProjectCreationPage(String pageName, QVTProjectFieldData data) {
        super(pageName);
        this.fCreationData = data;
    }

    protected boolean validatePage() {
        IPath projectLocation;
        File projectFile;
        IPath wsLocation;
        boolean result = super.validatePage();
        if (result && this.getProjectHandle() != null && (wsLocation = this.getProjectHandle().getWorkspace().getRoot().getLocation()) != null && (projectFile = Path.fromOSString((String)(projectLocation = wsLocation.append(this.getProjectHandle().getName())).toOSString()).toFile()).exists()) {
            try {
                projectFile = projectFile.getCanonicalFile();
            }
            catch (IOException e) {
                QVTUIPlugin.log(e);
            }
            String errMessage = NLS.bind((String)"Project ''{0}'' already exists in the workspace", (Object)projectFile.getName());
            this.setErrorMessage(errMessage);
            return false;
        }
        if (result && !this.validateQvtSourceContainer()) {
            return false;
        }
        return result;
    }

    protected boolean validateQvtSourceContainer() {
        IStatus status = SourceContainerUpdater.validate(this.getQVTSourceContainerValue());
        if (!status.isOK()) {
            int type = 0;
            switch (status.getSeverity()) {
                case 1: {
                    type = 1;
                    break;
                }
                case 2: {
                    type = 2;
                    break;
                }
                case 4: {
                    type = 3;
                }
            }
            this.setMessage(status.getMessage(), type);
            return status.getSeverity() <= 1;
        }
        return true;
    }

    protected String getQVTSourceContainerValue() {
        return this.fQvtSourceContainerText != null ? this.fQvtSourceContainerText.getText() : null;
    }

    public IContainer getQVTSourceContainerHandle() {
        String value = this.getQVTSourceContainerValue();
        if (value == null || value.length() == 0) {
            return this.getProjectHandle();
        }
        return this.getProjectHandle().getFolder(value);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        Composite control = (Composite)this.getControl();
        GridLayout layout = new GridLayout();
        control.setLayout((Layout)layout);
        this.createQVTSourceContainer(control);
        this.createProjectTypeGroup(control);
        Dialog.applyDialogFont((Control)control);
        this.setControl((Control)control);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)control, "org.eclipse.m2m.qvt.oml.transformation_project");
    }

    private void createQVTSourceContainer(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        gd.verticalIndent = 15;
        composite.setLayoutData((Object)gd);
        String tooltipText = "Enter a path of folder to contain QVT sources";
        this.fQvtSourceContainerLabel = new Label(composite, 0);
        this.fQvtSourceContainerLabel.setText("&QVT source container:");
        this.fQvtSourceContainerLabel.setToolTipText(tooltipText);
        this.fQvtSourceContainerText = this.createText(composite, "transforms");
        this.fQvtSourceContainerText.setToolTipText(tooltipText);
    }

    private void createProjectTypeGroup(Composite parent) {
        Composite container = new Composite(parent, 10);
        container.setLayout((Layout)new GridLayout());
        container.setLayoutData((Object)new GridData(1808));
        Group projectTypeGroup = new Group(container, 16);
        projectTypeGroup.setText(Messages.ProjectStructurePage_createProjectType);
        GridLayout projectTypeLayout = new GridLayout();
        projectTypeLayout.numColumns = 1;
        projectTypeGroup.setLayout((Layout)projectTypeLayout);
        projectTypeGroup.setLayoutData((Object)new GridData(1808));
        GridData gd = new GridData(768);
        gd.verticalIndent = 5;
        this.fSimpleProject = new Button((Composite)projectTypeGroup, 16);
        this.fSimpleProject.setText(Messages.ProjectStructurePage_createSimpleProject);
        this.fSimpleProject.setLayoutData((Object)new GridData(768));
        this.fSimpleProject.setSelection(true);
        this.fSimplePlugin = new Button((Composite)projectTypeGroup, 16);
        this.fSimplePlugin.setText(Messages.ProjectStructurePage_createSimplePluginProject);
        this.fSimplePlugin.setLayoutData((Object)gd);
        this.fJavaPlugin = new Button((Composite)projectTypeGroup, 16);
        this.fJavaPlugin.setText(Messages.ProjectStructurePage_createJavaPluginProject);
        this.fJavaPlugin.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewQVTProjectCreationPage.this.updateControls();
            }
        });
        this.fJavaPlugin.setLayoutData((Object)gd);
        this.fJavaSettingsGroup = new Group((Composite)projectTypeGroup, 0);
        this.fJavaSettingsGroup.setText(Messages.ProjectStructurePage_JavaProjectSettings);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        this.fJavaSettingsGroup.setLayout((Layout)layout);
        this.fJavaSettingsGroup.setLayoutData((Object)new GridData(768));
        this.fSourceLabel = this.createLabel((Composite)this.fJavaSettingsGroup, Messages.ProjectStructurePage_source);
        this.fSourceText = this.createText((Composite)this.fJavaSettingsGroup, "src");
        this.fSourceText.setLayoutData((Object)new GridData(768));
        this.fOutputLabel = this.createLabel((Composite)this.fJavaSettingsGroup, Messages.ProjectStructurePage_output);
        this.fOutputText = this.createText((Composite)this.fJavaSettingsGroup, "bin");
        this.fOutputLabel.setLayoutData((Object)new GridData(768));
        this.updateControls();
    }

    private void updateControls() {
        this.fCreationData.setPlugin(this.fJavaPlugin.getSelection());
        this.fCreationData.setSimple(!this.fJavaPlugin.getSelection());
        this.fJavaSettingsGroup.setEnabled(this.fJavaPlugin.getSelection());
        this.fSourceLabel.setEnabled(this.fJavaPlugin.getSelection());
        this.fSourceText.setEnabled(this.fJavaPlugin.getSelection());
        this.fOutputLabel.setEnabled(this.fJavaPlugin.getSelection());
        this.fOutputText.setEnabled(this.fJavaPlugin.getSelection());
    }

    private Label createLabel(Composite container, String text) {
        Label label = new Label(container, 0);
        label.setText(text);
        GridData gd = new GridData();
        label.setLayoutData((Object)gd);
        return label;
    }

    private Text createText(Composite container, String txtValue) {
        Text text = new Text(container, 2052);
        GridData gd = new GridData(768);
        gd.widthHint = 300;
        text.setLayoutData((Object)gd);
        if (txtValue != null) {
            text.setText(txtValue);
        }
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewQVTProjectCreationPage.this.validatePage();
            }
        });
        return text;
    }

    public IWizardPage getNextPage() {
        this.updateData();
        return super.getNextPage();
    }

    public void updateData() {
        this.fCreationData.setPlugin(!this.fSimpleProject.getSelection());
        this.fCreationData.setProjectName(this.getProjectName());
        this.fCreationData.setSimple(!this.fJavaPlugin.getSelection());
        if (this.fJavaPlugin.getSelection()) {
            this.fCreationData.setSourceFolderName(this.fSourceText.getText().trim());
            this.fCreationData.setOutputFolderName(this.fOutputText.getText().trim());
        } else {
            this.fCreationData.setSourceFolderName(null);
            this.fCreationData.setOutputFolderName(null);
        }
    }

    public boolean isCreatePlugin() {
        return this.fSimpleProject != null && !this.fSimpleProject.getSelection();
    }

    public boolean isJavaPlugin() {
        return this.fJavaPlugin != null && !this.fJavaPlugin.getSelection();
    }
}

