/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amalgam.discovery.ui.common.internal;

import java.util.Hashtable;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class GradientCanvas
extends Canvas {
    private static final int SEPARATOR = 2;
    private static final int BOTTOM_SEPARATOR = 4;
    private static final int BACKGROUND_IMAGE_TILED = 8;
    public static final String COLOR_BASE_BG = "baseBg";
    static String PREFIX = "org.eclipse.ui.forms.";
    static String H_PREFIX = String.valueOf(PREFIX) + "H_";
    public static String H_BOTTOM_KEYLINE1 = String.valueOf(H_PREFIX) + "BOTTOM_KEYLINE1";
    public static String H_BOTTOM_KEYLINE2 = String.valueOf(H_PREFIX) + "BOTTOM_KEYLINE2";
    private Image backgroundImage;
    private Image gradientImage;
    Hashtable colors = new Hashtable();
    private int flags;
    private GradientInfo gradientInfo;

    public boolean forceFocus() {
        return false;
    }

    public GradientCanvas(Composite parent, int style) {
        super(parent, style);
        this.setBackgroundMode(1);
        this.setSeparatorAlignment(1024);
        this.addListener(9, new Listener(){

            public void handleEvent(Event e) {
                GradientCanvas.this.onPaint(e.gc);
            }
        });
        this.addListener(12, new Listener(){

            public void handleEvent(Event e) {
                if (GradientCanvas.this.gradientImage != null) {
                    GradientCanvas.this.gradientImage.dispose();
                    GradientCanvas.this.gradientImage = null;
                }
            }
        });
        this.addListener(11, new Listener(){

            public void handleEvent(Event e) {
                if (GradientCanvas.this.gradientInfo != null || GradientCanvas.this.backgroundImage != null && !GradientCanvas.this.isBackgroundImageTiled()) {
                    GradientCanvas.this.updateGradientImage();
                }
            }
        });
    }

    public void setBackground(Color bg) {
        super.setBackground(bg);
        this.internalSetBackground(bg);
    }

    private void internalSetBackground(Color bg) {
        this.putColor(COLOR_BASE_BG, bg);
    }

    public void setBackgroundGradient(Color[] gradientColors, int[] percents, boolean vertical) {
        if (gradientColors != null) {
            this.gradientInfo = new GradientInfo();
            this.gradientInfo.gradientColors = gradientColors;
            this.gradientInfo.percents = percents;
            this.gradientInfo.vertical = vertical;
            this.setBackground(null);
            this.updateGradientImage();
        } else {
            this.gradientInfo = null;
            if (this.gradientImage != null) {
                this.gradientImage.dispose();
                this.gradientImage = null;
                this.setBackgroundImage(null);
            }
        }
    }

    public void setHeadingBackgroundImage(Image image) {
        this.backgroundImage = image;
        if (image != null) {
            this.setBackground(null);
        }
        if (this.isBackgroundImageTiled()) {
            this.setBackgroundImage(image);
        } else {
            this.updateGradientImage();
        }
    }

    public Image getHeadingBackgroundImage() {
        return this.backgroundImage;
    }

    public void setBackgroundImageTiled(boolean tiled) {
        this.flags = tiled ? (this.flags |= 8) : (this.flags &= 0xFFFFFFF7);
        this.setHeadingBackgroundImage(this.backgroundImage);
    }

    public boolean isBackgroundImageTiled() {
        return (this.flags & 8) != 0;
    }

    public void setBackgroundImage(Image image) {
        super.setBackgroundImage(image);
        if (image != null) {
            this.internalSetBackground(null);
        }
    }

    private void onPaint(GC gc) {
        if (!this.isSeparatorVisible() && this.getBackgroundImage() == null) {
            return;
        }
        Rectangle carea = this.getClientArea();
        Image buffer = new Image((Device)this.getDisplay(), carea.width, carea.height);
        buffer.setBackground(this.getBackground());
        GC igc = new GC((Drawable)buffer);
        igc.setBackground(this.getBackground());
        igc.fillRectangle(0, 0, carea.width, carea.height);
        if (this.getBackgroundImage() != null) {
            if (this.gradientInfo != null) {
                this.drawBackground(igc, carea.x, carea.y, carea.width, carea.height);
            } else {
                Image bgImage = this.getBackgroundImage();
                Rectangle ibounds = bgImage.getBounds();
                this.drawBackground(igc, carea.x, carea.y, ibounds.width, ibounds.height);
            }
        }
        if (this.isSeparatorVisible()) {
            this.drawSeparator(carea, igc);
        }
        igc.dispose();
        gc.drawImage(buffer, carea.x, carea.y);
        buffer.dispose();
    }

    private void drawSeparator(Rectangle carea, GC igc) {
        if (this.hasColor(H_BOTTOM_KEYLINE1)) {
            igc.setForeground(this.getColor(H_BOTTOM_KEYLINE1));
        } else {
            igc.setForeground(this.getBackground());
        }
        if (this.getSeparatorAlignment() == 1024) {
            igc.drawLine(carea.x, carea.height - 2, carea.x + carea.width - 1, carea.height - 2);
        } else {
            igc.drawLine(carea.x, 1, carea.x + carea.width - 1, 1);
        }
        if (this.hasColor(H_BOTTOM_KEYLINE2)) {
            igc.setForeground(this.getColor(H_BOTTOM_KEYLINE2));
        } else {
            igc.setForeground(this.getForeground());
        }
        if (this.getSeparatorAlignment() == 1024) {
            igc.drawLine(carea.x, carea.height - 1, carea.x + carea.width - 1, carea.height - 1);
        } else {
            igc.drawLine(carea.x, 0, carea.x + carea.width - 1, 0);
        }
    }

    private void updateGradientImage() {
        Rectangle rect = this.getBounds();
        if (this.gradientImage != null) {
            this.gradientImage.dispose();
            this.gradientImage = null;
        }
        if (this.gradientInfo != null) {
            boolean vertical = this.gradientInfo.vertical;
            int width = vertical ? 1 : rect.width;
            int height = vertical ? rect.height : 1;
            this.gradientImage = new Image((Device)this.getDisplay(), Math.max(width, 1), Math.max(height, 1));
            GC gc = new GC((Drawable)this.gradientImage);
            this.drawTextGradient(gc, width, height);
            gc.dispose();
        } else if (this.backgroundImage != null && !this.isBackgroundImageTiled()) {
            this.gradientImage = new Image((Device)this.getDisplay(), Math.max(rect.width, 1), Math.max(rect.height, 1));
            this.gradientImage.setBackground(this.getBackground());
            GC gc = new GC((Drawable)this.gradientImage);
            gc.drawImage(this.backgroundImage, 0, 0);
            gc.dispose();
        }
        this.setBackgroundImage(this.gradientImage);
    }

    private void drawTextGradient(GC gc, int width, int height) {
        Color oldBackground = gc.getBackground();
        if (this.gradientInfo.gradientColors.length == 1) {
            if (this.gradientInfo.gradientColors[0] != null) {
                gc.setBackground(this.gradientInfo.gradientColors[0]);
            }
            gc.fillRectangle(0, 0, width, height);
        } else {
            Color oldForeground = gc.getForeground();
            Color lastColor = this.gradientInfo.gradientColors[0];
            if (lastColor == null) {
                lastColor = oldBackground;
            }
            int pos = 0;
            int i = 0;
            while (i < this.gradientInfo.percents.length) {
                gc.setForeground(lastColor);
                lastColor = this.gradientInfo.gradientColors[i + 1];
                if (lastColor == null) {
                    lastColor = oldBackground;
                }
                gc.setBackground(lastColor);
                if (this.gradientInfo.vertical) {
                    int gradientHeight = this.gradientInfo.percents[i] * height / 100 - pos;
                    gc.fillGradientRectangle(0, pos, width, gradientHeight, true);
                    pos += gradientHeight;
                } else {
                    int gradientWidth = this.gradientInfo.percents[i] * width / 100 - pos;
                    gc.fillGradientRectangle(pos, 0, gradientWidth, height, false);
                    pos += gradientWidth;
                }
                ++i;
            }
            if (this.gradientInfo.vertical && pos < height) {
                gc.setBackground(this.getColor(COLOR_BASE_BG));
                gc.fillRectangle(0, pos, width, height - pos);
            }
            if (!this.gradientInfo.vertical && pos < width) {
                gc.setBackground(this.getColor(COLOR_BASE_BG));
                gc.fillRectangle(pos, 0, width - pos, height);
            }
            if (this.isSeparatorVisible()) {
                this.drawSeparator(this.getClientArea(), gc);
            }
            gc.setForeground(oldForeground);
        }
    }

    public boolean isSeparatorVisible() {
        return (this.flags & 2) != 0;
    }

    public void setSeparatorVisible(boolean addSeparator) {
        this.flags = addSeparator ? (this.flags |= 2) : (this.flags &= 0xFFFFFFFD);
    }

    public void setSeparatorAlignment(int alignment) {
        this.flags = alignment == 1024 ? (this.flags |= 4) : (this.flags &= 0xFFFFFFFB);
    }

    public int getSeparatorAlignment() {
        return (this.flags & 4) != 0 ? 1024 : 128;
    }

    public void putColor(String key, Color color) {
        if (color == null) {
            this.colors.remove(key);
        } else {
            this.colors.put(key, color);
        }
    }

    public Color getColor(String key) {
        return (Color)this.colors.get(key);
    }

    public boolean hasColor(String key) {
        return this.colors.containsKey(key);
    }

    private class GradientInfo {
        Color[] gradientColors;
        int[] percents;
        boolean vertical;

        private GradientInfo() {
        }
    }
}

